/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.common.AvailableConnectionsBase;
import oracle.ucp.common.UniversalConnectionPoolImpl;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.logging.UCPLoggerFactory;

public class AvailableConnectionsOneCollection
extends AvailableConnectionsBase {
    private static final Logger logger = UCPLoggerFactory.createLogger(AvailableConnectionsOneCollection.class.getCanonicalName());
    private final Collection<UniversalPooledConnection> m_availableConnections;

    public AvailableConnectionsOneCollection(UniversalConnectionPoolImpl cp, Collection availableConnections) throws UniversalConnectionPoolException {
        super(cp);
        if (availableConnections == null) {
            UniversalConnectionPoolException ucpe = UCPErrorHandler.newUniversalConnectionPoolException(57);
            logger.throwing(this.getClass().getName(), "AvailableConnectionsOneCollection", ucpe);
            throw ucpe;
        }
        this.m_availableConnections = Collections.synchronizedCollection(availableConnections);
    }

    public synchronized Collection getAvailableConnections(ConnectionRetrievalInfo connectionRetrievalInfo) {
        return this.m_availableConnections;
    }

    public synchronized void addAvailableConnection(UniversalPooledConnection connection) {
        if (this.m_availableConnections.add(connection)) {
            this.notifyAvailable(connection.getConnectionRetrievalInfo());
        }
    }

    public synchronized boolean removeAvailableConnection(UniversalPooledConnection connection) {
        return this.m_availableConnections.remove(connection);
    }

    public synchronized UniversalPooledConnection removeAvailableConnection(ConnectionRetrievalInfo cri) {
        return this.removeAvailableConnection();
    }

    public synchronized UniversalPooledConnection removeAvailableConnection() {
        if (this.m_availableConnections.size() > 0) {
            UniversalPooledConnection connection = this.m_availableConnections.iterator().next();
            this.m_availableConnections.remove(connection);
            return connection;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllConnections() {
        int i;
        UniversalPooledConnection[] connsToClose;
        AvailableConnectionsOneCollection availableConnectionsOneCollection = this;
        synchronized (availableConnectionsOneCollection) {
            connsToClose = this.getAllAvailableConnections();
            for (i = 0; i < connsToClose.length; ++i) {
                this.removeAvailableConnection(connsToClose[i]);
            }
        }
        UniversalConnectionPoolImpl cp = this.getConnectionPool();
        for (i = 0; i < connsToClose.length; ++i) {
            cp.closePhysicalConnection(connsToClose[i].getPhysicalConnection());
        }
        logger.finest("all connections closed");
    }

    public synchronized int getNumAvailableConnections() {
        return this.m_availableConnections.size();
    }

    public int getNumAvailableLabeledConnections() {
        return 0;
    }

    public synchronized UniversalPooledConnection[] getAllAvailableConnections() {
        UniversalPooledConnection[] connections = new UniversalPooledConnection[this.m_availableConnections.size()];
        this.m_availableConnections.toArray(connections);
        return connections;
    }
}

