/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ucp.AbandonedConnectionTimeoutCallback;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionFactoryAdapter;
import oracle.ucp.ConnectionLabelingCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.TimeToLiveConnectionTimeoutCallback;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalConnectionPoolLifeCycleState;
import oracle.ucp.UniversalConnectionPoolStatistics;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.common.AbandonedConnectionTimerTask;
import oracle.ucp.common.BorrowRequestQueue;
import oracle.ucp.common.ConnectionHarvestingTimerTask;
import oracle.ucp.common.FailoverEvent;
import oracle.ucp.common.FailoverEventHandlerTask;
import oracle.ucp.common.Failoverable;
import oracle.ucp.common.InactiveConnectionTimerTask;
import oracle.ucp.common.TimeToLiveConnectionTimerTask;
import oracle.ucp.util.Task;
import oracle.ucp.util.TaskHandle;
import oracle.ucp.util.TimerHandle;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.UCPTaskBase;
import oracle.ucp.util.UCPTimerTaskImpl;
import oracle.ucp.util.UniqueIdentifier;
import oracle.ucp.util.logging.UCPLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UniversalConnectionPoolBase
implements UniversalConnectionPool,
Failoverable {
    private static final Logger logger = UCPLoggerFactory.createLogger(UniversalConnectionPoolBase.class.getCanonicalName());
    public static final int DEFAULT_INITIAL_POOL_SIZE = 0;
    public static final int DEFAULT_MIN_POOL_SIZE = 0;
    public static final int DEFAULT_MAX_POOL_SIZE = Integer.MAX_VALUE;
    public static final int DEFAULT_INACTIVE_CONNECTION_TIMEOUT = 0;
    public static final int DEFAULT_TIMEOUT_CHECK_INTERVAL = 30;
    public static final int DEFAULT_ABANDONED_CONNECTION_TIMEOUT = 0;
    public static final int DEFAULT_CONNECTION_WAIT_TIMEOUT = 3;
    public static final int DEFAULT_TIME_TO_LIVE_CONNECTION_TIMEOUT = 0;
    public static final boolean DEFAULT_VALIDATE_BORROWED_CONNECTION = false;
    public static final int DEFAULT_CONNECTION_HARVEST_TRIGGER_COUNT = Integer.MAX_VALUE;
    public static final int DEFAULT_CONNECTION_HARVEST_MAX_COUNT = 1;
    public static final String DEFAULT_POOLNAME_PREFIX = "UniversalConnectionPool-";
    protected AtomicReference<UniversalConnectionPoolLifeCycleState> m_lifeCycleState = new AtomicReference<UniversalConnectionPoolLifeCycleState>(UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_STOPPED);
    private AtomicInteger m_initialPoolSize = new AtomicInteger(0);
    private AtomicInteger m_minPoolSize = new AtomicInteger(0);
    protected final AtomicBoolean m_skipPoolGrowing = new AtomicBoolean(false);
    private AtomicInteger m_maxPoolSize = new AtomicInteger(Integer.MAX_VALUE);
    private int m_inactiveConnectionTimeout = 0;
    private int m_timeoutCheckInterval = 30;
    private int m_abandonedConnectionTimeout = 0;
    private AtomicInteger m_connectionWaitTimeout = new AtomicInteger(3);
    private final AtomicInteger m_numConnectionsCreated = new AtomicInteger(0);
    private final AtomicInteger m_numConnectionsClosed = new AtomicInteger(0);
    private int m_timeToLiveConnectionTimeout = 0;
    private AtomicBoolean m_validateConnectionOnBorrow = new AtomicBoolean(false);
    private AtomicInteger m_connectionHarvestTriggerCount = new AtomicInteger(Integer.MAX_VALUE);
    private AtomicLong m_maxConnectionReuseTime = new AtomicLong(0L);
    private AtomicInteger m_maxConnectionReuseCount = new AtomicInteger(0);
    private AtomicInteger m_connectionHarvestMaxCount = new AtomicInteger(1);
    private final ConnectionFactoryAdapter m_connectionFactoryAdapter;
    private ConnectionRetrievalInfo m_defaultConnectionRetrievalInfo = null;
    protected ConnectionLabelingCallback m_connectionLabelingCallback = null;
    protected ConnectionAffinityCallback m_connectionAffinityCallback = null;
    private TimerHandle m_abandonedConnectionTimer = null;
    private TimerHandle m_inactiveConnectionTimer = null;
    private TimerHandle m_timeToLiveConnectionTimer = null;
    private TimerHandle m_connectionHarvestTimer = null;
    private boolean m_failoverEnabled = false;
    private String m_poolName = new UniqueIdentifier("UniversalConnectionPool-").toString();
    private final AtomicInteger m_abandonedConnectionsCount = new AtomicInteger(0);
    final AtomicLong m_cumulativeReturnedConnectionCount = new AtomicLong(0L);
    final AtomicLong m_cumulativeConnectionBorrowedCount = new AtomicLong(0L);
    final AtomicLong m_cumulativeSuccessfulConnectionWaitCount = new AtomicLong(0L);
    final AtomicLong m_cumulativeFailedConnectionWaitCount = new AtomicLong(0L);
    AtomicInteger m_peakConnectionsCount = new AtomicInteger();
    AtomicInteger m_cumulativeConnectionsCreated = new AtomicInteger();
    final AtomicLong m_cumulativeSuccessfulConnectionWaitTime = new AtomicLong(0L);
    final AtomicLong m_cumulativeFailedConnectionWaitTime = new AtomicLong(0L);
    AtomicLong m_peakConnectionWaitTime = new AtomicLong();
    final AtomicInteger m_pendingRequestsCount = new AtomicInteger(0);
    final AtomicLong m_cumulativeConnectionUseTime = new AtomicLong(0L);
    private final AtomicInteger m_averageBorrowedConnectionsCount = new AtomicInteger(0);
    private TimerHandle m_averageBorrowedConnectionsTimer = null;
    private TimerHandle m_replaceNonReusableConnectionsTimer = null;
    public static final int THREAD_POOL_SIZE = 24;
    private static final AtomicInteger m_poolsRunning = new AtomicInteger(0);
    final BorrowRequestQueue m_borrowRequestQueue = new BorrowRequestQueue();

    UniversalConnectionPoolBase(ConnectionFactoryAdapter connectionFactoryAdapter) throws UniversalConnectionPoolException {
        if (connectionFactoryAdapter == null) {
            UCPErrorHandler.throwUniversalConnectionPoolException(104);
        }
        this.m_connectionFactoryAdapter = connectionFactoryAdapter;
        this.m_connectionFactoryAdapter.setUniversalConnectionPool(this);
    }

    public static TaskHandle submitWTPTask(Task task) {
        return UniversalConnectionPoolManagerBase.getTaskManager().submitTask(task);
    }

    protected abstract UniversalPooledConnection[] getInUseConnectionsArray();

    @Override
    public abstract UniversalPooledConnection borrowConnection(ConnectionRetrievalInfo var1) throws UniversalConnectionPoolException;

    protected abstract UniversalPooledConnection createOnePooledConnection(ConnectionRetrievalInfo var1) throws UniversalConnectionPoolException;

    @Override
    public abstract void returnConnection(UniversalPooledConnection var1) throws UniversalConnectionPoolException;

    @Override
    public abstract void closeConnection(UniversalPooledConnection var1) throws UniversalConnectionPoolException;

    protected abstract void addOneAvailableConnection(UniversalPooledConnection var1) throws UniversalConnectionPoolException;

    public abstract void removeAndCloseOneAvailableConnection(UniversalPooledConnection var1) throws UniversalConnectionPoolException;

    @Override
    public abstract void purge() throws UniversalConnectionPoolException;

    @Override
    public abstract void refresh() throws UniversalConnectionPoolException;

    @Override
    public abstract void recycle() throws UniversalConnectionPoolException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getInitialConnections() throws UniversalConnectionPoolException {
        UniversalConnectionPoolBase universalConnectionPoolBase = this;
        synchronized (universalConnectionPoolBase) {
            this.validatePoolSizes();
        }
        int initialPoolSize = this.getInitialPoolSize();
        if (initialPoolSize > 0) {
            if (this.m_defaultConnectionRetrievalInfo != null) {
                if (!this.addNewConnections(this.m_defaultConnectionRetrievalInfo, initialPoolSize)) {
                    UCPErrorHandler.throwUniversalConnectionPoolException(66);
                }
            } else {
                UCPErrorHandler.throwUniversalConnectionPoolException(4);
            }
        }
    }

    public abstract void growPool(int var1);

    public abstract void growPool(int var1, List<ConnectionRetrievalInfo> var2);

    protected abstract void reducePool(int var1);

    public abstract boolean addNewConnections(ConnectionRetrievalInfo var1, int var2) throws UniversalConnectionPoolException;

    @Override
    public synchronized void reconfigure(Properties props) throws UniversalConnectionPoolException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws UniversalConnectionPoolException {
        if (!this.isLifecycleStopped() && !this.isLifecycleFailed()) {
            UCPErrorHandler.throwUniversalConnectionPoolException(60);
        }
        this.setLifecycleStarting();
        if (1 == m_poolsRunning.incrementAndGet()) {
            UniversalConnectionPoolManagerBase.getTaskManager().start();
            UniversalConnectionPoolManagerBase.getTimerManager().start();
        }
        try {
            UniversalConnectionPoolBase universalConnectionPoolBase = this;
            synchronized (universalConnectionPoolBase) {
                this.initAbandonedConnectionTimeoutTimer();
                this.initInactiveConnectionTimeoutTimer();
                this.initTimeToLiveConnectionTimeoutTimer();
                this.initConnectionHarvestingTimer();
                this.initAverageBorrowedConnectionsTimer();
                this.initReplaceNonReusableConnectionsTimer();
                if (this.isFailoverEnabled()) {
                    this.startFailover();
                }
                this.getInitialConnections();
            }
        }
        catch (UniversalConnectionPoolException e) {
            this.setLifecycleFailed();
            logger.log(Level.FINEST, "start", e);
            UniversalConnectionPoolBase universalConnectionPoolBase = this;
            synchronized (universalConnectionPoolBase) {
                try {
                    this.purge();
                }
                catch (Exception e1) {
                    logger.log(Level.FINEST, "purge", e1);
                }
                this.disableAbandonedConnectionTimeoutTimer();
                this.disableInactiveConnectionTimeoutTimer();
                this.disableTimeToLiveConnectionTimeoutTimer();
                this.disableConnectionHarvestingTimer();
                this.cancelAverageBorrowedConnectionsTimer();
                this.cancelReplaceNonReusableConnectionsTimer();
            }
            if (1 == m_poolsRunning.getAndDecrement()) {
                UniversalConnectionPoolManagerBase.getTaskManager().stop();
                UniversalConnectionPoolManagerBase.getTimerManager().stop();
                m_poolsRunning.set(0);
            }
            throw e;
        }
        this.setLifecycleRunning();
        logger.fine("universal connection pool started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void stop() throws UniversalConnectionPoolException {
        UniversalConnectionPoolBase universalConnectionPoolBase;
        if (this.isLifecycleStopped()) {
            return;
        }
        boolean wasRunning = this.isLifecycleRunning();
        this.setLifecycleStopping();
        try {
            UniversalConnectionPoolBase universalConnectionPoolBase2 = this;
            synchronized (universalConnectionPoolBase2) {
                this.purge();
            }
            Object var5_5 = null;
            universalConnectionPoolBase = this;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            UniversalConnectionPoolBase universalConnectionPoolBase3 = this;
            synchronized (universalConnectionPoolBase3) {
                this.disableAbandonedConnectionTimeoutTimer();
                this.disableInactiveConnectionTimeoutTimer();
                this.disableTimeToLiveConnectionTimeoutTimer();
                this.disableConnectionHarvestingTimer();
                this.cancelAverageBorrowedConnectionsTimer();
                this.cancelReplaceNonReusableConnectionsTimer();
                if (this.isFailoverEnabled()) {
                    try {
                        this.stopFailover();
                    }
                    catch (UniversalConnectionPoolException e) {
                        logger.log(Level.FINEST, "calling stopFailover()", e);
                    }
                }
                this.resetNonCumulativePoolStatistics();
            }
            throw throwable;
        }
        synchronized (universalConnectionPoolBase) {
            this.disableAbandonedConnectionTimeoutTimer();
            this.disableInactiveConnectionTimeoutTimer();
            this.disableTimeToLiveConnectionTimeoutTimer();
            this.disableConnectionHarvestingTimer();
            this.cancelAverageBorrowedConnectionsTimer();
            this.cancelReplaceNonReusableConnectionsTimer();
            if (this.isFailoverEnabled()) {
                try {
                    this.stopFailover();
                }
                catch (UniversalConnectionPoolException e) {
                    logger.log(Level.FINEST, "calling stopFailover()", e);
                }
            }
            this.resetNonCumulativePoolStatistics();
        }
        {
            catch (UniversalConnectionPoolException e) {
                this.setLifecycleFailed();
                throw e;
            }
        }
        if (wasRunning && 1 == m_poolsRunning.getAndDecrement()) {
            UniversalConnectionPoolManagerBase.getTaskManager().stop();
            UniversalConnectionPoolManagerBase.getTimerManager().stop();
            m_poolsRunning.set(0);
        }
        this.setLifecycleStopped();
        this.resetNonCumulativePoolStatistics();
        logger.fine("universal connection pool stopped");
    }

    protected void resetAllPoolStatistics() {
        this.m_numConnectionsCreated.set(0);
        this.m_numConnectionsClosed.set(0);
        this.m_abandonedConnectionsCount.set(0);
        this.m_peakConnectionsCount.set(0);
        this.m_peakConnectionWaitTime.set(0L);
        this.m_pendingRequestsCount.set(0);
        this.m_cumulativeReturnedConnectionCount.set(0L);
        this.m_cumulativeConnectionBorrowedCount.set(0L);
        this.m_cumulativeSuccessfulConnectionWaitCount.set(0L);
        this.m_cumulativeFailedConnectionWaitCount.set(0L);
        this.m_cumulativeSuccessfulConnectionWaitTime.set(0L);
        this.m_cumulativeFailedConnectionWaitTime.set(0L);
        this.m_cumulativeConnectionUseTime.set(0L);
        this.m_cumulativeConnectionsCreated.set(0);
        this.m_averageBorrowedConnectionsCount.set(0);
        logger.finest("all pool statistics metrics have been reset");
    }

    protected void resetNonCumulativePoolStatistics() {
        this.m_numConnectionsCreated.set(0);
        this.m_numConnectionsClosed.set(0);
        this.m_abandonedConnectionsCount.set(0);
        this.m_peakConnectionsCount.set(0);
        this.m_peakConnectionWaitTime.set(0L);
        this.m_pendingRequestsCount.set(0);
        this.m_averageBorrowedConnectionsCount.set(0);
        logger.finest("non-cumulative pool statistics metrics have been reset");
    }

    @Override
    public String getName() {
        return this.m_poolName;
    }

    @Override
    public synchronized void setName(String name) {
        logger.log(Level.FINEST, "PoolName: {0}", name);
        this.m_poolName = name;
    }

    @Override
    public int getInitialPoolSize() {
        return this.m_initialPoolSize.get();
    }

    @Override
    public synchronized void setInitialPoolSize(int initialPoolSize) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "InitialPoolSize: {0}", initialPoolSize);
        if (initialPoolSize < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.m_initialPoolSize.set(initialPoolSize);
    }

    @Override
    public int getMinPoolSize() {
        return this.m_minPoolSize.get();
    }

    @Override
    public synchronized void setMinPoolSize(int minPoolSize) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "MinPoolSize: {0}", minPoolSize);
        if (minPoolSize < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.m_minPoolSize.set(minPoolSize);
    }

    @Override
    public int getMaxPoolSize() {
        return this.m_maxPoolSize.get();
    }

    @Override
    public void setMaxPoolSize(int maxPoolSize) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "MaxPoolSize: {0}", maxPoolSize);
        if (maxPoolSize < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        int oldMaxPoolSize = this.m_maxPoolSize.getAndSet(maxPoolSize);
        if (this.isLifecycleRunning() && maxPoolSize < oldMaxPoolSize) {
            this.reducePool(maxPoolSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closePhysicalConnection(Object physicalConnection) {
        try {
            try {
                this.m_connectionFactoryAdapter.closeConnection(physicalConnection);
            }
            catch (UniversalConnectionPoolException connectionPoolException) {
                logger.log(Level.FINEST, "calling CFA closeConnection()", connectionPoolException);
                Object var4_3 = null;
                if (this.isLifecycleRunning()) {
                    this.incrementConnectionsClosedCount();
                } else {
                    logger.finest("pool is not running");
                }
            }
            Object var4_2 = null;
            if (this.isLifecycleRunning()) {
                this.incrementConnectionsClosedCount();
            } else {
                logger.finest("pool is not running");
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.isLifecycleRunning()) {
                this.incrementConnectionsClosedCount();
            } else {
                logger.finest("pool is not running");
            }
            throw throwable;
        }
        logger.fine("closed physical connection");
    }

    protected abstract UniversalPooledConnection[] getAvailableConnections();

    @Override
    public int getInactiveConnectionTimeout() {
        return this.m_inactiveConnectionTimeout;
    }

    protected synchronized void processInactiveConnections() {
        logger.finest("processing inactive connections");
        if (this.m_inactiveConnectionTimeout > 0) {
            final long cutoffTime = System.currentTimeMillis() - (long)(this.m_inactiveConnectionTimeout * 1000);
            final UniversalConnectionPoolBase thisLocker = this;
            UniversalConnectionPoolBase.submitWTPTask(new UCPTaskBase(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    boolean toGrowPool = false;
                    ArrayList<ConnectionRetrievalInfo> listCri = new ArrayList<ConnectionRetrievalInfo>();
                    Object object = thisLocker;
                    synchronized (object) {
                        int i;
                        UniversalPooledConnection[] availableConnections = UniversalConnectionPoolBase.this.getAvailableConnections();
                        UniversalPooledConnection[] connectionsToClose = new UniversalPooledConnection[availableConnections.length];
                        int numToClose = 0;
                        for (i = 0; i < availableConnections.length; ++i) {
                            if (cutoffTime < availableConnections[i].getAvailableStartTime()) continue;
                            connectionsToClose[numToClose] = availableConnections[i];
                            ++numToClose;
                        }
                        for (i = 0; i < numToClose; ++i) {
                            ConnectionRetrievalInfo cri = connectionsToClose[i].getConnectionRetrievalInfo();
                            listCri.add(cri);
                            try {
                                UniversalConnectionPoolBase.this.removeAndCloseOneAvailableConnection(connectionsToClose[i]);
                                toGrowPool = true;
                                continue;
                            }
                            catch (UniversalConnectionPoolException e) {
                                logger.log(Level.FINEST, "loop: replacing a connection: " + connectionsToClose[i], e);
                            }
                        }
                    }
                    if (toGrowPool) {
                        logger.finest("growing pool to min pool size");
                        UniversalConnectionPoolBase.this.growPool(UniversalConnectionPoolBase.this.getMinPoolSize(), listCri);
                    }
                }
            });
        }
    }

    private void initInactiveConnectionTimeoutTimer() throws UniversalConnectionPoolException {
        if (this.m_timeoutCheckInterval > 0 && this.m_inactiveConnectionTimeout > 0) {
            try {
                this.m_inactiveConnectionTimer = UniversalConnectionPoolManagerBase.getTimerManager().schedule(new InactiveConnectionTimerTask(this), 0L, this.m_timeoutCheckInterval * 1000);
            }
            catch (Exception exc) {
                this.m_inactiveConnectionTimer = null;
                this.setLifecycleFailed();
                UCPErrorHandler.throwUniversalConnectionPoolException(51);
            }
            logger.finest("inactive connection timeout timer initialized");
        } else {
            this.m_inactiveConnectionTimer = null;
        }
    }

    private void disableInactiveConnectionTimeoutTimer() {
        if (this.m_inactiveConnectionTimer != null) {
            this.m_inactiveConnectionTimer.cancel();
            this.m_inactiveConnectionTimer = null;
        }
        logger.finest("inactive connection timeout timer disabled");
    }

    @Override
    public synchronized void setInactiveConnectionTimeout(int inactiveConnectionTimeout) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "InactiveConnectionTimeout: {0}", inactiveConnectionTimeout);
        if (inactiveConnectionTimeout < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        if (this.m_inactiveConnectionTimeout != inactiveConnectionTimeout) {
            this.disableInactiveConnectionTimeoutTimer();
            this.m_inactiveConnectionTimeout = inactiveConnectionTimeout;
            if (this.m_inactiveConnectionTimeout > 0 && this.isLifecycleRunning()) {
                this.initInactiveConnectionTimeoutTimer();
            }
        }
    }

    protected TimerHandle getInactiveConnectionTimer() {
        return this.m_inactiveConnectionTimer;
    }

    @Override
    public int getConnectionWaitTimeout() {
        return this.m_connectionWaitTimeout.get();
    }

    @Override
    public synchronized void setConnectionWaitTimeout(int waitTimeout) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "ConnectionWaitTimeout: {0}", waitTimeout);
        if (waitTimeout < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.m_connectionWaitTimeout.set(waitTimeout);
    }

    @Override
    public int getTimeToLiveConnectionTimeout() {
        return this.m_timeToLiveConnectionTimeout;
    }

    synchronized void processTimeToLiveTimeout() {
        logger.finest("processing TimeToLiveConnectionTimeout");
        if (this.m_timeToLiveConnectionTimeout > 0) {
            final long cutoffTime = System.currentTimeMillis() - (long)(this.m_timeToLiveConnectionTimeout * 1000);
            final UniversalConnectionPoolBase thisLocker = this;
            UniversalConnectionPoolBase.submitWTPTask(new UCPTaskBase(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = thisLocker;
                    synchronized (object) {
                        UniversalPooledConnection[] pooledConnections = UniversalConnectionPoolBase.this.getInUseConnectionsArray();
                        for (int i = 0; i < pooledConnections.length; ++i) {
                            if (pooledConnections[i].getBorrowedStartTime() > cutoffTime) continue;
                            try {
                                TimeToLiveConnectionTimeoutCallback cbkOnThisConn = pooledConnections[i].getTimeToLiveConnectionTimeoutCallback();
                                if (cbkOnThisConn != null && (cbkOnThisConn == null || cbkOnThisConn.handleTimedOutConnection())) continue;
                                UniversalConnectionPoolBase.this.processTimedOutConnection(pooledConnections[i]);
                                UniversalConnectionPoolBase.this.returnConnection(pooledConnections[i]);
                                continue;
                            }
                            catch (UniversalConnectionPoolException e) {
                                logger.log(Level.FINEST, "loop returnConnection() " + pooledConnections[i], e);
                            }
                        }
                    }
                }
            });
        }
        logger.finest("TTL connection timeout timer processed");
    }

    private void initTimeToLiveConnectionTimeoutTimer() throws UniversalConnectionPoolException {
        if (this.m_timeoutCheckInterval > 0 && this.m_timeToLiveConnectionTimeout > 0) {
            try {
                this.m_timeToLiveConnectionTimer = UniversalConnectionPoolManagerBase.getTimerManager().schedule(new TimeToLiveConnectionTimerTask(this), 0L, this.m_timeoutCheckInterval * 1000);
            }
            catch (Exception exc) {
                this.m_timeToLiveConnectionTimer = null;
                this.setLifecycleFailed();
                UCPErrorHandler.throwUniversalConnectionPoolException(53);
            }
            logger.finest("TTL connection timeout timer initialized");
        } else {
            this.m_timeToLiveConnectionTimer = null;
        }
    }

    private void disableTimeToLiveConnectionTimeoutTimer() {
        if (this.m_timeToLiveConnectionTimer != null) {
            this.m_timeToLiveConnectionTimer.cancel();
            this.m_timeToLiveConnectionTimer = null;
        }
        logger.finest("TTL connection timeout timer disabled");
    }

    @Override
    public synchronized void setTimeToLiveConnectionTimeout(int timeToLiveConnectionTimeout) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "TimeToLiveConnectionTimeout: {0}", timeToLiveConnectionTimeout);
        if (timeToLiveConnectionTimeout < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        if (this.m_timeToLiveConnectionTimeout != timeToLiveConnectionTimeout) {
            this.disableTimeToLiveConnectionTimeoutTimer();
            this.m_timeToLiveConnectionTimeout = timeToLiveConnectionTimeout;
            if (this.m_timeToLiveConnectionTimeout > 0 && this.isLifecycleRunning()) {
                this.initTimeToLiveConnectionTimeoutTimer();
            }
        }
    }

    protected TimerHandle getTimeToLiveConnectionTimer() {
        return this.m_timeToLiveConnectionTimer;
    }

    @Override
    public int getTimeoutCheckInterval() {
        return this.m_timeoutCheckInterval;
    }

    @Override
    public synchronized void setTimeoutCheckInterval(int timeoutCheckInterval) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "TimeoutCheckInterval: {0}", timeoutCheckInterval);
        if (timeoutCheckInterval < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        if (this.m_timeoutCheckInterval != timeoutCheckInterval) {
            this.disableAbandonedConnectionTimeoutTimer();
            this.disableInactiveConnectionTimeoutTimer();
            this.disableTimeToLiveConnectionTimeoutTimer();
            this.disableConnectionHarvestingTimer();
            this.m_timeoutCheckInterval = timeoutCheckInterval;
            if (this.m_timeoutCheckInterval > 0 && this.isLifecycleRunning()) {
                this.initAbandonedConnectionTimeoutTimer();
                this.initInactiveConnectionTimeoutTimer();
                this.initTimeToLiveConnectionTimeoutTimer();
                this.initConnectionHarvestingTimer();
            }
        }
    }

    @Override
    public boolean getValidateConnectionOnBorrow() {
        return this.m_validateConnectionOnBorrow.get();
    }

    @Override
    public synchronized void setValidateConnectionOnBorrow(boolean validateConnectionOnBorrow) {
        logger.log(Level.FINEST, "ValidateConnectionOnBorrow: {0}", validateConnectionOnBorrow);
        this.m_validateConnectionOnBorrow.set(validateConnectionOnBorrow);
    }

    @Override
    public int getConnectionHarvestTriggerCount() {
        return this.m_connectionHarvestTriggerCount.get();
    }

    @Override
    public synchronized void setConnectionHarvestTriggerCount(int connectionHarvestTriggerCount) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "ConnectionHarvestTriggerCount: {0}", connectionHarvestTriggerCount);
        if (connectionHarvestTriggerCount < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        if (connectionHarvestTriggerCount != this.m_connectionHarvestTriggerCount.get()) {
            this.disableConnectionHarvestingTimer();
            this.m_connectionHarvestTriggerCount.set(connectionHarvestTriggerCount);
            if (this.m_connectionHarvestTriggerCount.get() >= 0 && this.m_connectionHarvestTriggerCount.get() < Integer.MAX_VALUE && this.isLifecycleRunning()) {
                this.initConnectionHarvestingTimer();
            }
        }
    }

    @Override
    public int getConnectionHarvestMaxCount() {
        return this.m_connectionHarvestMaxCount.get();
    }

    @Override
    public synchronized void setConnectionHarvestMaxCount(int connectionHarvestMaxCount) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "ConnectionHarvestMaxCount: {0}", connectionHarvestMaxCount);
        if (connectionHarvestMaxCount < 1) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.m_connectionHarvestMaxCount.set(connectionHarvestMaxCount);
    }

    int getConnectionsCreatedCount() {
        return this.m_numConnectionsCreated.get();
    }

    protected void incrementConnectionsCreatedCount() {
        this.m_numConnectionsCreated.incrementAndGet();
    }

    int getConnectionsClosedCount() {
        return this.m_numConnectionsClosed.get();
    }

    protected void incrementConnectionsClosedCount() {
        this.m_numConnectionsClosed.incrementAndGet();
    }

    @Override
    public abstract int getAvailableConnectionsCount();

    @Override
    public abstract int getBorrowedConnectionsCount();

    public abstract int getTotalConnectionsCount();

    @Override
    public abstract UniversalConnectionPoolStatistics getStatistics();

    @Override
    public UniversalConnectionPoolLifeCycleState getLifeCycleState() {
        return this.m_lifeCycleState.get();
    }

    public ConnectionFactoryAdapter getConnectionFactoryAdapter() {
        return this.m_connectionFactoryAdapter;
    }

    @Override
    public ConnectionRetrievalInfo getConnectionRetrievalInfo() {
        return this.m_defaultConnectionRetrievalInfo;
    }

    @Override
    public synchronized void setConnectionRetrievalInfo(ConnectionRetrievalInfo defaultConnectionRetrievalInfo) {
        logger.log(Level.FINEST, "ConnectionRetrievalInfo: {0}", defaultConnectionRetrievalInfo);
        this.m_defaultConnectionRetrievalInfo = defaultConnectionRetrievalInfo;
    }

    @Override
    public synchronized void registerConnectionLabelingCallback(ConnectionLabelingCallback cbk) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "ConnectionLabelingCallback: {0}", cbk);
        if (null != this.m_connectionLabelingCallback) {
            UCPErrorHandler.throwUniversalConnectionPoolException(91);
        }
        this.m_connectionLabelingCallback = cbk;
    }

    @Override
    public synchronized void removeConnectionLabelingCallback() throws UniversalConnectionPoolException {
        logger.finest("connection labeling callback removed");
        this.m_connectionLabelingCallback = null;
    }

    @Override
    public synchronized void registerConnectionAffinityCallback(ConnectionAffinityCallback cbk) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "ConnectionAffinityCallback: {0}", cbk);
        this.m_connectionAffinityCallback = cbk;
    }

    @Override
    public synchronized void removeConnectionAffinityCallback() throws UniversalConnectionPoolException {
        logger.finest("connection affinity callback removed");
        this.m_connectionAffinityCallback = null;
    }

    public synchronized ConnectionAffinityCallback getConnectionAffinityCallback() {
        return this.m_connectionAffinityCallback;
    }

    @Override
    public int getAbandonedConnectionTimeout() {
        return this.m_abandonedConnectionTimeout;
    }

    synchronized void processAbandonedConnections() {
        logger.finest("processing abandoned connections");
        if (this.m_abandonedConnectionTimeout > 0) {
            final long cutoffTime = System.currentTimeMillis() - (long)(this.m_abandonedConnectionTimeout * 1000);
            final UniversalConnectionPoolBase thisLocker = this;
            UniversalConnectionPoolBase.submitWTPTask(new UCPTaskBase(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = thisLocker;
                    synchronized (object) {
                        UniversalPooledConnection[] pooledConnections = UniversalConnectionPoolBase.this.getInUseConnectionsArray();
                        for (int i = 0; i < pooledConnections.length; ++i) {
                            UniversalPooledConnection upc = pooledConnections[i];
                            if (!upc.isConnectionHarvestable() || upc.getLastAccessedTime() > cutoffTime) continue;
                            try {
                                AbandonedConnectionTimeoutCallback cbkOnThisConn = upc.getAbandonedConnectionTimeoutCallback();
                                if (cbkOnThisConn != null && (cbkOnThisConn == null || cbkOnThisConn.handleTimedOutConnection())) continue;
                                UniversalConnectionPoolBase.this.processTimedOutConnection(upc);
                                UniversalConnectionPoolBase.this.returnConnection(upc);
                                UniversalConnectionPoolBase.this.m_abandonedConnectionsCount.incrementAndGet();
                                continue;
                            }
                            catch (UniversalConnectionPoolException e) {
                                logger.log(Level.FINEST, "loop returnConnection() " + upc, e);
                            }
                        }
                    }
                }
            });
        }
        logger.finest("abandoned connections processed");
    }

    protected void processTimedOutConnection(UniversalPooledConnection pc) throws UniversalConnectionPoolException {
    }

    private void initAbandonedConnectionTimeoutTimer() throws UniversalConnectionPoolException {
        if (this.m_timeoutCheckInterval > 0 && this.m_abandonedConnectionTimeout > 0) {
            try {
                this.m_abandonedConnectionTimer = UniversalConnectionPoolManagerBase.getTimerManager().schedule(new AbandonedConnectionTimerTask(this), 0L, this.m_timeoutCheckInterval * 1000);
            }
            catch (Exception exc) {
                this.m_abandonedConnectionTimer = null;
                this.setLifecycleFailed();
                UCPErrorHandler.throwUniversalConnectionPoolException(52);
            }
            logger.finest("abandoned connection timeout timer initialized");
        } else {
            this.m_abandonedConnectionTimer = null;
        }
    }

    protected void validatePoolSizes() throws UniversalConnectionPoolException {
        int initialPoolSize = this.m_initialPoolSize.get();
        int minPoolSize = this.m_minPoolSize.get();
        int maxPoolSize = this.m_maxPoolSize.get();
        if (initialPoolSize < 0 || initialPoolSize > maxPoolSize || minPoolSize < 0 || minPoolSize > maxPoolSize || maxPoolSize < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        if (0 == maxPoolSize) {
            UCPErrorHandler.throwUniversalConnectionPoolException(59);
        }
    }

    private void disableAbandonedConnectionTimeoutTimer() {
        if (this.m_abandonedConnectionTimer != null) {
            this.m_abandonedConnectionTimer.cancel();
            this.m_abandonedConnectionTimer = null;
        }
        logger.finest("abandoned connection timeout timer disabled");
    }

    @Override
    public synchronized void setAbandonedConnectionTimeout(int abandonedConnectionTimeout) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "AbandonedConnectionTimeout: {0}", abandonedConnectionTimeout);
        if (abandonedConnectionTimeout < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        if (abandonedConnectionTimeout != this.m_abandonedConnectionTimeout) {
            this.disableAbandonedConnectionTimeoutTimer();
            this.m_abandonedConnectionTimeout = abandonedConnectionTimeout;
            if (this.m_abandonedConnectionTimeout > 0 && this.isLifecycleRunning()) {
                this.initAbandonedConnectionTimeoutTimer();
            }
        }
    }

    protected TimerHandle getAbandonedConnectionTimer() {
        return this.m_abandonedConnectionTimer;
    }

    abstract void processConnectionHarvesting();

    protected abstract UniversalPooledConnection[] getAllBorrowedConnections();

    private void initConnectionHarvestingTimer() throws UniversalConnectionPoolException {
        int connectionHarvestTriggerCount = this.m_connectionHarvestTriggerCount.get();
        if (this.m_timeoutCheckInterval > 0 && connectionHarvestTriggerCount >= 0 && connectionHarvestTriggerCount < Integer.MAX_VALUE) {
            try {
                this.m_connectionHarvestTimer = UniversalConnectionPoolManagerBase.getTimerManager().schedule(new ConnectionHarvestingTimerTask(this), 0L, this.m_timeoutCheckInterval * 1000);
            }
            catch (Exception exc) {
                this.m_connectionHarvestTimer = null;
                this.setLifecycleFailed();
                UCPErrorHandler.throwUniversalConnectionPoolException(97);
            }
            logger.finest("connection harvesting timer initialized");
        } else {
            this.m_connectionHarvestTimer = null;
        }
    }

    private void disableConnectionHarvestingTimer() {
        if (this.m_connectionHarvestTimer != null) {
            this.m_connectionHarvestTimer.cancel();
            this.m_connectionHarvestTimer = null;
        }
        logger.finest("connection harvesting timer disabled");
    }

    private void initAverageBorrowedConnectionsTimer() {
        int AVERAGER_SAMPLE_INTERVAL = 120000;
        this.m_averageBorrowedConnectionsTimer = UniversalConnectionPoolManagerBase.getTimerManager().scheduleAtFixedRate(new UCPTimerTaskImpl(){
            private long accumulator = 0L;
            private int samples = 0;

            public void run() {
                if (UniversalConnectionPoolBase.this.isLifecycleRunning()) {
                    UniversalConnectionPoolBase.submitWTPTask(new UCPTaskBase(){

                        public void run() {
                            accumulator += UniversalConnectionPoolBase.this.getBorrowedConnectionsCount();
                            samples++;
                            UniversalConnectionPoolBase.this.m_averageBorrowedConnectionsCount.set((int)(accumulator / (long)samples));
                        }
                    });
                }
            }
        }, 0L, 120000L);
        logger.finest("average borrowed connection timer initialized");
    }

    private void cancelAverageBorrowedConnectionsTimer() {
        if (this.m_averageBorrowedConnectionsTimer != null) {
            this.m_averageBorrowedConnectionsTimer.cancel();
        }
        this.m_averageBorrowedConnectionsTimer = null;
        logger.finest("average borrowed connection timer cancelled");
    }

    private void initReplaceNonReusableConnectionsTimer() {
        long reuseTime = this.m_maxConnectionReuseTime.get();
        long timerInterval = reuseTime / 4L + reuseTime % 4L;
        if (reuseTime > 0L) {
            this.m_replaceNonReusableConnectionsTimer = UniversalConnectionPoolManagerBase.getTimerManager().scheduleAtFixedRate(new UCPTimerTaskImpl(){

                public void run() {
                    UniversalConnectionPoolBase.this.replaceNonReusableConnectionsWithWTP();
                }
            }, 0L, timerInterval * 1000L);
            logger.finest("replace non-reusable connections timer initialized");
        }
    }

    private void cancelReplaceNonReusableConnectionsTimer() {
        if (this.m_replaceNonReusableConnectionsTimer != null) {
            this.m_replaceNonReusableConnectionsTimer.cancel();
        }
        this.m_replaceNonReusableConnectionsTimer = null;
        logger.finest("replace non-reusable connections timer cancelled");
    }

    protected abstract void setConnectionHarvestable(UniversalPooledConnection var1, boolean var2) throws UniversalConnectionPoolException;

    public boolean isFailoverEnabled() {
        return this.m_failoverEnabled;
    }

    protected synchronized void startFailover() throws UniversalConnectionPoolException {
        FailoverEventHandlerTask failoverEventHandlerTask = this.getFailoverEventHandlerTask();
        if (failoverEventHandlerTask != null) {
            failoverEventHandlerTask.start();
        }
        logger.fine("failover started");
    }

    protected synchronized void stopFailover() throws UniversalConnectionPoolException {
        FailoverEventHandlerTask failoverEventHandlerTask = this.getFailoverEventHandlerTask();
        if (failoverEventHandlerTask != null) {
            failoverEventHandlerTask.waitTerminate();
        }
        logger.fine("failover stopped");
    }

    protected FailoverEventHandlerTask getFailoverEventHandlerTask() {
        return null;
    }

    public synchronized void setFailoverEnabled(boolean failoverEnabled) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "FailoverEnabled: {0}", failoverEnabled);
        if (failoverEnabled) {
            if (!this.isFailoverEnabled() && this.isLifecycleRunning()) {
                this.startFailover();
                this.m_failoverEnabled = failoverEnabled;
                this.refresh();
            }
        } else if (this.isFailoverEnabled() && this.isLifecycleRunning()) {
            this.stopFailover();
        }
        this.m_failoverEnabled = failoverEnabled;
        logger.finest("failover " + (failoverEnabled ? "enabled" : "disabled"));
    }

    @Override
    public long getMaxConnectionReuseTime() {
        return this.m_maxConnectionReuseTime.get();
    }

    @Override
    public void setMaxConnectionReuseTime(long maxConnectionReuseTime) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "MaxConnectionReuseTime: {0}", maxConnectionReuseTime);
        if (maxConnectionReuseTime < 0L) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        if (maxConnectionReuseTime != this.m_maxConnectionReuseTime.get()) {
            this.cancelReplaceNonReusableConnectionsTimer();
            this.m_maxConnectionReuseTime.set(maxConnectionReuseTime);
            if (maxConnectionReuseTime > 0L && this.isLifecycleRunning()) {
                this.initReplaceNonReusableConnectionsTimer();
            }
        }
    }

    @Override
    public int getMaxConnectionReuseCount() {
        return this.m_maxConnectionReuseCount.get();
    }

    @Override
    public void setMaxConnectionReuseCount(int maxConnectionReuseCount) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "MaxConnectionReuseCount: {0}", maxConnectionReuseCount);
        if (maxConnectionReuseCount < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        this.m_maxConnectionReuseCount.set(maxConnectionReuseCount);
    }

    abstract void replaceNonReusableConnections();

    private synchronized void replaceNonReusableConnectionsWithWTP() {
        UniversalConnectionPoolBase.submitWTPTask(new UCPTaskBase(){

            public void run() {
                UniversalConnectionPoolBase.this.replaceNonReusableConnections();
            }
        });
    }

    public boolean isRuntimeLoadBalancingEnabled() {
        return false;
    }

    public synchronized void setRuntimeLoadBalancingEnabled(boolean RLBEnabled) throws UniversalConnectionPoolException {
    }

    protected abstract void discardUsedConnection(Object var1);

    protected abstract UniversalPooledConnection getUsedConnection(Object var1);

    protected abstract boolean returnUsedPhysicalConnection(Object var1) throws UniversalConnectionPoolException;

    protected abstract boolean closeUsedPhysicalConnection(Object var1) throws UniversalConnectionPoolException;

    @Override
    public synchronized void setFailoverInfo(Object info) throws UniversalConnectionPoolException {
    }

    @Override
    public Object getFailoverInfo() {
        return null;
    }

    @Override
    public void handleFailoverEvent(FailoverEvent event) throws UniversalConnectionPoolException {
    }

    public int getAbandonedConnectionsCount() {
        return this.m_abandonedConnectionsCount.get();
    }

    public int getPendingRequestsCount() {
        return this.m_pendingRequestsCount.get();
    }

    public long getCumulativeConnectionReturnedCount() {
        return this.m_cumulativeReturnedConnectionCount.get();
    }

    public long getCumulativeSuccessfulConnectionWaitCount() {
        return this.m_cumulativeSuccessfulConnectionWaitCount.get();
    }

    public long getCumulativeFailedConnectionWaitCount() {
        return this.m_cumulativeFailedConnectionWaitCount.get();
    }

    public long getCumulativeSuccessfulConnectionWaitTime() {
        return this.m_cumulativeSuccessfulConnectionWaitTime.get();
    }

    public long getCumulativeFailedConnectionWaitTime() {
        return this.m_cumulativeFailedConnectionWaitTime.get();
    }

    public long getCumulativeConnectionBorrowedCount() {
        return this.m_cumulativeConnectionBorrowedCount.get();
    }

    public long getPeakConnectionWaitTime() {
        return this.m_peakConnectionWaitTime.get();
    }

    public synchronized long getCumulativeConnectionUseTime() {
        return this.m_cumulativeConnectionUseTime.get();
    }

    public int getPeakConnectionsCount() {
        return this.m_peakConnectionsCount.get();
    }

    public int getCumulativeConnectionsCreated() {
        return this.m_cumulativeConnectionsCreated.get();
    }

    public int getAverageBorrowedConnectionsCount() {
        return this.m_averageBorrowedConnectionsCount.get();
    }

    public abstract int getLabeledConnectionsCount();

    public boolean isLifecycleRunning() {
        return this.m_lifeCycleState.get() == UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_RUNNING;
    }

    public boolean isLifecycleStarting() {
        return this.m_lifeCycleState.get() == UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_STARTING;
    }

    public boolean isLifecycleStopping() {
        return this.m_lifeCycleState.get() == UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_STOPPING;
    }

    public boolean isLifecycleStopped() {
        return this.m_lifeCycleState.get() == UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_STOPPED;
    }

    public boolean isLifecycleFailed() {
        return this.m_lifeCycleState.get() == UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_FAILED;
    }

    void setLifecycleFailed() {
        this.m_lifeCycleState.set(UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_FAILED);
    }

    private void setLifecycleStarting() {
        this.m_lifeCycleState.set(UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_STARTING);
    }

    private void setLifecycleStopping() {
        this.m_lifeCycleState.set(UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_STOPPING);
    }

    private void setLifecycleRunning() {
        this.m_lifeCycleState.set(UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_RUNNING);
    }

    private void setLifecycleStopped() {
        this.m_lifeCycleState.set(UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_STOPPED);
    }

    protected synchronized ConnectionLabelingCallback getConnectionLabelingCallback() {
        return this.m_connectionLabelingCallback;
    }

    protected long getCumulativeReturnedConnectionCount() {
        return this.m_cumulativeReturnedConnectionCount.get();
    }
}

