/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ons.ONS;
import oracle.ons.ONSException;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.common.FailoverEvent;
import oracle.ucp.common.FailoverEventHandlerTask;
import oracle.ucp.common.Failoverable;
import oracle.ucp.jdbc.oracle.DataBasedConnectionAffinityCallback;
import oracle.ucp.jdbc.oracle.FailoverActionResult;
import oracle.ucp.jdbc.oracle.FailoverStatisticsAccumulator;
import oracle.ucp.jdbc.oracle.FailoverStatisticsCounters;
import oracle.ucp.jdbc.oracle.FailoverStatisticsItem;
import oracle.ucp.jdbc.oracle.FailoverablePooledConnection;
import oracle.ucp.jdbc.oracle.ONSDatabaseEventHandlerTask;
import oracle.ucp.jdbc.oracle.ONSRuntimeLBEventHandlerTask;
import oracle.ucp.jdbc.oracle.OracleConnectionAffinityContext;
import oracle.ucp.jdbc.oracle.OracleDatabaseInstanceInfo;
import oracle.ucp.jdbc.oracle.OracleDatabaseInstanceInfoList;
import oracle.ucp.jdbc.oracle.OracleFailoverEvent;
import oracle.ucp.jdbc.oracle.OracleGravitateConnectionPoolTask;
import oracle.ucp.jdbc.oracle.OracleLoadBalancingEvent;
import oracle.ucp.jdbc.oracle.RACCallback;
import oracle.ucp.jdbc.oracle.RACCallbackGuard;
import oracle.ucp.jdbc.oracle.RACInstance;
import oracle.ucp.jdbc.oracle.RACInstanceImpl;
import oracle.ucp.jdbc.oracle.RACManager;
import oracle.ucp.util.ProlongedTask;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.Util;
import oracle.ucp.util.logging.UCPLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RACManagerImpl
implements RACManager,
Failoverable {
    private static final Logger logger = UCPLoggerFactory.createLogger(RACManagerImpl.class.getCanonicalName());
    private boolean m_isEntireServiceDownProcessed = false;
    private int m_cardinality = 0;
    private final AtomicReference<RACCallback> m_cbk = new AtomicReference<RACCallbackGuard>(new RACCallbackGuard());
    private final FailoverStatisticsAccumulator eventAccumulator = new FailoverStatisticsAccumulator();
    private FailoverStatisticsItem currentEvent;
    private int m_targetTearDownConnCount = 0;
    int m_tornDownConnCount = 0;
    int m_markedToCloseConnCount = 0;
    private int m_targetUpEventNewConnCount = 0;
    private int m_upEventNewConnCount = 0;
    private final StringBuilder m_errorInfo = new StringBuilder(512);
    final AtomicReference<ONSDatabaseEventHandlerTask> m_failoverEventHandlerTask = new AtomicReference();
    private final OracleDatabaseInstanceInfoList m_dbInstanceInfoList;
    final AtomicReference<String> m_serviceName = new AtomicReference();
    private final AtomicReference<String> m_onsConfigurationString = new AtomicReference<String>("");
    private final int STARTED = 1;
    private final int STOPPED = 2;
    private int m_state = 2;
    protected final AtomicReference<String> m_fcfProcessingInfo = new AtomicReference<String>("");
    private final int ACTION_MARKDOWN = 100;
    private final int ACTION_CLEANUP = 200;
    private final BlockingQueue<OracleDatabaseInstanceInfo> m_instancesToRetireQueue = new LinkedBlockingQueue<OracleDatabaseInstanceInfo>();
    private final AtomicInteger m_countTotal = new AtomicInteger();
    private final Random m_rand = new Random(0L);
    private final AtomicReference<OracleGravitateConnectionPoolTask> m_gravitatePoolTask = new AtomicReference();
    private boolean m_isInstanceAffinityEnabled = false;
    private final AtomicBoolean m_gravitateTaskBusy = new AtomicBoolean();
    int[] m_mixTable;
    static final int MIX_TABLE_SIZE = 4096;
    static final int IRREDUCIBLE_POLYNOMIAL = 4105;
    static final int MIX_TABLE_GENERATOR = 3;
    private final AtomicReference<ONSRuntimeLBEventHandlerTask> m_rlbEventHandlerTask = new AtomicReference();
    private final AtomicBoolean m_runtimeLoadBalancingEnabled = new AtomicBoolean();
    protected ConnectionAffinityCallback m_connectionAffinityCallback = null;
    private final Map<String, Boolean> m_affinityMap = Collections.synchronizedMap(new HashMap());
    protected final AtomicLong m_successfulAffinityBasedBorrowCount = new AtomicLong(0L);
    protected final AtomicLong m_failedAffinityBasedBorrowCount = new AtomicLong(0L);
    protected final AtomicLong m_successfulRCLBBasedBorrowCount = new AtomicLong(0L);
    protected final AtomicLong m_failedRCLBBasedBorrowCount = new AtomicLong(0L);
    private final AtomicBoolean m_rclbMetricsPolicyEnabled = new AtomicBoolean(false);
    private final AtomicInteger m_dbVersion = new AtomicInteger(0);

    RACManagerImpl() throws UniversalConnectionPoolException {
        this.m_dbInstanceInfoList = new OracleDatabaseInstanceInfoList(this);
    }

    private boolean validateServiceEvent(OracleFailoverEvent failoverEvent) {
        String _svcName = failoverEvent.getServiceName();
        String _dbName = failoverEvent.getDbUniqueName();
        return _svcName != null && !_svcName.equals("") && _dbName != null && !_dbName.equals("");
    }

    private boolean validateHostDownEvent(OracleFailoverEvent failoverEvent) {
        String _hostName = failoverEvent.getHostName();
        return _hostName != null && !_hostName.equals("");
    }

    @Override
    public void handleFailoverEvent(FailoverEvent event) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "failoverEvent: {0}", event);
        if (event == null || !(event instanceof OracleFailoverEvent)) {
            UniversalConnectionPoolException ucpe = UCPErrorHandler.newUniversalConnectionPoolException(306);
            logger.throwing(this.getClass().getName(), "handleFailoverEvent", ucpe);
            throw ucpe;
        }
        OracleFailoverEvent failoverEvent = (OracleFailoverEvent)event;
        String status = failoverEvent.getStatus();
        String eventType = failoverEvent.getEventType();
        String serviceName = failoverEvent.getServiceName();
        String instanceName = failoverEvent.getInstanceName();
        String dbUniqueName = failoverEvent.getDbUniqueName();
        String hostName = failoverEvent.getHostName();
        String reason = failoverEvent.getReason();
        logger.log(Level.FINEST, "eventType: {0}, status = {1}", new Object[]{eventType, status});
        if (eventType.equals("database/event/service")) {
            if (serviceName == null || !serviceName.equals(this.m_serviceName.get())) {
                logger.log(Level.FINEST, "The service event has service name: {0}, not applicable to this pool and not processed.", serviceName);
                return;
            }
            if (status.equalsIgnoreCase("down") || status.equalsIgnoreCase("not_restarting") || status.equalsIgnoreCase("restart_failed")) {
                if (this.validateServiceEvent(failoverEvent)) {
                    this.currentEvent = new FailoverStatisticsItem(FailoverStatisticsItem.Type.SERVICE_DOWN, serviceName, instanceName, dbUniqueName, hostName);
                    this.eventAccumulator.addItem(this.currentEvent);
                    this.getRACCallback().initiateDownEventProcessing(failoverEvent);
                } else {
                    logger.log(Level.FINEST, "The service down event is invalid and not processed.");
                }
            } else if (status.equalsIgnoreCase("up")) {
                if (this.validateServiceEvent(failoverEvent)) {
                    this.currentEvent = new FailoverStatisticsItem(FailoverStatisticsItem.Type.SERVICE_UP, serviceName, instanceName, dbUniqueName, hostName);
                    this.eventAccumulator.addItem(this.currentEvent);
                    int numToCreate = this.getRACCallback().initiateUpEventProcessing(failoverEvent);
                    this.processUpEvent2ndPhase(numToCreate);
                    this.m_isEntireServiceDownProcessed = false;
                } else {
                    logger.log(Level.FINEST, "The service up event is invalid and not processed.");
                }
            }
        } else if (eventType.equals("database/event/host") && status.equalsIgnoreCase("nodedown")) {
            if (this.validateHostDownEvent(failoverEvent)) {
                this.currentEvent = new FailoverStatisticsItem(FailoverStatisticsItem.Type.HOST_DOWN, serviceName, instanceName, dbUniqueName, hostName);
                this.eventAccumulator.addItem(this.currentEvent);
                this.getRACCallback().initiateDownEventProcessing(failoverEvent);
            } else {
                logger.log(Level.FINEST, "The host down event is invalid and not processed.");
            }
        } else {
            logger.log(Level.FINEST, "Invalid Event received {0}", eventType);
        }
        this.updateFCFProcessingInfo(this.eventAccumulator.toString());
        this.resetFCFInternalMetrics();
    }

    @Override
    public int processUpEvent(FailoverablePooledConnection[] aconns, FailoverablePooledConnection[] bconns, int initialPoolSize, int maxPoolSize, OracleFailoverEvent failoverEvent) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "{0}, {1}, {2}, {3}, {4}", new Object[]{aconns, bconns, initialPoolSize, maxPoolSize, failoverEvent});
        String status = failoverEvent.getStatus();
        String eventType = failoverEvent.getEventType();
        logger.log(Level.FINEST, "eventType: {0}, status = {1}", new Object[]{eventType, status});
        int numConnsToCreate = -1;
        if (eventType.equals("database/event/service")) {
            if (status.equalsIgnoreCase("up")) {
                numConnsToCreate = this.processServiceUpEvent(aconns, bconns, initialPoolSize, maxPoolSize, failoverEvent.getInstanceName(), failoverEvent.getHostName(), failoverEvent.getDbUniqueName());
            } else {
                logger.log(Level.FINEST, "The service up event is invalid and not processed.");
            }
        } else {
            logger.log(Level.FINEST, "Invalid Event received {0}", eventType);
        }
        return numConnsToCreate;
    }

    private FailoverStatisticsCounters processConnectionsForServiceDown(FailoverablePooledConnection[] conns, boolean isProcessingAvailableConnections, String instanceName, String dbUniqueName, boolean isPlannedDownEvent, int actionFlag) {
        logger.log(Level.FINEST, "{0}, {1}, {2}, {3}, {4}, {5}", new Object[]{conns, isProcessingAvailableConnections, instanceName, dbUniqueName, isPlannedDownEvent, actionFlag});
        FailoverStatisticsCounters cs = new FailoverStatisticsCounters();
        cs.conns = conns.length;
        for (int i = 0; i < cs.conns; ++i) {
            if (!this.failoverServiceEventMatch(conns[i], instanceName, dbUniqueName)) continue;
            ++cs.affected;
            FailoverActionResult result = this.processFailoverAction(conns[i], isProcessingAvailableConnections, isPlannedDownEvent, actionFlag);
            cs.update(result);
        }
        return cs;
    }

    FailoverActionResult processFailoverAction(FailoverablePooledConnection pc, boolean isAvailableConnection, boolean isPlannedDownEvent, int actionFlag) {
        logger.log(Level.FINEST, "{0}, {1}, {2}, {3}", new Object[]{pc, isAvailableConnection, isPlannedDownEvent, actionFlag});
        FailoverActionResult result = FailoverActionResult.NOOP;
        switch (actionFlag) {
            case 0: {
                try {
                    if (!isAvailableConnection && isPlannedDownEvent) {
                        pc.setStatus(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN);
                        result = FailoverActionResult.MARKED_CLOSE_ON_RETURN;
                        break;
                    }
                    pc.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                    result = FailoverActionResult.MARKED_BAD;
                }
                catch (UniversalConnectionPoolException ucpe) {
                    logger.log(Level.FINEST, "setting status failed: ", this.getStackTraceString(ucpe));
                    this.m_errorInfo.append(", ").append(ucpe.getStackTrace()[0].toString());
                    result = FailoverActionResult.FAILED;
                }
                break;
            }
            case 1: {
                try {
                    pc.abort();
                }
                catch (Exception exc) {
                    logger.log(Level.FINEST, "aborting connection failed: ", this.getStackTraceString(exc));
                    this.m_errorInfo.append(", ").append(exc.getStackTrace()[0].toString());
                    result = FailoverActionResult.FAILED;
                }
                try {
                    pc.close(!isAvailableConnection);
                    result = FailoverActionResult.ABORTED_AND_CLOSED;
                }
                catch (UniversalConnectionPoolException ucpe) {
                    logger.log(Level.FINEST, "closing connection failed: ", this.getStackTraceString(ucpe));
                    this.m_errorInfo.append(", ").append(ucpe.getStackTrace()[0].toString());
                    result = FailoverActionResult.FAILED;
                }
                break;
            }
        }
        return result;
    }

    private FailoverStatisticsCounters processConnectionsForHostDown(FailoverablePooledConnection[] pooledConnections, boolean isProcessingAvailableConnections, String hostName, int actionFlag) {
        logger.log(Level.FINEST, "{0}, {1}, {2}, {3}", new Object[]{pooledConnections, isProcessingAvailableConnections, hostName, actionFlag});
        FailoverStatisticsCounters cs = new FailoverStatisticsCounters();
        cs.conns = pooledConnections.length;
        for (int i = 0; i < cs.conns; ++i) {
            if (!this.failoverHostEventMatch(pooledConnections[i], hostName)) continue;
            ++cs.affected;
            FailoverActionResult result = this.processFailoverAction(pooledConnections[i], isProcessingAvailableConnections, false, actionFlag);
            cs.update(result);
        }
        return cs;
    }

    private int processServiceUpEvent(FailoverablePooledConnection[] aconns, FailoverablePooledConnection[] bconns, int initialPoolSize, int maxPoolSize, String instanceName, String hostName, String dbUniqueName) {
        int createCount;
        logger.log(Level.FINEST, "initialSize: {0}, maxSize: {1}, instanceName: {2}, dbUniqueName: {3}", new Object[]{initialPoolSize, maxPoolSize, instanceName, dbUniqueName});
        this.currentEvent.availConns = aconns == null ? 0 : aconns.length;
        int n = this.currentEvent.borrowedConns = bconns == null ? 0 : bconns.length;
        assert (this.m_dbInstanceInfoList != null);
        if (instanceName != null && !"".equals(instanceName)) {
            this.m_dbInstanceInfoList.markUpInstanceForUpEvent(this.m_serviceName.get(), instanceName, hostName, dbUniqueName);
        }
        this.m_cardinality = this.m_dbInstanceInfoList.getUpInstancesCount();
        int totalConnsCount = this.currentEvent.availConns + this.currentEvent.borrowedConns;
        if (this.m_cardinality == 0) {
            logger.log(Level.FINEST, "cardinality == 0, incorrect instance status");
            createCount = 0;
        } else if (this.m_cardinality == 1) {
            createCount = initialPoolSize - totalConnsCount;
            if (createCount > 0) {
                logger.log(Level.FINEST, "first up instance, to obtain {0} connections", createCount);
            } else {
                createCount = 0;
                logger.log(Level.FINEST, "first up instance, no new connections to obtain");
            }
        } else {
            createCount = this.getUpEventConnectionsToCreateCount(aconns, bconns, maxPoolSize, totalConnsCount);
            logger.log(Level.FINEST, "cardinality is {0}, to get {1} connections", new Object[]{this.m_cardinality, createCount});
        }
        this.m_targetUpEventNewConnCount = createCount;
        return createCount;
    }

    private void processUpEvent2ndPhase(int createCount) {
        boolean isFCFSuccessful;
        for (int i = 0; i < createCount; ++i) {
            try {
                this.getRACCallback().openNewConnection(null, null);
                ++this.m_upEventNewConnCount;
                continue;
            }
            catch (Exception e) {
                logger.log(Level.FINEST, "UP-event processing failed when adding new connections", this.getStackTraceString(e));
                this.m_errorInfo.append(", ").append(e.getStackTrace()[0].toString());
            }
        }
        this.currentEvent.cardinality = this.m_cardinality;
        this.currentEvent.targetedToTearConns = this.m_targetTearDownConnCount;
        this.currentEvent.tornDownConns = this.m_tornDownConnCount;
        this.currentEvent.markedToCloseConns = this.m_markedToCloseConnCount;
        this.currentEvent.targetUpEventNewConns = this.m_targetUpEventNewConnCount;
        this.currentEvent.upEventNewConnCount = this.m_upEventNewConnCount;
        this.currentEvent.successful = isFCFSuccessful = this.m_upEventNewConnCount == this.m_targetUpEventNewConnCount && this.m_targetTearDownConnCount == this.m_tornDownConnCount + this.m_markedToCloseConnCount && 0 == this.m_errorInfo.length();
        logger.log(Level.FINEST, "Fast Connection Failover " + (isFCFSuccessful ? "succeeded" : "failed"));
    }

    private int getUpEventConnectionsToCreateCount(FailoverablePooledConnection[] aconns, FailoverablePooledConnection[] bconns, int maxPoolSize, int totalConnsCount) {
        logger.log(Level.FINEST, "maxPoolSize: {0}, totalConnsCount: {1}", new Object[]{maxPoolSize, totalConnsCount});
        int connectionsToCreate = 0;
        int averageConnections = totalConnsCount / (this.m_cardinality - 1);
        int poolSizeHeadRoom = maxPoolSize - totalConnsCount;
        connectionsToCreate = averageConnections <= poolSizeHeadRoom ? averageConnections : poolSizeHeadRoom;
        if (connectionsToCreate < averageConnections) {
            int connectionsTornDown;
            int targetAverageConnections = totalConnsCount / this.m_cardinality;
            this.m_targetTearDownConnCount = connectionsTornDown = this.tearDownConnections(aconns, bconns, targetAverageConnections);
            if (connectionsTornDown > 0) {
                connectionsToCreate = connectionsTornDown;
            }
        }
        return connectionsToCreate;
    }

    private int tearDownConnections(FailoverablePooledConnection[] aconns, FailoverablePooledConnection[] bconns, int targetAverageConnections) {
        OracleDatabaseInstanceInfo dbInstance;
        boolean _sucProcessingOneConn;
        int i;
        logger.log(Level.FINEST, "targetAverageConnections: {0}", targetAverageConnections);
        assert (aconns != null);
        assert (bconns != null);
        int _tornDownAvailConnCount = 0;
        int _markedToCloseCount = 0;
        for (i = 0; i < aconns.length; ++i) {
            _sucProcessingOneConn = true;
            dbInstance = this.m_dbInstanceInfoList.getOracleDatabaseInstanceInfo(aconns[i].getInstance(), aconns[i].getDatabase());
            if (dbInstance.numToTearDown == -1) {
                dbInstance.numToTearDown = dbInstance.numberOfConnectionsCount - targetAverageConnections;
            }
            if (dbInstance.numToTearDown <= 0) continue;
            _sucProcessingOneConn = FailoverActionResult.FAILED != this.processFailoverAction(aconns[i], true, false, 0);
            boolean bl = _sucProcessingOneConn = _sucProcessingOneConn && FailoverActionResult.FAILED != this.processFailoverAction(aconns[i], true, false, 1);
            if (!_sucProcessingOneConn) continue;
            --dbInstance.numToTearDown;
            ++_tornDownAvailConnCount;
        }
        this.m_tornDownConnCount += _tornDownAvailConnCount;
        for (i = 0; i < bconns.length; ++i) {
            _sucProcessingOneConn = true;
            dbInstance = this.m_dbInstanceInfoList.getOracleDatabaseInstanceInfo(bconns[i].getInstance(), bconns[i].getDatabase());
            if (dbInstance.numToTearDown == -1) {
                dbInstance.numToTearDown = dbInstance.numberOfConnectionsCount - targetAverageConnections;
            }
            if (dbInstance.numToTearDown <= 0) continue;
            try {
                bconns[i].setStatus(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN);
            }
            catch (UniversalConnectionPoolException ucpe) {
                logger.log(Level.FINEST, "Borrowed connection tearing failed when setting status", this.getStackTraceString(ucpe));
                this.m_errorInfo.append(", ").append(ucpe.getStackTrace()[0].toString());
                _sucProcessingOneConn = false;
            }
            if (!_sucProcessingOneConn) continue;
            --dbInstance.numToTearDown;
            ++_markedToCloseCount;
        }
        this.m_markedToCloseConnCount += _markedToCloseCount;
        logger.log(Level.FINEST, "available torn: {0}, borrowed marked to close: {1}", new Object[]{_tornDownAvailConnCount, _markedToCloseCount});
        return _tornDownAvailConnCount + _markedToCloseCount;
    }

    boolean failoverServiceEventMatch(FailoverablePooledConnection pooledConnection, String instanceName, String dbUniqueName) {
        logger.log(Level.FINEST, "{0}, {1}, {2}", new Object[]{pooledConnection, instanceName, dbUniqueName});
        if (instanceName == null) {
            return true;
        }
        String pcDbUniqueName = pooledConnection.getDatabase();
        String pcDataSourceInstanceName = pooledConnection.getInstance();
        if (pcDataSourceInstanceName == null || pcDbUniqueName == null) {
            return false;
        }
        return instanceName.equals(pcDataSourceInstanceName) && dbUniqueName.equals(pcDbUniqueName);
    }

    private boolean failoverHostEventMatch(FailoverablePooledConnection pooledConnection, String hostName) {
        logger.log(Level.FINEST, "{0}, {1}", new Object[]{pooledConnection, hostName});
        String pooledConnectionHostName = pooledConnection.getHost();
        return hostName != null && pooledConnectionHostName != null && hostName.equals(pooledConnectionHostName);
    }

    private void resetFCFInternalMetrics() {
        this.m_targetTearDownConnCount = 0;
        this.m_tornDownConnCount = 0;
        this.m_markedToCloseConnCount = 0;
        this.m_targetUpEventNewConnCount = 0;
        this.m_upEventNewConnCount = 0;
        int _len = this.m_errorInfo.length();
        this.m_errorInfo.delete(0, _len);
    }

    private String getStackTraceString(Throwable exc) {
        StringWriter stackTraceWriter = new StringWriter(1024);
        PrintWriter pw = new PrintWriter(stackTraceWriter);
        exc.printStackTrace(pw);
        return ((Object)stackTraceWriter).toString();
    }

    private void startONS(final String onsConfigStr) throws UniversalConnectionPoolException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws UniversalConnectionPoolException {
                    try {
                        new ONS(onsConfigStr);
                        logger.log(Level.FINEST, "ONS({0}) succeeded", onsConfigStr);
                    }
                    catch (ONSException e) {
                        UniversalConnectionPoolException ucpe = UCPErrorHandler.newUniversalConnectionPoolException(308);
                        logger.throwing(this.getClass().getName(), "start", ucpe);
                        throw ucpe;
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException onsexc) {
            UniversalConnectionPoolException ucpe = UCPErrorHandler.newUniversalConnectionPoolException(308);
            logger.throwing(this.getClass().getName(), "start", ucpe);
            throw ucpe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void start() throws UniversalConnectionPoolException {
        logger.finest("start");
        if (this.m_state != 2) {
            UniversalConnectionPoolException ucpe = UCPErrorHandler.newUniversalConnectionPoolException(60);
            logger.throwing(this.getClass().getName(), "start", ucpe);
            throw ucpe;
        }
        String onsConfigurationString = this.m_onsConfigurationString.get();
        if (onsConfigurationString != null && !"".equals(onsConfigurationString)) {
            this.startONS(onsConfigurationString);
        }
        AtomicReference<ONSDatabaseEventHandlerTask> atomicReference = this.m_failoverEventHandlerTask;
        synchronized (atomicReference) {
            if (this.m_failoverEventHandlerTask.get() != null) {
                this.stop();
            } else {
                this.m_failoverEventHandlerTask.set(new ONSDatabaseEventHandlerTask(this));
            }
        }
        ONSDatabaseEventHandlerTask fcfTask = this.m_failoverEventHandlerTask.get();
        if (fcfTask != null) {
            fcfTask.setTerminate(false);
            fcfTask.start();
        }
        this.m_state = 1;
        logger.fine("failover started");
    }

    private FailoverEventHandlerTask getFailoverEventHandlerTask() {
        return this.m_failoverEventHandlerTask.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() throws UniversalConnectionPoolException {
        logger.finest("stop failover");
        if (this.m_state == 2) {
            logger.finest("failover already stopped");
            return;
        }
        this.terminateRuntimeLoadBalancing();
        ONSDatabaseEventHandlerTask fcfTask = this.m_failoverEventHandlerTask.get();
        if (fcfTask != null) {
            fcfTask.setTerminate(true);
            fcfTask.waitTerminate();
        }
        AtomicReference<ONSDatabaseEventHandlerTask> atomicReference = this.m_failoverEventHandlerTask;
        synchronized (atomicReference) {
            this.m_failoverEventHandlerTask.set(null);
        }
        this.resetRACStatistics();
        this.m_state = 2;
        logger.fine("failover stopped");
    }

    private void resetRACStatistics() {
        this.m_successfulAffinityBasedBorrowCount.set(0L);
        this.m_failedAffinityBasedBorrowCount.set(0L);
        this.m_successfulRCLBBasedBorrowCount.set(0L);
        this.m_failedRCLBBasedBorrowCount.set(0L);
        this.m_fcfProcessingInfo.set("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setFailoverEventHandlerTask(ONSDatabaseEventHandlerTask failoverEventHandlerTask) {
        logger.log(Level.FINEST, "failoverEventHandlerTask: {0}", failoverEventHandlerTask);
        AtomicReference<ONSDatabaseEventHandlerTask> atomicReference = this.m_failoverEventHandlerTask;
        synchronized (atomicReference) {
            this.m_failoverEventHandlerTask.set(failoverEventHandlerTask);
        }
    }

    @Override
    public void setFailoverInfo(Object info) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "failoverInfo: {0}", info);
        this.updateDatabaseInstanceInfo(info, true, true);
    }

    void updateDatabaseInstanceInfo(Object info, boolean isForFailover, boolean isAddingConnection) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "{0}, {1}, {2}", new Object[]{info, isForFailover, isAddingConnection});
        OracleDatabaseInstanceInfo dbi = (OracleDatabaseInstanceInfo)info;
        this.m_serviceName.compareAndSet(null, dbi.serviceName);
        assert (this.m_dbInstanceInfoList != null);
        this.m_dbInstanceInfoList.updateDatabaseInstanceInfo(dbi, isForFailover, isAddingConnection);
    }

    @Override
    public Object getFailoverInfo() {
        return this.m_dbInstanceInfoList;
    }

    @Override
    public String getONSConfiguration() {
        return this.m_onsConfigurationString.get();
    }

    @Override
    public void setONSConfiguration(String onsConfigStr) throws UniversalConnectionPoolException {
        String oldOnsConfigStr;
        logger.log(Level.FINEST, "onsConfigStr: {0}", onsConfigStr);
        if (onsConfigStr == null) {
            onsConfigStr = "";
        }
        if (onsConfigStr.equals(oldOnsConfigStr = this.m_onsConfigurationString.getAndSet(onsConfigStr))) {
            return;
        }
        if (this.m_state == 1) {
            this.stop();
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateFCFProcessingInfo(String fcfInfo) {
        AtomicReference<String> atomicReference = this.m_fcfProcessingInfo;
        synchronized (atomicReference) {
            this.m_fcfProcessingInfo.set(fcfInfo);
        }
    }

    @Override
    public void markDownConnectionsForDownEvent(FailoverablePooledConnection[] aconns, FailoverablePooledConnection[] bconns, OracleFailoverEvent failoverEvent) {
        logger.log(Level.FINEST, "{0}, {1}, {2}", new Object[]{aconns, bconns, failoverEvent.toString()});
        this.processConnectionsForDownEvent(aconns, bconns, failoverEvent, 100);
    }

    @Override
    public void cleanupConnectionsForDownEvent(FailoverablePooledConnection[] aconns, FailoverablePooledConnection[] bconns, OracleFailoverEvent failoverEvent) {
        logger.log(Level.FINEST, "{0}, {1}, {2}", new Object[]{aconns, bconns, failoverEvent.toString()});
        this.processConnectionsForDownEvent(aconns, bconns, failoverEvent, 200);
    }

    private void processConnectionsForDownEvent(FailoverablePooledConnection[] aconns, FailoverablePooledConnection[] bconns, OracleFailoverEvent failoverEvent, int actionFlag) {
        logger.log(Level.FINEST, "{0}, {1}, {2}", new Object[]{aconns, bconns, failoverEvent.toString()});
        String status = failoverEvent.getStatus();
        String eventType = failoverEvent.getEventType();
        logger.log(Level.FINEST, "eventType: {0}, status = {1}", new Object[]{eventType, status});
        if (eventType.equals("database/event/service")) {
            if (status.equalsIgnoreCase("down") || status.equalsIgnoreCase("not_restarting") || status.equalsIgnoreCase("restart_failed")) {
                boolean isPlannedDownEvent;
                String instanceName = failoverEvent.getInstanceName();
                String dbUniqueName = failoverEvent.getDbUniqueName();
                String reason = failoverEvent.getReason();
                boolean bl = isPlannedDownEvent = reason != null && reason.equals("user");
                if (actionFlag == 100) {
                    if (!this.m_isEntireServiceDownProcessed) {
                        this.currentEvent.availMarked = this.processConnectionsForServiceDown(aconns, true, instanceName, dbUniqueName, isPlannedDownEvent, 0);
                        this.currentEvent.borrowedMarked = this.processConnectionsForServiceDown(bconns, false, instanceName, dbUniqueName, isPlannedDownEvent, 0);
                        if (instanceName == null) {
                            this.m_isEntireServiceDownProcessed = false;
                        }
                    }
                } else if (actionFlag == 200) {
                    boolean isFCFSuccessful;
                    this.currentEvent.availConns = aconns == null ? 0 : aconns.length;
                    int n = this.currentEvent.borrowedConns = bconns == null ? 0 : bconns.length;
                    if (!isPlannedDownEvent) {
                        this.currentEvent.borrowedClosed = this.processConnectionsForServiceDown(bconns, false, instanceName, dbUniqueName, isPlannedDownEvent, 1);
                    }
                    this.currentEvent.availClosed = this.processConnectionsForServiceDown(aconns, true, instanceName, dbUniqueName, isPlannedDownEvent, 1);
                    assert (this.m_dbInstanceInfoList != null);
                    this.m_dbInstanceInfoList.markDownInstanceForServiceDownEvent(instanceName, dbUniqueName);
                    this.currentEvent.reason = reason;
                    this.currentEvent.successful = isFCFSuccessful = this.currentEvent.availClosed.failed == 0 && this.currentEvent.borrowedClosed.failed == 0 && this.m_errorInfo.length() == 0;
                    logger.log(Level.FINEST, "Fast Connection Failover " + (isFCFSuccessful ? "succeeded" : "failed"));
                }
            } else {
                logger.log(Level.FINEST, "The down event is invalid and not processed.");
            }
        } else if (eventType.equals("database/event/host") && status.equalsIgnoreCase("nodedown")) {
            String hostName = failoverEvent.getHostName();
            if (actionFlag == 100) {
                this.currentEvent.availMarked = this.processConnectionsForHostDown(aconns, true, hostName, 0);
                this.currentEvent.borrowedMarked = this.processConnectionsForHostDown(bconns, false, hostName, 0);
            } else if (actionFlag == 200) {
                boolean isFCFSuccessful;
                this.currentEvent.availConns = aconns == null ? 0 : aconns.length;
                this.currentEvent.borrowedConns = bconns == null ? 0 : bconns.length;
                this.currentEvent.borrowedClosed = this.processConnectionsForHostDown(bconns, false, hostName, 1);
                this.currentEvent.availClosed = this.processConnectionsForHostDown(aconns, true, hostName, 1);
                assert (this.m_dbInstanceInfoList != null);
                this.m_dbInstanceInfoList.markDownInstanceForHostDownEvent(hostName);
                this.currentEvent.successful = isFCFSuccessful = this.currentEvent.availClosed.failed == 0 && this.currentEvent.borrowedClosed.failed == 0 && this.m_errorInfo.length() == 0;
                logger.log(Level.FINEST, "Fast Connection Failover " + (isFCFSuccessful ? "succeeded" : "failed"));
            }
        } else {
            logger.log(Level.FINEST, "Invalid Event received {0}", eventType);
        }
    }

    @Override
    public void registerRACCallback(RACCallback cbk) {
        this.m_cbk.set(new RACCallbackGuard(cbk));
    }

    @Override
    public void unregisterRACCallback(RACCallback cbk) {
        this.m_cbk.compareAndSet(cbk, null);
    }

    public RACCallback getRACCallback() {
        return this.m_cbk.get();
    }

    @Override
    public void connectionOpened(FailoverablePooledConnection fpc) throws UniversalConnectionPoolException {
        OracleDatabaseInstanceInfo tmpInstance = new OracleDatabaseInstanceInfo(fpc.getDatabase(), fpc.getInstance(), fpc.getHost());
        tmpInstance.serviceName = fpc.getService();
        tmpInstance.id = fpc.getInstanceNumber();
        this.updateDatabaseInstanceInfo(tmpInstance, true, true);
        if (this.m_state == 1 && !this.isRuntimeLoadBalancingEnabled()) {
            this.setRuntimeLoadBalancingEnabled(true);
            this.setDatabaseVersion(fpc.getDatabaseVersion());
        }
    }

    @Override
    public void connectionClosed(FailoverablePooledConnection fpc) throws UniversalConnectionPoolException {
        OracleDatabaseInstanceInfo tmpInstance = new OracleDatabaseInstanceInfo(fpc.getDatabase(), fpc.getInstance(), fpc.getHost());
        tmpInstance.serviceName = fpc.getService();
        this.updateDatabaseInstanceInfo(tmpInstance, true, false);
        if (fpc.isNamedInstanceConnection()) {
            this.decrementNamedInstanceConnCount(tmpInstance);
        }
    }

    @Override
    public String getFCFProcessingInfo() {
        return this.m_fcfProcessingInfo.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementNamedInstanceConnCount(OracleDatabaseInstanceInfo dbInfo) {
        RACManagerImpl rACManagerImpl = this;
        synchronized (rACManagerImpl) {
            OracleDatabaseInstanceInfo dbInstance = this.m_dbInstanceInfoList.getOracleDatabaseInstanceInfo(dbInfo.instanceName, dbInfo.databaseUniqName);
            if (dbInstance.numNamedInstanceConns > 0) {
                --dbInstance.numNamedInstanceConns;
            }
        }
    }

    @Override
    public boolean isRuntimeLoadBalancingEnabled() {
        return this.m_runtimeLoadBalancingEnabled.get();
    }

    public synchronized void setRuntimeLoadBalancingEnabled(boolean RLBEnabled) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "runtimeLoadBalancingEnabled: {0}", RLBEnabled);
        this.m_runtimeLoadBalancingEnabled.set(RLBEnabled);
        if (RLBEnabled) {
            this.initRuntimeLoadBalancing(this.m_serviceName.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void initRuntimeLoadBalancing(String serviceName) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "serviceName: {0}", serviceName);
        AtomicReference<ONSRuntimeLBEventHandlerTask> atomicReference = this.m_rlbEventHandlerTask;
        synchronized (atomicReference) {
            if (this.m_rlbEventHandlerTask.get() == null) {
                this.m_rlbEventHandlerTask.set(new ONSRuntimeLBEventHandlerTask(this.m_serviceName.get(), this));
            }
        }
        this.m_rlbEventHandlerTask.get().start();
        this.generateMixTable();
    }

    protected synchronized void terminateRuntimeLoadBalancing() throws UniversalConnectionPoolException {
        logger.finest("terminateRuntimeLoadBalancing");
        this.cleanupRLBTasks();
        this.setRuntimeLoadBalancingEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRuntimeLoadBalancingEventHandlerTask(ONSRuntimeLBEventHandlerTask rlbEventHandlerTask) {
        logger.log(Level.FINEST, "runtimeLoadBalancingEventHandlerTask: {0}", rlbEventHandlerTask);
        AtomicReference<ONSRuntimeLBEventHandlerTask> atomicReference = this.m_rlbEventHandlerTask;
        synchronized (atomicReference) {
            this.m_rlbEventHandlerTask.set(rlbEventHandlerTask);
        }
    }

    protected void processDatabaseInstances() {
        logger.finest("process database instances");
        assert (this.m_dbInstanceInfoList != null);
        this.m_dbInstanceInfoList.processDatabaseInstanceList(this.m_instancesToRetireQueue, this.m_countTotal);
        this.setRCLBMetricsPolicyEnabled(true);
    }

    protected void gravitatePool() {
    }

    @Override
    public FailoverablePooledConnection selectConnectionPerRCLBAndAffinity(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "ConnectionRetrievalInfo: {0}", cri);
        ConnectionAffinityCallback cbk = this.getConnectionAffinityCallback();
        if (cbk.getAffinityPolicy() == ConnectionAffinityCallback.AffinityPolicy.DATA_BASED_AFFINITY) {
            return this.selectConnectionPerDataBasedAffinity(cri);
        }
        this.m_isInstanceAffinityEnabled = cbk.getAffinityPolicy() == ConnectionAffinityCallback.AffinityPolicy.TRANSACTION_BASED_AFFINITY;
        Object appAffinityContext = cbk.getConnectionAffinityContext();
        FailoverablePooledConnection pc = null;
        if (appAffinityContext == null) {
            logger.log(Level.FINEST, "Application has no affinity context established");
            pc = this.selectConnectionPerRCLB(cri);
            logger.log(Level.FINEST, "Connection obtained based on RCLB: {0}", pc);
            if (pc != null) {
                OracleConnectionAffinityContext affinityContext = this.getUpdatedAffinityContextAfterRCLB(pc, this.m_isInstanceAffinityEnabled);
                if (affinityContext != null) {
                    cbk.setConnectionAffinityContext(affinityContext.clone());
                    logger.log(Level.FINEST, "Application affinity context is now set.");
                } else {
                    logger.log(Level.FINEST, "Application affinity context is not set.");
                }
            }
        } else {
            boolean isAppAffinityContextValidToUse;
            logger.log(Level.FINEST, "Application has affinity context established");
            OracleConnectionAffinityContext affinityContext = (OracleConnectionAffinityContext)appAffinityContext;
            String instanceName = affinityContext.getInstanceName();
            String dbUniqName = affinityContext.getDatabaseUniqueName();
            String serviceName = affinityContext.getServiceName();
            boolean isInstanceAffinityEnabled = affinityContext.isForInstanceAffinity();
            boolean affinityValue = false;
            if (!isInstanceAffinityEnabled) {
                String instanceKey = this.generateDatabaseInstanceKey(instanceName, dbUniqName, serviceName);
                affinityValue = this.getConnectionAffinityValue(instanceKey);
            }
            boolean bl = isAppAffinityContextValidToUse = isInstanceAffinityEnabled || affinityValue;
            if (isAppAffinityContextValidToUse) {
                if (isInstanceAffinityEnabled) {
                    logger.log(Level.FINEST, "Database instance affinity. Use application's affinity context.");
                } else {
                    logger.log(Level.FINEST, "Temporal affinity. Use application's affinity context.");
                }
                logger.log(Level.FINEST, "Affinity context: instance={0}, service={1}, db={2}", new Object[]{instanceName, serviceName, dbUniqName});
                RACInstanceImpl racInstance = new RACInstanceImpl(serviceName, instanceName, "", dbUniqName);
                pc = this.getRACCallback().getAvailableConnectionToInstance(cri, racInstance);
                logger.log(Level.FINEST, "Connection found matching affinity context: {0}", pc);
                if (pc == null) {
                    logger.log(Level.FINEST, "Affinity contexts match but no connection available to serviceName: {0}, instanceName: {1}, dbUniqueName: {2}", new Object[]{serviceName, instanceName, dbUniqName});
                    pc = this.getConnectionToNamedInstance(instanceName, dbUniqName, isInstanceAffinityEnabled);
                    logger.log(Level.FINEST, "Connection obtained to named instance: {0}", pc);
                    if (pc == null) {
                        pc = this.selectConnectionPerRCLB(cri);
                        logger.log(Level.FINEST, "Connection obtained based on RCLB: {0}", pc);
                        if (pc != null) {
                            OracleConnectionAffinityContext updatedAffinityContext = this.getUpdatedAffinityContextAfterRCLB(pc, isInstanceAffinityEnabled);
                            if (!isInstanceAffinityEnabled) {
                                cbk.setConnectionAffinityContext(updatedAffinityContext);
                                logger.log(Level.FINEST, "Temporal affinity. Application affinity context is updated: {0}", updatedAffinityContext);
                            }
                        }
                        this.incrementFailedAffinityBasedBorrowCount();
                    } else {
                        this.incrementSuccessfulAffinityBasedBorrowCount();
                    }
                } else {
                    this.incrementSuccessfulAffinityBasedBorrowCount();
                }
            } else {
                pc = this.selectConnectionPerRCLB(cri);
                logger.log(Level.FINEST, "Connection obtained based on RCLB: {0}", pc);
                if (pc != null) {
                    OracleConnectionAffinityContext updatedAffinityContext = this.getUpdatedAffinityContextAfterRCLB(pc, false);
                    cbk.setConnectionAffinityContext(updatedAffinityContext);
                    logger.log(Level.FINEST, "Temporal affinity miss. Application affinity context is updated: {0}", updatedAffinityContext);
                }
                this.incrementFailedAffinityBasedBorrowCount();
            }
        }
        logger.log(Level.FINEST, "method returns connection: {0}", pc);
        return pc;
    }

    private OracleConnectionAffinityContext getUpdatedAffinityContextAfterRCLB(FailoverablePooledConnection fpc, boolean isInstanceAffinityEnabled) {
        logger.log(Level.FINEST, "fpc: {0}, isInstanceAffinityEnabled: {1}", new Object[]{fpc, isInstanceAffinityEnabled});
        OracleConnectionAffinityContext updatedAffinityContext = null;
        boolean needToCreateAffinityContext = true;
        String instanceName = fpc.getInstance();
        String dbName = fpc.getDatabase();
        String serviceName = fpc.getService();
        if (!isInstanceAffinityEnabled) {
            logger.log(Level.FINEST, "Checking affinity hint for this instance");
            String instanceKey = this.generateDatabaseInstanceKey(instanceName, dbName, serviceName);
            if (!this.getConnectionAffinityValue(instanceKey)) {
                needToCreateAffinityContext = false;
            }
            if (!needToCreateAffinityContext) {
                logger.log(Level.FINEST, "Temporal Affinity hint is false");
            }
        }
        if (needToCreateAffinityContext) {
            logger.log(Level.FINEST, "Creating temporary updated affinity context.");
            updatedAffinityContext = new OracleConnectionAffinityContext();
            updatedAffinityContext.setConnectionPoolID(this.getRACCallback().getPoolName());
            updatedAffinityContext.setInstanceName(instanceName);
            updatedAffinityContext.setDatabaseUniqueName(dbName);
            updatedAffinityContext.setServiceName(serviceName);
            if (isInstanceAffinityEnabled) {
                logger.log(Level.FINEST, "New context is for instance affinity.");
                updatedAffinityContext.setForInstanceAffinity(true);
            }
            logger.log(Level.FINEST, "New Affinity context created: {0}", updatedAffinityContext);
        }
        return updatedAffinityContext;
    }

    private FailoverablePooledConnection getConnectionToNamedInstance(String instanceName, String dbUniqName, boolean isInstanceAffinityEnabled) {
        FailoverablePooledConnection fpc = null;
        if (this.m_dbInstanceInfoList.isNamedInstanceConnectingAllowed(instanceName, dbUniqName, isInstanceAffinityEnabled)) {
            OracleDatabaseInstanceInfo dbInstance = this.m_dbInstanceInfoList.getOracleDatabaseInstanceInfo(instanceName, dbUniqName);
            String namedInstanceUrl = dbInstance.namedInstanceUrl;
            if (dbInstance.namedInstanceUrl != null) {
                try {
                    RACInstanceImpl racInstance = new RACInstanceImpl(dbInstance);
                    fpc = this.getRACCallback().openNewConnection(namedInstanceUrl, racInstance);
                }
                catch (Exception exc) {
                    fpc = null;
                    logger.throwing(this.getClass().getName(), "call to openNewConnection failed: ", exc);
                }
                if (fpc != null) {
                    fpc.setAsNamedInstanceConnection();
                    ++dbInstance.numNamedInstanceConns;
                }
            } else {
                logger.log(Level.FINEST, "URL invalid for connecting to named instance");
            }
        }
        return fpc;
    }

    protected FailoverablePooledConnection selectConnectionPerDataBasedAffinity(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "ConnectionRetrievalInfo: {0}", cri);
        DataBasedConnectionAffinityCallback cbk = (DataBasedConnectionAffinityCallback)this.getConnectionAffinityCallback();
        int partitionId = cbk.getPartitionId();
        FailoverablePooledConnection pc = null;
        if (partitionId < 0) {
            logger.log(Level.FINEST, "Callback returns incorrect partition-id.");
        } else {
            logger.log(Level.FINEST, "Callback returns partition-id:{0}", partitionId);
            int configuredInstCardinality = this.m_dbInstanceInfoList.size();
            while (true) {
                int instanceId = (partitionId %= 4096) % configuredInstCardinality;
                OracleDatabaseInstanceInfo dbInstance = this.m_dbInstanceInfoList.getOracleDatabaseInstanceInfo(instanceId);
                logger.log(Level.FINEST, "Partition-id={0}, dbinfo={1}", new Object[]{partitionId, dbInstance});
                if (dbInstance == null) {
                    partitionId = this.m_mixTable[partitionId];
                    logger.log(Level.FINEST, "Bad instance, dbinfo == null in table, remap to partition-id:{0}", partitionId);
                    continue;
                }
                OracleDatabaseInstanceInfoList.INSTANCE_CATEGORY_FOR_DATA_AFFINITY instanceCategory = this.m_dbInstanceInfoList.getInstanceCategory(dbInstance);
                String instanceName = dbInstance.instanceName;
                String dbUniqName = dbInstance.databaseUniqName;
                String serviceName = dbInstance.serviceName;
                switch (instanceCategory) {
                    case GOOD_INSTANCE: {
                        logger.log(Level.FINEST, "Data-based affinity. Found good instance based on partition-id.");
                        logger.log(Level.FINEST, "Partition-id={0}, Good instance: instance={0}, service={1}, db={2}", new Object[]{partitionId, instanceName, serviceName, dbUniqName});
                        RACInstanceImpl racInstance = new RACInstanceImpl(serviceName, instanceName, "", dbUniqName);
                        pc = this.getRACCallback().getAvailableConnectionToInstance(cri, racInstance);
                        logger.log(Level.FINEST, "Available connection found in chosen good instance: {0}", pc);
                        if (pc == null) {
                            logger.log(Level.FINEST, "Found good instance but no connection available to serviceName: {0}, instanceName: {1}, dbUniqueName: {2}", new Object[]{serviceName, instanceName, dbUniqName});
                            pc = this.getConnectionToNamedInstance(instanceName, dbUniqName, true);
                            logger.log(Level.FINEST, "Connection obtained to named instance: {0}", pc);
                            if (pc == null) {
                                pc = this.selectConnectionPerRCLB(cri);
                                logger.log(Level.FINEST, "Connection obtained based on RCLB: {0}", pc);
                                this.incrementFailedAffinityBasedBorrowCount();
                                break;
                            }
                            this.incrementSuccessfulAffinityBasedBorrowCount();
                            break;
                        }
                        this.incrementSuccessfulAffinityBasedBorrowCount();
                        break;
                    }
                    case VIOLATING_INSTANCE: {
                        logger.log(Level.FINEST, "Violating instance: instance={0}, service={1}, db={2}", new Object[]{partitionId, instanceName, serviceName, dbUniqName});
                        pc = this.selectConnectionPerRCLB(cri);
                        logger.log(Level.FINEST, "Connection obtained based on RCLB: {0}", pc);
                        this.incrementFailedAffinityBasedBorrowCount();
                        break;
                    }
                    case BAD_INSTANCE: {
                        partitionId = this.m_mixTable[partitionId];
                        logger.log(Level.FINEST, "Bad instance, service: {0}, instance: {1}, db: {2}; remap to partition-id:{3}", new Object[]{serviceName, instanceName, dbUniqName, partitionId});
                    }
                }
                if (pc != null) break;
            }
        }
        logger.log(Level.FINEST, "method returns connection: {0}", pc);
        return pc;
    }

    private void generateMixTable() {
        if (this.m_mixTable != null) {
            return;
        }
        int[] alog = new int[4096];
        alog[0] = 1;
        for (int i = 1; i < 4096; ++i) {
            alog[i] = alog[i - 1] << 1 ^ alog[i - 1];
            if ((alog[i] & 0x1000) == 0) continue;
            int n = i;
            alog[n] = alog[n] ^ 0x1009;
        }
        int[] log = new int[4096];
        for (int i = 0; i < 4096; ++i) {
            log[alog[i]] = i;
        }
        log[0] = 4096;
        int[] mix = new int[4096];
        for (int i = 1; i < 4096; ++i) {
            mix[log[i - 1] - 1] = log[i] - 1;
        }
        mix[log[4095] - 1] = log[0] - 1;
        this.m_mixTable = mix;
    }

    private void destroyMixTable() {
        this.m_mixTable = null;
    }

    @Override
    public FailoverablePooledConnection selectConnectionPerRCLB(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        boolean useRLBMetricsPolicy;
        logger.log(Level.FINEST, "ConnectionRetrievalInfo: {0}", cri);
        assert (this.m_dbInstanceInfoList != null);
        FailoverablePooledConnection pc = null;
        boolean bl = useRLBMetricsPolicy = this.isRCLBMetricsPolicyEnabled() && this.m_dbInstanceInfoList.size() > 0 && this.m_dbInstanceInfoList.useGoodGroup();
        if (useRLBMetricsPolicy) {
            pc = this.m_dbInstanceInfoList.selectConnectionPerRLBMetrics(cri, this);
        }
        if (!useRLBMetricsPolicy) {
            Collection<FailoverablePooledConnection> conns = this.getRACCallback().getAvailableConnections(cri);
            if (conns == null || conns.size() == 0) {
                return null;
            }
            int sz = conns.size();
            int pos = this.m_rand.nextInt(sz);
            Iterator<FailoverablePooledConnection> iter = conns.iterator();
            for (int i = 0; i < (pos + sz) % sz; ++i) {
                iter.next();
            }
            ArrayList<FailoverablePooledConnection> connsToClose = new ArrayList<FailoverablePooledConnection>();
            for (int i = 0; i < sz; ++i) {
                FailoverablePooledConnection tmpPc;
                UniversalPooledConnectionStatus status;
                if (!iter.hasNext()) {
                    iter = conns.iterator();
                }
                if (!(status = (tmpPc = iter.next()).getStatus()).equals(UniversalPooledConnectionStatus.STATUS_NORMAL)) continue;
                boolean needValidateOnBorrow = this.getRACCallback().getValidateConnectionOnBorrow();
                boolean validateResult = true;
                if (needValidateOnBorrow) {
                    validateResult = this.getRACCallback().isValid(tmpPc);
                }
                if (!needValidateOnBorrow || validateResult) {
                    pc = tmpPc;
                    break;
                }
                connsToClose.add(tmpPc);
            }
            for (FailoverablePooledConnection invalidFPC : connsToClose) {
                try {
                    invalidFPC.close(false);
                }
                catch (UniversalConnectionPoolException exc) {
                    logger.log(Level.FINEST, "closing connection failed", exc);
                }
            }
            this.incrementFailedRCLBBasedBorrowCount();
        }
        return pc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupRLBTasks() {
        logger.finest("cleanupRLBTasks");
        AtomicReference<ProlongedTask> atomicReference = this.m_rlbEventHandlerTask;
        synchronized (atomicReference) {
            ONSRuntimeLBEventHandlerTask rlbEventHandlerTask = this.m_rlbEventHandlerTask.get();
            if (rlbEventHandlerTask != null) {
                rlbEventHandlerTask.setTerminate(true);
            }
        }
        atomicReference = this.m_gravitatePoolTask;
        synchronized (atomicReference) {
            ProlongedTask gravitatePoolTask = this.m_gravitatePoolTask.get();
            if (gravitatePoolTask != null) {
                gravitatePoolTask.stop();
                this.m_gravitatePoolTask.set(null);
            }
        }
        this.destroyMixTable();
    }

    FailoverablePooledConnection selectConnectionFromArray(Collection<FailoverablePooledConnection> conns, OracleDatabaseInstanceInfo dbInstance) {
        logger.log(Level.FINEST, "{0}, {1}", new Object[]{conns, dbInstance.instanceName});
        FailoverablePooledConnection pc = null;
        int sz = conns.size();
        int numToClose = 0;
        FailoverablePooledConnection[] connectionsToClose = new FailoverablePooledConnection[sz];
        for (FailoverablePooledConnection conn : conns) {
            UniversalPooledConnectionStatus status = conn.getStatus();
            if (!status.equals(UniversalPooledConnectionStatus.STATUS_NORMAL)) continue;
            boolean needValidateOnBorrow = this.getRACCallback().getValidateConnectionOnBorrow();
            boolean validateResult = true;
            if (needValidateOnBorrow) {
                validateResult = this.getRACCallback().isValid(conn);
            }
            if (!needValidateOnBorrow || validateResult) {
                if (!Util.sameOrEqual(conn.getDatabase(), dbInstance.databaseUniqName) || !Util.sameOrEqual(conn.getInstance(), dbInstance.instanceName)) continue;
                pc = conn;
                break;
            }
            connectionsToClose[numToClose] = conn;
            ++numToClose;
        }
        for (int j = 0; j < numToClose; ++j) {
            try {
                connectionsToClose[j].close(false);
                continue;
            }
            catch (UniversalConnectionPoolException exc) {
                logger.log(Level.FINEST, "closing connection failed", exc);
            }
        }
        logger.log(Level.FINEST, "pc: {0}, serviceName: {1}, instanceName: {2},numberOfConnectionsCount: {3},attemptedConnRequestCount: {4},totalConnections: {5}", new Object[]{pc, this.m_serviceName.get(), dbInstance.instanceName, dbInstance.numberOfConnectionsCount, dbInstance.attemptedConnRequestCount, this.getRACCallback().getTotalConnectionsCount()});
        return pc;
    }

    @Override
    public long getSuccessfulAffinityBasedBorrowCount() {
        return this.m_successfulAffinityBasedBorrowCount.get();
    }

    @Override
    public long getFailedAffinityBasedBorrowCount() {
        return this.m_failedAffinityBasedBorrowCount.get();
    }

    @Override
    public long getSuccessfulRCLBBasedBorrowCount() {
        return this.m_successfulRCLBBasedBorrowCount.get();
    }

    @Override
    public long getFailedRCLBBasedBorrowCount() {
        return this.m_failedRCLBBasedBorrowCount.get();
    }

    protected void incrementSuccessfulAffinityBasedBorrowCount() {
        this.m_successfulAffinityBasedBorrowCount.incrementAndGet();
    }

    protected void incrementFailedAffinityBasedBorrowCount() {
        this.m_failedAffinityBasedBorrowCount.incrementAndGet();
    }

    protected void incrementSuccessfulRCLBBasedBorrowCount() {
        this.m_successfulRCLBBasedBorrowCount.incrementAndGet();
    }

    protected void incrementFailedRCLBBasedBorrowCount() {
        this.m_failedRCLBBasedBorrowCount.incrementAndGet();
    }

    boolean isRCLBMetricsPolicyEnabled() {
        return this.m_rclbMetricsPolicyEnabled.get();
    }

    void setRCLBMetricsPolicyEnabled(boolean metricsPolicyEnabled) {
        logger.log(Level.FINEST, "RCLB metrics policy enabled: {0}", metricsPolicyEnabled);
        this.m_rclbMetricsPolicyEnabled.set(metricsPolicyEnabled);
    }

    int getDatabaseVersion() {
        return this.m_dbVersion.get();
    }

    void setDatabaseVersion(int version) {
        this.m_dbVersion.compareAndSet(0, version);
    }

    @Override
    public void registerConnectionAffinityCallback(ConnectionAffinityCallback cbk) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "ConnectionAffinityCallback: {0}", cbk);
        this.m_connectionAffinityCallback = cbk;
    }

    @Override
    public void unregisterConnectionAffinityCallback(ConnectionAffinityCallback cbk) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "ConnectionAffinityCallback: {0}", cbk);
        this.m_connectionAffinityCallback = null;
        this.m_affinityMap.clear();
        logger.finest("Affinity hints cleared in the pool.");
    }

    public synchronized ConnectionAffinityCallback getConnectionAffinityCallback() {
        return this.m_connectionAffinityCallback;
    }

    void setConnectionAffinityValue(String instanceKey, boolean newValue) {
        logger.log(Level.FINEST, "instanceKey: {0}, newValue: {1}", new Object[]{instanceKey, newValue});
        assert (instanceKey != null);
        this.m_affinityMap.put(instanceKey, newValue);
    }

    boolean getConnectionAffinityValue(String instanceKey) {
        logger.log(Level.FINEST, "instanceKey: {0}", instanceKey);
        assert (instanceKey != null);
        Boolean lookupValue = this.m_affinityMap.get(instanceKey);
        if (lookupValue == null) {
            logger.log(Level.FINEST, "instance/context not in map, lookup returns null");
        }
        boolean affinityValue = lookupValue != null ? lookupValue : false;
        logger.log(Level.FINEST, "returns: {0}", affinityValue);
        return affinityValue;
    }

    String generateDatabaseInstanceKey(String instanceName, String dbName, String serviceName) {
        return instanceName + "##" + dbName + "##" + serviceName;
    }

    void handleLoadBalancingEvent(OracleLoadBalancingEvent rlbEvent) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "rlbEvent: {0}", rlbEvent);
        String instNameKey = null;
        String dbUniqNameKey = null;
        boolean isInstanceAffinityEnabled = false;
        ConnectionAffinityCallback cbk = this.getConnectionAffinityCallback();
        isInstanceAffinityEnabled = cbk != null ? cbk.getAffinityPolicy() == ConnectionAffinityCallback.AffinityPolicy.TRANSACTION_BASED_AFFINITY : false;
        Set<RACInstance> racInstances = rlbEvent.getRACInstances();
        for (RACInstance racInstance : racInstances) {
            instNameKey = racInstance.getInstance();
            dbUniqNameKey = racInstance.getDatabase();
            OracleDatabaseInstanceInfo tmpInstance = new OracleDatabaseInstanceInfo(dbUniqNameKey, instNameKey);
            tmpInstance.percent = racInstance.getPercent();
            tmpInstance.flag = racInstance.getInstanceStatus().ordinal() + 1;
            tmpInstance.serviceName = this.m_serviceName.get();
            this.updateDatabaseInstanceInfo(tmpInstance, false, false);
            if (isInstanceAffinityEnabled) continue;
            String instanceKey = this.generateDatabaseInstanceKey(instNameKey, dbUniqNameKey, this.m_serviceName.get());
            this.setConnectionAffinityValue(instanceKey, ((RACInstanceImpl)racInstance).getAffinityHint());
        }
        this.processDatabaseInstances();
        this.getRACCallback().lbaEventOccurred(rlbEvent);
    }
}

