/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.criteria;

import javax.xml.bind.annotation.XmlEnum;

@XmlEnum
public enum LogicalOperator {
    EQUAL,
    LESSTHAN,
    GREATERTHAN,
    LESSTHANEQUAL,
    GREATERTHANEQUAL,
    ISEMPTY,
    ISNOTEMPTY,
    NOTEQUAL,
    CONTAINS,
    DOESNOTCONTAIN,
    IN,
    NOTIN,
    AND,
    OR,
    NOT,
    XOR,
    STARTSWITH,
    ENDSWITH,
    DOESNOTSTARTWITH,
    DOESNOTENDWITH,
    EVALCHILDFIELDS,
    LENGTHEQUALS,
    LENGTHLESSTHAN,
    LENGTHGREATERTHAN,
    REGEX,
    GREATERTHANTODAY,
    LESSTHANTODAY,
    EQUALTOTODAY,
    NOTEQUALTOTODAY,
    CONTAINSUNPARSABLE,
    NOTGREATERTHANTODAY,
    NOTLESSTHANTODAY,
    DOESNOTCONTAINUNPARSABLE,
    TIER1EQUALS,
    TIER2EQUALS,
    TIER3EQUALS,
    TIER4EQUALS,
    MISSINGCONTENT,
    NOTMISSINGCONTENT,
    BETWEEN,
    NUMINSTANCESEQUAL(true),
    NUMINSTANCESGREATERTHAN(true),
    NUMINSTANCESLESSTHAN(true),
    TOTALLENGTHGREATERTHAN(true),
    TOTALLENGTHLESSTHAN(true),
    TOTALLENGTHEQUALS(true),
    TIMEEQUALS,
    TIMELESSTHAN,
    TIMEGREATERTHAN,
    ISNULL,
    ISNOTNULL;

    private boolean multiField;

    private LogicalOperator() {
        this.setMultiField(false);
    }

    private LogicalOperator(boolean multiField) {
        this.setMultiField(multiField);
    }

    public static LogicalOperator lookUp(String operator) {
        LogicalOperator[] allOper;
        for (LogicalOperator oper : allOper = LogicalOperator.values()) {
            if (!oper.name().equalsIgnoreCase(operator)) continue;
            return oper;
        }
        throw new IllegalArgumentException("No value found for " + operator);
    }

    public void setMultiField(boolean multiField) {
        this.multiField = multiField;
    }

    public boolean isMultiField() {
        return this.multiField;
    }

    public LogicalOperator invert() {
        switch (this) {
            case EQUAL: {
                return NOTEQUAL;
            }
            case LESSTHAN: {
                return GREATERTHANEQUAL;
            }
            case GREATERTHAN: {
                return LESSTHANEQUAL;
            }
            case LESSTHANEQUAL: {
                return GREATERTHAN;
            }
            case GREATERTHANEQUAL: {
                return LESSTHAN;
            }
            case ISEMPTY: {
                return ISNOTEMPTY;
            }
            case ISNOTEMPTY: {
                return ISEMPTY;
            }
            case NOTEQUAL: {
                return EQUAL;
            }
            case CONTAINS: {
                return DOESNOTCONTAIN;
            }
            case DOESNOTCONTAIN: {
                return CONTAINS;
            }
            case IN: {
                return NOTIN;
            }
            case NOTIN: {
                return IN;
            }
            case STARTSWITH: {
                return DOESNOTSTARTWITH;
            }
            case DOESNOTSTARTWITH: {
                return STARTSWITH;
            }
            case ENDSWITH: {
                return DOESNOTENDWITH;
            }
            case DOESNOTENDWITH: {
                return ENDSWITH;
            }
            case GREATERTHANTODAY: {
                return NOTGREATERTHANTODAY;
            }
            case NOTGREATERTHANTODAY: {
                return GREATERTHANTODAY;
            }
            case LESSTHANTODAY: {
                return NOTLESSTHANTODAY;
            }
            case NOTLESSTHANTODAY: {
                return LESSTHANTODAY;
            }
            case CONTAINSUNPARSABLE: {
                return DOESNOTCONTAINUNPARSABLE;
            }
            case DOESNOTCONTAINUNPARSABLE: {
                return CONTAINSUNPARSABLE;
            }
            case MISSINGCONTENT: {
                return NOTMISSINGCONTENT;
            }
            case NOTMISSINGCONTENT: {
                return MISSINGCONTENT;
            }
            case EQUALTOTODAY: {
                return NOTEQUALTOTODAY;
            }
            case NOTEQUALTOTODAY: {
                return EQUALTOTODAY;
            }
        }
        return this;
    }
}

