/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.model;

import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.RootAssetRevision;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Group
extends Asset
implements Serializable {
    private static final long serialVersionUID = 3945489989710490803L;
    private GroupType groupType;
    private List<RootAssetRevision> revisions = new ArrayList<RootAssetRevision>();
    private Long seriesDocumentId;
    private Long seasonAssetId;

    public void addRevision(RootAssetRevision revision) {
        revision.setDocumentId(this.getId());
        if (this.revisions == null) {
            this.revisions = new ArrayList<RootAssetRevision>();
        }
        this.revisions.add(revision);
    }

    public List<RootAssetRevision> getRevisions() {
        return this.revisions;
    }

    public void addRootAssetRevision(RootAssetRevision newRevision) throws MetadataException {
        newRevision.setRevisionNumber(this.getLatestRevisionNumber());
        this.addRevision(newRevision);
    }

    public void setRevisions(List<RootAssetRevision> revisions) {
        this.revisions = revisions;
    }

    public Group(long id) {
        this.setId(id);
    }

    public Group() {
    }

    @Override
    public String getType() {
        return this.groupType.name();
    }

    public void setType(String groupType) {
        this.groupType = GroupType.valueOf(groupType);
    }

    public void setType(GroupType groupType) {
        this.groupType = groupType;
    }

    public RootAssetRevision getRevision(int revisionNumber) {
        for (RootAssetRevision r : this.revisions) {
            if (r.getRevisionNumber() != revisionNumber) continue;
            return r;
        }
        return null;
    }

    public RootAssetRevision getLatestRootAssetRevision() {
        return this.getRevision(this.getLatestRevisionNumber());
    }

    public Long getSeriesDocumentId() {
        return this.seriesDocumentId;
    }

    public Long getSeasonAssetId() {
        return this.seasonAssetId;
    }

    public void setSeriesDocumentId(Long seriesDocumentId) {
        this.seriesDocumentId = seriesDocumentId;
    }

    public void setSeasonAssetId(Long seasonAssetId) {
        this.seasonAssetId = seasonAssetId;
    }

    public static enum GroupType {
        GROUP,
        PACKAGE,
        SERIES,
        SEASON,
        CHAPTERLIST,
        MOVIE,
        PREVIEW;

    }
}

