/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.util;

import com.tandbergtv.metadatamanager.util.MappingFileParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class XPathMappingReader {
    private static String MAPPING_DELIMITER = ",";
    private static String xPathMappingFiile = "XPathMapping.dat";
    private Map<String, String> ecmfXpathLookUp = new HashMap<String, String>();
    private Map<String, String> ttvXpathLookUp = new HashMap<String, String>();
    private static Logger logger = Logger.getLogger(XPathMappingReader.class);
    private static XPathMappingReader instance = null;

    public static synchronized XPathMappingReader getInstance() {
        if (instance == null) {
            instance = new XPathMappingReader();
        }
        return instance;
    }

    private XPathMappingReader() {
        BufferedReader br = new BufferedReader(new InputStreamReader(MappingFileParser.class.getClassLoader().getResourceAsStream(xPathMappingFiile)));
        this.readInputStream(br);
    }

    private void readInputStream(BufferedReader br) throws RuntimeException {
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#") || line.indexOf(MAPPING_DELIMITER) == -1) continue;
                String[] xpathMapping = line.split(MAPPING_DELIMITER);
                this.ecmfXpathLookUp.put(xpathMapping[0].trim(), xpathMapping[1].trim());
                this.ttvXpathLookUp.put(xpathMapping[1].trim(), xpathMapping[0].trim());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Unable to close reader ", (Throwable)ex);
            }
        }
    }

    public Map<String, String> getEcmfXpathLookUp() {
        return this.ecmfXpathLookUp;
    }

    public Map<String, String> getTtvXpathLookUp() {
        return this.ttvXpathLookUp;
    }
}

