/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.terminal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import org.jboss.aesh.terminal.CursorPosition;
import org.jboss.aesh.terminal.Terminal;
import org.jboss.aesh.terminal.TerminalCharacter;
import org.jboss.aesh.terminal.TerminalSize;

public class TestTerminal
implements Terminal {
    private InputStream input;
    private Writer writer;
    private TerminalSize size;

    @Override
    public void init(InputStream inputStream, OutputStream stdOut, OutputStream stdErr) {
        this.input = inputStream;
        this.writer = new PrintWriter(new OutputStreamWriter(stdOut));
        this.size = new TerminalSize(24, 80);
    }

    @Override
    public int[] read(boolean readAhead) throws IOException {
        int input = this.input.read();
        int available = this.input.available();
        if (available > 1 && readAhead) {
            int[] in = new int[available];
            in[0] = input;
            for (int c = 1; c < available; ++c) {
                in[c] = this.input.read();
            }
            return in;
        }
        return new int[]{input};
    }

    @Override
    public void writeToStdOut(String out) throws IOException {
        if (out != null && out.length() > 0) {
            this.writer.write(out);
            this.writer.flush();
        }
    }

    @Override
    public void writeToStdOut(char[] out) throws IOException {
        if (out != null && out.length > 0) {
            this.writer.write(out);
            this.writer.flush();
        }
    }

    @Override
    public void writeToStdOut(char out) throws IOException {
        this.writer.write(out);
        this.writer.flush();
    }

    @Override
    public void writeToStdErr(String err) throws IOException {
        if (err != null && err.length() > 0) {
            this.writer.write(err);
            this.writer.flush();
        }
    }

    @Override
    public void writeToStdErr(char[] err) throws IOException {
        if (err != null && err.length > 0) {
            this.writer.write(err);
            this.writer.flush();
        }
    }

    @Override
    public void writeToStdErr(char err) throws IOException {
        this.writer.write(err);
        this.writer.flush();
    }

    @Override
    public TerminalSize getSize() {
        return this.size;
    }

    @Override
    public CursorPosition getCursor() {
        return new CursorPosition(0, 0);
    }

    @Override
    public void setCursor(CursorPosition cp) throws IOException {
    }

    @Override
    public void moveCursor(int r, int c) throws IOException {
    }

    @Override
    public void writeChar(TerminalCharacter character) throws IOException {
        this.writeToStdOut(character.getCharacter());
    }

    @Override
    public void writeChars(List<TerminalCharacter> chars) throws IOException {
        for (TerminalCharacter c : chars) {
            this.writeToStdOut(c.getCharacter());
        }
    }

    @Override
    public boolean isEchoEnabled() {
        return false;
    }

    @Override
    public void reset() throws IOException {
    }

    @Override
    public void clear() throws IOException {
    }
}

