/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.client;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Arrays;
import org.hornetq.api.core.HornetQAddressFullException;
import org.hornetq.api.core.HornetQConnectionTimedOutException;
import org.hornetq.api.core.HornetQDisconnectedException;
import org.hornetq.api.core.HornetQIllegalStateException;
import org.hornetq.api.core.HornetQInterceptorRejectedPacketException;
import org.hornetq.api.core.HornetQInternalErrorException;
import org.hornetq.api.core.HornetQLargeMessageException;
import org.hornetq.api.core.HornetQLargeMessageInterruptedException;
import org.hornetq.api.core.HornetQNotConnectedException;
import org.hornetq.api.core.HornetQObjectClosedException;
import org.hornetq.api.core.HornetQTransactionOutcomeUnknownException;
import org.hornetq.api.core.HornetQTransactionRolledBackException;
import org.hornetq.api.core.HornetQUnBlockedException;
import org.hornetq.core.client.HornetQClientMessageBundle;
import org.hornetq.core.cluster.DiscoveryGroup;
import org.hornetq.spi.core.remoting.Connection;
import org.w3c.dom.Node;

public class HornetQClientMessageBundle_$bundle
implements Serializable,
HornetQClientMessageBundle {
    private static final long serialVersionUID = 1L;
    public static final HornetQClientMessageBundle_$bundle INSTANCE = new HornetQClientMessageBundle_$bundle();
    private static final String closeListenerCannotBeNull = "HQ119039: Close Listener cannot be null";
    private static final String invalidWindowSize = "HQ119035: Invalid window size {0}";
    private static final String connectionTimedOutInInitialBroadcast = "HQ119012: Timed out waiting to receive initial broadcast from cluster";
    private static final String noTCForSessionFactory = "HQ119024: Couldn't select a TransportConfiguration to create SessionFactory";
    private static final String txOutcomeUnknown = "HQ119031: The transaction was rolled back on failover however commit may have been succesful";
    private static final String oneNodeHasChildren = "HQ119050: one node has children and the other doesn't";
    private static final String errorReadingBody = "HQ119026: Error reading the LargeMessageBody";
    private static final String secondNodeNull = "HQ119046: the second node to be compared is null";
    private static final String failedToInitialiseSessionFactory = "HQ119004: Failed to initialise session factory";
    private static final String connectionExists = "HQ119041: Connection already exists with id {0}";
    private static final String addressIsFull = "HQ119058: Address \"{0}\" is full. Message encode size = {1}B";
    private static final String mustBeBoolean = "HQ119052: Element {0} requires a valid Boolean value, but '{1}' cannot be parsed as a Boolean";
    private static final String connectionTimedOut = "HQ119011: Did not receive data from server for {0}";
    private static final String mustBeLong = "HQ119055: Element {0} requires a valid Long value, but '{1}' cannot be parsed as a Long";
    private static final String cannotConnectToServers = "HQ119007: Cannot connect to server(s). Tried with all available servers.";
    private static final String errorSavingBody = "HQ119025: Error saving the message body";
    private static final String nodeHasDifferentChildNumber = "HQ119051: nodes hava a different number of children";
    private static final String connectionDestroyed = "HQ119010: Connection is destroyed";
    private static final String nodeHaveDifferentNames = "HQ119047: nodes have different node names";
    private static final String noCodec = "HQ119044: No available codec to decode password!";
    private static final String invalidManagementParam = "HQ119034: Params for management operations must be of the following type: int long double String boolean Map or array thereof but found {0}";
    private static final String nullListener = "HQ119042: Invalid argument null listener";
    private static final String timedOutSendingPacket = "HQ119014: Timed out waiting for response when sending packet {0}";
    private static final String channelDisconnected = "HQ119006: Channel disconnected";
    private static final String failListenerCannotBeNull = "HQ119040: Fail Listener cannot be null";
    private static final String failedToCreateSession = "HQ119001: Failed to create session";
    private static final String interceptorRejectedPacket = "HQ119059: Interceptor {0} rejected packet in a blocking call. This call will never complete.";
    private static final String messageHandlerSet = "HQ119020: Cannot call receive(...) - a MessageHandler is set";
    private static final String invalidEncodeType = "HQ119033: Invalid type: {0}";
    private static final String nettyError = "HQ119005: Exception in Netty transport";
    private static final String inReceive = "HQ119021: Cannot set MessageHandler - consumer is in receive(...)";
    private static final String consumerClosed = "HQ119017: Consumer is closed";
    private static final String queueMisConfigured = "HQ119003: Queue can not be both durable and temporary";
    private static final String firstNodeNull = "HQ119045: the first node to be compared is null";
    private static final String invalidType = "HQ119032: Invalid type: {0}";
    private static final String nodeHaveDifferentAttNumber = "HQ119048: nodes hava a different number of attributes";
    private static final String noOperationMapped = "HQ119036: No operation mapped to int {0}";
    private static final String attsDontMatch = "HQ119049: attribute {0}={1} doesn't match";
    private static final String producerClosed = "HQ119018: Producer is closed";
    private static final String errordecodingPassword = "HQ119057: Error decoding password";
    private static final String unblockingACall = "HQ119016: Connection failure detected. Unblocking a blocking call that will never get a response";
    private static final String cannotConnectToStaticConnectors2 = "HQ119009: Failed to connect to any static connectors";
    private static final String errorWritingLargeMessage = "HQ119029: Error writing body of message";
    private static final String largeMessageInterrupted = "HQ119060: Large Message Transmission interrupted on consumer shutdown.";
    private static final String connectionTimedOutOnReceiveTopology = "HQ119013: Timed out waiting to receive cluster topology. Group:{0}";
    private static final String cannotConnectToStaticConnectors = "HQ119008: Failed to connect to any static connectors";
    private static final String largeMessageLostSession = "HQ119023: The large message lost connection with its session, either because of a rollback or a closed session";
    private static final String errorClosingLargeMessage = "HQ119027: Error closing stream from LargeMessageBody";
    private static final String headerSizeTooBig = "HQ119022: Header size ({0}) is too big, use the messageBody for large data, or increase minLargeMessageSize";
    private static final String mustBeDouble = "HQ119053: Element {0} requires a valid Double value, but '{1}' cannot be parsed as a Double";
    private static final String timeoutOnLargeMessage = "HQ119028: Timeout waiting for LargeMessage Body";
    private static final String invalidCommandID = "HQ119037: Invalid last Received Command ID: {0}";
    private static final String mustBeInteger = "HQ119054: Element {0} requires a valid Integer value, but '{1}' cannot be parsed as a Integer";
    private static final String txRolledBack = "HQ119030: The transaction was rolled back on failover to a backup server";
    private static final String sessionClosed = "HQ119019: Session is closed";
    private static final String disconnected = "HQ119015: The connection was disconnected because of server shutdown";
    private static final String failedToGetDecoder = "HQ119056: Failed to get decoder";
    private static final String clientSessionClosed = "HQ119000: ClientSession closed while creating session";
    private static final String clietSessionInternal = "HQ119002: Internal Error! ClientSessionFactoryImpl::createSessionInternal just reached a condition that was not supposed to happen. Please inform this condition to the HornetQ team";
    private static final String noChannelToClose = "HQ119038: Cannot find channel with id {0} to close";
    private static final String nullHandler = "HQ119043: Invalid argument null handler";

    protected HornetQClientMessageBundle_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    @Override
    public final IllegalArgumentException closeListenerCannotBeNull() {
        IllegalArgumentException result = new IllegalArgumentException(this.closeListenerCannotBeNull$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String closeListenerCannotBeNull$str() {
        return closeListenerCannotBeNull;
    }

    @Override
    public final IllegalArgumentException invalidWindowSize(Integer size) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.invalidWindowSize$str(), size));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidWindowSize$str() {
        return invalidWindowSize;
    }

    @Override
    public final HornetQConnectionTimedOutException connectionTimedOutInInitialBroadcast() {
        HornetQConnectionTimedOutException result = new HornetQConnectionTimedOutException(this.connectionTimedOutInInitialBroadcast$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String connectionTimedOutInInitialBroadcast$str() {
        return connectionTimedOutInInitialBroadcast;
    }

    @Override
    public final HornetQIllegalStateException noTCForSessionFactory() {
        HornetQIllegalStateException result = new HornetQIllegalStateException(this.noTCForSessionFactory$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noTCForSessionFactory$str() {
        return noTCForSessionFactory;
    }

    @Override
    public final HornetQTransactionOutcomeUnknownException txOutcomeUnknown() {
        HornetQTransactionOutcomeUnknownException result = new HornetQTransactionOutcomeUnknownException(this.txOutcomeUnknown$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String txOutcomeUnknown$str() {
        return txOutcomeUnknown;
    }

    @Override
    public final IllegalArgumentException oneNodeHasChildren() {
        IllegalArgumentException result = new IllegalArgumentException(this.oneNodeHasChildren$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String oneNodeHasChildren$str() {
        return oneNodeHasChildren;
    }

    @Override
    public final HornetQLargeMessageException errorReadingBody(Exception e) {
        HornetQLargeMessageException result = new HornetQLargeMessageException(this.errorReadingBody$str());
        result.initCause(e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorReadingBody$str() {
        return errorReadingBody;
    }

    @Override
    public final IllegalArgumentException secondNodeNull() {
        IllegalArgumentException result = new IllegalArgumentException(this.secondNodeNull$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String secondNodeNull$str() {
        return secondNodeNull;
    }

    @Override
    public final HornetQInternalErrorException failedToInitialiseSessionFactory(Exception e) {
        HornetQInternalErrorException result = new HornetQInternalErrorException(this.failedToInitialiseSessionFactory$str(), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToInitialiseSessionFactory$str() {
        return failedToInitialiseSessionFactory;
    }

    @Override
    public final IllegalArgumentException connectionExists(Object id) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.connectionExists$str(), id));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String connectionExists$str() {
        return connectionExists;
    }

    @Override
    public final HornetQAddressFullException addressIsFull(String addressName, int size) {
        HornetQAddressFullException result = new HornetQAddressFullException(MessageFormat.format(this.addressIsFull$str(), addressName, size));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String addressIsFull$str() {
        return addressIsFull;
    }

    @Override
    public final IllegalArgumentException mustBeBoolean(Node elem, String value) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.mustBeBoolean$str(), elem, value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mustBeBoolean$str() {
        return mustBeBoolean;
    }

    @Override
    public final HornetQConnectionTimedOutException connectionTimedOut(Connection transportConnection) {
        HornetQConnectionTimedOutException result = new HornetQConnectionTimedOutException(MessageFormat.format(this.connectionTimedOut$str(), transportConnection));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String connectionTimedOut$str() {
        return connectionTimedOut;
    }

    @Override
    public final IllegalArgumentException mustBeLong(Node elem, String value) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.mustBeLong$str(), elem, value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mustBeLong$str() {
        return mustBeLong;
    }

    @Override
    public final HornetQNotConnectedException cannotConnectToServers() {
        HornetQNotConnectedException result = new HornetQNotConnectedException(this.cannotConnectToServers$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotConnectToServers$str() {
        return cannotConnectToServers;
    }

    @Override
    public final HornetQLargeMessageException errorSavingBody(Exception e) {
        HornetQLargeMessageException result = new HornetQLargeMessageException(this.errorSavingBody$str());
        result.initCause(e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorSavingBody$str() {
        return errorSavingBody;
    }

    @Override
    public final IllegalArgumentException nodeHasDifferentChildNumber() {
        IllegalArgumentException result = new IllegalArgumentException(this.nodeHasDifferentChildNumber$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nodeHasDifferentChildNumber$str() {
        return nodeHasDifferentChildNumber;
    }

    @Override
    public final HornetQNotConnectedException connectionDestroyed() {
        HornetQNotConnectedException result = new HornetQNotConnectedException(this.connectionDestroyed$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String connectionDestroyed$str() {
        return connectionDestroyed;
    }

    @Override
    public final IllegalArgumentException nodeHaveDifferentNames() {
        IllegalArgumentException result = new IllegalArgumentException(this.nodeHaveDifferentNames$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nodeHaveDifferentNames$str() {
        return nodeHaveDifferentNames;
    }

    @Override
    public final IllegalArgumentException noCodec() {
        IllegalArgumentException result = new IllegalArgumentException(this.noCodec$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noCodec$str() {
        return noCodec;
    }

    @Override
    public final IllegalArgumentException invalidManagementParam(Object type) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.invalidManagementParam$str(), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidManagementParam$str() {
        return invalidManagementParam;
    }

    @Override
    public final IllegalArgumentException nullListener() {
        IllegalArgumentException result = new IllegalArgumentException(this.nullListener$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullListener$str() {
        return nullListener;
    }

    @Override
    public final HornetQConnectionTimedOutException timedOutSendingPacket(Byte type) {
        HornetQConnectionTimedOutException result = new HornetQConnectionTimedOutException(MessageFormat.format(this.timedOutSendingPacket$str(), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String timedOutSendingPacket$str() {
        return timedOutSendingPacket;
    }

    @Override
    public final HornetQNotConnectedException channelDisconnected() {
        HornetQNotConnectedException result = new HornetQNotConnectedException(this.channelDisconnected$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String channelDisconnected$str() {
        return channelDisconnected;
    }

    @Override
    public final IllegalArgumentException failListenerCannotBeNull() {
        IllegalArgumentException result = new IllegalArgumentException(this.failListenerCannotBeNull$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failListenerCannotBeNull$str() {
        return failListenerCannotBeNull;
    }

    @Override
    public final HornetQInternalErrorException failedToCreateSession(Throwable t) {
        HornetQInternalErrorException result = new HornetQInternalErrorException(this.failedToCreateSession$str(), t);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToCreateSession$str() {
        return failedToCreateSession;
    }

    @Override
    public final HornetQInterceptorRejectedPacketException interceptorRejectedPacket(String interceptionResult) {
        HornetQInterceptorRejectedPacketException result = new HornetQInterceptorRejectedPacketException(MessageFormat.format(this.interceptorRejectedPacket$str(), interceptionResult));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String interceptorRejectedPacket$str() {
        return interceptorRejectedPacket;
    }

    @Override
    public final HornetQIllegalStateException messageHandlerSet() {
        HornetQIllegalStateException result = new HornetQIllegalStateException(this.messageHandlerSet$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String messageHandlerSet$str() {
        return messageHandlerSet;
    }

    @Override
    public final IllegalArgumentException invalidEncodeType(Object type) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.invalidEncodeType$str(), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidEncodeType$str() {
        return invalidEncodeType;
    }

    @Override
    public final HornetQInternalErrorException nettyError() {
        HornetQInternalErrorException result = new HornetQInternalErrorException(this.nettyError$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nettyError$str() {
        return nettyError;
    }

    @Override
    public final HornetQIllegalStateException inReceive() {
        HornetQIllegalStateException result = new HornetQIllegalStateException(this.inReceive$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String inReceive$str() {
        return inReceive;
    }

    @Override
    public final HornetQObjectClosedException consumerClosed() {
        HornetQObjectClosedException result = new HornetQObjectClosedException(this.consumerClosed$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String consumerClosed$str() {
        return consumerClosed;
    }

    @Override
    public final HornetQInternalErrorException queueMisConfigured() {
        HornetQInternalErrorException result = new HornetQInternalErrorException(this.queueMisConfigured$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String queueMisConfigured$str() {
        return queueMisConfigured;
    }

    @Override
    public final IllegalArgumentException firstNodeNull() {
        IllegalArgumentException result = new IllegalArgumentException(this.firstNodeNull$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String firstNodeNull$str() {
        return firstNodeNull;
    }

    @Override
    public final IllegalArgumentException invalidType(Object type) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.invalidType$str(), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidType$str() {
        return invalidType;
    }

    @Override
    public final IllegalArgumentException nodeHaveDifferentAttNumber() {
        IllegalArgumentException result = new IllegalArgumentException(this.nodeHaveDifferentAttNumber$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nodeHaveDifferentAttNumber$str() {
        return nodeHaveDifferentAttNumber;
    }

    @Override
    public final IllegalArgumentException noOperationMapped(Integer operation) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.noOperationMapped$str(), operation));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noOperationMapped$str() {
        return noOperationMapped;
    }

    @Override
    public final IllegalArgumentException attsDontMatch(String name, String value) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.attsDontMatch$str(), name, value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String attsDontMatch$str() {
        return attsDontMatch;
    }

    @Override
    public final HornetQObjectClosedException producerClosed() {
        HornetQObjectClosedException result = new HornetQObjectClosedException(this.producerClosed$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String producerClosed$str() {
        return producerClosed;
    }

    @Override
    public final IllegalArgumentException errordecodingPassword(Exception e) {
        IllegalArgumentException result = new IllegalArgumentException(this.errordecodingPassword$str(), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errordecodingPassword$str() {
        return errordecodingPassword;
    }

    @Override
    public final HornetQUnBlockedException unblockingACall() {
        HornetQUnBlockedException result = new HornetQUnBlockedException(this.unblockingACall$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unblockingACall$str() {
        return unblockingACall;
    }

    @Override
    public final HornetQNotConnectedException cannotConnectToStaticConnectors2() {
        HornetQNotConnectedException result = new HornetQNotConnectedException(this.cannotConnectToStaticConnectors2$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotConnectToStaticConnectors2$str() {
        return cannotConnectToStaticConnectors2;
    }

    @Override
    public final HornetQLargeMessageException errorWritingLargeMessage(Exception e) {
        HornetQLargeMessageException result = new HornetQLargeMessageException(this.errorWritingLargeMessage$str());
        result.initCause(e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorWritingLargeMessage$str() {
        return errorWritingLargeMessage;
    }

    @Override
    public final HornetQLargeMessageInterruptedException largeMessageInterrupted() {
        HornetQLargeMessageInterruptedException result = new HornetQLargeMessageInterruptedException(this.largeMessageInterrupted$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String largeMessageInterrupted$str() {
        return largeMessageInterrupted;
    }

    @Override
    public final HornetQConnectionTimedOutException connectionTimedOutOnReceiveTopology(DiscoveryGroup discoveryGroup) {
        HornetQConnectionTimedOutException result = new HornetQConnectionTimedOutException(MessageFormat.format(this.connectionTimedOutOnReceiveTopology$str(), discoveryGroup));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String connectionTimedOutOnReceiveTopology$str() {
        return connectionTimedOutOnReceiveTopology;
    }

    @Override
    public final HornetQNotConnectedException cannotConnectToStaticConnectors(Exception e) {
        HornetQNotConnectedException result = new HornetQNotConnectedException(this.cannotConnectToStaticConnectors$str());
        result.initCause(e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotConnectToStaticConnectors$str() {
        return cannotConnectToStaticConnectors;
    }

    @Override
    public final HornetQIllegalStateException largeMessageLostSession() {
        HornetQIllegalStateException result = new HornetQIllegalStateException(this.largeMessageLostSession$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String largeMessageLostSession$str() {
        return largeMessageLostSession;
    }

    @Override
    public final HornetQLargeMessageException errorClosingLargeMessage(Exception e) {
        HornetQLargeMessageException result = new HornetQLargeMessageException(this.errorClosingLargeMessage$str());
        result.initCause(e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorClosingLargeMessage$str() {
        return errorClosingLargeMessage;
    }

    @Override
    public final HornetQIllegalStateException headerSizeTooBig(Integer headerSize) {
        HornetQIllegalStateException result = new HornetQIllegalStateException(MessageFormat.format(this.headerSizeTooBig$str(), headerSize));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String headerSizeTooBig$str() {
        return headerSizeTooBig;
    }

    @Override
    public final IllegalArgumentException mustBeDouble(Node elem, String value) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.mustBeDouble$str(), elem, value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mustBeDouble$str() {
        return mustBeDouble;
    }

    @Override
    public final HornetQLargeMessageException timeoutOnLargeMessage() {
        HornetQLargeMessageException result = new HornetQLargeMessageException(this.timeoutOnLargeMessage$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String timeoutOnLargeMessage$str() {
        return timeoutOnLargeMessage;
    }

    @Override
    public final IllegalArgumentException invalidCommandID(Integer lastReceivedCommandID) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.invalidCommandID$str(), lastReceivedCommandID));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidCommandID$str() {
        return invalidCommandID;
    }

    @Override
    public final IllegalArgumentException mustBeInteger(Node elem, String value) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.mustBeInteger$str(), elem, value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mustBeInteger$str() {
        return mustBeInteger;
    }

    @Override
    public final HornetQTransactionRolledBackException txRolledBack() {
        HornetQTransactionRolledBackException result = new HornetQTransactionRolledBackException(this.txRolledBack$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String txRolledBack$str() {
        return txRolledBack;
    }

    @Override
    public final HornetQObjectClosedException sessionClosed() {
        HornetQObjectClosedException result = new HornetQObjectClosedException(this.sessionClosed$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String sessionClosed$str() {
        return sessionClosed;
    }

    @Override
    public final HornetQDisconnectedException disconnected() {
        HornetQDisconnectedException result = new HornetQDisconnectedException(this.disconnected$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String disconnected$str() {
        return disconnected;
    }

    @Override
    public final IllegalArgumentException failedToGetDecoder(Exception e) {
        IllegalArgumentException result = new IllegalArgumentException(this.failedToGetDecoder$str(), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToGetDecoder$str() {
        return failedToGetDecoder;
    }

    @Override
    public final HornetQInternalErrorException clientSessionClosed() {
        HornetQInternalErrorException result = new HornetQInternalErrorException(this.clientSessionClosed$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String clientSessionClosed$str() {
        return clientSessionClosed;
    }

    @Override
    public final HornetQInternalErrorException clietSessionInternal() {
        HornetQInternalErrorException result = new HornetQInternalErrorException(this.clietSessionInternal$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String clietSessionInternal$str() {
        return clietSessionInternal;
    }

    @Override
    public final IllegalArgumentException noChannelToClose(Long id) {
        IllegalArgumentException result = new IllegalArgumentException(MessageFormat.format(this.noChannelToClose$str(), id));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noChannelToClose$str() {
        return noChannelToClose;
    }

    @Override
    public final IllegalArgumentException nullHandler() {
        IllegalArgumentException result = new IllegalArgumentException(this.nullHandler$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullHandler$str() {
        return nullHandler;
    }
}

