/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.impl.netty;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.buffer.DynamicChannelBuffer;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;

public class HornetQFrameDecoder2
extends SimpleChannelUpstreamHandler {
    private ChannelBuffer previousData = ChannelBuffers.EMPTY_BUFFER;

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        ChannelBuffer in = (ChannelBuffer)e.getMessage();
        if (this.previousData.readable()) {
            ChannelBuffer frame;
            int length;
            if (this.previousData.readableBytes() + in.readableBytes() < 4) {
                this.append(in, 200);
                return;
            }
            switch (this.previousData.readableBytes()) {
                case 1: {
                    length = this.previousData.getUnsignedByte(this.previousData.readerIndex()) << 24 | in.getMedium(in.readerIndex());
                    if (in.readableBytes() - 3 >= length) break;
                    this.append(in, length);
                    return;
                }
                case 2: {
                    length = this.previousData.getUnsignedShort(this.previousData.readerIndex()) << 16 | in.getUnsignedShort(in.readerIndex());
                    if (in.readableBytes() - 2 >= length) break;
                    this.append(in, length);
                    return;
                }
                case 3: {
                    length = this.previousData.getUnsignedMedium(this.previousData.readerIndex()) << 8 | in.getUnsignedByte(in.readerIndex());
                    if (in.readableBytes() - 1 >= length) break;
                    this.append(in, length);
                    return;
                }
                case 4: {
                    length = this.previousData.getInt(this.previousData.readerIndex());
                    if (in.readableBytes() >= length) break;
                    this.append(in, length);
                    return;
                }
                default: {
                    length = this.previousData.getInt(this.previousData.readerIndex());
                    if (in.readableBytes() + this.previousData.readableBytes() - 4 >= length) break;
                    this.append(in, length);
                    return;
                }
            }
            if (this.previousData instanceof DynamicChannelBuffer) {
                this.previousData.writeBytes(in, length + 4 - this.previousData.readableBytes());
                frame = this.previousData;
            } else {
                frame = ChannelBuffers.dynamicBuffer(length + 4);
                frame.writeBytes(this.previousData, this.previousData.readerIndex(), this.previousData.readableBytes());
                frame.writeBytes(in, length + 4 - frame.writerIndex());
            }
            frame.skipBytes(4);
            if (!in.readable()) {
                this.previousData = ChannelBuffers.EMPTY_BUFFER;
                Channels.fireMessageReceived(ctx, (Object)frame);
                return;
            }
            Channels.fireMessageReceived(ctx, (Object)frame);
        }
        this.decode(ctx, in);
        this.previousData = in.readable() ? in : ChannelBuffers.EMPTY_BUFFER;
    }

    private void decode(ChannelHandlerContext ctx, ChannelBuffer in) {
        int length;
        int readableBytes;
        while ((readableBytes = in.readableBytes()) >= 4 && readableBytes >= (length = in.getInt(in.readerIndex())) + 4) {
            ChannelBuffer frame = ChannelBuffers.dynamicBuffer(length + 4);
            frame.writeBytes(in, length + 4);
            frame.skipBytes(4);
            Channels.fireMessageReceived(ctx, (Object)frame);
        }
    }

    private void append(ChannelBuffer in, int length) {
        if (this.previousData instanceof DynamicChannelBuffer) {
            this.previousData.discardReadBytes();
            this.previousData.writeBytes(in);
        } else {
            ChannelBuffer newPreviousData = ChannelBuffers.dynamicBuffer(Math.max(this.previousData.readableBytes() + in.readableBytes(), length + 4));
            newPreviousData.writeBytes(this.previousData);
            newPreviousData.writeBytes(in);
            this.previousData = newPreviousData;
        }
    }
}

