/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remotingjmx;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Endpoint;
import org.jboss.remotingjmx.DelegatingRemotingConnectorServer;
import org.jboss.remotingjmx.MBeanServerManager;
import org.jboss.remotingjmx.ServerMessageEventHandlerFactory;
import org.jboss.remotingjmx.VersionedProxy;
import org.jboss.remotingjmx.WrappedMBeanServerConnection;

public class RemotingConnectorServer
extends JMXConnectorServer {
    private static final Logger log = Logger.getLogger(RemotingConnectorServer.class);
    private final DelegatingRemotingConnectorServer connectorServer;

    public RemotingConnectorServer(MBeanServer mbeanServer, Endpoint endpoint) {
        this(mbeanServer, endpoint, Collections.EMPTY_MAP);
    }

    public RemotingConnectorServer(MBeanServer mbeanServer, Endpoint endpoint, ServerMessageEventHandlerFactory serverMessageEventHandlerFactory) {
        this(mbeanServer, endpoint, Executors.newCachedThreadPool(), Collections.EMPTY_MAP, serverMessageEventHandlerFactory);
    }

    public RemotingConnectorServer(MBeanServer mbeanServer, Endpoint endpoint, Map<String, ?> environment) {
        this(mbeanServer, endpoint, Executors.newCachedThreadPool(), environment, null);
    }

    public RemotingConnectorServer(MBeanServer mbeanServer, Endpoint endpoint, Map<String, ?> environment, ServerMessageEventHandlerFactory serverMessageEventHandlerFactory) {
        this(mbeanServer, endpoint, Executors.newCachedThreadPool(), environment, serverMessageEventHandlerFactory);
    }

    public RemotingConnectorServer(MBeanServer mbeanServer, Endpoint endpoint, Executor executor) {
        this(mbeanServer, endpoint, executor, Collections.EMPTY_MAP, null);
    }

    public RemotingConnectorServer(MBeanServer mbeanServer, Endpoint endpoint, Executor executor, Map<String, ?> environment, ServerMessageEventHandlerFactory serverMessageEventHandlerFactory) {
        super(mbeanServer);
        MBeanServerManager serverManager = new MBeanServerManager(){
            private final WrappedMBeanServerConnection connection = new WrappedMBeanServerConnection(){

                @Override
                public MBeanServerConnection getMBeanServerConnection() {
                    return RemotingConnectorServer.this.getMBeanServer();
                }

                @Override
                public void connectionOpened(VersionedProxy proxy) {
                    String connectionId = proxy.getConnectionId();
                    log.debugf("Connection '%s' now opened.", (Object)connectionId);
                    RemotingConnectorServer.this.connectionOpened(connectionId, "", null);
                }

                @Override
                public void connectionClosed(VersionedProxy proxy) {
                    String connectionId = proxy.getConnectionId();
                    log.debugf("Connection '%s' now opened.", (Object)connectionId);
                    RemotingConnectorServer.this.connectionClosed(connectionId, "", null);
                }
            };

            @Override
            public WrappedMBeanServerConnection getDefaultMBeanServer() {
                return this.connection;
            }

            @Override
            public WrappedMBeanServerConnection getMBeanServer(Map<String, String> parameters) {
                if (parameters.isEmpty()) {
                    return this.getDefaultMBeanServer();
                }
                return null;
            }
        };
        this.connectorServer = new DelegatingRemotingConnectorServer(serverManager, endpoint, executor, environment, serverMessageEventHandlerFactory);
    }

    @Override
    public void start() throws IOException {
        this.connectorServer.start();
    }

    @Override
    public void stop() throws IOException {
        this.connectorServer.stop();
    }

    @Override
    public boolean isActive() {
        return this.connectorServer.isActive();
    }

    @Override
    public JMXServiceURL getAddress() {
        return this.connectorServer.getAddress();
    }

    @Override
    public Map<String, ?> getAttributes() {
        return this.connectorServer.getAttributes();
    }
}

