/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.PhysicalAddress;
import org.jgroups.View;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.PingData;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

public class FILE_PING
extends Discovery {
    protected static final String SUFFIX = ".node";
    @Property(description="The absolute path of the shared file")
    protected String location = File.separator + "tmp" + File.separator + "jgroups";
    @Property(description="Interval (in milliseconds) at which the own Address is written. 0 disables it.")
    protected long interval = 60000L;
    protected File root_dir = null;
    protected FilenameFilter filter;
    private Future<?> writer_future;

    @Override
    public void init() throws Exception {
        super.init();
        this.createRootDir();
    }

    @Override
    public void start() throws Exception {
        super.start();
        if (this.interval > 0L) {
            this.writer_future = this.timer.scheduleWithFixedDelay(new WriterTask(), this.interval, this.interval, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void stop() {
        if (this.writer_future != null) {
            this.writer_future.cancel(false);
            this.writer_future = null;
        }
        super.stop();
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public Collection<PhysicalAddress> fetchClusterMembers(String cluster_name) {
        List<PingData> existing_mbrs = this.readAll(cluster_name);
        PhysicalAddress physical_addr = (PhysicalAddress)this.down(new Event(87, this.local_addr));
        List<PhysicalAddress> physical_addrs = Arrays.asList(physical_addr);
        PingData data = new PingData(this.local_addr, null, false, UUID.get(this.local_addr), physical_addrs);
        this.writeToFile(data, cluster_name);
        if (existing_mbrs.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<PhysicalAddress> retval = new HashSet<PhysicalAddress>();
        for (PingData tmp : existing_mbrs) {
            Collection<PhysicalAddress> dests;
            Collection<PhysicalAddress> collection = dests = tmp != null ? tmp.getPhysicalAddrs() : null;
            if (dests == null) continue;
            for (PhysicalAddress dest : dests) {
                if (dest == null) continue;
                retval.add(dest);
            }
        }
        return retval;
    }

    @Override
    public boolean sendDiscoveryRequestsInParallel() {
        return true;
    }

    @Override
    public Object down(Event evt) {
        Object retval = super.down(evt);
        if (evt.getType() == 6) {
            this.handleView((View)evt.getArg());
        }
        return retval;
    }

    protected void createRootDir() {
        this.root_dir = new File(this.location);
        if (this.root_dir.exists()) {
            if (!this.root_dir.isDirectory()) {
                throw new IllegalArgumentException("location " + this.root_dir.getPath() + " is not a directory");
            }
        } else {
            this.root_dir.mkdirs();
        }
        if (!this.root_dir.exists()) {
            throw new IllegalArgumentException("location " + this.root_dir.getPath() + " could not be accessed");
        }
        this.filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(FILE_PING.SUFFIX);
            }
        };
    }

    protected void handleView(View view) {
        boolean is_coordinator;
        List<Address> mbrs = view.getMembers();
        boolean bl = is_coordinator = !mbrs.isEmpty() && ((Address)mbrs.iterator().next()).equals(this.local_addr);
        if (is_coordinator) {
            List<PingData> data = this.readAll(this.group_addr);
            for (PingData entry : data) {
                Address addr = entry.getAddress();
                if (addr == null || mbrs.contains(addr)) continue;
                this.remove(this.group_addr, addr);
            }
        }
    }

    protected void remove(String clustername, Address addr) {
        if (clustername == null || addr == null) {
            return;
        }
        File dir = new File(this.root_dir, clustername);
        if (!dir.exists()) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("remove : " + clustername);
        }
        String filename = addr instanceof UUID ? ((UUID)addr).toStringLong() : addr.toString();
        File file = new File(dir, filename + SUFFIX);
        this.deleteFile(file);
    }

    protected synchronized List<PingData> readAll(String clustername) {
        File[] files;
        ArrayList<PingData> retval = new ArrayList<PingData>();
        File dir = new File(this.root_dir, clustername);
        if (!dir.exists()) {
            dir.mkdir();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("reading all : " + clustername);
        }
        if ((files = dir.listFiles(this.filter)) != null) {
            for (File file : files) {
                PingData data = null;
                for (int i = 0; i < 3; ++i) {
                    data = null;
                    if (file.exists()) {
                        data = this.readFile(file);
                    }
                    if (data != null) break;
                    Util.sleep(100L);
                }
                if (data == null) {
                    this.log.warn("failed parsing content in " + file.getAbsolutePath() + ": removing it from " + clustername);
                    this.deleteFile(file);
                    continue;
                }
                retval.add(data);
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized PingData readFile(File file) {
        PingData pingData;
        PingData retval = null;
        DataInputStream in = null;
        try {
            in = new DataInputStream(new FileInputStream(file));
            PingData tmp = new PingData();
            tmp.readFrom(in);
            pingData = tmp;
        }
        catch (Exception e) {
            try {
                this.log.debug("failed to read file : " + file.getAbsolutePath(), e);
            }
            catch (Throwable throwable) {
                Util.close(in);
                throw throwable;
            }
            Util.close(in);
            return retval;
        }
        Util.close(in);
        return pingData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void writeToFile(PingData data, String clustername) {
        File dir = new File(this.root_dir, clustername);
        if (!dir.exists()) {
            dir.mkdir();
        }
        if (data == null) {
            return;
        }
        String filename = FILE_PING.addressAsString(this.local_addr);
        File tmpFile = this.writeToTempFile(dir, data);
        if (tmpFile == null) {
            return;
        }
        File destination = new File(dir, filename + SUFFIX);
        try {
            FileChannel src_ch = new FileInputStream(tmpFile).getChannel();
            FileChannel dest_ch = new FileOutputStream(destination).getChannel();
            src_ch.transferTo(0L, src_ch.size(), dest_ch);
            src_ch.close();
            dest_ch.close();
            if (this.log.isTraceEnabled()) {
                this.log.trace("Moved: " + tmpFile.getName() + "->" + destination.getName());
            }
        }
        catch (IOException ioe) {
            this.log.error("attempt to move failed at " + clustername + " : " + tmpFile.getName() + "->" + destination.getName(), ioe);
        }
        finally {
            this.deleteFile(tmpFile);
        }
    }

    protected static String addressAsString(Address address) {
        if (address == null) {
            return "";
        }
        if (address instanceof UUID) {
            return ((UUID)address).toStringLong();
        }
        return address.toString();
    }

    private boolean deleteFile(File file) {
        boolean result = true;
        if (this.log.isTraceEnabled()) {
            this.log.trace("Attempting to delete file : " + file.getAbsolutePath());
        }
        if (file != null && file.exists()) {
            try {
                result = file.delete();
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Deleted file result: " + file.getAbsolutePath() + " : " + result);
                }
            }
            catch (Throwable e) {
                this.log.error("Failed to delete file: " + file.getAbsolutePath(), e);
            }
        }
        return result;
    }

    private File writeToTempFile(File dir, PingData data) {
        DataOutputStream out = null;
        String filename = FILE_PING.addressAsString(this.local_addr);
        File file = new File(dir, filename + ".tmp");
        try {
            out = new DataOutputStream(new FileOutputStream(file));
            data.writeTo(out);
            Util.close(out);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Stored temporary file: " + file.getAbsolutePath());
            }
        }
        catch (Exception e) {
            Util.close(out);
            this.log.error("Failed to write temporary file: " + file.getAbsolutePath(), e);
            this.deleteFile(file);
            return null;
        }
        return file;
    }

    protected class WriterTask
    implements Runnable {
        protected WriterTask() {
        }

        @Override
        public void run() {
            PhysicalAddress physical_addr = (PhysicalAddress)FILE_PING.this.down(new Event(87, FILE_PING.this.local_addr));
            List<PhysicalAddress> physical_addrs = Arrays.asList(physical_addr);
            PingData data = new PingData(FILE_PING.this.local_addr, null, false, UUID.get(FILE_PING.this.local_addr), physical_addrs);
            FILE_PING.this.writeToFile(data, FILE_PING.this.group_addr);
        }
    }
}

