/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.relay;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jgroups.protocols.relay.SiteAddress;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

public class SiteUUID
extends UUID
implements SiteAddress {
    private static final long serialVersionUID = 3748908939644729773L;
    protected String name;
    protected short site;
    protected static final ConcurrentMap<Short, String> site_cache = new ConcurrentHashMap<Short, String>(10);

    public SiteUUID() {
    }

    public SiteUUID(long mostSigBits, long leastSigBits, String name, short site) {
        super(mostSigBits, leastSigBits);
        this.name = name;
        this.site = site;
    }

    public SiteUUID(UUID uuid, String name, short site) {
        super(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
        this.name = name;
        this.site = site;
    }

    public String getName() {
        return this.name;
    }

    public static void addToCache(short site, String name) {
        site_cache.putIfAbsent(site, name);
    }

    public static void replaceInCache(short site, String name) {
        site_cache.put(site, name);
    }

    public static String getSiteName(short site) {
        return (String)site_cache.get(site);
    }

    public static void clearCache() {
        site_cache.clear();
    }

    @Override
    public short getSite() {
        return this.site;
    }

    @Override
    public UUID copy() {
        return new SiteUUID(this.mostSigBits, this.leastSigBits, this.name, this.site);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.name = in.readUTF();
        this.site = in.readShort();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeUTF(this.name);
        out.writeShort(this.site);
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        super.readFrom(in);
        this.name = Util.readString(in);
        this.site = in.readShort();
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        super.writeTo(out);
        Util.writeString(this.name, out);
        out.writeShort(this.site);
    }

    @Override
    public int size() {
        return super.size() + Util.size(this.name) + 2;
    }

    @Override
    public String toString() {
        String retval = this.name != null ? this.name : super.toString();
        String suffix = (String)site_cache.get(this.site);
        return retval + ":" + (suffix != null ? suffix : String.valueOf(this.site));
    }

    protected static short getSite(String site_name) {
        for (Map.Entry entry : site_cache.entrySet()) {
            if (!((String)entry.getValue()).equals(site_name)) continue;
            return (Short)entry.getKey();
        }
        throw new IllegalArgumentException("site \"" + site_name + "\" does not have a corresponding ID");
    }
}

