/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class BlockingInputStream
extends InputStream {
    protected boolean closed = false;
    protected final byte[] buf;
    protected int read_pos = 0;
    protected int write_pos = 0;
    protected final Lock lock = new ReentrantLock();
    protected final Condition not_full = this.lock.newCondition();
    protected final Condition not_empty = this.lock.newCondition();

    public BlockingInputStream() {
        this(100000);
    }

    public BlockingInputStream(int capacity) {
        this.buf = new byte[capacity];
    }

    @Override
    public int read() throws IOException {
        this.lock.lock();
        try {
            while (true) {
                if (this.read_pos < this.write_pos) {
                    int retval = this.buf[this.read_pos++] & 0xFF;
                    this.not_full.signal();
                    int n = retval;
                    return n;
                }
                if (this.closed) {
                    int retval = -1;
                    return retval;
                }
                try {
                    this.not_empty.await();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        BlockingInputStream.sanityCheck(b, off, len);
        this.lock.lock();
        try {
            while (true) {
                if (this.read_pos < this.write_pos) {
                    int bytes_to_read = Math.min(len, this.size());
                    System.arraycopy(this.buf, this.read_pos, b, off, bytes_to_read);
                    this.read_pos += bytes_to_read;
                    this.not_full.signal();
                    int n = bytes_to_read;
                    return n;
                }
                if (this.closed) {
                    int bytes_to_read = -1;
                    return bytes_to_read;
                }
                try {
                    this.not_empty.await();
                }
                catch (InterruptedException e) {}
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void write(byte[] buf) throws IOException {
        if (buf != null) {
            this.write(buf, 0, buf.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] buf, int offset, int length) throws IOException {
        if (buf == null) {
            return;
        }
        BlockingInputStream.sanityCheck(buf, offset, length);
        this.lock.lock();
        try {
            if (this.closed) {
                return;
            }
            int bytes_written = 0;
            while (bytes_written < length && !this.closed) {
                if (this.read_pos > 0 && length - bytes_written > this.remaining()) {
                    this.compact();
                }
                if (this.remaining() > 0) {
                    int bytes_to_write = Math.min(length - bytes_written, this.remaining());
                    System.arraycopy(buf, offset + bytes_written, this.buf, this.write_pos, bytes_to_write);
                    this.write_pos += bytes_to_write;
                    bytes_written += bytes_to_write;
                    this.not_empty.signal();
                    continue;
                }
                try {
                    this.not_full.await();
                }
                catch (InterruptedException e) {}
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long skip(long n) throws IOException {
        throw new IOException("skip() not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        this.lock.lock();
        try {
            int n = this.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int capacity() {
        return this.buf.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.lock.lock();
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.not_empty.signal();
            this.not_full.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        this.lock.lock();
        try {
            boolean bl = this.closed;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return this.size() + "/" + this.capacity() + ", size=" + this.size() + ", remaining=" + this.remaining() + (this.closed ? " (closed)" : "");
    }

    protected int size() {
        return this.write_pos - this.read_pos;
    }

    protected int remaining() {
        return this.buf.length - this.write_pos;
    }

    protected void compact() {
        if (this.read_pos == 0) {
            return;
        }
        if (this.size() == 0) {
            this.write_pos = 0;
            this.read_pos = 0;
            return;
        }
        int length = this.write_pos - this.read_pos;
        System.arraycopy(this.buf, this.read_pos, this.buf, 0, length);
        this.write_pos -= this.read_pos;
        this.read_pos = 0;
        this.not_full.signal();
    }

    protected static void sanityCheck(byte[] buf, int offset, int length) {
        if (buf == null) {
            throw new NullPointerException("buffer is null");
        }
        if (offset + length > buf.length) {
            throw new ArrayIndexOutOfBoundsException("length (" + length + ") + offset (" + offset + ") > buf.length (" + buf.length + ")");
        }
    }
}

