/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.message.TraceObject;
import org.h2.util.IOUtils;
import org.h2.util.Task;
import org.h2.value.Value;

public class JdbcBlob
extends TraceObject
implements Blob {
    Value value;
    private JdbcConnection conn;

    public JdbcBlob(JdbcConnection jdbcConnection, Value value, int n) {
        this.setTrace(jdbcConnection.getSession().getTrace(), 9, n);
        this.conn = jdbcConnection;
        this.value = value;
    }

    @Override
    public long length() throws SQLException {
        try {
            long l;
            this.debugCodeCall("length");
            this.checkClosed();
            if (this.value.getType() == 15 && (l = this.value.getPrecision()) > 0L) {
                return l;
            }
            return IOUtils.copyAndCloseInput(this.value.getInputStream(), null);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void truncate(long l) throws SQLException {
        throw this.unsupported("LOB update");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(long l, int n) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getBytes(" + l + ", " + n + ");");
            }
            this.checkClosed();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            InputStream inputStream = this.value.getInputStream();
            try {
                IOUtils.skipFully(inputStream, l - 1L);
                IOUtils.copy(inputStream, byteArrayOutputStream, n);
            }
            finally {
                inputStream.close();
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int setBytes(long l, byte[] byArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBytes(" + l + ", " + JdbcBlob.quoteBytes(byArray) + ");");
            }
            this.checkClosed();
            if (l != 1L) {
                throw DbException.getInvalidValueException("pos", l);
            }
            this.value = this.conn.createBlob(new ByteArrayInputStream(byArray), -1L);
            return byArray.length;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        throw this.unsupported("LOB update");
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        try {
            this.debugCodeCall("getBinaryStream");
            this.checkClosed();
            return this.value.getInputStream();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public OutputStream setBinaryStream(long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBinaryStream(" + l + ");");
            }
            this.checkClosed();
            if (l != 1L) {
                throw DbException.getInvalidValueException("pos", l);
            }
            if (this.value.getPrecision() != 0L) {
                throw DbException.getInvalidValueException("length", this.value.getPrecision());
            }
            final JdbcConnection jdbcConnection = this.conn;
            final PipedInputStream pipedInputStream = new PipedInputStream();
            final Task task = new Task(){

                @Override
                public void call() {
                    JdbcBlob.this.value = jdbcConnection.createBlob(pipedInputStream, -1L);
                }
            };
            PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream){

                @Override
                public void close() throws IOException {
                    super.close();
                    try {
                        task.get();
                    }
                    catch (Exception exception) {
                        throw DbException.convertToIOException(exception);
                    }
                }
            };
            task.execute();
            return new BufferedOutputStream(pipedOutputStream);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public long position(byte[] byArray, long l) throws SQLException {
        if (this.isDebugEnabled()) {
            this.debugCode("position(" + JdbcBlob.quoteBytes(byArray) + ", " + l + ");");
        }
        throw this.unsupported("LOB search");
    }

    @Override
    public long position(Blob blob, long l) throws SQLException {
        if (this.isDebugEnabled()) {
            this.debugCode("position(blobPattern, " + l + ");");
        }
        throw this.unsupported("LOB subset");
    }

    @Override
    public void free() {
        this.debugCodeCall("free");
        this.value = null;
    }

    @Override
    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        throw this.unsupported("LOB update");
    }

    private void checkClosed() {
        this.conn.checkClosed();
        if (this.value == null) {
            throw DbException.get(90007);
        }
    }

    public String toString() {
        return this.getTraceObjectName() + ": " + (this.value == null ? "null" : this.value.getTraceSQL());
    }
}

