/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.DbfFactory;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.config.configprovider.ConfigurationResourceProvider;
import com.sun.faces.config.configprovider.MetaInfResourceProvider;
import com.sun.faces.config.configprovider.RIConfigResourceProvider;
import com.sun.faces.config.configprovider.WebResourceProvider;
import com.sun.faces.config.processor.ApplicationConfigProcessor;
import com.sun.faces.config.processor.ComponentConfigProcessor;
import com.sun.faces.config.processor.ConfigProcessor;
import com.sun.faces.config.processor.ConverterConfigProcessor;
import com.sun.faces.config.processor.FactoryConfigProcessor;
import com.sun.faces.config.processor.LifecycleConfigProcessor;
import com.sun.faces.config.processor.ManagedBeanConfigProcessor;
import com.sun.faces.config.processor.NavigationConfigProcessor;
import com.sun.faces.config.processor.RenderKitConfigProcessor;
import com.sun.faces.config.processor.ValidatorConfigProcessor;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Timer;
import com.sun.faces.util.Util;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class ConfigManager {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final List<ConfigurationResourceProvider> RESOURCE_PROVIDERS;
    private static final int NUMBER_OF_TASK_THREADS = 5;
    private static final ConfigManager CONFIG_MANAGER;
    private List<ServletContext> initializedContexts = new CopyOnWriteArrayList<ServletContext>();
    private static final ConfigProcessor CONFIG_PROCESSOR_CHAIN;
    private static final String XSL = "/com/sun/faces/jsf1_0-1_1toSchema.xsl";

    public static ConfigManager getInstance() {
        return CONFIG_MANAGER;
    }

    public void initialize(ServletContext sc) {
        if (!this.hasBeenInitialized(sc)) {
            this.initializedContexts.add(sc);
            try {
                CONFIG_PROCESSOR_CHAIN.process(sc, ConfigManager.getConfigDocuments(sc));
            }
            catch (Exception e) {
                this.releaseFactories();
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unsanitized stacktrace from failed start...", e);
                }
                Throwable t = this.unwind(e);
                throw new ConfigurationException("CONFIGURATION FAILED! " + t.getMessage(), t);
            }
        }
    }

    public void destory(ServletContext sc) {
        this.releaseFactories();
        this.initializedContexts.remove(sc);
    }

    public boolean hasBeenInitialized(ServletContext sc) {
        return this.initializedContexts.contains(sc);
    }

    private static Document[] getConfigDocuments(ServletContext sc) {
        ExecutorService executor = null;
        if (ConfigManager.useThreads(sc)) {
            executor = Executors.newFixedThreadPool(5);
        }
        ArrayList<FutureTask<Collection<URL>>> urlTasks = new ArrayList<FutureTask<Collection<URL>>>(RESOURCE_PROVIDERS.size());
        for (ConfigurationResourceProvider p : RESOURCE_PROVIDERS) {
            FutureTask<Collection<URL>> t = new FutureTask<Collection<URL>>(new URLTask(p, sc));
            urlTasks.add(t);
            if (executor != null) {
                executor.execute(t);
                continue;
            }
            t.run();
        }
        ArrayList<FutureTask<Document>> docTasks = new ArrayList<FutureTask<Document>>(RESOURCE_PROVIDERS.size() << 1);
        boolean validating = WebConfiguration.getInstance(sc).isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.ValidateFacesConfigFiles);
        for (FutureTask futureTask : urlTasks) {
            try {
                Collection collection = (Collection)futureTask.get();
                for (URL u : collection) {
                    FutureTask<Document> d = new FutureTask<Document>(new ParseTask(validating, u));
                    docTasks.add(d);
                    if (executor != null) {
                        executor.execute(d);
                        continue;
                    }
                    d.run();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                throw new ConfigurationException(exception);
            }
        }
        ArrayList docs = new ArrayList(docTasks.size());
        for (FutureTask futureTask : docTasks) {
            try {
                docs.add(futureTask.get());
            }
            catch (ExecutionException e) {
                throw new ConfigurationException(e);
            }
            catch (InterruptedException ignored) {
            }
        }
        if (executor != null) {
            executor.shutdown();
        }
        return docs.toArray(new Document[docs.size()]);
    }

    private static boolean useThreads(ServletContext ctx) {
        WebConfiguration config = WebConfiguration.getInstance(ctx);
        return config.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableThreading);
    }

    private Throwable unwind(Throwable throwable) {
        Throwable t = null;
        if (throwable != null && (t = this.unwind(throwable.getCause())) == null) {
            t = throwable;
        }
        return t;
    }

    private void releaseFactories() {
        block2: {
            try {
                FactoryFinder.releaseFactories();
            }
            catch (FacesException ignored) {
                if (!LOGGER.isLoggable(Level.FINE)) break block2;
                LOGGER.log(Level.FINE, "Exception thrown from FactoryFinder.releaseFactories()", ignored);
            }
        }
    }

    static {
        CONFIG_MANAGER = new ConfigManager();
        ArrayList<ConfigurationResourceProvider> l = new ArrayList<ConfigurationResourceProvider>(3);
        l.add(new RIConfigResourceProvider());
        l.add(new MetaInfResourceProvider());
        l.add(new WebResourceProvider());
        RESOURCE_PROVIDERS = Collections.unmodifiableList(l);
        ConfigProcessor[] configProcessors = new ConfigProcessor[]{new FactoryConfigProcessor(), new LifecycleConfigProcessor(), new ApplicationConfigProcessor(), new ComponentConfigProcessor(), new ConverterConfigProcessor(), new ValidatorConfigProcessor(), new ManagedBeanConfigProcessor(), new RenderKitConfigProcessor(), new NavigationConfigProcessor()};
        for (int i = 0; i < configProcessors.length; ++i) {
            ConfigProcessor p = configProcessors[i];
            if (i + 1 >= configProcessors.length) continue;
            p.setNext(configProcessors[i + 1]);
        }
        CONFIG_PROCESSOR_CHAIN = configProcessors[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class URLTask
    implements Callable<Collection<URL>> {
        private ConfigurationResourceProvider provider;
        private ServletContext sc;

        public URLTask(ConfigurationResourceProvider provider, ServletContext sc) {
            this.provider = provider;
            this.sc = sc;
        }

        @Override
        public Collection<URL> call() throws Exception {
            return this.provider.getResources(this.sc);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParseTask
    implements Callable<Document> {
        private static final String FACES_SCHEMA_DEFAULT_NS = "http://java.sun.com/xml/ns/javaee";
        private URL documentURL;
        private DocumentBuilderFactory factory;
        private boolean validating;

        public ParseTask(boolean validating, URL documentURL) throws Exception {
            this.documentURL = documentURL;
            this.factory = DbfFactory.getFactory();
            this.validating = validating;
        }

        @Override
        public Document call() throws Exception {
            try {
                Timer timer = Timer.getInstance();
                if (timer != null) {
                    timer.startTiming();
                }
                Document d = this.getDocument();
                if (timer != null) {
                    timer.stopTiming();
                    timer.logResult("Parse " + this.documentURL.toExternalForm());
                }
                return d;
            }
            catch (Exception e) {
                throw new ConfigurationException(MessageFormat.format("Unable to parse document ''{0}'': {1}", this.documentURL.toExternalForm(), e.getMessage()), e);
            }
        }

        private Document getDocument() throws Exception {
            DocumentBuilder db = this.getNonValidatingBuilder();
            InputSource is = new InputSource(ParseTask.getInputStream(this.documentURL));
            is.setSystemId(this.documentURL.toExternalForm());
            Document doc = db.parse(is);
            String documentNS = doc.getDocumentElement().getNamespaceURI();
            if (this.validating && documentNS != null) {
                DOMSource domSource = new DOMSource(doc, this.documentURL.toExternalForm());
                if (FACES_SCHEMA_DEFAULT_NS.equals(documentNS)) {
                    DocumentBuilder builder = this.getBuilderForSchema(DbfFactory.FacesSchema.FACES_12);
                    if (builder.isValidating()) {
                        Util.newValidator(builder).validate(domSource);
                        return (Document)domSource.getNode();
                    }
                    return (Document)domSource.getNode();
                }
                DOMResult domResult = new DOMResult();
                Transformer transformer = ParseTask.getTransformer();
                transformer.transform(domSource, domResult);
                DocumentBuilder builder = this.getBuilderForSchema(DbfFactory.FacesSchema.FACES_11);
                if (builder.isValidating()) {
                    Util.newValidator(builder).validate(domSource);
                    return (Document)domSource.getNode();
                }
                return (Document)domSource.getNode();
            }
            return doc;
        }

        private static Transformer getTransformer() throws Exception {
            TransformerFactory factory = Util.createTransformerFactory();
            return factory.newTransformer(new StreamSource(ParseTask.getInputStream(ConfigManager.class.getResource(ConfigManager.XSL))));
        }

        private static InputStream getInputStream(URL url) throws IOException {
            URLConnection conn = url.openConnection();
            conn.setUseCaches(false);
            return new BufferedInputStream(conn.getInputStream());
        }

        private DocumentBuilder getNonValidatingBuilder() throws Exception {
            DocumentBuilderFactory tFactory = DbfFactory.getFactory();
            tFactory.setValidating(false);
            DocumentBuilder tBuilder = Util.newDocumentBuilder(tFactory);
            tBuilder.setEntityResolver(DbfFactory.FACES_ENTITY_RESOLVER);
            tBuilder.setErrorHandler(DbfFactory.FACES_ERROR_HANDLER);
            return tBuilder;
        }

        private DocumentBuilder getBuilderForSchema(DbfFactory.FacesSchema schema) throws Exception {
            try {
                this.factory.setSchema(schema.getSchema());
            }
            catch (UnsupportedOperationException upe) {
                return this.getNonValidatingBuilder();
            }
            DocumentBuilder builder = Util.newDocumentBuilder(this.factory);
            builder.setEntityResolver(DbfFactory.FACES_ENTITY_RESOLVER);
            builder.setErrorHandler(DbfFactory.FACES_ERROR_HANDLER);
            return builder;
        }
    }
}

