/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.ext.validator;

import com.sun.faces.ext.validator.MojarraMessageFactory;
import java.io.Serializable;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class RegexValidator
implements Validator,
Serializable {
    private static final long serialVersionUID = 1961950699958181806L;
    private String regex;

    public void setPattern(String pattern) {
        this.regex = pattern;
    }

    public void validate(FacesContext context, UIComponent component, Object obj) {
        Locale locale = context.getViewRoot().getLocale();
        if (this.regex == null || this.regex.length() == 0) {
            FacesMessage fmsg = MojarraMessageFactory.getMessage(locale, "com.sun.faces.ext.validator.regexValidator.PATTERN_NOT_SET", new Object[]{null});
            throw new ValidatorException(fmsg);
        }
        try {
            Pattern pattern = Pattern.compile(this.regex);
            Matcher matcher = pattern.matcher((String)obj);
            if (!matcher.matches()) {
                Object[] params = new Object[]{this.regex};
                FacesMessage fmsg = MojarraMessageFactory.getMessage(locale, "com.sun.faces.ext.validator.regexValidator.NOT_MATCHED", params);
                throw new ValidatorException(fmsg);
            }
        }
        catch (PatternSyntaxException pse) {
            FacesMessage fmsg = MojarraMessageFactory.getMessage(locale, "com.sun.faces.ext.validator.regexValidator.EXP_ERR", new Object[]{null});
            throw new ValidatorException(fmsg, (Throwable)pse);
        }
    }
}

