/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.pop3;

import com.sun.mail.pop3.DefaultFolder;
import com.sun.mail.pop3.POP3Folder;
import com.sun.mail.pop3.Protocol;
import com.sun.mail.util.PropUtil;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Map;
import javax.mail.AuthenticationFailedException;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;

public class POP3Store
extends Store {
    private String name;
    private int defaultPort;
    private boolean isSSL;
    private Protocol port;
    private POP3Folder portOwner;
    private String host;
    private int portNum;
    private String user;
    private String passwd;
    private boolean useStartTLS;
    private boolean requireStartTLS;
    private Map capabilities;
    private PrintStream out;
    volatile Constructor messageConstructor;
    volatile boolean rsetBeforeQuit;
    volatile boolean disableTop;
    volatile boolean forgetTopHeaders;
    volatile boolean supportsUidl;
    volatile boolean cacheWriteTo;
    volatile boolean useFileCache;
    volatile File fileCacheDir;
    volatile boolean keepMessageContent;

    public POP3Store(Session session, URLName url) {
        this(session, url, "pop3", false);
    }

    public POP3Store(Session session, URLName url, String name, boolean isSSL) {
        block11: {
            super(session, url);
            this.name = "pop3";
            this.defaultPort = 110;
            this.isSSL = false;
            this.port = null;
            this.portOwner = null;
            this.host = null;
            this.portNum = -1;
            this.user = null;
            this.passwd = null;
            this.useStartTLS = false;
            this.requireStartTLS = false;
            this.messageConstructor = null;
            this.rsetBeforeQuit = false;
            this.disableTop = false;
            this.forgetTopHeaders = false;
            this.supportsUidl = true;
            this.cacheWriteTo = false;
            this.useFileCache = false;
            this.fileCacheDir = null;
            this.keepMessageContent = false;
            if (url != null) {
                name = url.getProtocol();
            }
            this.name = name;
            this.out = session.getDebugOut();
            if (this.out == null) {
                this.out = System.out;
            }
            if (!isSSL) {
                isSSL = PropUtil.getBooleanSessionProperty(session, "mail." + name + ".ssl.enable", false);
            }
            this.defaultPort = isSSL ? 995 : 110;
            this.isSSL = isSSL;
            this.rsetBeforeQuit = this.getBoolProp("rsetbeforequit");
            this.disableTop = this.getBoolProp("disabletop");
            this.forgetTopHeaders = this.getBoolProp("forgettopheaders");
            this.cacheWriteTo = this.getBoolProp("cachewriteto");
            this.useFileCache = this.getBoolProp("filecache.enable");
            String dir = session.getProperty("mail." + name + ".filecache.dir");
            if (this.debug && dir != null) {
                this.out.println("DEBUG POP3: mail." + name + ".filecache.dir: " + dir);
            }
            if (dir != null) {
                this.fileCacheDir = new File(dir);
            }
            this.keepMessageContent = this.getBoolProp("keepmessagecontent");
            this.useStartTLS = this.getBoolProp("starttls.enable");
            this.requireStartTLS = this.getBoolProp("starttls.required");
            String s = session.getProperty("mail." + name + ".message.class");
            if (s != null) {
                if (this.debug) {
                    this.out.println("DEBUG POP3: message class: " + s);
                }
                try {
                    ClassLoader cl = this.getClass().getClassLoader();
                    Class<?> messageClass = null;
                    try {
                        messageClass = Class.forName(s, false, cl);
                    }
                    catch (ClassNotFoundException ex1) {
                        messageClass = Class.forName(s);
                    }
                    Class[] c = new Class[]{Folder.class, Integer.TYPE};
                    this.messageConstructor = messageClass.getConstructor(c);
                }
                catch (Exception ex) {
                    if (!this.debug) break block11;
                    this.out.println("DEBUG POP3: failed to load message class: " + ex);
                }
            }
        }
    }

    private final synchronized boolean getBoolProp(String prop) {
        prop = "mail." + this.name + "." + prop;
        boolean val = PropUtil.getBooleanSessionProperty(this.session, prop, false);
        if (this.debug) {
            this.out.println("DEBUG POP3: " + prop + ": " + val);
        }
        return val;
    }

    synchronized Session getSession() {
        return this.session;
    }

    @Override
    protected synchronized boolean protocolConnect(String host, int portNum, String user, String passwd) throws MessagingException {
        if (host == null || passwd == null || user == null) {
            return false;
        }
        if (portNum == -1) {
            portNum = PropUtil.getIntSessionProperty(this.session, "mail." + this.name + ".port", -1);
        }
        if (portNum == -1) {
            portNum = this.defaultPort;
        }
        this.host = host;
        this.portNum = portNum;
        this.user = user;
        this.passwd = passwd;
        try {
            this.port = this.getPort(null);
        }
        catch (EOFException eex) {
            throw new AuthenticationFailedException(eex.getMessage());
        }
        catch (IOException ioex) {
            throw new MessagingException("Connect failed", ioex);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isConnected() {
        if (!super.isConnected()) {
            return false;
        }
        try {
            if (this.port == null) {
                this.port = this.getPort(null);
            } else if (!this.port.noop()) {
                throw new IOException("NOOP failed");
            }
            return true;
        }
        catch (IOException ioex) {
            try {
                super.close();
            }
            catch (MessagingException messagingException) {}
            finally {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Protocol getPort(POP3Folder owner) throws IOException {
        if (this.port != null && this.portOwner == null) {
            this.portOwner = owner;
            return this.port;
        }
        Protocol p = new Protocol(this.host, this.portNum, this.debug, this.out, this.session.getProperties(), "mail." + this.name, this.isSSL);
        if (this.useStartTLS || this.requireStartTLS) {
            if (p.hasCapability("STLS")) {
                if (p.stls()) {
                    p.setCapabilities(p.capa());
                } else if (this.requireStartTLS) {
                    if (this.debug) {
                        this.out.println("DEBUG POP3: STLS required but failed");
                    }
                    try {
                        p.quit();
                    }
                    catch (IOException ioex) {}
                    finally {
                        throw new EOFException("STLS required but failed");
                    }
                }
            } else if (this.requireStartTLS) {
                if (this.debug) {
                    this.out.println("DEBUG POP3: STLS required but not supported");
                }
                try {
                    p.quit();
                }
                catch (IOException ioex) {}
                finally {
                    throw new EOFException("STLS required but not supported");
                }
            }
        }
        this.capabilities = p.getCapabilities();
        if (!this.disableTop && this.capabilities != null && !this.capabilities.containsKey("TOP")) {
            this.disableTop = true;
            if (this.debug) {
                this.out.println("DEBUG POP3: server doesn't support TOP, disabling it");
            }
        }
        this.supportsUidl = this.capabilities == null || this.capabilities.containsKey("UIDL");
        String msg = null;
        msg = p.login(this.user, this.passwd);
        if (msg != null) {
            try {
                p.quit();
            }
            catch (IOException ioex) {}
            finally {
                throw new EOFException(msg);
            }
        }
        if (this.port == null && owner != null) {
            this.port = p;
            this.portOwner = owner;
        }
        if (this.portOwner == null) {
            this.portOwner = owner;
        }
        return p;
    }

    synchronized void closePort(POP3Folder owner) {
        if (this.portOwner == owner) {
            this.port = null;
            this.portOwner = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws MessagingException {
        try {
            if (this.port != null) {
                this.port.quit();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.port = null;
            super.close();
        }
    }

    @Override
    public Folder getDefaultFolder() throws MessagingException {
        this.checkConnected();
        return new DefaultFolder(this);
    }

    @Override
    public Folder getFolder(String name) throws MessagingException {
        this.checkConnected();
        return new POP3Folder(this, name);
    }

    @Override
    public Folder getFolder(URLName url) throws MessagingException {
        this.checkConnected();
        return new POP3Folder(this, url.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map capabilities() throws MessagingException {
        Map c;
        POP3Store pOP3Store = this;
        synchronized (pOP3Store) {
            c = this.capabilities;
        }
        if (c != null) {
            return Collections.unmodifiableMap(c);
        }
        return Collections.EMPTY_MAP;
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        if (this.port != null) {
            this.close();
        }
    }

    private void checkConnected() throws MessagingException {
        if (!super.isConnected()) {
            throw new MessagingException("Not connected");
        }
    }
}

