/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.basic;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.apache.cxf.aegis.Context;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.basic.DateType;
import org.apache.cxf.aegis.util.date.TimezoneLessXsDateFormat;
import org.apache.cxf.aegis.xml.MessageReader;
import org.apache.cxf.aegis.xml.MessageWriter;

public class TimezoneLessDateType
extends DateType {
    private static TimezoneLessXsDateFormat format = new TimezoneLessXsDateFormat();

    @Override
    public Object readObject(MessageReader reader, Context context) throws DatabindingException {
        String value = reader.getValue();
        if (value == null) {
            return null;
        }
        try {
            return ((Calendar)format.parseObject(value.trim())).getTime();
        }
        catch (ParseException e) {
            throw new DatabindingException("Could not parse xs:date: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void writeObject(Object object, MessageWriter writer, Context context) {
        Calendar c;
        if (object instanceof Calendar) {
            c = (Calendar)object;
        } else {
            c = Calendar.getInstance();
            c.setTime((Date)object);
        }
        writer.writeValue(format.format(c));
    }
}

