/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.frontend;

import java.io.IOException;
import java.util.List;
import org.apache.cxf.BusException;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerImpl;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.frontend.AbstractWSDLBasedEndpointFactory;
import org.apache.cxf.service.factory.FactoryBeanListener;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.invoker.BeanInvoker;
import org.apache.cxf.service.invoker.Factory;
import org.apache.cxf.service.invoker.FactoryInvoker;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.invoker.SingletonFactory;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.wsdl11.WSDLEndpointFactory;

public class ServerFactoryBean
extends AbstractWSDLBasedEndpointFactory {
    private Server server;
    private boolean start = true;
    private Object serviceBean;
    private List<String> schemaLocations;
    private Invoker invoker;

    public ServerFactoryBean() {
        this(new ReflectionServiceFactoryBean());
    }

    public ServerFactoryBean(ReflectionServiceFactoryBean sbean) {
        super(sbean);
    }

    public String getBeanName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    @Override
    protected String detectTransportIdFromAddress(String ad) {
        DestinationFactoryManager dfm;
        DestinationFactory df = this.getDestinationFactory();
        if (df == null && (df = (dfm = (DestinationFactoryManager)this.getBus().getExtension(DestinationFactoryManager.class)).getDestinationFactoryForUri(this.getAddress())) != null) {
            return (String)df.getTransportIds().get(0);
        }
        return null;
    }

    @Override
    protected WSDLEndpointFactory getWSDLEndpointFactory() {
        if (this.destinationFactory == null) {
            try {
                this.destinationFactory = ((DestinationFactoryManager)this.getBus().getExtension(DestinationFactoryManager.class)).getDestinationFactory(this.transportId);
            }
            catch (Throwable t) {
                try {
                    ConduitInitiator o = ((ConduitInitiatorManager)this.getBus().getExtension(ConduitInitiatorManager.class)).getConduitInitiator(this.transportId);
                    if (o instanceof WSDLEndpointFactory) {
                        return (WSDLEndpointFactory)o;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (this.destinationFactory instanceof WSDLEndpointFactory) {
            return (WSDLEndpointFactory)this.destinationFactory;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Server create() {
        ClassLoaderUtils.ClassLoaderHolder orig = null;
        try {
            try {
                ClassLoader loader;
                if (this.bus != null && (loader = (ClassLoader)this.bus.getExtension(ClassLoader.class)) != null) {
                    orig = ClassLoaderUtils.setThreadContextClassloader((ClassLoader)loader);
                }
                if (this.getServiceFactory().getProperties() == null) {
                    this.getServiceFactory().setProperties(this.getProperties());
                } else if (this.getProperties() != null) {
                    this.getServiceFactory().getProperties().putAll(this.getProperties());
                }
                if (this.serviceBean != null && this.getServiceClass() == null) {
                    this.setServiceClass(ClassHelper.getRealClass((Object)this.serviceBean));
                }
                if (this.invoker != null) {
                    this.getServiceFactory().setInvoker(this.invoker);
                } else if (this.serviceBean != null) {
                    this.invoker = this.createInvoker();
                    this.getServiceFactory().setInvoker(this.invoker);
                }
                Endpoint ep = this.createEndpoint();
                this.server = new ServerImpl(this.getBus(), ep, this.getDestinationFactory(), this.getBindingFactory());
                if (ep.getService().getInvoker() == null) {
                    if (this.invoker == null) {
                        ep.getService().setInvoker(this.createInvoker());
                    } else {
                        ep.getService().setInvoker(this.invoker);
                    }
                }
            }
            catch (EndpointException e) {
                throw new ServiceConstructionException((Throwable)e);
            }
            catch (BusException e) {
                throw new ServiceConstructionException((Throwable)e);
            }
            catch (IOException e) {
                throw new ServiceConstructionException((Throwable)e);
            }
            if (this.serviceBean != null) {
                Class cls = ClassHelper.getRealClass((Object)this.getServiceBean());
                if (this.getServiceClass() == null || cls.equals(this.getServiceClass())) {
                    this.initializeAnnotationInterceptors(this.server.getEndpoint(), cls);
                } else {
                    this.initializeAnnotationInterceptors(this.server.getEndpoint(), new Class[]{cls, this.getServiceClass()});
                }
            } else if (this.getServiceClass() != null) {
                this.initializeAnnotationInterceptors(this.server.getEndpoint(), this.getServiceClass());
            }
            this.applyFeatures();
            Object[] objectArray = new Object[3];
            objectArray[0] = this.server;
            objectArray[1] = this.serviceBean;
            objectArray[2] = this.serviceBean == null ? (this.getServiceClass() == null ? this.getServiceFactory().getServiceClass() : this.getServiceClass()) : (this.getServiceClass() == null ? ClassHelper.getRealClass((Object)this.getServiceBean()) : this.getServiceClass());
            this.getServiceFactory().sendEvent(FactoryBeanListener.Event.SERVER_CREATED, objectArray);
            if (this.start) {
                this.server.start();
            }
            Server server = this.server;
            return server;
        }
        finally {
            if (orig != null) {
                orig.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (this.getServer() == null) {
            ClassLoaderUtils.ClassLoaderHolder orig = null;
            try {
                ClassLoader loader;
                if (this.bus != null && (loader = (ClassLoader)this.bus.getExtension(ClassLoader.class)) != null) {
                    orig = ClassLoaderUtils.setThreadContextClassloader((ClassLoader)loader);
                }
                this.create();
            }
            finally {
                if (orig != null) {
                    orig.reset();
                }
            }
        }
    }

    public void destroy() {
        if (this.getServer() != null) {
            this.getServer().destroy();
            this.setServer(null);
        }
    }

    @Override
    protected void initializeServiceFactory() {
        super.initializeServiceFactory();
        this.getServiceFactory().setSchemaLocations(this.schemaLocations);
    }

    protected void applyFeatures() {
        if (this.getFeatures() != null) {
            for (AbstractFeature feature : this.getFeatures()) {
                feature.initialize(this.server, this.getBus());
            }
        }
    }

    protected Invoker createInvoker() {
        if (this.getServiceBean() == null) {
            return new FactoryInvoker((Factory)new SingletonFactory(this.getServiceClass()));
        }
        return new BeanInvoker(this.getServiceBean());
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public boolean isStart() {
        return this.start;
    }

    public void setStart(boolean start) {
        this.start = start;
    }

    public Object getServiceBean() {
        return this.serviceBean;
    }

    public Class<?> getServiceBeanClass() {
        if (this.serviceBean != null) {
            return ClassHelper.getRealClass((Object)this.serviceBean);
        }
        return this.getServiceFactory().getServiceClass();
    }

    public void setServiceBean(Object serviceBean) {
        this.serviceBean = serviceBean;
    }

    public List<String> getSchemaLocations() {
        return this.schemaLocations;
    }

    public void setSchemaLocations(List<String> schemaLocations) {
        this.schemaLocations = schemaLocations;
    }

    public Invoker getInvoker() {
        return this.invoker;
    }

    public void setInvoker(Invoker invoker) {
        this.invoker = invoker;
    }

    public void setWsdlLocation(String location) {
        this.setWsdlURL(location);
    }

    public String getWsdlLocation() {
        return this.getWsdlURL();
    }
}

