/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.Duration;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientImpl;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.DeferredConduitSelector;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.workqueue.SynchronousExecutor;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.RelatesToType;
import org.apache.cxf.ws.rm.DestinationSequence;
import org.apache.cxf.ws.rm.EncoderDecoder;
import org.apache.cxf.ws.rm.ProtocolVariation;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMEndpoint;
import org.apache.cxf.ws.rm.RMException;
import org.apache.cxf.ws.rm.RMManager;
import org.apache.cxf.ws.rm.RMUtils;
import org.apache.cxf.ws.rm.SourceSequence;
import org.apache.cxf.ws.rm.manager.SourcePolicyType;
import org.apache.cxf.ws.rm.v200702.CreateSequenceResponseType;
import org.apache.cxf.ws.rm.v200702.CreateSequenceType;
import org.apache.cxf.ws.rm.v200702.Expires;
import org.apache.cxf.ws.rm.v200702.Identifier;
import org.apache.cxf.ws.rm.v200702.OfferType;
import org.apache.cxf.ws.rm.v200702.TerminateSequenceType;

public class Proxy {
    private static final Logger LOG = LogUtils.getL7dLogger(Proxy.class);
    private RMEndpoint reliableEndpoint;
    private Identifier offeredIdentifier;

    public Proxy(RMEndpoint rme) {
        this.reliableEndpoint = rme;
    }

    RMEndpoint getReliableEndpoint() {
        return this.reliableEndpoint;
    }

    void acknowledge(DestinationSequence ds) throws RMException {
        ProtocolVariation protocol = ds.getProtocol();
        String address = ds.getAcksTo().getAddress().getValue();
        if (RMUtils.getAddressingConstants().getAnonymousURI().equals(address)) {
            LOG.log(Level.WARNING, "STANDALONE_ANON_ACKS_NOT_SUPPORTED");
            return;
        }
        RMConstants constants = protocol.getConstants();
        OperationInfo oi = this.reliableEndpoint.getEndpoint(protocol).getEndpointInfo().getService().getInterface().getOperation(constants.getSequenceAckOperationName());
        this.invoke(oi, protocol, new Object[]{ds}, null);
    }

    void terminate(SourceSequence ss) throws RMException {
        ProtocolVariation protocol = ss.getProtocol();
        RMConstants constants = protocol.getConstants();
        OperationInfo oi = this.reliableEndpoint.getEndpoint(protocol).getEndpointInfo().getService().getInterface().getOperation(constants.getTerminateSequenceOperationName());
        TerminateSequenceType ts = new TerminateSequenceType();
        ts.setIdentifier(ss.getIdentifier());
        EncoderDecoder codec = protocol.getCodec();
        this.invoke(oi, protocol, new Object[]{codec.convertToSend(ts)}, null);
    }

    void createSequenceResponse(Object createResponse, ProtocolVariation protocol) throws RMException {
        LOG.fine("sending CreateSequenceResponse from client side");
        RMConstants constants = protocol.getConstants();
        OperationInfo oi = this.reliableEndpoint.getEndpoint(protocol).getEndpointInfo().getService().getInterface().getOperation(constants.getCreateSequenceResponseOnewayOperationName());
        this.invoke(oi, protocol, new Object[]{createResponse}, null);
    }

    public CreateSequenceResponseType createSequence(EndpointReferenceType defaultAcksTo, RelatesToType relatesTo, boolean isServer, final ProtocolVariation protocol) throws RMException {
        SourcePolicyType sp = this.reliableEndpoint.getManager().getSourcePolicy();
        CreateSequenceType create = new CreateSequenceType();
        String address = sp.getAcksTo();
        EndpointReferenceType acksTo = null;
        acksTo = null != address ? RMUtils.createReference(address) : defaultAcksTo;
        create.setAcksTo(acksTo);
        Duration d = sp.getSequenceExpiration();
        if (null != d) {
            Expires expires = new Expires();
            expires.setValue(d);
            create.setExpires(expires);
        }
        if (sp.isIncludeOffer()) {
            OfferType offer = new OfferType();
            d = sp.getOfferedSequenceExpiration();
            if (null != d) {
                Expires expires = new Expires();
                expires.setValue(d);
                offer.setExpires(expires);
            }
            offer.setIdentifier(this.reliableEndpoint.getSource().generateSequenceIdentifier());
            create.setOffer(offer);
            this.setOfferedIdentifier(offer);
        }
        InterfaceInfo ii = this.reliableEndpoint.getEndpoint(protocol).getEndpointInfo().getService().getInterface();
        EncoderDecoder codec = protocol.getCodec();
        RMConstants constants = codec.getConstants();
        final OperationInfo oi = isServer ? ii.getOperation(constants.getCreateSequenceOnewayOperationName()) : ii.getOperation(constants.getCreateSequenceOperationName());
        final Object send = codec.convertToSend(create);
        if (isServer) {
            LOG.fine("sending CreateSequenceRequest from server side");
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        Proxy.this.invoke(oi, protocol, new Object[]{send}, null);
                    }
                    catch (RMException rMException) {
                        // empty catch block
                    }
                }
            };
            Executor ex = this.reliableEndpoint.getApplicationEndpoint().getExecutor();
            if (ex == null) {
                ex = SynchronousExecutor.getInstance();
            }
            ex.execute(r);
            return null;
        }
        Object resp = this.invoke(oi, protocol, new Object[]{send}, null);
        return codec.convertReceivedCreateSequenceResponse(resp);
    }

    void lastMessage(SourceSequence s) throws RMException {
        ProtocolVariation protocol = s.getProtocol();
        EndpointReferenceType target = s.getTarget();
        AttributedURIType uri = null;
        if (null != target) {
            uri = target.getAddress();
        }
        String addr = null;
        if (null != uri) {
            addr = uri.getValue();
        }
        if (addr == null) {
            LOG.log(Level.WARNING, "STANDALONE_CLOSE_SEQUENCE_NO_TARGET_MSG");
            return;
        }
        if (RMUtils.getAddressingConstants().getAnonymousURI().equals(addr)) {
            LOG.log(Level.WARNING, "STANDALONE_CLOSE_SEQUENCE_ANON_TARGET_MSG");
            return;
        }
        RMConstants constants = protocol.getConstants();
        OperationInfo oi = this.reliableEndpoint.getEndpoint(protocol).getEndpointInfo().getService().getInterface().getOperation(constants.getCloseSequenceOperationName());
        HashMap<String, Object> context = new HashMap<String, Object>(Collections.singletonMap(SourceSequence.class.getName(), s));
        this.invoke(oi, protocol, new Object[0], context);
    }

    void ackRequested(SourceSequence s) throws RMException {
        ProtocolVariation protocol = s.getProtocol();
        EndpointReferenceType target = s.getTarget();
        AttributedURIType uri = null;
        if (null != target) {
            uri = target.getAddress();
        }
        String addr = null;
        if (null != uri) {
            addr = uri.getValue();
        }
        if (addr == null) {
            LOG.log(Level.WARNING, "STANDALONE_ACK_REQUESTED_NO_TARGET_MSG");
            return;
        }
        if (RMUtils.getAddressingConstants().getAnonymousURI().equals(addr)) {
            LOG.log(Level.WARNING, "STANDALONE_ACK_REQUESTED_ANON_TARGET_MSG");
            return;
        }
        RMConstants constants = protocol.getConstants();
        OperationInfo oi = this.reliableEndpoint.getEndpoint(protocol).getEndpointInfo().getService().getInterface().getOperation(constants.getAckRequestedOperationName());
        this.invoke(oi, protocol, new Object[0], null);
    }

    Identifier getOfferedIdentifier() {
        return this.offeredIdentifier;
    }

    void setOfferedIdentifier(OfferType offer) {
        if (offer != null) {
            this.offeredIdentifier = offer.getIdentifier();
        }
    }

    Object invoke(OperationInfo oi, ProtocolVariation protocol, Object[] params, Map<String, Object> context) throws RMException {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "Sending out-of-band RM protocol message {0}.", oi == null ? null : oi.getName());
        }
        RMManager manager = this.reliableEndpoint.getManager();
        Bus bus = manager.getBus();
        Endpoint endpoint = this.reliableEndpoint.getEndpoint(protocol);
        BindingInfo bi = this.reliableEndpoint.getBindingInfo(protocol);
        Conduit c = this.reliableEndpoint.getConduit();
        Client client = null;
        if (params.length > 0 && params[0] instanceof DestinationSequence) {
            EndpointReferenceType acksTo = ((DestinationSequence)params[0]).getAcksTo();
            String acksAddress = acksTo.getAddress().getValue();
            AttributedURIType attrURIType = new AttributedURIType();
            attrURIType.setValue(acksAddress);
            EndpointReferenceType acks = new EndpointReferenceType();
            acks.setAddress(attrURIType);
            client = this.createClient(bus, endpoint, protocol, c, acks);
            params = new Object[]{};
        } else {
            EndpointReferenceType replyTo = this.reliableEndpoint.getReplyTo();
            client = this.createClient(bus, endpoint, protocol, c, replyTo);
        }
        BindingOperationInfo boi = bi.getOperation(oi);
        try {
            Object[] result = client.invoke(boi, params, context);
            if (result != null && result.length > 0) {
                return result[0];
            }
        }
        catch (Exception ex) {
            org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("SEND_PROTOCOL_MSG_FAILED_EXC", LOG, new Object[]{oi == null ? null : oi.getName()});
            LOG.log(Level.SEVERE, msg.toString(), ex);
            throw new RMException(msg, ex);
        }
        return null;
    }

    protected Client createClient(Bus bus, Endpoint endpoint, ProtocolVariation protocol, Conduit conduit, final EndpointReferenceType address) {
        DeferredConduitSelector cs = new DeferredConduitSelector(conduit){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized Conduit selectConduit(Message message) {
                Conduit conduit = null;
                EndpointInfo endpointInfo = this.getEndpoint().getEndpointInfo();
                EndpointReferenceType original = endpointInfo.getTarget();
                try {
                    if (null != address) {
                        endpointInfo.setAddress(address);
                    }
                    conduit = super.selectConduit(message);
                }
                finally {
                    endpointInfo.setAddress(original);
                }
                return conduit;
            }
        };
        RMClient client = new RMClient(bus, endpoint, (ConduitSelector)cs);
        Map context = client.getRequestContext();
        context.put("org.apache.cxf.ws.rm.namespace", protocol.getWSRMNamespace());
        context.put("org.apache.cxf.ws.rm.wsa-namespace", protocol.getWSANamespace());
        return client;
    }

    void setReliableEndpoint(RMEndpoint rme) {
        this.reliableEndpoint = rme;
    }

    class RMClient
    extends ClientImpl {
        RMClient(Bus bus, Endpoint endpoint, ConduitSelector cs) {
            super(bus, endpoint, cs);
        }

        public void onMessage(Message m) {
            m.getExchange().put(Endpoint.class, (Object)Proxy.this.reliableEndpoint.getApplicationEndpoint());
            super.onMessage(m);
        }
    }
}

