/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.builder.primitive.PrimitiveAssertion;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.AlgorithmSuite;
import org.apache.cxf.ws.security.policy.model.Binding;
import org.apache.cxf.ws.security.policy.model.Layout;
import org.apache.cxf.ws.security.policy.model.TransportToken;
import org.apache.neethi.All;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;

public class TransportBinding
extends Binding {
    private TransportToken transportToken;

    public TransportBinding(SPConstants version, PolicyBuilder b) {
        super(version, b);
    }

    public TransportToken getTransportToken() {
        return this.transportToken;
    }

    public void setTransportToken(TransportToken transportToken) {
        this.transportToken = transportToken;
    }

    public QName getRealName() {
        return this.constants.getTransportBinding();
    }

    public QName getName() {
        return SP12Constants.INSTANCE.getTransportBinding();
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String localName = this.getRealName().getLocalPart();
        String namespaceURI = this.getRealName().getNamespaceURI();
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = this.getRealName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        }
        writer.writeStartElement(prefix, localName, namespaceURI);
        writer.writeNamespace(prefix, namespaceURI);
        String pPrefix = writer.getPrefix(SPConstants.POLICY.getNamespaceURI());
        if (pPrefix == null) {
            pPrefix = SPConstants.POLICY.getPrefix();
            writer.setPrefix(pPrefix, SPConstants.POLICY.getNamespaceURI());
        }
        writer.writeStartElement(pPrefix, SPConstants.POLICY.getLocalPart(), SPConstants.POLICY.getNamespaceURI());
        if (this.transportToken == null) {
            throw new RuntimeException("no TransportToken found");
        }
        this.transportToken.serialize(writer);
        AlgorithmSuite algorithmSuite = this.getAlgorithmSuite();
        if (algorithmSuite == null) {
            throw new RuntimeException("no AlgorithmSuite found");
        }
        algorithmSuite.serialize(writer);
        Layout layout = this.getLayout();
        if (layout != null) {
            layout.serialize(writer);
        }
        if (this.isIncludeTimestamp()) {
            writer.writeStartElement(prefix, "IncludeTimestamp", namespaceURI);
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }

    @Override
    public PolicyComponent normalize() {
        return this;
    }

    public Policy getPolicy() {
        Policy p = new Policy();
        ExactlyOne ea = new ExactlyOne();
        p.addPolicyComponent((PolicyComponent)ea);
        All all = new All();
        if (this.transportToken != null) {
            all.addPolicyComponent((PolicyComponent)this.transportToken);
        }
        if (this.isIncludeTimestamp()) {
            all.addPolicyComponent((PolicyComponent)new PrimitiveAssertion(SP12Constants.INCLUDE_TIMESTAMP));
        }
        if (this.getLayout() != null) {
            all.addPolicyComponent((PolicyComponent)this.getLayout());
        }
        ea.addPolicyComponent((PolicyComponent)all);
        Policy pc = p.normalize(this.builder.getPolicyRegistry(), true);
        if (pc instanceof Policy) {
            return pc;
        }
        p = new Policy();
        p.addPolicyComponent((PolicyComponent)pc);
        return p;
    }
}

