/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class ClassCollector {
    private final Map<String, String> seiClassNames = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, String> typesClassNames = new HashMap<String, String>();
    private final Map<String, String> exceptionClassNames = new HashMap<String, String>();
    private final Map<String, String> serviceClassNames = new HashMap<String, String>();
    private final Map<String, String> implClassNames = new HashMap<String, String>();
    private final Map<String, String> clientClassNames = new HashMap<String, String>();
    private final Map<String, String> serverClassNames = new HashMap<String, String>();
    private final Map<String, String> reservedClassNames = new HashMap<String, String>();
    private final Set<String> typesPackages = new HashSet<String>();

    public void reserveClass(String fullName) {
        String cls = fullName;
        int idx = cls.lastIndexOf(46);
        String pkg = "";
        if (idx != -1) {
            pkg = cls.substring(0, idx);
            cls = cls.substring(idx + 1);
        }
        this.reservedClassNames.put(this.key(pkg, cls), fullName);
        this.addSeiClassName(pkg, cls, fullName);
        this.addTypesClassName(pkg, cls, fullName);
        this.addServerClassName(pkg, cls, fullName);
        this.addImplClassName(pkg, cls, fullName);
        this.addClientClassName(pkg, cls, fullName);
        this.addServiceClassName(pkg, cls, fullName);
        this.addExceptionClassName(pkg, cls, fullName);
    }

    public boolean isReserved(String packagename, String type) {
        return this.reservedClassNames.containsKey(this.key(packagename, type));
    }

    public boolean containSeiClass(String packagename, String type) {
        return this.seiClassNames.containsKey(this.key(packagename, type));
    }

    public boolean containTypesClass(String packagename, String type) {
        return this.typesClassNames.containsKey(this.key(packagename, type));
    }

    public boolean containExceptionClass(String packagename, String type) {
        return this.exceptionClassNames.containsKey(this.key(packagename, type));
    }

    public boolean containServiceClass(String packagename, String type) {
        return this.serviceClassNames.containsKey(this.key(packagename, type));
    }

    public boolean containClientClass(String packagename, String type) {
        return this.clientClassNames.containsKey(this.key(packagename, type));
    }

    public boolean containServerClass(String packagename, String type) {
        return this.serverClassNames.containsKey(this.key(packagename, type));
    }

    public boolean containImplClass(String packagename, String type) {
        return this.implClassNames.containsKey(this.key(packagename, type));
    }

    public void addSeiClassName(String packagename, String type, String fullClassName) {
        this.seiClassNames.put(this.key(packagename, type), fullClassName);
    }

    public void addTypesClassName(String packagename, String type, String fullClassName) {
        this.typesClassNames.put(this.key(packagename, type), fullClassName);
    }

    public void addServerClassName(String packagename, String type, String fullClassName) {
        this.serverClassNames.put(this.key(packagename, type), fullClassName);
    }

    public void addImplClassName(String packagename, String type, String fullClassName) {
        this.implClassNames.put(this.key(packagename, type), fullClassName);
    }

    public void addClientClassName(String packagename, String type, String fullClassName) {
        this.clientClassNames.put(this.key(packagename, type), fullClassName);
    }

    public void addServiceClassName(String packagename, String type, String fullClassName) {
        this.serviceClassNames.put(this.key(packagename, type), fullClassName);
    }

    public void addExceptionClassName(String packagename, String type, String fullClassName) {
        this.exceptionClassNames.put(this.key(packagename, type), fullClassName);
    }

    public String getTypesFullClassName(String packagename, String type) {
        return this.typesClassNames.get(this.key(packagename, type));
    }

    public boolean containsTypeIgnoreCase(String packagename, String type) {
        String key = this.key(packagename, type);
        if (this.typesClassNames.containsKey(key)) {
            return true;
        }
        for (String s : this.typesClassNames.keySet()) {
            if (!key.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    private String key(String packagename, String type) {
        return packagename + "#" + type;
    }

    public Set<String> getTypesPackages() {
        return this.typesPackages;
    }

    public Collection<String> getGeneratedFileInfo() {
        TreeSet<String> generatedFileList = new TreeSet<String>();
        generatedFileList.addAll(this.seiClassNames.values());
        generatedFileList.addAll(this.typesClassNames.values());
        generatedFileList.addAll(this.exceptionClassNames.values());
        generatedFileList.addAll(this.serviceClassNames.values());
        generatedFileList.addAll(this.implClassNames.values());
        generatedFileList.addAll(this.clientClassNames.values());
        return generatedFileList;
    }
}

