/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.config;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.ws.Holder;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.api_v3.Clerk;
import org.apache.juddi.api_v3.ClerkDetail;
import org.apache.juddi.api_v3.Node;
import org.apache.juddi.api_v3.NodeDetail;
import org.apache.juddi.api_v3.SaveClerk;
import org.apache.juddi.api_v3.SaveNode;
import org.apache.juddi.v3.client.config.UDDINode;
import org.apache.juddi.v3.client.transport.TransportException;
import org.uddi.api_v3.BindingDetail;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.DeleteBinding;
import org.uddi.api_v3.DeleteService;
import org.uddi.api_v3.DeleteTModel;
import org.uddi.api_v3.DiscardAuthToken;
import org.uddi.api_v3.DispositionReport;
import org.uddi.api_v3.FindRelatedBusinesses;
import org.uddi.api_v3.FindTModel;
import org.uddi.api_v3.GetAuthToken;
import org.uddi.api_v3.GetBindingDetail;
import org.uddi.api_v3.GetBusinessDetail;
import org.uddi.api_v3.GetServiceDetail;
import org.uddi.api_v3.GetTModelDetail;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.RelatedBusinessesList;
import org.uddi.api_v3.Result;
import org.uddi.api_v3.SaveBinding;
import org.uddi.api_v3.SaveBusiness;
import org.uddi.api_v3.SaveService;
import org.uddi.api_v3.SaveTModel;
import org.uddi.api_v3.ServiceDetail;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelDetail;
import org.uddi.api_v3.TModelList;
import org.uddi.sub_v3.DeleteSubscription;
import org.uddi.sub_v3.Subscription;
import org.uddi.v3_service.DispositionReportFaultMessage;

public class UDDIClerk
implements Serializable {
    private static final long serialVersionUID = -8597375975981358134L;
    private Log log = LogFactory.getLog(this.getClass());
    protected String name;
    protected UDDINode uddiNode;
    protected String publisher;
    protected String password;
    private Date tokenBirthDate;
    private String authToken;
    private String[] classWithAnnotations;
    private String managerName;
    private Map<String, Properties> services = new HashMap<String, Properties>();

    public UDDIClerk() {
    }

    public UDDIClerk(Clerk clerk) {
        this.name = clerk.getName();
        this.password = clerk.getPassword();
        this.publisher = clerk.getPublisher();
        this.uddiNode = new UDDINode(clerk.getNode());
    }

    public String[] getClassWithAnnotations() {
        return this.classWithAnnotations;
    }

    public void setClassWithAnnotations(String[] classWithAnnotations) {
        this.classWithAnnotations = classWithAnnotations;
    }

    public Map<String, Properties> getServices() {
        return this.services;
    }

    public void setServices(Map<String, Properties> services) {
        this.services = services;
    }

    public String getManagerName() {
        return this.managerName;
    }

    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }

    public Subscription register(Subscription subscription) {
        return this.register(subscription, this.getUDDINode().getApiNode());
    }

    public Subscription register(Subscription subscription, Node node) {
        this.log.info((Object)("Registering subscription with key " + subscription.getSubscriptionKey()));
        Holder holder = new Holder();
        try {
            String authToken = this.getAuthToken(node.getSecurityUrl());
            ArrayList<Subscription> subscriptions = new ArrayList<Subscription>();
            subscriptions.add(subscription);
            holder.value = subscriptions;
            this.getUDDINode().getTransport().getUDDISubscriptionService(node.getSubscriptionUrl()).saveSubscription(authToken, holder);
        }
        catch (Exception e) {
            this.log.error((Object)("Unable to register subscription " + subscription.getSubscriptionKey() + " ." + e.getMessage()), (Throwable)e);
        }
        catch (Throwable t) {
            this.log.error((Object)("Unable to register subscriptionl " + subscription.getSubscriptionKey() + " ." + t.getMessage()), t);
        }
        this.log.debug((Object)("Registering subscription " + subscription.getSubscriptionKey() + " completed."));
        subscription = (Subscription)((List)holder.value).get(0);
        return subscription;
    }

    public TModelDetail register(TModel tModel) {
        return this.register(tModel, this.getUDDINode().getApiNode());
    }

    public TModelDetail register(TModel tModel, Node node) {
        TModelDetail tModelDetail = null;
        this.log.info((Object)("Registering tModel with key " + tModel.getTModelKey()));
        try {
            String authToken = this.getAuthToken(node.getSecurityUrl());
            SaveTModel saveTModel = new SaveTModel();
            saveTModel.setAuthInfo(authToken);
            saveTModel.getTModel().add(tModel);
            tModelDetail = this.getUDDINode().getTransport().getUDDIPublishService(node.getPublishUrl()).saveTModel(saveTModel);
        }
        catch (Exception e) {
            this.log.error((Object)("Unable to register tModel " + tModel.getTModelKey() + " ." + e.getMessage()), (Throwable)e);
        }
        catch (Throwable t) {
            this.log.error((Object)("Unable to register tModel " + tModel.getTModelKey() + " ." + t.getMessage()), t);
        }
        this.log.debug((Object)("Registering tModel " + tModel.getTModelKey() + " completed."));
        return tModelDetail;
    }

    public BindingTemplate register(BindingTemplate binding) {
        return this.register(binding, this.getUDDINode().getApiNode());
    }

    public BindingTemplate register(BindingTemplate binding, Node node) {
        BindingTemplate bindingTemplate = null;
        this.log.info((Object)("Registering bindingTemplate with key " + binding.getBindingKey()));
        try {
            String authToken = this.getAuthToken(node.getSecurityUrl());
            SaveBinding saveBinding = new SaveBinding();
            saveBinding.setAuthInfo(authToken);
            saveBinding.getBindingTemplate().add(binding);
            BindingDetail bindingDetail = this.getUDDINode().getTransport().getUDDIPublishService(node.getPublishUrl()).saveBinding(saveBinding);
            bindingTemplate = (BindingTemplate)bindingDetail.getBindingTemplate().get(0);
        }
        catch (Exception e) {
            this.log.error((Object)("Unable to register template binding " + bindingTemplate.getBindingKey() + " ." + e.getMessage()), (Throwable)e);
        }
        catch (Throwable t) {
            this.log.error((Object)("Unable to register template binding " + bindingTemplate.getBindingKey() + " ." + t.getMessage()), t);
        }
        this.log.debug((Object)("Registering template binding " + binding.getBindingKey() + " completed."));
        return bindingTemplate;
    }

    public BusinessService register(BusinessService service) {
        return this.register(service, this.getUDDINode().getApiNode());
    }

    public BusinessService register(BusinessService service, Node node) {
        BusinessService businessService = null;
        this.log.info((Object)("Registering service " + ((Name)service.getName().get(0)).getValue() + " with key " + service.getServiceKey()));
        try {
            String authToken = this.getAuthToken(node.getSecurityUrl());
            SaveService saveService = new SaveService();
            saveService.setAuthInfo(authToken);
            saveService.getBusinessService().add(service);
            ServiceDetail serviceDetail = this.getUDDINode().getTransport().getUDDIPublishService(node.getPublishUrl()).saveService(saveService);
            businessService = (BusinessService)serviceDetail.getBusinessService().get(0);
        }
        catch (Exception e) {
            this.log.error((Object)("Unable to register service " + ((Name)service.getName().get(0)).getValue() + " ." + e.getMessage()), (Throwable)e);
        }
        catch (Throwable t) {
            this.log.error((Object)("Unable to register service " + ((Name)service.getName().get(0)).getValue() + " ." + t.getMessage()), t);
        }
        this.log.debug((Object)("Registering service " + ((Name)service.getName().get(0)).getValue() + " completed."));
        return businessService;
    }

    public BusinessEntity register(BusinessEntity business) {
        return this.register(business, this.getUDDINode().getApiNode());
    }

    public BusinessEntity register(BusinessEntity business, Node node) {
        BusinessEntity businessEntity = null;
        this.log.info((Object)("Registering business " + ((Name)business.getName().get(0)).getValue() + " with key " + business.getBusinessKey()));
        try {
            String authToken = this.getAuthToken(node.getSecurityUrl());
            SaveBusiness saveBusiness = new SaveBusiness();
            saveBusiness.setAuthInfo(authToken);
            saveBusiness.getBusinessEntity().add(business);
            BusinessDetail businessDetail = this.getUDDINode().getTransport().getUDDIPublishService(node.getPublishUrl()).saveBusiness(saveBusiness);
            businessEntity = (BusinessEntity)businessDetail.getBusinessEntity().get(0);
        }
        catch (Exception e) {
            this.log.error((Object)("Unable to register business " + ((Name)business.getName().get(0)).getValue() + " ." + e.getMessage()), (Throwable)e);
        }
        catch (Throwable t) {
            this.log.error((Object)("Unable to register business " + ((Name)business.getName().get(0)).getValue() + " ." + t.getMessage()), t);
        }
        this.log.debug((Object)("Registering businessEntity " + ((Name)businessEntity.getName().get(0)).getValue() + " completed."));
        return businessEntity;
    }

    public void unRegisterService(String serviceKey) {
        this.unRegisterService(serviceKey, this.getUDDINode().getApiNode());
    }

    public void unRegisterService(String serviceKey, Node node) {
        this.log.info((Object)("UnRegistering the service " + serviceKey));
        try {
            String authToken = this.getAuthToken(node.getSecurityUrl());
            DeleteService deleteService = new DeleteService();
            deleteService.setAuthInfo(authToken);
            deleteService.getServiceKey().add(serviceKey);
            this.getUDDINode().getTransport().getUDDIPublishService(node.getPublishUrl()).deleteService(deleteService);
        }
        catch (Exception e) {
            this.log.error((Object)("Unable to register service " + serviceKey + " ." + e.getMessage()), (Throwable)e);
        }
    }

    public void unRegisterBinding(String bindingKey) {
        this.unRegisterBinding(bindingKey, this.getUDDINode().getApiNode());
    }

    public void unRegisterBinding(String bindingKey, Node node) {
        this.log.info((Object)("UnRegistering binding key " + bindingKey));
        try {
            String authToken = this.getAuthToken(node.getSecurityUrl());
            DeleteBinding deleteBinding = new DeleteBinding();
            deleteBinding.setAuthInfo(authToken);
            deleteBinding.getBindingKey().add(bindingKey);
            this.getUDDINode().getTransport().getUDDIPublishService(node.getPublishUrl()).deleteBinding(deleteBinding);
        }
        catch (Exception e) {
            this.log.error((Object)("Unable to unregister bindingkey " + bindingKey + " ." + e.getMessage()), (Throwable)e);
        }
    }

    public void unRegisterTModel(String tModelKey) {
        this.unRegisterTModel(tModelKey, this.getUDDINode().getApiNode());
    }

    public void unRegisterTModel(String tModelKey, Node node) {
        this.log.info((Object)("UnRegistering tModel key " + tModelKey));
        try {
            String authToken = this.getAuthToken(node.getSecurityUrl());
            DeleteTModel deleteTModel = new DeleteTModel();
            deleteTModel.setAuthInfo(authToken);
            deleteTModel.getTModelKey().add(tModelKey);
            this.getUDDINode().getTransport().getUDDIPublishService(node.getPublishUrl()).deleteTModel(deleteTModel);
        }
        catch (Exception e) {
            this.log.error((Object)("Unable to unregister tModelkey " + tModelKey + " ." + e.getMessage()), (Throwable)e);
        }
    }

    public void unRegisterSubscription(String subscriptionKey) {
        this.unRegisterSubscription(subscriptionKey, this.getUDDINode().getApiNode());
    }

    public void unRegisterSubscription(String subscriptionKey, Node node) {
        this.log.info((Object)("UnRegistering subscription with key " + subscriptionKey));
        try {
            String authToken = this.getAuthToken(node.getSecurityUrl());
            DeleteSubscription deleteSubscription = new DeleteSubscription();
            deleteSubscription.setAuthInfo(authToken);
            deleteSubscription.getSubscriptionKey().add(subscriptionKey);
            this.getUDDINode().getTransport().getUDDISubscriptionService(node.getSubscriptionUrl()).deleteSubscription(deleteSubscription);
        }
        catch (Exception e) {
            this.log.error((Object)("Unable to unregister subscription key " + subscriptionKey + " ." + e.getMessage()), (Throwable)e);
        }
    }

    public TModelList findTModel(FindTModel findTModel) throws RemoteException, ConfigurationException, TransportException {
        return this.findTModel(findTModel, this.getUDDINode().getApiNode());
    }

    public TModelList findTModel(FindTModel findTModel, Node node) throws RemoteException, TransportException, ConfigurationException {
        findTModel.setAuthInfo(this.getAuthToken(node.getSecurityUrl()));
        try {
            TModelList tModelList = this.getUDDINode().getTransport().getUDDIInquiryService(node.getInquiryUrl()).findTModel(findTModel);
            return tModelList;
        }
        catch (DispositionReportFaultMessage dr) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport((Exception)((Object)dr));
            this.checkForErrorInDispositionReport(report, null, null);
        }
        catch (SOAPFaultException sfe) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport((Exception)((Object)sfe));
            this.checkForErrorInDispositionReport(report, null, null);
        }
        catch (UndeclaredThrowableException ute) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport((Exception)ute);
            this.checkForErrorInDispositionReport(report, null, null);
        }
        return null;
    }

    public TModelDetail getTModelDetail(String tModelKey) throws RemoteException, ConfigurationException, TransportException {
        GetTModelDetail getTModelDetail = new GetTModelDetail();
        getTModelDetail.getTModelKey().add(tModelKey);
        return this.getTModelDetail(getTModelDetail);
    }

    public TModelDetail getTModelDetail(GetTModelDetail getTModelDetail) throws RemoteException, ConfigurationException, TransportException {
        return this.getTModelDetail(getTModelDetail, this.getUDDINode().getApiNode());
    }

    public TModelDetail getTModelDetail(GetTModelDetail getTModelDetail, Node node) throws RemoteException, TransportException, ConfigurationException {
        getTModelDetail.setAuthInfo(this.getAuthToken(node.getSecurityUrl()));
        try {
            TModelDetail tModelDetail = this.getUDDINode().getTransport().getUDDIInquiryService(node.getInquiryUrl()).getTModelDetail(getTModelDetail);
            return tModelDetail;
        }
        catch (DispositionReportFaultMessage dr) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport((Exception)((Object)dr));
            this.checkForErrorInDispositionReport(report, null, null);
        }
        catch (SOAPFaultException sfe) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport((Exception)((Object)sfe));
            this.checkForErrorInDispositionReport(report, null, null);
        }
        catch (UndeclaredThrowableException ute) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport((Exception)ute);
            this.checkForErrorInDispositionReport(report, null, null);
        }
        return null;
    }

    public BusinessService findService(String serviceKey) throws RemoteException, TransportException, ConfigurationException {
        return this.findService(serviceKey, this.getUDDINode().getApiNode());
    }

    public BusinessService findService(String serviceKey, Node node) throws RemoteException, TransportException, ConfigurationException {
        GetServiceDetail getServiceDetail = new GetServiceDetail();
        getServiceDetail.getServiceKey().add(serviceKey);
        getServiceDetail.setAuthInfo(this.getAuthToken(node.getSecurityUrl()));
        try {
            ServiceDetail sd = this.getUDDINode().getTransport().getUDDIInquiryService(node.getInquiryUrl()).getServiceDetail(getServiceDetail);
            List businessServiceList = sd.getBusinessService();
            if (businessServiceList.size() == 0) {
                throw new ConfigurationException("Could not find Service with key=" + serviceKey);
            }
            return (BusinessService)businessServiceList.get(0);
        }
        catch (DispositionReportFaultMessage dr) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport((Exception)((Object)dr));
            this.checkForErrorInDispositionReport(report, "E_invalidKeyPassed", serviceKey);
        }
        catch (SOAPFaultException sfe) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport((Exception)((Object)sfe));
            this.checkForErrorInDispositionReport(report, "E_invalidKeyPassed", serviceKey);
        }
        catch (UndeclaredThrowableException ute) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport((Exception)ute);
            this.checkForErrorInDispositionReport(report, "E_invalidKeyPassed", serviceKey);
        }
        return null;
    }

    public BindingTemplate findServiceBinding(String bindingKey) throws DispositionReportFaultMessage, RemoteException, TransportException, ConfigurationException {
        return this.findServiceBinding(bindingKey, this.getUDDINode().getApiNode());
    }

    public BindingTemplate findServiceBinding(String bindingKey, Node node) throws DispositionReportFaultMessage, RemoteException, TransportException, ConfigurationException {
        GetBindingDetail getBindingDetail = new GetBindingDetail();
        getBindingDetail.getBindingKey().add(bindingKey);
        getBindingDetail.setAuthInfo(this.getAuthToken(node.getSecurityUrl()));
        try {
            BindingDetail bd = this.getUDDINode().getTransport().getUDDIInquiryService(node.getInquiryUrl()).getBindingDetail(getBindingDetail);
            List bindingTemplateList = bd.getBindingTemplate();
            if (bindingTemplateList.size() == 0) {
                throw new ConfigurationException("Could not find ServiceBinding with key=" + bindingKey);
            }
            return (BindingTemplate)bindingTemplateList.get(0);
        }
        catch (DispositionReportFaultMessage dr) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport((Exception)((Object)dr));
            this.checkForErrorInDispositionReport(report, "E_invalidKeyPassed", bindingKey);
        }
        catch (SOAPFaultException sfe) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport((Exception)((Object)sfe));
            this.checkForErrorInDispositionReport(report, "E_invalidKeyPassed", bindingKey);
        }
        catch (UndeclaredThrowableException ute) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport((Exception)ute);
            this.checkForErrorInDispositionReport(report, "E_invalidKeyPassed", bindingKey);
        }
        return null;
    }

    public BusinessEntity findBusiness(String businessKey) throws RemoteException, TransportException, ConfigurationException {
        return this.findBusiness(businessKey, this.getUDDINode().getApiNode());
    }

    public BusinessEntity findBusiness(String businessKey, Node node) throws RemoteException, TransportException, ConfigurationException {
        GetBusinessDetail getBusinessDetail = new GetBusinessDetail();
        getBusinessDetail.getBusinessKey().add(businessKey);
        getBusinessDetail.setAuthInfo(node.getSecurityUrl());
        try {
            BusinessDetail bd = this.getUDDINode().getTransport().getUDDIInquiryService(node.getInquiryUrl()).getBusinessDetail(getBusinessDetail);
            return (BusinessEntity)bd.getBusinessEntity().get(0);
        }
        catch (DispositionReportFaultMessage dr) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport((Exception)((Object)dr));
            this.checkForErrorInDispositionReport(report, "E_invalidKeyPassed", businessKey);
        }
        catch (SOAPFaultException sfe) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport((Exception)((Object)sfe));
            this.checkForErrorInDispositionReport(report, "E_invalidKeyPassed", businessKey);
        }
        catch (UndeclaredThrowableException ute) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport((Exception)ute);
            this.checkForErrorInDispositionReport(report, "E_invalidKeyPassed", businessKey);
        }
        return null;
    }

    public RelatedBusinessesList findRelatedBusinesses(String businessKey, Node node) throws RemoteException, TransportException, ConfigurationException {
        FindRelatedBusinesses findRelatedBusinesses = new FindRelatedBusinesses();
        findRelatedBusinesses.setBusinessKey(businessKey);
        findRelatedBusinesses.setAuthInfo(node.getSecurityUrl());
        try {
            RelatedBusinessesList rbl = this.getUDDINode().getTransport().getUDDIInquiryService(node.getInquiryUrl()).findRelatedBusinesses(findRelatedBusinesses);
            return rbl;
        }
        catch (DispositionReportFaultMessage dr) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport((Exception)((Object)dr));
            this.checkForErrorInDispositionReport(report, "E_invalidKeyPassed", businessKey);
        }
        catch (SOAPFaultException sfe) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport((Exception)((Object)sfe));
            this.checkForErrorInDispositionReport(report, "E_invalidKeyPassed", businessKey);
        }
        catch (UndeclaredThrowableException ute) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport((Exception)ute);
            this.checkForErrorInDispositionReport(report, "E_invalidKeyPassed", businessKey);
        }
        return null;
    }

    private void checkForErrorInDispositionReport(DispositionReport report, String Error, String entityKey) {
        if (entityKey != null && report != null && report.countainsErrorCode("E_invalidKeyPassed")) {
            this.log.info((Object)("entityKey " + entityKey + " was not found in the registry"));
        } else if (report == null) {
            this.log.info((Object)"Missing DispositionReport");
        } else {
            for (Result result : report.getResult()) {
                this.log.error((Object)(result.getErrInfo().getErrCode() + " " + result.getErrInfo().getValue()));
            }
        }
    }

    private String getAuthToken(String endpointURL) throws TransportException, DispositionReportFaultMessage, RemoteException {
        if (this.authToken != null && !"".equals(this.authToken) && this.tokenBirthDate != null && System.currentTimeMillis() > this.tokenBirthDate.getTime() + 600000L) {
            DiscardAuthToken discardAuthToken = new DiscardAuthToken();
            discardAuthToken.setAuthInfo(this.authToken);
            this.getUDDINode().getTransport().getUDDISecurityService(endpointURL).discardAuthToken(discardAuthToken);
            this.authToken = null;
        }
        if (this.authToken == null || "".equals(this.authToken)) {
            this.tokenBirthDate = new Date();
            GetAuthToken getAuthToken = new GetAuthToken();
            getAuthToken.setUserID(this.getPublisher());
            getAuthToken.setCred(this.getPassword());
            this.authToken = this.getUDDINode().getTransport().getUDDISecurityService(endpointURL).getAuthToken(getAuthToken).getAuthInfo();
        }
        return this.authToken;
    }

    public NodeDetail saveNode(Node node) {
        NodeDetail nodeDetail = null;
        try {
            this.log.info((Object)("Sending Node " + node.getName() + " info to jUDDI " + this.getUDDINode().getName()));
            SaveNode saveNode = new SaveNode();
            saveNode.setAuthInfo(this.getAuthToken(node.getSecurityUrl()));
            saveNode.getNode().add(node);
            nodeDetail = this.getUDDINode().getTransport().getJUDDIApiService(node.getJuddiApiUrl()).saveNode(saveNode);
        }
        catch (Exception e) {
            this.log.error((Object)("Unable to save node " + node.getName() + " ." + e.getMessage()), (Throwable)e);
        }
        catch (Throwable t) {
            this.log.error((Object)("Unable to save node " + node.getName() + " ." + t.getMessage()), t);
        }
        return nodeDetail;
    }

    public ClerkDetail saveClerk(UDDIClerk senderClerk) {
        ClerkDetail clerkDetail = null;
        try {
            this.log.debug((Object)("Sending Clerk " + senderClerk.getName() + " info to jUDDI " + this.getUDDINode().getName()));
            SaveClerk saveClerk = new SaveClerk();
            saveClerk.setAuthInfo(this.getAuthToken(senderClerk.getUDDINode().getSecurityUrl()));
            saveClerk.getClerk().add(this.getApiClerk());
            clerkDetail = this.getUDDINode().getTransport().getJUDDIApiService(senderClerk.getUDDINode().getJuddiApiUrl()).saveClerk(saveClerk);
        }
        catch (Exception e) {
            this.log.error((Object)("Unable to save clerk " + this.getName() + " ." + e.getMessage()), (Throwable)e);
        }
        catch (Throwable t) {
            this.log.error((Object)("Unable to save clerk " + this.getName() + " ." + t.getMessage()), t);
        }
        return clerkDetail;
    }

    public Clerk getApiClerk() {
        Clerk apiClerk = new Clerk();
        apiClerk.setName(this.name);
        apiClerk.setNode(this.uddiNode.getApiNode());
        apiClerk.setPassword(this.password);
        apiClerk.setPublisher(this.publisher);
        return apiClerk;
    }

    public UDDINode getUDDINode() {
        return this.uddiNode;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUDDINode(UDDINode uddiNode) {
        this.uddiNode = uddiNode;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

