/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.EmailAddress;
import javax.xml.registry.infomodel.ExternalIdentifier;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.LocalizedString;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.PostalAddress;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.Slot;
import javax.xml.registry.infomodel.SpecificationLink;
import javax.xml.registry.infomodel.TelephoneNumber;
import javax.xml.registry.infomodel.User;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.scout.registry.infomodel.InternationalStringImpl;
import org.uddi.api_v3.AccessPoint;
import org.uddi.api_v3.Address;
import org.uddi.api_v3.AddressLine;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BindingTemplates;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.BusinessServices;
import org.uddi.api_v3.CategoryBag;
import org.uddi.api_v3.Contact;
import org.uddi.api_v3.Contacts;
import org.uddi.api_v3.Description;
import org.uddi.api_v3.DiscoveryURL;
import org.uddi.api_v3.DiscoveryURLs;
import org.uddi.api_v3.Email;
import org.uddi.api_v3.HostingRedirector;
import org.uddi.api_v3.IdentifierBag;
import org.uddi.api_v3.InstanceDetails;
import org.uddi.api_v3.KeyedReference;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.ObjectFactory;
import org.uddi.api_v3.OverviewDoc;
import org.uddi.api_v3.OverviewURL;
import org.uddi.api_v3.PersonName;
import org.uddi.api_v3.Phone;
import org.uddi.api_v3.PublisherAssertion;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelBag;
import org.uddi.api_v3.TModelInstanceDetails;
import org.uddi.api_v3.TModelInstanceInfo;

public class ScoutJaxrUddiV3Helper {
    private static final String UDDI_ORG_TYPES = "uuid:C1ACF26D-9672-4404-9D70-39B756E62AB4";
    private static Log log = LogFactory.getLog(ScoutJaxrUddiV3Helper.class);
    private static ObjectFactory objectFactory = new ObjectFactory();

    public static Address getAddress(PostalAddress postalAddress) throws JAXRException {
        Address address = objectFactory.createAddress();
        AddressLine[] addarr = new AddressLine[7];
        String stnum = postalAddress.getStreetNumber();
        String st = postalAddress.getStreet();
        String city = postalAddress.getCity();
        String country = postalAddress.getCountry();
        String code = postalAddress.getPostalCode();
        String state = postalAddress.getStateOrProvince();
        String type = postalAddress.getType();
        AddressLine stnumAL = objectFactory.createAddressLine();
        stnumAL.setKeyName("STREET_NUMBER");
        if (stnum != null) {
            stnumAL.setKeyValue("STREET_NUMBER");
            stnumAL.setValue(stnum);
        }
        AddressLine stAL = objectFactory.createAddressLine();
        stAL.setKeyName("STREET");
        if (st != null) {
            stAL.setKeyValue("STREET");
            stAL.setValue(st);
        }
        AddressLine cityAL = objectFactory.createAddressLine();
        cityAL.setKeyName("CITY");
        if (city != null) {
            cityAL.setKeyValue("CITY");
            cityAL.setValue(city);
        }
        AddressLine countryAL = objectFactory.createAddressLine();
        countryAL.setKeyName("COUNTRY");
        if (country != null) {
            countryAL.setKeyValue("COUNTRY");
            countryAL.setValue(country);
        }
        AddressLine codeAL = objectFactory.createAddressLine();
        codeAL.setKeyName("POSTALCODE");
        if (code != null) {
            codeAL.setKeyValue("POSTALCODE");
            codeAL.setValue(code);
        }
        AddressLine stateAL = objectFactory.createAddressLine();
        stateAL.setKeyName("STATE");
        if (state != null) {
            stateAL.setKeyValue("STATE");
            stateAL.setValue(state);
        }
        AddressLine typeAL = objectFactory.createAddressLine();
        typeAL.setKeyName("TYPE");
        if (type != null) {
            typeAL.setKeyValue("TYPE");
            typeAL.setValue(type);
        }
        addarr[0] = stnumAL;
        addarr[1] = stAL;
        addarr[2] = cityAL;
        addarr[3] = countryAL;
        addarr[4] = codeAL;
        addarr[5] = stateAL;
        addarr[6] = typeAL;
        address.getAddressLine().addAll(Arrays.asList(addarr));
        return address;
    }

    public static BindingTemplate getBindingTemplateFromJAXRSB(ServiceBinding serviceBinding) throws JAXRException {
        BindingTemplate bt = objectFactory.createBindingTemplate();
        if (serviceBinding.getKey() != null && serviceBinding.getKey().getId() != null) {
            bt.setBindingKey(serviceBinding.getKey().getId());
        } else {
            bt.setBindingKey("");
        }
        try {
            ServiceBinding sb;
            String accessuri = serviceBinding.getAccessURI();
            if (accessuri != null) {
                AccessPoint accessPoint = objectFactory.createAccessPoint();
                accessPoint.setUseType(ScoutJaxrUddiV3Helper.getUseType(accessuri));
                accessPoint.setValue(accessuri);
                bt.setAccessPoint(accessPoint);
            }
            if ((sb = serviceBinding.getTargetBinding()) != null) {
                HostingRedirector red = objectFactory.createHostingRedirector();
                Key key = sb.getKey();
                if (key != null && key.getId() != null) {
                    red.setBindingKey(key.getId());
                } else {
                    red.setBindingKey("");
                }
                bt.setHostingRedirector(red);
            } else if (bt.getAccessPoint() == null) {
                bt.setAccessPoint(objectFactory.createAccessPoint());
            }
            Service svc = serviceBinding.getService();
            if (svc != null && svc.getKey() != null && svc.getKey().getId() != null) {
                bt.setServiceKey(svc.getKey().getId());
            }
            InternationalString idesc = serviceBinding.getDescription();
            ScoutJaxrUddiV3Helper.addDescriptions(bt.getDescription(), idesc);
            Collection slcol = serviceBinding.getSpecificationLinks();
            TModelInstanceDetails tid = objectFactory.createTModelInstanceDetails();
            if (slcol != null && !slcol.isEmpty()) {
                for (SpecificationLink slink : slcol) {
                    Collection externalLinks;
                    TModelInstanceInfo emptyTInfo = objectFactory.createTModelInstanceInfo();
                    tid.getTModelInstanceInfo().add(emptyTInfo);
                    RegistryObject specificationObject = slink.getSpecificationObject();
                    if (specificationObject.getKey() == null || specificationObject.getKey().getId() == null) continue;
                    emptyTInfo.setTModelKey(specificationObject.getKey().getId());
                    if (specificationObject.getDescription() != null) {
                        for (Object o : specificationObject.getDescription().getLocalizedStrings()) {
                            LocalizedString locDesc = (LocalizedString)o;
                            Description description = objectFactory.createDescription();
                            emptyTInfo.getDescription().add(description);
                            description.setValue(locDesc.getValue());
                            description.setLang(locDesc.getLocale().getLanguage());
                        }
                    }
                    if ((externalLinks = slink.getExternalLinks()) == null || externalLinks.size() <= 0) continue;
                    for (ExternalLink link : externalLinks) {
                        InstanceDetails ids = objectFactory.createInstanceDetails();
                        emptyTInfo.setInstanceDetails(ids);
                        if (link.getDescription() != null) {
                            Description description = objectFactory.createDescription();
                            ids.getDescription().add(description);
                            description.setValue(link.getDescription().getValue());
                        }
                        if (link.getExternalURI() != null) {
                            OverviewDoc overviewDoc = objectFactory.createOverviewDoc();
                            ids.getOverviewDoc().add(overviewDoc);
                            OverviewURL ourl = new OverviewURL();
                            ourl.setValue(link.getExternalURI());
                            overviewDoc.setOverviewURL(ourl);
                        }
                        if (slink.getUsageParameters() == null) continue;
                        StringBuffer buffer = new StringBuffer();
                        for (Object o : slink.getUsageParameters()) {
                            String s = (String)o;
                            buffer.append(s + " ");
                        }
                        ids.setInstanceParms(buffer.toString().trim());
                    }
                }
            }
            if (tid.getTModelInstanceInfo().size() != 0) {
                bt.setTModelInstanceDetails(tid);
            }
            log.debug((Object)("BindingTemplate=" + bt.toString()));
        }
        catch (Exception ud) {
            throw new JAXRException("Apache JAXR Impl:", (Throwable)ud);
        }
        return bt;
    }

    public static PublisherAssertion getPubAssertionFromJAXRAssociation(Association association) throws JAXRException {
        PublisherAssertion pa = objectFactory.createPublisherAssertion();
        try {
            if (association.getSourceObject().getKey() != null && association.getSourceObject().getKey().getId() != null) {
                pa.setFromKey(association.getSourceObject().getKey().getId());
            }
            if (association.getTargetObject().getKey() != null && association.getTargetObject().getKey().getId() != null) {
                pa.setToKey(association.getTargetObject().getKey().getId());
            }
            Concept c = association.getAssociationType();
            String v = c.getValue();
            KeyedReference kr = objectFactory.createKeyedReference();
            Key key = c.getKey();
            if (key == null) {
                key = c.getClassificationScheme().getKey();
            }
            if (key != null && key.getId() != null) {
                kr.setTModelKey(key.getId());
            }
            kr.setKeyName("Concept");
            if (v != null) {
                kr.setKeyValue(v);
            }
            pa.setKeyedReference(kr);
        }
        catch (Exception ud) {
            throw new JAXRException("Apache JAXR Impl:", (Throwable)ud);
        }
        return pa;
    }

    public static PublisherAssertion getPubAssertionFromJAXRAssociationKey(String key) throws JAXRException {
        PublisherAssertion pa = objectFactory.createPublisherAssertion();
        try {
            StringTokenizer token = new StringTokenizer(key, "|");
            if (token.hasMoreTokens()) {
                pa.setFromKey(ScoutJaxrUddiV3Helper.getToken(token.nextToken()));
                pa.setToKey(ScoutJaxrUddiV3Helper.getToken(token.nextToken()));
                KeyedReference kr = objectFactory.createKeyedReference();
                String str = ScoutJaxrUddiV3Helper.getToken(token.nextToken());
                if ("UUID".equalsIgnoreCase(str)) {
                    str = str + ":" + ScoutJaxrUddiV3Helper.getToken(token.nextToken());
                }
                kr.setTModelKey(str);
                kr.setKeyName(ScoutJaxrUddiV3Helper.getToken(token.nextToken()));
                kr.setKeyValue(ScoutJaxrUddiV3Helper.getToken(token.nextToken()));
                pa.setKeyedReference(kr);
            }
        }
        catch (Exception ud) {
            throw new JAXRException("Apache JAXR Impl:", (Throwable)ud);
        }
        return pa;
    }

    public static BusinessService getBusinessServiceFromJAXRService(Service service) throws JAXRException {
        BusinessService bs = objectFactory.createBusinessService();
        try {
            BindingTemplates bt;
            InternationalString iname = service.getName();
            ScoutJaxrUddiV3Helper.addNames(bs.getName(), iname);
            InternationalString idesc = service.getDescription();
            ScoutJaxrUddiV3Helper.addDescriptions(bs.getDescription(), idesc);
            Organization o = service.getProvidingOrganization();
            if (o != null) {
                Key k = o.getKey();
                if (k != null && k.getId() != null) {
                    bs.setBusinessKey(k.getId());
                }
            } else {
                throw new JAXRException("Service has no associated organization");
            }
            if (service.getKey() != null && service.getKey().getId() != null) {
                bs.setServiceKey(service.getKey().getId());
            } else {
                bs.setServiceKey("");
            }
            CategoryBag catBag = ScoutJaxrUddiV3Helper.getCategoryBagFromClassifications(service.getClassifications());
            if (catBag != null) {
                bs.setCategoryBag(catBag);
            }
            if ((bt = ScoutJaxrUddiV3Helper.getBindingTemplates(service.getServiceBindings())) != null) {
                bs.setBindingTemplates(bt);
            }
            log.debug((Object)("BusinessService=" + bs.toString()));
        }
        catch (Exception ud) {
            throw new JAXRException("Apache JAXR Impl:", (Throwable)ud);
        }
        return bs;
    }

    public static TModel getTModelFromJAXRClassificationScheme(ClassificationScheme classificationScheme) throws JAXRException {
        TModel tm = objectFactory.createTModel();
        try {
            CategoryBag catBag;
            Key k = classificationScheme.getKey();
            if (k != null && k.getId() != null) {
                tm.setTModelKey(k.getId());
            } else {
                tm.setTModelKey("");
            }
            Slot s = classificationScheme.getSlot("authorizedName");
            s = classificationScheme.getSlot("operator");
            InternationalString iname = classificationScheme.getName();
            tm.setName(ScoutJaxrUddiV3Helper.getFirstName(iname));
            InternationalString idesc = classificationScheme.getDescription();
            ScoutJaxrUddiV3Helper.addDescriptions(tm.getDescription(), idesc);
            IdentifierBag idBag = ScoutJaxrUddiV3Helper.getIdentifierBagFromExternalIdentifiers(classificationScheme.getExternalIdentifiers());
            if (idBag != null) {
                tm.setIdentifierBag(idBag);
            }
            if ((catBag = ScoutJaxrUddiV3Helper.getCategoryBagFromClassifications(classificationScheme.getClassifications())) != null) {
                tm.setCategoryBag(catBag);
            }
        }
        catch (Exception ud) {
            throw new JAXRException("Apache JAXR Impl:", (Throwable)ud);
        }
        return tm;
    }

    public static TModel getTModelFromJAXRConcept(Concept concept) throws JAXRException {
        TModel tm = objectFactory.createTModel();
        if (concept == null) {
            return null;
        }
        try {
            CategoryBag catBag;
            IdentifierBag idBag;
            Key key = concept.getKey();
            if (key != null && key.getId() != null) {
                tm.setTModelKey(key.getId());
            }
            Slot sl1 = concept.getSlot("authorizedName");
            InternationalString iname = concept.getName();
            tm.setName(ScoutJaxrUddiV3Helper.getFirstName(iname));
            InternationalString idesc = concept.getDescription();
            ScoutJaxrUddiV3Helper.addDescriptions(tm.getDescription(), idesc);
            Collection externalLinks = concept.getExternalLinks();
            if (externalLinks != null && externalLinks.size() > 0) {
                tm.getOverviewDoc().add(ScoutJaxrUddiV3Helper.getOverviewDocFromExternalLink((ExternalLink)externalLinks.iterator().next()));
            }
            if ((idBag = ScoutJaxrUddiV3Helper.getIdentifierBagFromExternalIdentifiers(concept.getExternalIdentifiers())) != null) {
                tm.setIdentifierBag(idBag);
            }
            if ((catBag = ScoutJaxrUddiV3Helper.getCategoryBagFromClassifications(concept.getClassifications())) != null) {
                tm.setCategoryBag(catBag);
            }
        }
        catch (Exception ud) {
            throw new JAXRException("Apache JAXR Impl:", (Throwable)ud);
        }
        return tm;
    }

    private static void addDescriptions(List<Description> descripions, InternationalString idesc) throws JAXRException {
        if (idesc != null) {
            for (Object o : idesc.getLocalizedStrings()) {
                LocalizedString locName = (LocalizedString)o;
                Description desc = objectFactory.createDescription();
                descripions.add(desc);
                desc.setValue(locName.getValue());
                desc.setLang(locName.getLocale().getLanguage());
            }
        }
    }

    private static Name getFirstName(InternationalString iname) throws JAXRException {
        Iterator i$ = iname.getLocalizedStrings().iterator();
        if (i$.hasNext()) {
            Object o = i$.next();
            LocalizedString locName = (LocalizedString)o;
            Name name = objectFactory.createName();
            name.setValue(locName.getValue());
            name.setLang(locName.getLocale().getLanguage());
            return name;
        }
        return null;
    }

    private static void addNames(List<Name> names, InternationalString iname) throws JAXRException {
        for (Object o : iname.getLocalizedStrings()) {
            LocalizedString locName = (LocalizedString)o;
            Name name = objectFactory.createName();
            name.setValue(locName.getValue());
            name.setLang(locName.getLocale().getLanguage());
            names.add(name);
        }
    }

    public static BusinessEntity getBusinessEntityFromJAXROrg(Organization organization) throws JAXRException {
        BusinessEntity biz = objectFactory.createBusinessEntity();
        BusinessServices bss = objectFactory.createBusinessServices();
        BusinessService[] barr = new BusinessService[]{};
        try {
            CategoryBag catBag;
            Key key = organization.getKey();
            if (key != null && key.getId() != null) {
                biz.setBusinessKey(key.getId());
            } else {
                biz.setBusinessKey("");
            }
            InternationalString iname = organization.getName();
            if (iname != null) {
                ScoutJaxrUddiV3Helper.addNames(biz.getName(), iname);
            }
            InternationalString idesc = organization.getDescription();
            ScoutJaxrUddiV3Helper.addDescriptions(biz.getDescription(), idesc);
            if (organization.getPrimaryContact() == null || organization.getPrimaryContact().getPersonName() == null || organization.getPrimaryContact().getPersonName().getFullName() != null) {
                // empty if block
            }
            Collection s = organization.getServices();
            log.debug((Object)("?Org has services=" + s.isEmpty()));
            barr = new BusinessService[s.size()];
            Iterator iter = s.iterator();
            int barrPos = 0;
            while (iter.hasNext()) {
                BusinessService bs;
                barr[barrPos] = bs = ScoutJaxrUddiV3Helper.getBusinessServiceFromJAXRService((Service)iter.next());
                ++barrPos;
            }
            Contacts cts = objectFactory.createContacts();
            Contact[] carr = new Contact[]{};
            User primaryContact = organization.getPrimaryContact();
            Collection users = organization.getUsers();
            int carrSize = 0;
            if (primaryContact != null) {
                ++carrSize;
            }
            for (User u : users) {
                if (u == primaryContact) continue;
                ++carrSize;
            }
            carr = new Contact[carrSize];
            if (primaryContact != null) {
                Contact ct;
                carr[0] = ct = ScoutJaxrUddiV3Helper.getContactFromJAXRUser(primaryContact);
            }
            Iterator it = users.iterator();
            int carrPos = 1;
            while (it.hasNext()) {
                Contact ct;
                User u = (User)it.next();
                if (u == primaryContact) continue;
                carr[carrPos] = ct = ScoutJaxrUddiV3Helper.getContactFromJAXRUser(u);
                ++carrPos;
            }
            bss.getBusinessService().addAll(Arrays.asList(barr));
            if (carr.length > 0) {
                cts.getContact().addAll(Arrays.asList(carr));
                biz.setContacts(cts);
            }
            biz.setBusinessServices(bss);
            Iterator exiter = organization.getExternalLinks().iterator();
            DiscoveryURLs emptyDUs = null;
            boolean first = true;
            while (exiter.hasNext()) {
                ExternalLink link = (ExternalLink)exiter.next();
                if (first) {
                    emptyDUs = objectFactory.createDiscoveryURLs();
                    biz.setDiscoveryURLs(emptyDUs);
                    first = false;
                }
                DiscoveryURL emptyDU = objectFactory.createDiscoveryURL();
                emptyDUs.getDiscoveryURL().add(emptyDU);
                emptyDU.setUseType("businessEntityExt");
                if (link.getExternalURI() == null) continue;
                emptyDU.setValue(link.getExternalURI());
            }
            IdentifierBag idBag = ScoutJaxrUddiV3Helper.getIdentifierBagFromExternalIdentifiers(organization.getExternalIdentifiers());
            if (idBag != null) {
                biz.setIdentifierBag(idBag);
            }
            if ((catBag = ScoutJaxrUddiV3Helper.getCategoryBagFromClassifications(organization.getClassifications())) != null) {
                biz.setCategoryBag(catBag);
            }
        }
        catch (Exception ud) {
            throw new JAXRException("Apache JAXR Impl:", (Throwable)ud);
        }
        return biz;
    }

    public static Contact getContactFromJAXRUser(User user) throws JAXRException {
        Contact ct = objectFactory.createContact();
        if (user == null) {
            return null;
        }
        Address[] addarr = new Address[]{};
        Phone[] phonearr = new Phone[]{};
        Email[] emailarr = new Email[]{};
        try {
            if (user.getPersonName() != null && user.getPersonName().getFullName() != null) {
                PersonName pn = new PersonName();
                pn.setValue(user.getPersonName().getFullName());
                ct.getPersonName().add(pn);
            }
            if (user.getType() != null) {
                ct.setUseType(user.getType());
            }
            Collection postc = user.getPostalAddresses();
            addarr = new Address[postc.size()];
            Iterator iterator = postc.iterator();
            int addarrPos = 0;
            while (iterator.hasNext()) {
                PostalAddress post = (PostalAddress)iterator.next();
                addarr[addarrPos] = ScoutJaxrUddiV3Helper.getAddress(post);
                ++addarrPos;
            }
            Collection ph = user.getTelephoneNumbers(null);
            phonearr = new Phone[ph.size()];
            Iterator it = ph.iterator();
            int phonearrPos = 0;
            while (it.hasNext()) {
                TelephoneNumber t = (TelephoneNumber)it.next();
                Phone phone = objectFactory.createPhone();
                String str = t.getNumber();
                log.debug((Object)("Telephone=" + str));
                if (str != null) {
                    phone.setValue(str);
                } else {
                    phone.setValue("");
                }
                phonearr[phonearrPos] = phone;
                ++phonearrPos;
            }
            Collection ec = user.getEmailAddresses();
            emailarr = new Email[ec.size()];
            Iterator iter = ec.iterator();
            int emailarrPos = 0;
            while (iter.hasNext()) {
                EmailAddress ea = (EmailAddress)iter.next();
                Email email = objectFactory.createEmail();
                if (ea.getAddress() != null) {
                    email.setValue(ea.getAddress());
                }
                if (ea.getType() != null) {
                    email.setUseType(ea.getType());
                }
                emailarr[emailarrPos] = email;
                ++emailarrPos;
            }
            ct.getAddress().addAll(Arrays.asList(addarr));
            ct.getPhone().addAll(Arrays.asList(phonearr));
            ct.getEmail().addAll(Arrays.asList(emailarr));
        }
        catch (Exception ud) {
            throw new JAXRException("Apache JAXR Impl:", (Throwable)ud);
        }
        return ct;
    }

    private static String getToken(String tokenstr) {
        if (tokenstr.equals("NULL")) {
            tokenstr = "";
        }
        return tokenstr;
    }

    private static String getUseType(String accessuri) {
        String acc = accessuri.toLowerCase();
        String uri = "other";
        if (acc.startsWith("http:")) {
            uri = "http:";
        } else if (acc.startsWith("https:")) {
            uri = "https:";
        } else if (acc.startsWith("ftp:")) {
            uri = "ftp:";
        } else if (acc.startsWith("phone:")) {
            uri = "phone:";
        }
        return uri;
    }

    public static CategoryBag getCategoryBagFromClassifications(Collection classifications) throws JAXRException {
        try {
            if (classifications == null || classifications.size() == 0) {
                return null;
            }
            CategoryBag cbag = objectFactory.createCategoryBag();
            for (Classification classification : classifications) {
                Key key;
                if (classification == null) continue;
                KeyedReference keyr = objectFactory.createKeyedReference();
                cbag.getKeyedReference().add(keyr);
                InternationalStringImpl iname = null;
                String value = null;
                ClassificationScheme scheme = classification.getClassificationScheme();
                if (scheme == null || classification.isExternal() && classification.getConcept() == null) {
                    keyr.setTModelKey(UDDI_ORG_TYPES);
                    keyr.setKeyValue("specification");
                    continue;
                }
                if (classification.isExternal()) {
                    iname = (InternationalStringImpl)classification.getName();
                    value = classification.getValue();
                } else {
                    Concept concept = classification.getConcept();
                    if (concept != null) {
                        iname = (InternationalStringImpl)concept.getName();
                        value = concept.getValue();
                        scheme = concept.getClassificationScheme();
                    }
                }
                String name = iname.getValue();
                if (name != null) {
                    keyr.setKeyName(name);
                }
                if (value != null) {
                    keyr.setKeyValue(value);
                }
                if (scheme == null || (key = scheme.getKey()) == null || key.getId() == null) continue;
                keyr.setTModelKey(key.getId());
            }
            if (cbag.getKeyedReference().isEmpty()) {
                return null;
            }
            return cbag;
        }
        catch (Exception ud) {
            throw new JAXRException("Apache JAXR Impl:", (Throwable)ud);
        }
    }

    public static TModelBag getTModelBagFromSpecifications(Collection specifications) throws JAXRException {
        try {
            if (specifications == null || specifications.size() == 0) {
                return null;
            }
            TModelBag tbag = objectFactory.createTModelBag();
            for (RegistryObject registryobject : specifications) {
                if (registryobject instanceof Concept) {
                    Concept concept = (Concept)registryobject;
                    if (concept.getKey() == null) continue;
                    tbag.getTModelKey().add(concept.getKey().toString());
                    continue;
                }
                log.info((Object)"ebXML case - the RegistryObject is an ExtrinsicObject, Not implemented");
            }
            if (tbag.getTModelKey().isEmpty()) {
                return null;
            }
            return tbag;
        }
        catch (Exception ud) {
            throw new JAXRException("Apache JAXR Impl:", (Throwable)ud);
        }
    }

    public static IdentifierBag getIdentifierBagFromExternalIdentifiers(Collection identifiers) throws JAXRException {
        try {
            if (identifiers == null || identifiers.size() == 0) {
                return null;
            }
            IdentifierBag ibag = objectFactory.createIdentifierBag();
            for (ExternalIdentifier extid : identifiers) {
                Key key;
                if (extid == null) continue;
                KeyedReference keyr = objectFactory.createKeyedReference();
                ibag.getKeyedReference().add(keyr);
                InternationalStringImpl iname = (InternationalStringImpl)extid.getName();
                String value = extid.getValue();
                ClassificationScheme scheme = extid.getIdentificationScheme();
                String name = iname.getValue();
                if (name != null) {
                    keyr.setKeyName(name);
                }
                if (value != null) {
                    keyr.setKeyValue(value);
                }
                if (scheme == null || (key = scheme.getKey()) == null || key.getId() == null) continue;
                keyr.setTModelKey(key.getId());
            }
            return ibag;
        }
        catch (Exception ud) {
            throw new JAXRException("Apache JAXR Impl:", (Throwable)ud);
        }
    }

    private static OverviewDoc getOverviewDocFromExternalLink(ExternalLink link) throws JAXRException {
        InternationalString extDesc;
        OverviewDoc od = objectFactory.createOverviewDoc();
        String url = link.getExternalURI();
        if (url != null) {
            OverviewURL ourl = new OverviewURL();
            ourl.setValue(url.toString());
            od.setOverviewURL(ourl);
        }
        if ((extDesc = link.getDescription()) != null) {
            Description description = objectFactory.createDescription();
            od.getDescription().add(description);
            description.setValue(extDesc.getValue());
        }
        return od;
    }

    private static BindingTemplates getBindingTemplates(Collection serviceBindings) throws JAXRException {
        BindingTemplates bt = null;
        if (serviceBindings != null && serviceBindings.size() > 0) {
            bt = objectFactory.createBindingTemplates();
            Iterator iter = serviceBindings.iterator();
            int currLoc = 0;
            BindingTemplate[] bindingTemplateArray = new BindingTemplate[serviceBindings.size()];
            while (iter.hasNext()) {
                ServiceBinding sb = (ServiceBinding)iter.next();
                bindingTemplateArray[currLoc] = ScoutJaxrUddiV3Helper.getBindingTemplateFromJAXRSB(sb);
                ++currLoc;
            }
            if (bindingTemplateArray != null) {
                bt.getBindingTemplate().addAll(Arrays.asList(bindingTemplateArray));
            }
        }
        return bt;
    }
}

