/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message.token;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.util.DOM2Writer;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.ws.security.util.XmlSchemaDateFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class Timestamp {
    private static final Log LOG = LogFactory.getLog(Timestamp.class);
    protected Element element = null;
    protected List<Element> customElements = null;
    protected Date createdDate;
    protected Date expiresDate;

    public Timestamp(Element timestampElement) throws WSSecurityException {
        this(timestampElement, true);
    }

    public Timestamp(Element timestampElement, boolean bspCompliant) throws WSSecurityException {
        this.element = timestampElement;
        this.customElements = new ArrayList<Element>();
        String strCreated = null;
        String strExpires = null;
        for (Node currentChild = this.element.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            String valueType;
            if (1 != currentChild.getNodeType()) continue;
            Element currentChildElement = (Element)currentChild;
            if ("Created".equals(currentChild.getLocalName()) && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd".equals(currentChild.getNamespaceURI())) {
                if (strCreated == null) {
                    valueType = currentChildElement.getAttribute("ValueType");
                    if (bspCompliant && valueType != null && !"".equals(valueType)) {
                        throw new WSSecurityException(3, "invalidTimestamp");
                    }
                    strCreated = ((Text)currentChildElement.getFirstChild()).getData();
                    continue;
                }
                throw new WSSecurityException(3, "invalidTimestamp");
            }
            if ("Expires".equals(currentChild.getLocalName()) && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd".equals(currentChild.getNamespaceURI())) {
                if (strExpires != null || bspCompliant && strCreated == null) {
                    throw new WSSecurityException(3, "invalidTimestamp");
                }
                valueType = currentChildElement.getAttribute("ValueType");
                if (bspCompliant && valueType != null && !"".equals(valueType)) {
                    throw new WSSecurityException(3, "invalidTimestamp");
                }
                strExpires = ((Text)currentChildElement.getFirstChild()).getData();
                continue;
            }
            if (bspCompliant) {
                throw new WSSecurityException(3, "invalidTimestamp");
            }
            this.customElements.add(currentChildElement);
        }
        if (bspCompliant && strCreated == null) {
            throw new WSSecurityException(3, "invalidTimestamp");
        }
        XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
        if (bspCompliant) {
            ((DateFormat)zulu).setLenient(false);
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Current time: " + zulu.format(new Date())));
            }
            if (strCreated != null) {
                this.createdDate = zulu.parse(strCreated);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Timestamp created: " + zulu.format(this.createdDate)));
                }
            }
            if (strExpires != null) {
                this.expiresDate = zulu.parse(strExpires);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Timestamp expires: " + zulu.format(this.expiresDate)));
                }
            }
        }
        catch (ParseException e) {
            throw new WSSecurityException(3, "invalidTimestamp", null, e);
        }
    }

    public Timestamp(boolean milliseconds, Document doc, int ttl) {
        this.customElements = new ArrayList<Element>();
        this.element = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Timestamp");
        DateFormat zulu = null;
        if (milliseconds) {
            zulu = new XmlSchemaDateFormat();
        } else {
            zulu = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            zulu.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        Element elementCreated = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Created");
        this.createdDate = new Date();
        elementCreated.appendChild(doc.createTextNode(zulu.format(this.createdDate)));
        this.element.appendChild(elementCreated);
        if (ttl != 0) {
            this.expiresDate = new Date();
            this.expiresDate.setTime(this.createdDate.getTime() + (long)ttl * 1000L);
            Element elementExpires = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Expires");
            elementExpires.appendChild(doc.createTextNode(zulu.format(this.expiresDate)));
            this.element.appendChild(elementExpires);
        }
    }

    public void addWSUNamespace() {
        WSSecurityUtil.setNamespace(this.element, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
    }

    public Element getElement() {
        return this.element;
    }

    public String toString() {
        return DOM2Writer.nodeToString(this.element);
    }

    public Date getCreated() {
        return this.createdDate;
    }

    public Date getExpires() {
        return this.expiresDate;
    }

    public void addCustomElement(Document doc, Element customElement) {
        this.customElements.add(customElement);
        this.element.appendChild(customElement);
    }

    public List<Element> getCustomElements() {
        return this.customElements;
    }

    public void setID(String id) {
        this.element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", id);
    }

    public String getID() {
        return this.element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
    }

    public boolean isExpired() {
        if (this.expiresDate != null) {
            Date rightNow = new Date();
            return this.expiresDate.before(rightNow);
        }
        return false;
    }

    public boolean verifyCreated(int timeToLive, int futureTimeToLive) {
        Date validCreation = new Date();
        long currentTime = validCreation.getTime();
        if (futureTimeToLive > 0) {
            validCreation.setTime(currentTime + (long)futureTimeToLive * 1000L);
        }
        if (this.createdDate != null && this.createdDate.after(validCreation)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Validation of Timestamp: The message was created in the future!");
            }
            return false;
        }
        validCreation.setTime(currentTime -= (long)timeToLive * 1000L);
        if (this.createdDate != null && this.createdDate.before(validCreation)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Validation of Timestamp: The message was created too long ago");
            }
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Validation of Timestamp: Everything is ok");
        }
        return true;
    }

    public int hashCode() {
        int result = 17;
        if (this.createdDate != null) {
            result = 31 * result + this.createdDate.hashCode();
        }
        if (this.expiresDate != null) {
            result = 31 * result + this.expiresDate.hashCode();
        }
        return result;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Timestamp)) {
            return false;
        }
        Timestamp timestamp = (Timestamp)object;
        if (!this.compare(timestamp.getCreated(), this.getCreated())) {
            return false;
        }
        return this.compare(timestamp.getExpires(), this.getExpires());
    }

    private boolean compare(Date item1, Date item2) {
        if (item1 == null && item2 != null) {
            return false;
        }
        return item1 == null || item1.equals(item2);
    }
}

