/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.util;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Loader {
    private static Log log = LogFactory.getLog(Loader.class);

    private Loader() {
    }

    public static URL getResource(String resource) {
        URL url = null;
        try {
            ClassLoader classLoader = Loader.getTCL();
            if (classLoader != null) {
                log.debug((Object)("Trying to find [" + resource + "] using " + classLoader + " class loader."));
                url = classLoader.getResource(resource);
                if (url == null && resource.startsWith("/")) {
                    url = classLoader.getResource(resource.substring(1));
                }
                if (url != null) {
                    return url;
                }
            }
        }
        catch (Throwable t) {
            log.warn((Object)"Caught Exception while in Loader.getResource. This may be innocuous.", t);
        }
        ClassLoader cluClassloader = Loader.class.getClassLoader();
        if (cluClassloader == null) {
            cluClassloader = ClassLoader.getSystemClassLoader();
        }
        if ((url = cluClassloader.getResource(resource)) == null && resource.startsWith("/")) {
            url = cluClassloader.getResource(resource.substring(1));
        }
        if (url != null) {
            return url;
        }
        log.debug((Object)("Trying to find [" + resource + "] using ClassLoader.getSystemResource()."));
        return ClassLoader.getSystemResource(resource);
    }

    public static URL getResource(ClassLoader loader, String resource) {
        URL url = null;
        try {
            if (loader != null) {
                log.debug((Object)("Trying to find [" + resource + "] using " + loader + " class loader."));
                url = loader.getResource(resource);
                if (url == null && resource.startsWith("/")) {
                    url = loader.getResource(resource.substring(1));
                }
                if (url != null) {
                    return url;
                }
            }
        }
        catch (Throwable t) {
            log.warn((Object)"Caught Exception while in Loader.getResource. This may be innocuous.", t);
        }
        return Loader.getResource(resource);
    }

    public static ClassLoader getTCL() throws IllegalAccessException, InvocationTargetException {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    public static ClassLoader getClassLoader(final Class<?> clazz) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return clazz.getClassLoader();
            }
        });
    }

    public static Class<?> loadClass(ClassLoader loader, String clazz) throws ClassNotFoundException {
        try {
            Class<?> c;
            if (loader != null && (c = loader.loadClass(clazz)) != null) {
                return c;
            }
        }
        catch (Throwable e) {
            log.warn((Object)e.getMessage(), e);
        }
        return Loader.loadClass(clazz, true);
    }

    public static <T> Class<? extends T> loadClass(ClassLoader loader, String clazz, Class<T> type) throws ClassNotFoundException {
        try {
            Class<?> c;
            if (loader != null && (c = loader.loadClass(clazz)) != null) {
                return c.asSubclass(type);
            }
        }
        catch (Throwable e) {
            log.warn((Object)e.getMessage(), e);
        }
        return Loader.loadClass(clazz, true, type);
    }

    public static Class<?> loadClass(String clazz) throws ClassNotFoundException {
        return Loader.loadClass(clazz, true);
    }

    public static <T> Class<? extends T> loadClass(String clazz, Class<T> type) throws ClassNotFoundException {
        return Loader.loadClass(clazz, true, type);
    }

    public static <T> Class<? extends T> loadClass(String clazz, boolean warn, Class<T> type) throws ClassNotFoundException {
        return Loader.loadClass(clazz, warn).asSubclass(type);
    }

    public static Class<?> loadClass(String clazz, boolean warn) throws ClassNotFoundException {
        try {
            Class<?> c;
            ClassLoader tcl = Loader.getTCL();
            if (tcl != null && (c = tcl.loadClass(clazz)) != null) {
                return c;
            }
        }
        catch (Throwable e) {
            if (warn) {
                log.warn((Object)e.getMessage(), e);
            }
            log.debug((Object)e.getMessage(), e);
        }
        return Loader.loadClass2(clazz, null);
    }

    private static Class<?> loadClass2(String className, Class<?> callingClass) throws ClassNotFoundException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            block5: {
                try {
                    if (Loader.class.getClassLoader() != null) {
                        return Loader.class.getClassLoader().loadClass(className);
                    }
                }
                catch (ClassNotFoundException exc) {
                    if (callingClass == null || callingClass.getClassLoader() == null) break block5;
                    return callingClass.getClassLoader().loadClass(className);
                }
            }
            throw ex;
        }
    }
}

