/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.tcp;

import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;
import org.infinispan.client.hotrod.impl.operations.PingOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransport;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransportFactory;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

public class TransportObjectFactory
extends BaseKeyedPoolableObjectFactory<SocketAddress, TcpTransport> {
    private static final Log log = LogFactory.getLog(TransportObjectFactory.class);
    private final TcpTransportFactory tcpTransportFactory;
    private final AtomicInteger topologyId;
    private final boolean pingOnStartup;
    private volatile boolean firstPingExecuted = false;
    private final Codec codec;

    public TransportObjectFactory(Codec codec, TcpTransportFactory tcpTransportFactory, AtomicInteger topologyId, boolean pingOnStartup) {
        this.tcpTransportFactory = tcpTransportFactory;
        this.topologyId = topologyId;
        this.pingOnStartup = pingOnStartup;
        this.codec = codec;
    }

    public TcpTransport makeObject(SocketAddress address) throws Exception {
        TcpTransport tcpTransport = new TcpTransport(address, this.tcpTransportFactory);
        if (log.isTraceEnabled()) {
            log.tracef("Created tcp transport: %s", tcpTransport);
        }
        if (this.pingOnStartup && !this.firstPingExecuted) {
            log.trace("Executing first ping!");
            this.firstPingExecuted = true;
            this.ping(tcpTransport, this.topologyId);
        }
        return tcpTransport;
    }

    private PingOperation.PingResult ping(TcpTransport tcpTransport, AtomicInteger topologyId) {
        PingOperation po = new PingOperation(this.codec, topologyId, tcpTransport);
        return po.execute();
    }

    public boolean validateObject(SocketAddress address, TcpTransport transport) {
        if (log.isTraceEnabled()) {
            log.tracef("About to validate(ping) connection to server %s. TcpTransport is %s", address, transport);
        }
        return this.ping(transport, this.topologyId) == PingOperation.PingResult.SUCCESS;
    }

    public void destroyObject(SocketAddress address, TcpTransport transport) throws Exception {
        if (log.isTraceEnabled()) {
            log.tracef("About to destroy tcp transport: %s", transport);
        }
        transport.destroy();
    }

    public void activateObject(SocketAddress address, TcpTransport transport) throws Exception {
        super.activateObject((Object)address, (Object)transport);
        if (log.isTraceEnabled()) {
            log.tracef("Fetching from pool: %s", transport);
        }
    }

    public void passivateObject(SocketAddress address, TcpTransport transport) throws Exception {
        super.passivateObject((Object)address, (Object)transport);
        if (log.isTraceEnabled()) {
            log.tracef("Returning to pool: %s", transport);
        }
    }
}

