/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.bridge.CMPFieldBridge;
import org.jboss.as.cmp.ejbql.ASTAbs;
import org.jboss.as.cmp.ejbql.ASTAbstractSchema;
import org.jboss.as.cmp.ejbql.ASTAnd;
import org.jboss.as.cmp.ejbql.ASTApproximateNumericLiteral;
import org.jboss.as.cmp.ejbql.ASTArithmeticComparison;
import org.jboss.as.cmp.ejbql.ASTArithmeticParenthetical;
import org.jboss.as.cmp.ejbql.ASTAvg;
import org.jboss.as.cmp.ejbql.ASTBetween;
import org.jboss.as.cmp.ejbql.ASTBooleanComparison;
import org.jboss.as.cmp.ejbql.ASTBooleanLiteral;
import org.jboss.as.cmp.ejbql.ASTCollectionMemberDeclaration;
import org.jboss.as.cmp.ejbql.ASTConcat;
import org.jboss.as.cmp.ejbql.ASTConditionalParenthetical;
import org.jboss.as.cmp.ejbql.ASTCount;
import org.jboss.as.cmp.ejbql.ASTDatetimeComparison;
import org.jboss.as.cmp.ejbql.ASTEJBQL;
import org.jboss.as.cmp.ejbql.ASTEntityComparison;
import org.jboss.as.cmp.ejbql.ASTExactNumericLiteral;
import org.jboss.as.cmp.ejbql.ASTFrom;
import org.jboss.as.cmp.ejbql.ASTIdentifier;
import org.jboss.as.cmp.ejbql.ASTIn;
import org.jboss.as.cmp.ejbql.ASTIsEmpty;
import org.jboss.as.cmp.ejbql.ASTLCase;
import org.jboss.as.cmp.ejbql.ASTLength;
import org.jboss.as.cmp.ejbql.ASTLike;
import org.jboss.as.cmp.ejbql.ASTLimitOffset;
import org.jboss.as.cmp.ejbql.ASTLocate;
import org.jboss.as.cmp.ejbql.ASTMax;
import org.jboss.as.cmp.ejbql.ASTMemberOf;
import org.jboss.as.cmp.ejbql.ASTMin;
import org.jboss.as.cmp.ejbql.ASTMod;
import org.jboss.as.cmp.ejbql.ASTMultDiv;
import org.jboss.as.cmp.ejbql.ASTNegation;
import org.jboss.as.cmp.ejbql.ASTNot;
import org.jboss.as.cmp.ejbql.ASTNullComparison;
import org.jboss.as.cmp.ejbql.ASTOr;
import org.jboss.as.cmp.ejbql.ASTOrderBy;
import org.jboss.as.cmp.ejbql.ASTOrderByPath;
import org.jboss.as.cmp.ejbql.ASTParameter;
import org.jboss.as.cmp.ejbql.ASTPath;
import org.jboss.as.cmp.ejbql.ASTPlusMinus;
import org.jboss.as.cmp.ejbql.ASTRangeVariableDeclaration;
import org.jboss.as.cmp.ejbql.ASTSelect;
import org.jboss.as.cmp.ejbql.ASTSqrt;
import org.jboss.as.cmp.ejbql.ASTStringComparison;
import org.jboss.as.cmp.ejbql.ASTStringLiteral;
import org.jboss.as.cmp.ejbql.ASTStringParenthetical;
import org.jboss.as.cmp.ejbql.ASTSubstring;
import org.jboss.as.cmp.ejbql.ASTSum;
import org.jboss.as.cmp.ejbql.ASTUCase;
import org.jboss.as.cmp.ejbql.ASTValueClassComparison;
import org.jboss.as.cmp.ejbql.ASTWhere;
import org.jboss.as.cmp.ejbql.ASTWhereConditionalTerm;
import org.jboss.as.cmp.ejbql.Catalog;
import org.jboss.as.cmp.ejbql.EJBQLParser;
import org.jboss.as.cmp.ejbql.EJBQLTypes;
import org.jboss.as.cmp.ejbql.JBossQLParser;
import org.jboss.as.cmp.ejbql.JBossQLParserVisitor;
import org.jboss.as.cmp.ejbql.Node;
import org.jboss.as.cmp.ejbql.SelectFunction;
import org.jboss.as.cmp.ejbql.SimpleNode;
import org.jboss.as.cmp.jdbc.AliasManager;
import org.jboss.as.cmp.jdbc.JDBCEntityPersistenceStore;
import org.jboss.as.cmp.jdbc.JDBCType;
import org.jboss.as.cmp.jdbc.JDBCTypeFactory;
import org.jboss.as.cmp.jdbc.QLCompiler;
import org.jboss.as.cmp.jdbc.QueryParameter;
import org.jboss.as.cmp.jdbc.SQLUtil;
import org.jboss.as.cmp.jdbc.bridge.JDBCAbstractCMRFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCAbstractEntityBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCCMPFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCFieldBridge;
import org.jboss.as.cmp.jdbc.metadata.JDBCFunctionMappingMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCQueryMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCReadAheadMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCRelationMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCTypeMappingMetaData;
import org.jboss.logging.Logger;

public final class EJBQLToSQL92Compiler
implements QLCompiler,
JBossQLParserVisitor {
    private static final Logger log = Logger.getLogger(EJBQLToSQL92Compiler.class);
    private final Catalog catalog;
    private Class returnType;
    private Class[] parameterTypes;
    private JDBCReadAheadMetaData readAhead;
    private AliasManager aliasManager;
    private Map joinPaths = new HashMap();
    private Map identifierToTable = new HashMap();
    private Set joinedAliases = new HashSet();
    private JDBCTypeMappingMetaData typeMapping;
    private JDBCTypeFactory typeFactory;
    private boolean forceDistinct;
    private String sql;
    private int offsetParam;
    private int offsetValue;
    private int limitParam;
    private int limitValue;
    private JDBCEntityPersistenceStore selectManager;
    private Object selectObject;
    private List inputParameters = new ArrayList();
    private JDBCType functionJDBCType;
    private List leftJoinCMRList = new ArrayList();
    private StringBuffer onFindCMRJoin;
    private boolean countCompositePk;
    private boolean selectDistinct;

    public EJBQLToSQL92Compiler(Catalog catalog) {
        this.catalog = catalog;
    }

    @Override
    public void compileEJBQL(String ejbql, Class returnType, Class[] parameterTypes, JDBCQueryMetaData metadata) throws Exception {
        this.reset();
        this.returnType = returnType;
        this.parameterTypes = parameterTypes;
        this.readAhead = metadata.getReadAhead();
        EJBQLParser parser = new EJBQLParser(new StringReader(""));
        try {
            ASTEJBQL ejbqlNode = parser.parse(this.catalog, parameterTypes, ejbql);
            this.sql = ejbqlNode.jjtAccept(this, new StringBuffer()).toString();
        }
        catch (Exception e) {
            this.reset();
            throw e;
        }
        catch (Error e) {
            this.reset();
            throw e;
        }
    }

    @Override
    public void compileJBossQL(String ejbql, Class returnType, Class[] parameterTypes, JDBCQueryMetaData metadata) throws Exception {
        this.reset();
        this.returnType = returnType;
        this.parameterTypes = parameterTypes;
        this.readAhead = metadata.getReadAhead();
        JBossQLParser parser = new JBossQLParser(new StringReader(""));
        try {
            ASTEJBQL ejbqlNode = parser.parse(this.catalog, parameterTypes, ejbql);
            this.sql = ejbqlNode.jjtAccept(this, new StringBuffer()).toString();
            if (log.isTraceEnabled()) {
                log.trace((Object)("ejbql: " + ejbql));
                log.trace((Object)("sql: " + this.sql));
            }
        }
        catch (Exception e) {
            this.reset();
            throw e;
        }
        catch (Error e) {
            this.reset();
            throw e;
        }
    }

    @Override
    public String getSQL() {
        return this.sql;
    }

    @Override
    public int getOffsetValue() {
        return this.offsetValue;
    }

    @Override
    public int getOffsetParam() {
        return this.offsetParam;
    }

    @Override
    public int getLimitValue() {
        return this.limitValue;
    }

    @Override
    public int getLimitParam() {
        return this.limitParam;
    }

    @Override
    public boolean isSelectEntity() {
        return this.selectObject instanceof JDBCAbstractEntityBridge;
    }

    @Override
    public JDBCAbstractEntityBridge getSelectEntity() {
        return (JDBCAbstractEntityBridge)this.selectObject;
    }

    @Override
    public boolean isSelectField() {
        boolean result;
        if (this.selectObject instanceof JDBCFieldBridge) {
            JDBCFieldBridge field = (JDBCFieldBridge)this.selectObject;
            result = field.isCMPField();
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public JDBCFieldBridge getSelectField() {
        return (JDBCFieldBridge)this.selectObject;
    }

    @Override
    public SelectFunction getSelectFunction() {
        return (SelectFunction)this.selectObject;
    }

    @Override
    public JDBCEntityPersistenceStore getStoreManager() {
        return this.selectManager;
    }

    @Override
    public List getInputParameters() {
        return this.inputParameters;
    }

    @Override
    public List getLeftJoinCMRList() {
        return this.leftJoinCMRList;
    }

    @Override
    public boolean isSelectDistinct() {
        return this.selectDistinct;
    }

    @Override
    public Object visit(SimpleNode node, Object data) {
        throw CmpMessages.MESSAGES.unknownNodeType(node);
    }

    @Override
    public Object visit(ASTEJBQL node, Object data) {
        Node selectNode = node.jjtGetChild(0);
        Node fromNode = node.jjtGetChild(1);
        StringBuffer selectClause = new StringBuffer(50);
        selectNode.jjtAccept(this, selectClause);
        StringBuffer whereClause = null;
        StringBuffer orderByClause = null;
        for (int i = 2; i < node.jjtGetNumChildren(); ++i) {
            Node childNode = node.jjtGetChild(i);
            if (childNode instanceof ASTWhere) {
                whereClause = new StringBuffer(20);
                childNode.jjtAccept(this, whereClause);
                continue;
            }
            if (childNode instanceof ASTOrderBy) {
                orderByClause = new StringBuffer();
                childNode.jjtAccept(this, orderByClause);
                continue;
            }
            if (!(childNode instanceof ASTLimitOffset)) continue;
            childNode.jjtAccept(this, null);
        }
        StringBuffer fromClause = new StringBuffer(30);
        fromNode.jjtAccept(this, fromClause);
        Iterator iter = this.identifierToTable.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String identifier = (String)entry.getKey();
            String table = (String)entry.getValue();
            String alias = this.aliasManager.getAlias(identifier);
            fromClause.append(table).append(' ').append(alias);
            this.join(alias, fromClause);
            if (!iter.hasNext()) continue;
            fromClause.append(", ");
        }
        this.selectDistinct = ((ASTSelect)selectNode).distinct || this.returnType == Set.class || this.forceDistinct;
        StringBuffer sql = (StringBuffer)data;
        if (this.selectManager.getMetaData().hasRowLocking() && !(this.selectObject instanceof SelectFunction)) {
            JDBCFunctionMappingMetaData rowLockingTemplate = this.typeMapping.getRowLockingTemplate();
            if (rowLockingTemplate == null) {
                throw CmpMessages.MESSAGES.rowLockingTemplateNotDefinedFor(this.typeMapping.getName());
            }
            boolean distinct = this.selectDistinct;
            Object[] args = new Object[]{distinct ? "DISTINCT " + selectClause : selectClause.toString(), fromClause, whereClause == null || whereClause.length() == 0 ? null : whereClause, orderByClause == null || orderByClause.length() == 0 ? null : orderByClause};
            rowLockingTemplate.getFunctionSql(args, sql);
        } else {
            sql.append("SELECT ");
            if (this.selectDistinct) {
                sql.append("DISTINCT ");
            }
            sql.append(selectClause).append(" FROM ").append(fromClause);
            if (whereClause != null && whereClause.length() > 0) {
                sql.append(" WHERE ").append(whereClause);
            }
            if (orderByClause != null && orderByClause.length() > 0) {
                sql.append(" ORDER BY ").append(orderByClause);
            }
        }
        if (this.countCompositePk) {
            sql.insert(0, "SELECT COUNT(*) FROM (").append(") t_count");
        }
        return data;
    }

    @Override
    public Object visit(ASTOrderBy node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        node.jjtGetChild(0).jjtAccept(this, data);
        for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
            buf.append(", ");
            node.jjtGetChild(i).jjtAccept(this, data);
        }
        return data;
    }

    @Override
    public Object visit(ASTOrderByPath node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        node.jjtGetChild(0).jjtAccept(this, data);
        if (node.ascending) {
            buf.append(" ASC");
        } else {
            buf.append(" DESC");
        }
        return data;
    }

    @Override
    public Object visit(ASTLimitOffset node, Object data) {
        Class parameterType;
        SimpleNode param;
        int child = 0;
        if (node.hasOffset) {
            Node offsetNode;
            if ((offsetNode = node.jjtGetChild(child++)) instanceof ASTParameter) {
                param = (ASTParameter)offsetNode;
                parameterType = this.getParameterType(param.number);
                if (Integer.TYPE != parameterType && Integer.class != parameterType) {
                    throw CmpMessages.MESSAGES.offsetParameterMustBeInt();
                }
                this.offsetParam = param.number;
            } else {
                param = (ASTExactNumericLiteral)offsetNode;
                this.offsetValue = (int)((ASTExactNumericLiteral)param).value;
            }
        }
        if (node.hasLimit) {
            Node limitNode = node.jjtGetChild(child);
            if (limitNode instanceof ASTParameter) {
                param = (ASTParameter)limitNode;
                parameterType = this.getParameterType(param.number);
                if (Integer.TYPE != parameterType && Integer.class != parameterType) {
                    throw CmpMessages.MESSAGES.limitParameterMustBeInt();
                }
                this.limitParam = param.number;
            } else {
                param = (ASTExactNumericLiteral)limitNode;
                this.limitValue = (int)((ASTExactNumericLiteral)param).value;
            }
        }
        return data;
    }

    @Override
    public Object visit(ASTSelect select, Object data) {
        StringBuffer sql = (StringBuffer)data;
        Node child0 = select.jjtGetChild(0);
        if (child0 instanceof ASTPath) {
            ASTPath path = (ASTPath)child0;
            if (path.isCMPField()) {
                CMPFieldBridge selectField = path.getCMPField();
                this.selectManager = selectField.getManager();
                this.selectObject = selectField;
                this.setTypeFactory(this.selectManager.getJDBCTypeFactory());
                this.addInnerJoinPath(path);
                String alias = this.aliasManager.getAlias(path.getPath(path.size() - 2));
                SQLUtil.getColumnNamesClause(selectField, alias, sql);
            } else {
                JDBCAbstractEntityBridge selectEntity = (JDBCAbstractEntityBridge)path.getEntity();
                this.selectManager = selectEntity.getManager();
                this.selectObject = selectEntity;
                this.setTypeFactory(selectEntity.getManager().getJDBCTypeFactory());
                String alias = this.aliasManager.getAlias(path.getPath());
                if (select.distinct) {
                    SQLUtil.getSearchableColumnNamesClause(selectEntity.getTableFields(), alias, sql);
                } else {
                    SQLUtil.getColumnNamesClause(selectEntity.getTableFields(), alias, sql);
                }
                this.addLeftJoinPath(path);
            }
        } else {
            ASTPath path = this.getPathFromChildren(child0);
            if (path == null) {
                throw CmpMessages.MESSAGES.noPathExpressionInSelect();
            }
            if (path.isCMPField()) {
                CMPFieldBridge selectField = path.getCMPField();
                this.selectManager = selectField.getManager();
                this.setTypeFactory(this.selectManager.getJDBCTypeFactory());
                if (selectField.getJDBCType().hasMapper()) {
                    this.functionJDBCType = selectField.getJDBCType();
                }
            } else if (path.isCMRField()) {
                JDBCFieldBridge cmrField = (JDBCFieldBridge)((Object)path.getCMRField());
                this.selectManager = cmrField.getManager();
                this.setTypeFactory(this.selectManager.getJDBCTypeFactory());
                this.addLeftJoinPath(path);
            } else {
                JDBCAbstractEntityBridge entity = (JDBCAbstractEntityBridge)path.getEntity();
                this.selectManager = entity.getManager();
                this.setTypeFactory(this.selectManager.getJDBCTypeFactory());
                this.addLeftJoinPath(path);
            }
            this.selectObject = child0;
            child0.jjtAccept(this, data);
        }
        return data;
    }

    @Override
    public Object visit(ASTWhere node, Object data) {
        node.jjtGetChild(0).jjtAccept(this, data);
        return data;
    }

    @Override
    public Object visit(ASTOr node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        node.jjtGetChild(0).jjtAccept(this, data);
        for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
            buf.append(" OR ");
            node.jjtGetChild(i).jjtAccept(this, data);
        }
        return data;
    }

    @Override
    public Object visit(ASTWhereConditionalTerm node, Object data) {
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            node.jjtGetChild(i).jjtAccept(this, data);
        }
        return data;
    }

    @Override
    public Object visit(ASTAnd node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        node.jjtGetChild(0).jjtAccept(this, data);
        for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
            buf.append(" AND ");
            node.jjtGetChild(i).jjtAccept(this, data);
        }
        return data;
    }

    @Override
    public Object visit(ASTNot node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        buf.append(" NOT ");
        node.jjtGetChild(0).jjtAccept(this, data);
        return data;
    }

    @Override
    public Object visit(ASTConditionalParenthetical node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        buf.append('(');
        node.jjtGetChild(0).jjtAccept(this, data);
        buf.append(')');
        return data;
    }

    @Override
    public Object visit(ASTBetween node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        node.jjtGetChild(0).jjtAccept(this, data);
        if (node.not) {
            buf.append(" NOT ");
        }
        buf.append(" BETWEEN ");
        node.jjtGetChild(1).jjtAccept(this, data);
        buf.append(" AND ");
        node.jjtGetChild(2).jjtAccept(this, data);
        return data;
    }

    @Override
    public Object visit(ASTIn node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        node.jjtGetChild(0).jjtAccept(this, data);
        if (node.not) {
            buf.append(" NOT ");
        }
        buf.append(" IN ").append('(');
        node.jjtGetChild(1).jjtAccept(this, data);
        for (int i = 2; i < node.jjtGetNumChildren(); ++i) {
            buf.append(", ");
            node.jjtGetChild(i).jjtAccept(this, data);
        }
        buf.append(')');
        return data;
    }

    @Override
    public Object visit(ASTLike node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        node.jjtGetChild(0).jjtAccept(this, data);
        if (node.not) {
            buf.append(" NOT ");
        }
        buf.append(" LIKE ");
        node.jjtGetChild(1).jjtAccept(this, data);
        if (node.jjtGetNumChildren() == 3) {
            buf.append(" {ESCAPE ");
            node.jjtGetChild(2).jjtAccept(this, data);
            buf.append('}');
        }
        return data;
    }

    @Override
    public Object visit(ASTNullComparison node, Object data) {
        StringBuffer sql = (StringBuffer)data;
        Node child0 = node.jjtGetChild(0);
        if (child0 instanceof ASTPath) {
            ASTPath path = (ASTPath)child0;
            this.addLeftJoinPath(path);
            JDBCFieldBridge field = (JDBCFieldBridge)path.getField();
            if (field instanceof JDBCAbstractCMRFieldBridge) {
                JDBCFieldBridge[] keyFields;
                String alias;
                JDBCAbstractCMRFieldBridge cmrField = (JDBCAbstractCMRFieldBridge)field;
                if (cmrField.hasForeignKey()) {
                    alias = this.aliasManager.getAlias(path.getPath(path.size() - 2));
                    keyFields = cmrField.getForeignKeyFields();
                } else {
                    alias = this.aliasManager.getAlias(path.getPath());
                    keyFields = cmrField.getMetaData().getRelationMetaData().isTableMappingStyle() ? cmrField.getRelatedCMRField().getEntity().getPrimaryKeyFields() : cmrField.getRelatedCMRField().getForeignKeyFields();
                }
                SQLUtil.getIsNullClause(node.not, keyFields, alias, sql);
            } else {
                String alias = this.aliasManager.getAlias(path.getPath(path.size() - 2));
                SQLUtil.getIsNullClause(node.not, field, alias, sql);
            }
        } else if (child0 instanceof ASTParameter) {
            ASTParameter param = (ASTParameter)child0;
            Class type = this.getParameterType(param.number);
            QueryParameter queryParam = new QueryParameter(param.number - 1, this.typeFactory.getJDBCType(type));
            this.inputParameters.add(queryParam);
            sql.append("? IS ");
            if (node.not) {
                sql.append(" NOT ");
            }
            sql.append("NULL");
        } else {
            throw CmpMessages.MESSAGES.unexpectedNodeInNull(node);
        }
        return data;
    }

    @Override
    public Object visit(ASTIsEmpty node, Object data) {
        ASTPath path = (ASTPath)node.jjtGetChild(0);
        if (!path.isCMRField()) {
            throw CmpMessages.MESSAGES.isEmptyCanOnlyBeAppliedToCmr();
        }
        this.addLeftJoinPath(path);
        StringBuffer sql = (StringBuffer)data;
        JDBCAbstractCMRFieldBridge cmrField = (JDBCAbstractCMRFieldBridge)path.getCMRField();
        JDBCAbstractEntityBridge relatedEntity = (JDBCAbstractEntityBridge)cmrField.getRelatedEntity();
        String alias = this.aliasManager.getAlias(path.getPath());
        SQLUtil.getIsNullClause(node.not, relatedEntity.getPrimaryKeyFields(), alias, sql);
        return data;
    }

    @Override
    public Object visit(ASTMemberOf node, Object data) {
        Node member = node.jjtGetChild(0);
        ASTPath colPath = (ASTPath)node.jjtGetChild(1);
        JDBCAbstractEntityBridge colEntity = (JDBCAbstractEntityBridge)colPath.getEntity();
        StringBuffer sql = (StringBuffer)data;
        if (node.not) {
            sql.append(" NOT ");
        }
        sql.append("EXISTS ").append('(').append("SELECT ");
        if (member instanceof ASTParameter) {
            ASTParameter toParam = (ASTParameter)member;
            this.verifyParameterEntityType(toParam.number, colEntity);
            this.inputParameters.addAll(QueryParameter.createParameters(toParam.number - 1, colEntity));
            String parentAlias = this.aliasManager.getAlias(colPath.getPath(0));
            String localParentAlias = this.aliasManager.getAlias(colPath.getPath(0) + "_local");
            JDBCAbstractEntityBridge parentEntity = (JDBCAbstractEntityBridge)colPath.getEntity(0);
            SQLUtil.getColumnNamesClause(parentEntity.getPrimaryKeyFields(), localParentAlias, sql);
            sql.append(" FROM ").append(parentEntity.getQualifiedTableName()).append(' ').append(localParentAlias);
            this.innerJoinPath(colPath, sql);
            sql.append(" WHERE ");
            JDBCAbstractEntityBridge col0 = (JDBCAbstractEntityBridge)colPath.getEntity(0);
            SQLUtil.getSelfCompareWhereClause(col0.getPrimaryKeyFields(), parentAlias, localParentAlias, sql);
            sql.append(" AND ");
            String localColAlias = this.aliasManager.getAlias(colPath.getPath() + "_local");
            SQLUtil.getWhereClause(colEntity.getPrimaryKeyFields(), localColAlias, sql);
        } else {
            JDBCAbstractEntityBridge parentEntity;
            String parentAlias;
            ASTPath memberPath = (ASTPath)member;
            JDBCAbstractEntityBridge memberEntity = (JDBCAbstractEntityBridge)memberPath.getEntity();
            if (!memberEntity.equals(colEntity)) {
                throw CmpMessages.MESSAGES.memberMustBeOfCollectionType(memberEntity.getEntityName(), colEntity.getEntityName());
            }
            String memberAlias = this.aliasManager.getAlias(memberPath.getPath());
            if (memberPath.size() > 1) {
                parentAlias = this.aliasManager.getAlias(memberPath.getPath(0) + "_local");
                parentEntity = (JDBCAbstractEntityBridge)memberPath.getEntity(0);
                SQLUtil.getColumnNamesClause(parentEntity.getPrimaryKeyFields(), parentAlias, sql);
                sql.append(" FROM ").append(parentEntity.getQualifiedTableName()).append(' ').append(parentAlias);
                this.innerJoinPath(memberPath, sql);
                this.innerJoinPath(colPath, sql);
            } else if (colPath.size() > 1) {
                parentAlias = this.aliasManager.getAlias(colPath.getPath(0) + "_local");
                parentEntity = (JDBCAbstractEntityBridge)colPath.getEntity(0);
                SQLUtil.getColumnNamesClause(parentEntity.getPrimaryKeyFields(), parentAlias, sql);
                sql.append(" FROM ").append(parentEntity.getQualifiedTableName()).append(' ').append(parentAlias);
                this.innerJoinPath(colPath, sql);
            } else {
                throw CmpMessages.MESSAGES.shouldBeCollectionValuedPathExpression();
            }
            sql.append(" WHERE ");
            JDBCAbstractEntityBridge member0 = (JDBCAbstractEntityBridge)memberPath.getEntity(0);
            String colAliasLocal = this.aliasManager.getAlias(colPath.getPath() + "_local");
            if (memberPath.size() > 1) {
                String memberAliasLocal = this.aliasManager.getAlias(memberPath.getPath() + "_local");
                SQLUtil.getSelfCompareWhereClause(colEntity.getPrimaryKeyFields(), memberAliasLocal, colAliasLocal, sql);
                sql.append(" AND ");
                String member0Alias = this.aliasManager.getAlias(memberPath.getPath(0));
                String member0AliasLocal = this.aliasManager.getAlias(memberPath.getPath(0) + "_local");
                SQLUtil.getSelfCompareWhereClause(member0.getPrimaryKeyFields(), member0Alias, member0AliasLocal, sql);
            } else {
                SQLUtil.getSelfCompareWhereClause(member0.getPrimaryKeyFields(), memberAlias, colAliasLocal, sql);
                sql.append(" AND ");
                String col0Alias = this.aliasManager.getAlias(colPath.getPath(0));
                String col0AliasLocal = this.aliasManager.getAlias(colPath.getPath(0) + "_local");
                SQLUtil.getSelfCompareWhereClause(colEntity.getPrimaryKeyFields(), col0Alias, col0AliasLocal, sql);
            }
        }
        sql.append(')');
        return data;
    }

    private void innerJoinPath(ASTPath path, StringBuffer sql) {
        String parentAlias;
        if (path.size() < 2) {
            return;
        }
        String leftAlias = parentAlias = this.aliasManager.getAlias(path.getPath(0) + "_local");
        for (int i = 1; i < path.size(); ++i) {
            String curPath = path.getPath(i);
            String joinAlias = this.aliasManager.getAlias(curPath + "_local");
            JDBCAbstractCMRFieldBridge cmrField = (JDBCAbstractCMRFieldBridge)path.getCMRField(i);
            JDBCAbstractEntityBridge joinEntity = (JDBCAbstractEntityBridge)cmrField.getRelatedEntity();
            JDBCRelationMetaData relation = cmrField.getMetaData().getRelationMetaData();
            String join = " INNER JOIN ";
            if (relation.isTableMappingStyle()) {
                String relTableAlias = this.aliasManager.getRelationTableAlias(curPath + "_local");
                sql.append(join).append(cmrField.getQualifiedTableName()).append(' ').append(relTableAlias).append(" ON ");
                SQLUtil.getRelationTableJoinClause(cmrField, leftAlias, relTableAlias, sql);
                sql.append(join).append(joinEntity.getQualifiedTableName()).append(' ').append(joinAlias).append(" ON ");
                SQLUtil.getRelationTableJoinClause(cmrField.getRelatedCMRField(), joinAlias, relTableAlias, sql);
            } else {
                sql.append(join).append(joinEntity.getQualifiedTableName()).append(' ').append(joinAlias).append(" ON ");
                SQLUtil.getJoinClause(cmrField, leftAlias, joinAlias, sql);
            }
            leftAlias = joinAlias;
        }
    }

    @Override
    public Object visit(ASTStringComparison node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        node.jjtGetChild(0).jjtAccept(this, data);
        buf.append(' ').append(node.opp).append(' ');
        node.jjtGetChild(1).jjtAccept(this, data);
        return data;
    }

    @Override
    public Object visit(ASTBooleanComparison node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        node.jjtGetChild(0).jjtAccept(this, data);
        if (node.jjtGetNumChildren() == 2) {
            buf.append(' ').append(node.opp).append(' ');
            node.jjtGetChild(1).jjtAccept(this, data);
        }
        return data;
    }

    @Override
    public Object visit(ASTDatetimeComparison node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        node.jjtGetChild(0).jjtAccept(this, data);
        buf.append(' ').append(node.opp).append(' ');
        node.jjtGetChild(1).jjtAccept(this, data);
        return data;
    }

    @Override
    public Object visit(ASTValueClassComparison node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        boolean not = node.opp.equals("<>");
        String comparison = node.opp;
        buf.append('(');
        if (not) {
            buf.append(" NOT ").append('(');
            comparison = "=";
        }
        ASTPath fromPath = (ASTPath)node.jjtGetChild(0);
        this.addInnerJoinPath(fromPath);
        String fromAlias = this.aliasManager.getAlias(fromPath.getPath(fromPath.size() - 2));
        CMPFieldBridge fromCMPField = fromPath.getCMPField();
        Node toNode = node.jjtGetChild(1);
        if (toNode instanceof ASTParameter) {
            ASTParameter toParam = (ASTParameter)toNode;
            Class parameterType = this.getParameterType(toParam.number);
            if (!fromCMPField.getFieldType().equals(parameterType)) {
                throw CmpMessages.MESSAGES.onlyLikeTypesCanBeCompared(fromCMPField.getFieldType().getName(), parameterType.getName());
            }
            this.inputParameters.addAll(QueryParameter.createParameters(toParam.number - 1, fromCMPField));
            SQLUtil.getWhereClause(fromCMPField.getJDBCType(), fromAlias, comparison, buf);
        } else {
            ASTPath toPath = (ASTPath)toNode;
            this.addInnerJoinPath(toPath);
            String toAlias = this.aliasManager.getAlias(toPath.getPath(toPath.size() - 2));
            JDBCCMPFieldBridge toCMPField = (JDBCCMPFieldBridge)toPath.getCMPField();
            if (!fromCMPField.getFieldType().equals(toCMPField.getFieldType())) {
                throw CmpMessages.MESSAGES.onlyLikeTypesCanBeCompared(fromCMPField.getFieldType().getName(), toCMPField.getFieldType().getName());
            }
            SQLUtil.getSelfCompareWhereClause(fromCMPField, toCMPField, fromAlias, toAlias, comparison, buf);
        }
        return (not ? buf.append(')') : buf).append(')');
    }

    @Override
    public Object visit(ASTEntityComparison node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        Node arg0 = node.jjtGetChild(0);
        Node arg1 = node.jjtGetChild(1);
        if (node.opp.equals("<>")) {
            this.compareEntity(true, arg0, arg1, buf);
        } else {
            this.compareEntity(false, arg0, arg1, buf);
        }
        return data;
    }

    @Override
    public Object visit(ASTArithmeticComparison node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        node.jjtGetChild(0).jjtAccept(this, data);
        buf.append(' ').append(node.opp).append(' ');
        node.jjtGetChild(1).jjtAccept(this, data);
        return data;
    }

    @Override
    public Object visit(ASTPlusMinus node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        node.jjtGetChild(0).jjtAccept(this, data);
        for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
            buf.append(' ').append(node.opps.get(i - 1)).append(' ');
            node.jjtGetChild(i).jjtAccept(this, data);
        }
        return data;
    }

    @Override
    public Object visit(ASTMultDiv node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        node.jjtGetChild(0).jjtAccept(this, data);
        for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
            buf.append(' ').append(node.opps.get(i - 1)).append(' ');
            node.jjtGetChild(i).jjtAccept(this, data);
        }
        return data;
    }

    @Override
    public Object visit(ASTNegation node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        buf.append('-');
        node.jjtGetChild(0).jjtAccept(this, data);
        return data;
    }

    @Override
    public Object visit(ASTArithmeticParenthetical node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        buf.append('(');
        node.jjtGetChild(0).jjtAccept(this, data);
        buf.append(')');
        return data;
    }

    @Override
    public Object visit(ASTStringParenthetical node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        buf.append('(');
        node.jjtGetChild(0).jjtAccept(this, data);
        buf.append(')');
        return data;
    }

    @Override
    public Object visit(ASTConcat node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("concat");
        Object[] args = this.childrenToStringArr(2, node);
        function.getFunctionSql(args, buf);
        return data;
    }

    @Override
    public Object visit(ASTSubstring node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("substring");
        Object[] args = this.childrenToStringArr(3, node);
        function.getFunctionSql(args, buf);
        return data;
    }

    @Override
    public Object visit(ASTUCase node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("ucase");
        Object[] args = this.childrenToStringArr(1, node);
        function.getFunctionSql(args, buf);
        return data;
    }

    @Override
    public Object visit(ASTLCase node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("lcase");
        Object[] args = this.childrenToStringArr(1, node);
        function.getFunctionSql(args, buf);
        return data;
    }

    @Override
    public Object visit(ASTLength node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("length");
        Object[] args = this.childrenToStringArr(1, node);
        function.getFunctionSql(args, buf);
        return data;
    }

    @Override
    public Object visit(ASTLocate node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("locate");
        Object[] args = new Object[]{node.jjtGetChild(0).jjtAccept(this, new StringBuffer()).toString(), node.jjtGetChild(1).jjtAccept(this, new StringBuffer()).toString(), node.jjtGetNumChildren() == 3 ? node.jjtGetChild(2).jjtAccept(this, new StringBuffer()).toString() : "1"};
        function.getFunctionSql(args, buf);
        return data;
    }

    @Override
    public Object visit(ASTAbs node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("abs");
        Object[] args = this.childrenToStringArr(1, node);
        function.getFunctionSql(args, buf);
        return data;
    }

    @Override
    public Object visit(ASTSqrt node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("sqrt");
        Object[] args = this.childrenToStringArr(1, node);
        function.getFunctionSql(args, buf);
        return data;
    }

    @Override
    public Object visit(ASTMod node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("mod");
        Object[] args = this.childrenToStringArr(2, node);
        function.getFunctionSql(args, buf);
        return data;
    }

    @Override
    public Object visit(ASTAvg node, Object data) {
        if (this.functionJDBCType != null) {
            node.setResultType(this.functionJDBCType.getJavaTypes()[0]);
            node.setJDBCType(this.functionJDBCType);
        } else {
            node.setResultType(this.returnType);
        }
        StringBuffer buf = (StringBuffer)data;
        Object[] args = new Object[]{node.distinct, node.jjtGetChild(0).jjtAccept(this, new StringBuffer()).toString()};
        JDBCTypeMappingMetaData.AVG_FUNC.getFunctionSql(args, buf);
        return data;
    }

    @Override
    public Object visit(ASTMax node, Object data) {
        if (this.functionJDBCType != null) {
            node.setResultType(this.functionJDBCType.getJavaTypes()[0]);
            node.setJDBCType(this.functionJDBCType);
        } else {
            node.setResultType(this.returnType);
        }
        StringBuffer buf = (StringBuffer)data;
        Object[] args = new Object[]{node.distinct, node.jjtGetChild(0).jjtAccept(this, new StringBuffer()).toString()};
        JDBCTypeMappingMetaData.MAX_FUNC.getFunctionSql(args, buf);
        return data;
    }

    @Override
    public Object visit(ASTMin node, Object data) {
        if (this.functionJDBCType != null) {
            node.setResultType(this.functionJDBCType.getJavaTypes()[0]);
            node.setJDBCType(this.functionJDBCType);
        } else {
            node.setResultType(this.returnType);
        }
        StringBuffer buf = (StringBuffer)data;
        Object[] args = new Object[]{node.distinct, node.jjtGetChild(0).jjtAccept(this, new StringBuffer()).toString()};
        JDBCTypeMappingMetaData.MIN_FUNC.getFunctionSql(args, buf);
        return data;
    }

    @Override
    public Object visit(ASTSum node, Object data) {
        if (this.functionJDBCType != null) {
            node.setResultType(this.functionJDBCType.getJavaTypes()[0]);
            node.setJDBCType(this.functionJDBCType);
        } else {
            node.setResultType(this.returnType);
        }
        StringBuffer buf = (StringBuffer)data;
        Object[] args = new Object[]{node.distinct, node.jjtGetChild(0).jjtAccept(this, new StringBuffer()).toString()};
        JDBCTypeMappingMetaData.SUM_FUNC.getFunctionSql(args, buf);
        return data;
    }

    @Override
    public Object visit(ASTCount node, Object data) {
        Object[] args;
        StringBuffer buf = (StringBuffer)data;
        node.setResultType(this.returnType);
        ASTPath cntPath = (ASTPath)node.jjtGetChild(0);
        if (cntPath.isCMPField()) {
            args = new Object[]{node.distinct, node.jjtGetChild(0).jjtAccept(this, new StringBuffer()).toString()};
        } else {
            JDBCAbstractEntityBridge entity = (JDBCAbstractEntityBridge)cntPath.getEntity();
            JDBCFieldBridge[] pkFields = entity.getPrimaryKeyFields();
            if (pkFields.length > 1) {
                this.countCompositePk = true;
                this.forceDistinct = node.distinct.length() > 0;
                this.addLeftJoinPath(cntPath);
                String alias = this.aliasManager.getAlias(cntPath.getPath());
                SQLUtil.getColumnNamesClause(entity.getPrimaryKeyFields(), alias, buf);
                return buf;
            }
            String alias = this.aliasManager.getAlias(cntPath.getPath());
            StringBuffer keyColumn = new StringBuffer(20);
            SQLUtil.getColumnNamesClause(pkFields[0], alias, keyColumn);
            args = new Object[]{node.distinct, keyColumn.toString()};
        }
        JDBCTypeMappingMetaData.COUNT_FUNC.getFunctionSql(args, buf);
        return data;
    }

    @Override
    public Object visit(ASTPath node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        if (!node.isCMPField()) {
            throw CmpMessages.MESSAGES.canOnlyVisitCmpNodes();
        }
        CMPFieldBridge cmpField = node.getCMPField();
        switch (node.type) {
            case 5: 
            case 6: {
                if (cmpField.getJDBCType().hasMapper() || cmpField.getJDBCType().getParameterSetter() != null) break;
            }
            case -1: {
                throw CmpMessages.MESSAGES.canNotVisitMultiColumnPath();
            }
        }
        this.addLeftJoinPath(node);
        String alias = this.aliasManager.getAlias(node.getPath(node.size() - 2));
        SQLUtil.getColumnNamesClause(cmpField, alias, buf);
        return data;
    }

    @Override
    public Object visit(ASTAbstractSchema node, Object data) {
        throw CmpMessages.MESSAGES.canNotVisitAbstractNode();
    }

    @Override
    public Object visit(ASTIdentifier node, Object data) {
        throw CmpMessages.MESSAGES.mustNotVisitIdentifierNode();
    }

    @Override
    public Object visit(ASTParameter node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        Class type = this.getParameterType(node.number);
        int ejbqlType = EJBQLTypes.getEJBQLType(type);
        if (ejbqlType == 5 || ejbqlType == 6 || ejbqlType == -1) {
            throw CmpMessages.MESSAGES.canNotVisitMultiColumnParameter();
        }
        QueryParameter param = new QueryParameter(node.number - 1, this.typeFactory.getJDBCType(type));
        this.inputParameters.add(param);
        buf.append('?');
        return data;
    }

    @Override
    public Object visit(ASTExactNumericLiteral node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        buf.append(node.literal);
        return data;
    }

    @Override
    public Object visit(ASTApproximateNumericLiteral node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        buf.append(node.literal);
        return data;
    }

    @Override
    public Object visit(ASTStringLiteral node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        buf.append(node.value);
        return data;
    }

    @Override
    public Object visit(ASTBooleanLiteral node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        if (node.value) {
            buf.append(this.typeMapping.getTrueMapping());
        } else {
            buf.append(this.typeMapping.getFalseMapping());
        }
        return data;
    }

    @Override
    public Object visit(ASTFrom from, Object data) {
        StringBuffer sql = (StringBuffer)data;
        from.jjtGetChild(0).jjtAccept(this, data);
        for (int i = 1; i < from.jjtGetNumChildren(); ++i) {
            from.jjtGetChild(i).jjtAccept(this, data);
        }
        return data;
    }

    @Override
    public Object visit(ASTCollectionMemberDeclaration node, Object data) {
        ASTPath path = (ASTPath)node.jjtGetChild(0);
        ASTIdentifier id = (ASTIdentifier)node.jjtGetChild(1);
        String alias = this.aliasManager.getAlias(id.identifier);
        this.aliasManager.addAlias(path.getPath(), alias);
        this.addInnerJoinPath(path);
        return data;
    }

    @Override
    public Object visit(ASTRangeVariableDeclaration node, Object data) {
        ASTAbstractSchema schema = (ASTAbstractSchema)node.jjtGetChild(0);
        JDBCAbstractEntityBridge entity = (JDBCAbstractEntityBridge)schema.entity;
        ASTIdentifier id = (ASTIdentifier)node.jjtGetChild(1);
        this.declareTable(id.identifier, entity.getQualifiedTableName());
        return data;
    }

    private void compareEntity(boolean not, Node fromNode, Node toNode, StringBuffer buf) {
        buf.append('(');
        if (not) {
            buf.append(" NOT ").append('(');
        }
        ASTPath fromPath = (ASTPath)fromNode;
        this.addLeftJoinPath(fromPath);
        String fromAlias = this.aliasManager.getAlias(fromPath.getPath());
        JDBCAbstractEntityBridge fromEntity = (JDBCAbstractEntityBridge)fromPath.getEntity();
        if (toNode instanceof ASTParameter) {
            ASTParameter toParam = (ASTParameter)toNode;
            this.verifyParameterEntityType(toParam.number, fromEntity);
            this.inputParameters.addAll(QueryParameter.createParameters(toParam.number - 1, fromEntity));
            SQLUtil.getWhereClause(fromEntity.getPrimaryKeyFields(), fromAlias, buf);
        } else {
            ASTPath toPath = (ASTPath)toNode;
            this.addLeftJoinPath(toPath);
            String toAlias = this.aliasManager.getAlias(toPath.getPath());
            JDBCAbstractEntityBridge toEntity = (JDBCAbstractEntityBridge)toPath.getEntity();
            if (!fromEntity.equals(toEntity)) {
                throw CmpMessages.MESSAGES.onlyLikeTypesCanBeCompared(fromEntity.getEntityName(), toEntity.getEntityName());
            }
            SQLUtil.getSelfCompareWhereClause(fromEntity.getPrimaryKeyFields(), fromAlias, toAlias, buf);
        }
        if (not) {
            buf.append(')');
        }
        buf.append(')');
    }

    private void join(String alias, StringBuffer sql) {
        Map paths = (Map)this.joinPaths.get(alias);
        if (paths == null || paths.isEmpty()) {
            return;
        }
        Iterator iter = paths.values().iterator();
        while (iter.hasNext()) {
            String leftAlias = alias;
            ASTPath path = (ASTPath)iter.next();
            for (int i = 1; i < path.size(); ++i) {
                if (!path.isCMRField(i)) continue;
                String curPath = path.getPath(i);
                String joinAlias = this.aliasManager.getAlias(curPath);
                if (this.joinedAliases.add(joinAlias)) {
                    String join;
                    JDBCAbstractCMRFieldBridge cmrField = (JDBCAbstractCMRFieldBridge)path.getCMRField(i);
                    JDBCAbstractEntityBridge joinEntity = (JDBCAbstractEntityBridge)cmrField.getRelatedEntity();
                    JDBCRelationMetaData relation = cmrField.getMetaData().getRelationMetaData();
                    String string = join = path.innerJoin ? " INNER JOIN " : " LEFT OUTER JOIN ";
                    if (relation.isTableMappingStyle()) {
                        String relTableAlias = this.aliasManager.getRelationTableAlias(curPath);
                        sql.append(join).append(cmrField.getQualifiedTableName()).append(' ').append(relTableAlias).append(" ON ");
                        SQLUtil.getRelationTableJoinClause(cmrField, leftAlias, relTableAlias, sql);
                        sql.append(join).append(joinEntity.getQualifiedTableName()).append(' ').append(joinAlias).append(" ON ");
                        SQLUtil.getRelationTableJoinClause(cmrField.getRelatedCMRField(), joinAlias, relTableAlias, sql);
                    } else {
                        sql.append(join).append(joinEntity.getQualifiedTableName()).append(' ').append(joinAlias).append(" ON ");
                        SQLUtil.getJoinClause(cmrField, leftAlias, joinAlias, sql);
                    }
                    this.join(joinAlias, sql);
                }
                leftAlias = joinAlias;
            }
        }
    }

    private void declareTable(String alias, String table) {
        this.identifierToTable.put(alias, table);
    }

    private void addLeftJoinPath(ASTPath path) {
        if (path.size() > 1 && path.isCMRField(1)) {
            ASTPath oldPath;
            String identifier = path.getPath(0);
            String alias = this.aliasManager.getAlias(identifier);
            HashMap<ASTPath, ASTPath> paths = (HashMap<ASTPath, ASTPath>)this.joinPaths.get(alias);
            if (paths == null) {
                paths = new HashMap<ASTPath, ASTPath>();
                this.joinPaths.put(alias, paths);
            }
            if ((oldPath = paths.put(path, path)) != null && oldPath.innerJoin) {
                path.innerJoin = true;
            }
        }
    }

    private void addInnerJoinPath(ASTPath path) {
        if (path.size() > 1 && path.isCMRField(1)) {
            String identifier = path.getPath(0);
            String alias = this.aliasManager.getAlias(identifier);
            HashMap<ASTPath, ASTPath> paths = (HashMap<ASTPath, ASTPath>)this.joinPaths.get(alias);
            if (paths == null) {
                paths = new HashMap<ASTPath, ASTPath>();
                this.joinPaths.put(alias, paths);
            }
            path.innerJoin = true;
            paths.put(path, path);
        }
    }

    private Object[] childrenToStringArr(int numChildren, Node node) {
        Object[] args = new Object[numChildren];
        for (int i = 0; i < numChildren; ++i) {
            args[i] = node.jjtGetChild(i).jjtAccept(this, new StringBuffer()).toString();
        }
        return args;
    }

    private ASTPath getPathFromChildren(Node selectFunction) {
        for (int childInd = 0; childInd < selectFunction.jjtGetNumChildren(); ++childInd) {
            ASTPath path;
            Node child = selectFunction.jjtGetChild(childInd);
            if (child instanceof ASTPath) {
                return (ASTPath)child;
            }
            if (!(child instanceof SelectFunction) || (path = this.getPathFromChildren(child)) == null) continue;
            return path;
        }
        return null;
    }

    private void setTypeFactory(JDBCTypeFactory typeFactory) {
        this.typeFactory = typeFactory;
        this.typeMapping = typeFactory.getTypeMapping();
        this.aliasManager = new AliasManager(this.typeMapping.getAliasHeaderPrefix(), this.typeMapping.getAliasHeaderSuffix(), this.typeMapping.getAliasMaxLength());
    }

    private Class getParameterType(int index) {
        int zeroBasedIndex = index - 1;
        Class[] params = this.parameterTypes;
        if (zeroBasedIndex < params.length) {
            return params[zeroBasedIndex];
        }
        return null;
    }

    private void verifyParameterEntityType(int number, JDBCAbstractEntityBridge entity) {
        Class parameterType = this.getParameterType(number);
        Class<?> remoteClass = entity.getRemoteInterface();
        Class<?> localClass = entity.getLocalInterface();
        if (!(localClass != null && localClass.isAssignableFrom(parameterType) || remoteClass != null && remoteClass.isAssignableFrom(parameterType))) {
            throw CmpMessages.MESSAGES.onlyLikeTypesCanBeCompared(entity.getEntityName(), parameterType.getName());
        }
    }

    private void reset() {
        this.returnType = null;
        this.parameterTypes = null;
        this.readAhead = null;
        this.inputParameters.clear();
        this.selectObject = null;
        this.selectManager = null;
        this.typeFactory = null;
        this.typeMapping = null;
        this.aliasManager = null;
        this.forceDistinct = false;
        this.limitParam = 0;
        this.limitValue = 0;
        this.offsetParam = 0;
        this.offsetValue = 0;
        this.leftJoinCMRList.clear();
        this.onFindCMRJoin = null;
        this.countCompositePk = false;
        this.joinPaths.clear();
        this.identifierToTable.clear();
        this.joinedAliases.clear();
        this.selectDistinct = false;
        this.functionJDBCType = null;
    }
}

