/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc.bridge;

import java.lang.reflect.Field;
import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.context.CmpEntityBeanContext;
import org.jboss.as.cmp.jdbc.JDBCContext;
import org.jboss.as.cmp.jdbc.JDBCStoreManager;
import org.jboss.as.cmp.jdbc.bridge.JDBCAbstractCMPFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCEntityBridge;
import org.jboss.as.cmp.jdbc.metadata.JDBCCMPFieldMetaData;

public class JDBCCMP1xFieldBridge
extends JDBCAbstractCMPFieldBridge {
    private Field field;

    public JDBCCMP1xFieldBridge(JDBCStoreManager manager, JDBCCMPFieldMetaData metadata) {
        super(manager, metadata);
        try {
            this.field = manager.getMetaData().getEntityClass().getField(this.getFieldName());
        }
        catch (NoSuchFieldException e) {
            throw CmpMessages.MESSAGES.fieldNotFound(this.getFieldName(), manager.getMetaData().getName());
        }
    }

    @Override
    public Object getInstanceValue(CmpEntityBeanContext ctx) {
        FieldState fieldState = this.getFieldState(ctx);
        if (!fieldState.isLoaded()) {
            throw CmpMessages.MESSAGES.cmpFieldNotLoaded(this.fieldName);
        }
        try {
            return this.field.get(ctx.getInstance());
        }
        catch (Exception e) {
            throw CmpMessages.MESSAGES.errorGettingInstanceField(this.getFieldName(), e);
        }
    }

    @Override
    public void setInstanceValue(CmpEntityBeanContext ctx, Object value) {
        try {
            this.field.set(ctx.getInstance(), value);
            FieldState fieldState = this.getFieldState(ctx);
            fieldState.setLoaded();
            fieldState.setCheckDirty();
        }
        catch (Exception e) {
            throw CmpMessages.MESSAGES.errorSettingInstanceField(this.getFieldName(), e);
        }
    }

    @Override
    public Object getLockedValue(CmpEntityBeanContext ctx) {
        throw CmpMessages.MESSAGES.optimisticLockingNotSupported();
    }

    @Override
    public void lockInstanceValue(CmpEntityBeanContext ctx) {
    }

    @Override
    public boolean isLoaded(CmpEntityBeanContext ctx) {
        return this.getFieldState(ctx).isLoaded();
    }

    @Override
    public boolean isDirty(CmpEntityBeanContext ctx) {
        if (this.isReadOnly() || this.isPrimaryKeyMember()) {
            return false;
        }
        return this.isLoaded(ctx) && !this.stateFactory.isStateValid(this.getInstanceValue(ctx), this.getFieldState(ctx).originalValue);
    }

    @Override
    public void setClean(CmpEntityBeanContext ctx) {
        FieldState fieldState = this.getFieldState(ctx);
        fieldState.originalValue = this.getInstanceValue(ctx);
        if (this.isReadOnly()) {
            fieldState.lastRead = System.currentTimeMillis();
        }
    }

    @Override
    public boolean isReadTimedOut(CmpEntityBeanContext ctx) {
        if (!this.isReadOnly()) {
            return true;
        }
        if (this.getReadTimeOut() == -1L) {
            return false;
        }
        long readInterval = System.currentTimeMillis() - this.getFieldState(ctx).lastRead;
        return readInterval >= this.getReadTimeOut();
    }

    @Override
    public void resetPersistenceContext(CmpEntityBeanContext ctx) {
        JDBCContext jdbcCtx;
        FieldState fieldState;
        if (this.isReadTimedOut(ctx) && (fieldState = (FieldState)(jdbcCtx = (JDBCContext)ctx.getPersistenceContext()).getFieldState(this.jdbcContextIndex)) != null) {
            fieldState.reset();
        }
    }

    @Override
    protected void setDirtyAfterGet(CmpEntityBeanContext ctx) {
        this.getFieldState(ctx).setCheckDirty();
    }

    private FieldState getFieldState(CmpEntityBeanContext ctx) {
        JDBCContext jdbcCtx = (JDBCContext)ctx.getPersistenceContext();
        FieldState fieldState = (FieldState)jdbcCtx.getFieldState(this.jdbcContextIndex);
        if (fieldState == null) {
            fieldState = new FieldState(jdbcCtx);
            jdbcCtx.setFieldState(this.jdbcContextIndex, fieldState);
        }
        return fieldState;
    }

    private class FieldState {
        private Object originalValue;
        private long lastRead = -1L;
        private JDBCEntityBridge.EntityState entityState;

        public FieldState(JDBCContext jdbcContext) {
            this.entityState = jdbcContext.getEntityState();
        }

        public boolean isLoaded() {
            return this.entityState.isLoaded(JDBCCMP1xFieldBridge.this.tableIndex);
        }

        public void setLoaded() {
            this.entityState.setLoaded(JDBCCMP1xFieldBridge.this.tableIndex);
        }

        public void setCheckDirty() {
            this.entityState.setCheckDirty(JDBCCMP1xFieldBridge.this.tableIndex);
        }

        public void reset() {
            this.originalValue = null;
            this.lastRead = -1L;
            this.entityState.resetFlags(JDBCCMP1xFieldBridge.this.tableIndex);
            JDBCCMP1xFieldBridge.this.log.debug((Object)"reset field state");
        }
    }
}

