/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc.metadata;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.cmp.CmpLogger;
import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.jdbc.metadata.JDBCCMPFieldPropertyMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCEntityMetaData;
import org.jboss.as.cmp.jdbc.metadata.parser.ParsedCmpField;

public final class JDBCCMPFieldMetaData {
    public static final byte CHECK_DIRTY_AFTER_GET_TRUE = 1;
    public static final byte CHECK_DIRTY_AFTER_GET_FALSE = 2;
    public static final byte CHECK_DIRTY_AFTER_GET_NOT_PRESENT = 4;
    private final JDBCEntityMetaData entity;
    private final String fieldName;
    private final Class<?> fieldType;
    private final String columnName;
    private final int jdbcType;
    private final String sqlType;
    private final boolean readOnly;
    private final int readTimeOut;
    private final boolean primaryKeyMember;
    private final boolean notNull;
    private final boolean genIndex;
    private final Field primaryKeyField;
    private final List<JDBCCMPFieldPropertyMetaData> propertyOverrides = new ArrayList<JDBCCMPFieldPropertyMetaData>();
    private final boolean unknownPkField;
    private final boolean autoIncrement;
    private final boolean relationTableField;
    private final byte checkDirtyAfterGet;
    private final String stateFactory;

    public JDBCCMPFieldMetaData(JDBCEntityMetaData entity) {
        this.entity = entity;
        this.fieldName = entity.getName() + "_upk";
        this.fieldType = entity.getPrimaryKeyClass();
        this.columnName = entity.getName() + "_upk";
        this.jdbcType = Integer.MIN_VALUE;
        this.sqlType = null;
        this.readOnly = entity.isReadOnly();
        this.readTimeOut = entity.getReadTimeOut();
        this.primaryKeyMember = true;
        this.notNull = true;
        this.genIndex = false;
        this.unknownPkField = true;
        this.autoIncrement = false;
        this.relationTableField = false;
        this.checkDirtyAfterGet = (byte)4;
        this.stateFactory = null;
        this.primaryKeyField = null;
    }

    public JDBCCMPFieldMetaData(JDBCEntityMetaData entity, String fieldName) {
        this.entity = entity;
        this.fieldName = fieldName;
        this.fieldType = this.loadFieldType(entity, fieldName);
        this.columnName = fieldName;
        this.jdbcType = Integer.MIN_VALUE;
        this.sqlType = null;
        this.readOnly = entity.isReadOnly();
        this.readTimeOut = entity.getReadTimeOut();
        this.genIndex = false;
        this.unknownPkField = false;
        this.autoIncrement = false;
        this.relationTableField = false;
        this.checkDirtyAfterGet = (byte)4;
        this.stateFactory = null;
        String pkFieldName = entity.getPrimaryKeyFieldName();
        if (pkFieldName != null) {
            this.primaryKeyField = null;
            if (pkFieldName.equals(fieldName)) {
                if (!entity.getPrimaryKeyClass().equals(this.fieldType)) {
                    throw CmpMessages.MESSAGES.pkFieldWrongType();
                }
                this.primaryKeyMember = true;
            } else {
                this.primaryKeyMember = false;
            }
        } else {
            Field[] fields = entity.getPrimaryKeyClass().getFields();
            boolean pkMember = false;
            Field pkField = null;
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!field.getName().equals(fieldName)) continue;
                if (!field.getType().equals(this.fieldType)) {
                    throw CmpMessages.MESSAGES.pkFieldWrongType(fieldName);
                }
                if (pkField != null) {
                    if (field.getDeclaringClass().equals(entity.getPrimaryKeyClass())) {
                        pkField = field;
                    }
                    CmpLogger.ROOT_LOGGER.pkFoundMoreThanOnceInHierarchy(fieldName, entity.getPrimaryKeyClass().getName(), pkField.getDeclaringClass().getName());
                } else {
                    pkField = field;
                }
                pkMember = true;
            }
            this.primaryKeyMember = pkMember;
            this.primaryKeyField = pkField;
        }
        this.notNull = this.fieldType.isPrimitive() || this.primaryKeyMember;
    }

    public JDBCCMPFieldMetaData(JDBCEntityMetaData entity, JDBCCMPFieldMetaData defaultValues) {
        this.entity = entity;
        if (defaultValues != null) {
            this.fieldName = defaultValues.fieldName;
            this.fieldType = defaultValues.fieldType == null && this.fieldName != null ? this.loadFieldType(entity, this.fieldName) : defaultValues.fieldType;
            this.columnName = defaultValues.getColumnName();
            this.jdbcType = defaultValues.getJDBCType();
            this.sqlType = defaultValues.getSQLType();
            this.primaryKeyMember = defaultValues.isPrimaryKeyMember();
            this.notNull = defaultValues.isNotNull();
            this.unknownPkField = defaultValues.isUnknownPkField();
            this.autoIncrement = defaultValues.isAutoIncrement();
            this.genIndex = false;
            this.relationTableField = defaultValues.isRelationTableField();
            this.checkDirtyAfterGet = defaultValues.getCheckDirtyAfterGet();
            this.stateFactory = defaultValues.getStateFactory();
            this.readOnly = defaultValues.isReadOnly();
            this.readTimeOut = defaultValues.getReadTimeOut();
            this.primaryKeyField = defaultValues.getPrimaryKeyField();
        } else {
            this.fieldName = entity.getName() + "_upk";
            this.fieldType = entity.getPrimaryKeyClass();
            this.columnName = entity.getName() + "_upk";
            this.jdbcType = Integer.MIN_VALUE;
            this.sqlType = null;
            this.primaryKeyMember = true;
            this.notNull = true;
            this.genIndex = false;
            this.unknownPkField = true;
            this.autoIncrement = false;
            this.relationTableField = false;
            this.checkDirtyAfterGet = (byte)4;
            this.stateFactory = null;
            this.readOnly = entity.isReadOnly();
            this.readTimeOut = entity.getReadTimeOut();
            this.primaryKeyField = null;
        }
    }

    public JDBCCMPFieldMetaData(JDBCEntityMetaData entity, ParsedCmpField parsedField, JDBCCMPFieldMetaData defaultValues, boolean primaryKeyMember, boolean notNull, boolean readOnly, int readTimeOut, boolean relationTableField) {
        this.entity = entity;
        this.fieldName = defaultValues.getFieldName();
        this.fieldType = defaultValues.getFieldType();
        this.columnName = parsedField.getColumnName() != null ? parsedField.getColumnName() : defaultValues.getColumnName();
        if (parsedField.getJdbcType() != null) {
            this.jdbcType = parsedField.getJdbcType();
            this.sqlType = parsedField.getSqlType();
        } else {
            this.jdbcType = defaultValues.getJDBCType();
            this.sqlType = defaultValues.getSQLType();
        }
        this.readOnly = readOnly;
        this.readTimeOut = readTimeOut;
        this.primaryKeyMember = primaryKeyMember;
        this.notNull = notNull;
        this.primaryKeyField = defaultValues.getPrimaryKeyField();
        for (JDBCCMPFieldPropertyMetaData propertyMetaData : parsedField.getPropertyOverrides()) {
            this.propertyOverrides.add(propertyMetaData);
        }
        this.unknownPkField = defaultValues.isUnknownPkField();
        this.autoIncrement = parsedField.getAutoIncrement() != null;
        this.genIndex = parsedField.getGenIndex() != null;
        this.relationTableField = relationTableField;
        this.checkDirtyAfterGet = parsedField.getCheckDirtyAfterGet() == null ? defaultValues.getCheckDirtyAfterGet() : (byte)(parsedField.getCheckDirtyAfterGet() != false ? 1 : 2);
        this.stateFactory = parsedField.getStateFactory() == null ? defaultValues.getStateFactory() : parsedField.getStateFactory();
    }

    public JDBCCMPFieldMetaData(JDBCEntityMetaData entity, JDBCCMPFieldMetaData defaultValues, String columnName, boolean primaryKeyMember, boolean notNull, boolean readOnly, int readTimeOut, boolean relationTableField) {
        this.entity = entity;
        this.fieldName = defaultValues.getFieldName();
        this.fieldType = defaultValues.fieldType == null && this.fieldName != null ? this.loadFieldType(entity, this.fieldName) : defaultValues.fieldType;
        this.columnName = columnName;
        this.jdbcType = defaultValues.getJDBCType();
        this.sqlType = defaultValues.getSQLType();
        this.readOnly = readOnly;
        this.readTimeOut = readTimeOut;
        this.primaryKeyMember = primaryKeyMember;
        this.notNull = notNull;
        for (JDBCCMPFieldPropertyMetaData propertyMetaData : defaultValues.getPropertyOverrides()) {
            this.propertyOverrides.add(propertyMetaData);
        }
        this.unknownPkField = defaultValues.isUnknownPkField();
        this.autoIncrement = false;
        this.genIndex = false;
        this.relationTableField = relationTableField;
        this.checkDirtyAfterGet = defaultValues.getCheckDirtyAfterGet();
        this.stateFactory = defaultValues.getStateFactory();
        this.primaryKeyField = defaultValues.getPrimaryKeyField();
    }

    public JDBCCMPFieldMetaData(JDBCEntityMetaData entity, String fieldName, Class<?> fieldType, String columnName, int jdbcType, String sqlType) {
        this.entity = entity;
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.columnName = columnName;
        this.jdbcType = jdbcType;
        this.sqlType = sqlType;
        this.readOnly = false;
        this.readTimeOut = -1;
        this.primaryKeyMember = false;
        this.notNull = true;
        this.primaryKeyField = null;
        this.unknownPkField = false;
        this.autoIncrement = false;
        this.genIndex = false;
        this.relationTableField = false;
        this.checkDirtyAfterGet = (byte)4;
        this.stateFactory = null;
    }

    public JDBCCMPFieldMetaData(JDBCEntityMetaData entity, ParsedCmpField parsedField, JDBCCMPFieldMetaData defaultValues) {
        this.entity = entity;
        this.unknownPkField = defaultValues.isUnknownPkField();
        this.fieldName = this.unknownPkField && parsedField.getFieldName() != null ? parsedField.getFieldName() : defaultValues.getFieldName();
        this.fieldType = parsedField.getUnknownPk() == null ? defaultValues.getFieldType() : parsedField.getUnknownPk();
        this.columnName = parsedField.getColumnName() != null ? parsedField.getColumnName() : defaultValues.getColumnName();
        if (parsedField.getJdbcType() != null) {
            this.jdbcType = parsedField.getJdbcType();
            this.sqlType = parsedField.getSqlType();
        } else {
            this.jdbcType = defaultValues.getJDBCType();
            this.sqlType = defaultValues.getSQLType();
        }
        this.readOnly = entity.isReadOnly() ? true : (parsedField.getReadOnly() != null ? parsedField.getReadOnly().booleanValue() : defaultValues.isReadOnly());
        this.readTimeOut = parsedField.getReadTimeOut() != null ? parsedField.getReadTimeOut().intValue() : defaultValues.getReadTimeOut();
        this.primaryKeyMember = defaultValues.isPrimaryKeyMember();
        this.primaryKeyField = defaultValues.getPrimaryKeyField();
        this.notNull = this.fieldType.isPrimitive() || this.primaryKeyMember || parsedField.getNotNull() != null && parsedField.getNotNull() != false;
        for (JDBCCMPFieldPropertyMetaData propertyMetaData : this.propertyOverrides) {
            this.addProperty(propertyMetaData);
        }
        this.autoIncrement = parsedField.getAutoIncrement() != null && parsedField.getAutoIncrement() != false;
        this.genIndex = parsedField.getGenIndex() == null || parsedField.getGenIndex() == false;
        this.relationTableField = defaultValues.isRelationTableField();
        this.checkDirtyAfterGet = JDBCCMPFieldMetaData.readCheckDirtyAfterGet(parsedField, defaultValues.getCheckDirtyAfterGet());
        this.stateFactory = parsedField.getStateFactory() == null ? defaultValues.getStateFactory() : parsedField.getStateFactory();
    }

    private static byte readCheckDirtyAfterGet(ParsedCmpField parsedField, byte defaultValue) {
        int checkDirtyAfterGet = parsedField.getCheckDirtyAfterGet() == null ? defaultValue : (parsedField.getCheckDirtyAfterGet() != false ? 1 : 2);
        return (byte)checkDirtyAfterGet;
    }

    public JDBCEntityMetaData getEntity() {
        return this.entity;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Class<?> getFieldType() {
        return this.fieldType;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getJDBCType() {
        return this.jdbcType;
    }

    public String getSQLType() {
        return this.sqlType;
    }

    public List<JDBCCMPFieldPropertyMetaData> getPropertyOverrides() {
        return Collections.unmodifiableList(this.propertyOverrides);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public int getReadTimeOut() {
        return this.readTimeOut;
    }

    public boolean isPrimaryKeyMember() {
        return this.primaryKeyMember;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public boolean isIndexed() {
        return this.genIndex;
    }

    public boolean isUnknownPkField() {
        return this.unknownPkField;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public boolean isRelationTableField() {
        return this.relationTableField;
    }

    public byte getCheckDirtyAfterGet() {
        return this.checkDirtyAfterGet;
    }

    public String getStateFactory() {
        return this.stateFactory;
    }

    public boolean equals(Object o) {
        if (o instanceof JDBCCMPFieldMetaData) {
            JDBCCMPFieldMetaData cmpField = (JDBCCMPFieldMetaData)o;
            return this.fieldName.equals(cmpField.fieldName) && this.entity.equals(cmpField.entity);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.entity.hashCode();
        result = 37 * result + this.fieldName.hashCode();
        return result;
    }

    public String toString() {
        return "[JDBCCMPFieldMetaData : fieldName=" + this.fieldName + ", " + this.entity + "]";
    }

    public void addProperty(JDBCCMPFieldPropertyMetaData propertyMetaData) {
        this.propertyOverrides.add(propertyMetaData);
    }

    public ClassLoader getClassLoader() {
        return JDBCCMPFieldMetaData.class.getClassLoader();
    }

    private Class loadFieldType(JDBCEntityMetaData entity, String fieldName) {
        if (entity.isCMP1x()) {
            try {
                return entity.getEntityClass().getField(fieldName).getType();
            }
            catch (NoSuchFieldException e) {
                throw CmpMessages.MESSAGES.fieldNotFound(fieldName, entity.getEntityClass().getName());
            }
        }
        String baseName = Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        String getName = "get" + baseName;
        String setName = "set" + baseName;
        Method[] methods = entity.getEntityClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!Modifier.isPublic(methods[i].getModifiers()) || !Modifier.isAbstract(methods[i].getModifiers())) continue;
            if (getName.equals(methods[i].getName()) && methods[i].getParameterTypes().length == 0 && !methods[i].getReturnType().equals(Void.TYPE)) {
                return methods[i].getReturnType();
            }
            if (!setName.equals(methods[i].getName()) || methods[i].getParameterTypes().length != 1 || !methods[i].getReturnType().equals(Void.TYPE)) continue;
            return methods[i].getParameterTypes()[0];
        }
        throw CmpMessages.MESSAGES.noAbstractAccessor(fieldName, entity.getEntityClass().getName());
    }

    public Field getPrimaryKeyField() {
        return this.primaryKeyField;
    }
}

