/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

class ModelControllerLock {
    private final Sync sync = new Sync();

    ModelControllerLock() {
    }

    public void lock(Integer permit) {
        if (permit == null) {
            throw new IllegalArgumentException();
        }
        this.sync.acquire(permit);
    }

    public void lockInterruptibly(Integer permit) throws InterruptedException {
        if (permit == null) {
            throw new IllegalArgumentException();
        }
        this.sync.acquireInterruptibly(permit);
    }

    public void unlock(Integer permit) {
        if (permit == null) {
            throw new IllegalArgumentException();
        }
        this.sync.release(permit);
    }

    private class Sync
    extends AbstractQueuedSynchronizer {
        private final AtomicReference<Object> permitHolder = new AtomicReference<Object>(null);

        private Sync() {
        }

        @Override
        protected boolean tryAcquire(int permit) {
            int c = this.getState();
            if (c == 0) {
                if (this.compareAndSetState(0, 1)) {
                    this.permitHolder.set(permit);
                    return true;
                }
            } else if (this.permitHolder.get().equals(permit)) {
                int next;
                int current;
                do {
                    if ((next = (current = this.getState()) + 1) >= 0) continue;
                    throw new Error("Maximum lock count exceeded");
                } while (!this.compareAndSetState(current, next));
                return true;
            }
            return false;
        }

        @Override
        protected boolean tryRelease(int permit) {
            if (this.permitHolder.get() == null) {
                throw new IllegalStateException();
            }
            if (this.permitHolder.get().equals(permit)) {
                int next;
                int current;
                do {
                    if ((next = (current = this.getState()) - 1) >= 0) continue;
                    throw new IllegalStateException();
                } while (!this.compareAndSetState(current, next));
                if (next == 0) {
                    this.permitHolder.compareAndSet(permit, null);
                    return true;
                }
                return false;
            }
            return false;
        }
    }
}

