/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;

public final class ServiceVerificationHandler
extends AbstractServiceListener<Object>
implements ServiceListener<Object>,
OperationStepHandler {
    private final Set<ServiceController<?>> set = new HashSet();
    private final Set<ServiceController<?>> failed = new HashSet();
    private final Set<ServiceController<?>> problem = new HashSet();
    private int outstanding;

    @Override
    public synchronized void execute(OperationContext context, ModelNode operation) {
        long start = 0L;
        long settleTime = 100L;
        while (this.outstanding > 0 || settleTime > 0L && !this.problem.isEmpty()) {
            try {
                long wait = this.outstanding > 0 ? 0L : settleTime;
                this.wait(wait);
                if (this.outstanding == 0) {
                    if (start == 0L) {
                        start = System.currentTimeMillis();
                        continue;
                    }
                    settleTime -= System.currentTimeMillis() - start;
                    continue;
                }
                start = 0L;
                settleTime = 100L;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                context.getFailureDescription().set(ControllerMessages.MESSAGES.operationCancelled());
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                return;
            }
        }
        if (!this.failed.isEmpty() || !this.problem.isEmpty()) {
            SortedSet<ServiceName> allMissing;
            HashSet missingTransitive = null;
            HashSet<ServiceName> trackedServices = new HashSet<ServiceName>();
            ModelNode failureDescription = context.getFailureDescription();
            ModelNode failedList = null;
            for (ServiceController<?> controller : this.failed) {
                if (failedList == null) {
                    failedList = failureDescription.get(ControllerMessages.MESSAGES.failedServices());
                }
                ServiceName serviceName = controller.getName();
                trackedServices.add(serviceName);
                failedList.get(serviceName.getCanonicalName()).set(ServiceVerificationHandler.getServiceFailureDescription(controller.getStartException()));
            }
            ModelNode problemList = null;
            for (ServiceController<?> controller : this.problem) {
                Set immediatelyUnavailable = controller.getImmediateUnavailableDependencies();
                if (!immediatelyUnavailable.isEmpty()) {
                    if (problemList == null) {
                        problemList = failureDescription.get(ControllerMessages.MESSAGES.servicesMissingDependencies());
                    }
                    StringBuilder missing = new StringBuilder();
                    Iterator i = immediatelyUnavailable.iterator();
                    while (i.hasNext()) {
                        ServiceName serviceName = (ServiceName)i.next();
                        trackedServices.add(serviceName);
                        missing.append(serviceName.getCanonicalName());
                        if (!i.hasNext()) continue;
                        missing.append(", ");
                    }
                    StringBuilder problem = new StringBuilder();
                    problem.append(controller.getName().getCanonicalName());
                    problem.append(" ").append(ControllerMessages.MESSAGES.servicesMissing(missing));
                    problemList.add(problem.toString());
                    continue;
                }
                if (missingTransitive == null) {
                    missingTransitive = new HashSet();
                }
                missingTransitive.add(controller);
            }
            if (missingTransitive != null && !(allMissing = ServiceVerificationHandler.findAllMissingServices(missingTransitive, trackedServices)).isEmpty()) {
                ModelNode missingTransitiveDesc = failureDescription.get(ControllerMessages.MESSAGES.missingTransitiveDependencyProblem());
                ModelNode missingTransitiveDeps = missingTransitiveDesc.get(ControllerMessages.MESSAGES.missingTransitiveDependendents());
                TreeSet<ServiceName> sortedNames = new TreeSet<ServiceName>();
                for (ServiceController serviceController : missingTransitive) {
                    sortedNames.add(serviceController.getName());
                }
                for (ServiceName serviceName : sortedNames) {
                    missingTransitiveDeps.add(serviceName.getCanonicalName());
                }
                ModelNode allMissingList = missingTransitiveDesc.get(ControllerMessages.MESSAGES.missingTransitiveDependencies());
                for (ServiceName serviceName : allMissing) {
                    allMissingList.add(serviceName.getCanonicalName());
                }
            }
            if (context.isRollbackOnRuntimeFailure()) {
                context.setRollbackOnly();
            }
        }
        for (ServiceController<?> controller : this.set) {
            controller.removeListener((ServiceListener)this);
        }
        context.stepCompleted();
    }

    public synchronized void listenerAdded(ServiceController<?> controller) {
        this.set.add(controller);
        if (!controller.getSubstate().isRestState()) {
            ++this.outstanding;
        }
    }

    public synchronized void transition(ServiceController<?> controller, ServiceController.Transition transition) {
        switch (transition) {
            case STARTING_to_START_FAILED: {
                this.failed.add(controller);
                break;
            }
            case START_FAILED_to_STARTING: {
                this.failed.remove(controller);
                break;
            }
            case START_REQUESTED_to_PROBLEM: {
                this.problem.add(controller);
                break;
            }
            case PROBLEM_to_START_REQUESTED: {
                this.problem.remove(controller);
            }
        }
        if (transition.leavesRestState()) {
            ++this.outstanding;
        } else if (transition.entersRestState() && this.outstanding-- == 1) {
            this.notifyAll();
        }
    }

    private static ModelNode getServiceFailureDescription(StartException exception) {
        ModelNode result = new ModelNode();
        if (exception != null) {
            StringBuilder sb = new StringBuilder(exception.toString());
            for (Throwable cause = exception.getCause(); cause != null; cause = cause.getCause()) {
                sb.append("\n    Caused by: ");
                sb.append(cause.toString());
            }
            result.set(sb.toString());
        }
        return result;
    }

    private static SortedSet<ServiceName> findAllMissingServices(Set<ServiceController<?>> missingTransitive, Set<ServiceName> alreadyTracked) {
        HashSet<ServiceContainer> examined = new HashSet<ServiceContainer>();
        TreeSet<ServiceName> result = new TreeSet<ServiceName>();
        for (ServiceController<?> controller : missingTransitive) {
            ServiceContainer container = controller.getServiceContainer();
            if (!examined.add(container)) continue;
            result.addAll(ServiceVerificationHandler.findAllMissingServices(container));
        }
        HashSet retain = new HashSet(result);
        retain.removeAll(alreadyTracked);
        if (retain.size() == 0) {
            result.clear();
        }
        return result;
    }

    private static Set<ServiceName> findAllMissingServices(ServiceContainer container) {
        HashSet<ServiceName> result = new HashSet<ServiceName>();
        for (ServiceName serviceName : container.getServiceNames()) {
            ServiceController controller = container.getService(serviceName);
            if (controller == null || controller.getMode() == ServiceController.Mode.NEVER || controller.getMode() == ServiceController.Mode.REMOVE || controller.getSubstate() != ServiceController.Substate.PROBLEM) continue;
            result.addAll(controller.getImmediateUnavailableDependencies());
        }
        return result;
    }
}

