/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.state;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.AddPropertiesUser;
import org.jboss.as.domain.management.security.ConsoleWrapper;
import org.jboss.as.domain.management.security.state.AbstractValidationState;
import org.jboss.as.domain.management.security.state.ConfirmationChoice;
import org.jboss.as.domain.management.security.state.ErrorState;
import org.jboss.as.domain.management.security.state.PromptNewUserState;
import org.jboss.as.domain.management.security.state.PromptPasswordState;
import org.jboss.as.domain.management.security.state.State;
import org.jboss.as.domain.management.security.state.StateValues;

public class ValidateUserState
extends AbstractValidationState {
    private static final char[] VALID_PUNCTUATION;
    private final StateValues stateValues;
    private final ConsoleWrapper theConsole;

    public ValidateUserState(ConsoleWrapper theConsole, StateValues stateValues) {
        this.theConsole = theConsole;
        this.stateValues = stateValues;
    }

    @Override
    protected Collection<State> getValidationStates() {
        ArrayList<State> validationStates = new ArrayList<State>(3);
        validationStates.add(this.getValidCharactersState());
        validationStates.add(this.getDuplicateCheckState());
        validationStates.add(this.getCommonNamesCheckState());
        return validationStates;
    }

    @Override
    protected State getSuccessState() {
        return new PromptPasswordState(this.theConsole, this.stateValues, false);
    }

    private State getRetryState() {
        return this.stateValues.isSilentOrNonInteractive() ? null : new PromptNewUserState(this.theConsole, this.stateValues);
    }

    private State getValidCharactersState() {
        return new State(){

            @Override
            public State execute() {
                for (char currentChar : ValidateUserState.this.stateValues.getUserName().toCharArray()) {
                    if (this.isValidPunctuation(currentChar) || Character.isLetter(currentChar) || Character.isDigit(currentChar)) continue;
                    return new ErrorState(ValidateUserState.this.theConsole, DomainManagementMessages.MESSAGES.usernameNotAlphaNumeric(), ValidateUserState.this.getRetryState(), ValidateUserState.this.stateValues);
                }
                return ValidateUserState.this;
            }

            private boolean isValidPunctuation(char currentChar) {
                return Arrays.binarySearch(VALID_PUNCTUATION, currentChar) >= 0;
            }
        };
    }

    private State getDuplicateCheckState() {
        return new State(){

            @Override
            public State execute() {
                if (ValidateUserState.this.stateValues.getKnownUsers().contains(ValidateUserState.this.stateValues.getUserName())) {
                    PromptNewUserState duplicateContinuing = ValidateUserState.this.stateValues.isSilentOrNonInteractive() ? null : new PromptNewUserState(ValidateUserState.this.theConsole, ValidateUserState.this.stateValues);
                    ValidateUserState.this.stateValues.setExistingUser(true);
                    if (ValidateUserState.this.stateValues.isSilentOrNonInteractive()) {
                        return ValidateUserState.this;
                    }
                    String message = DomainManagementMessages.MESSAGES.aboutToUpdateUser(ValidateUserState.this.stateValues.getUserName());
                    String prompt = DomainManagementMessages.MESSAGES.isCorrectPrompt() + " " + DomainManagementMessages.MESSAGES.yes() + "/" + DomainManagementMessages.MESSAGES.no() + "?";
                    return new ConfirmationChoice(ValidateUserState.this.theConsole, message, prompt, (State)ValidateUserState.this, (State)duplicateContinuing);
                }
                ValidateUserState.this.stateValues.setExistingUser(false);
                return ValidateUserState.this;
            }
        };
    }

    private State getCommonNamesCheckState() {
        return new State(){

            @Override
            public State execute() {
                if (!ValidateUserState.this.stateValues.isExistingUser() && !ValidateUserState.this.stateValues.isSilentOrNonInteractive()) {
                    for (String current : AddPropertiesUser.BAD_USER_NAMES) {
                        if (!current.equals(ValidateUserState.this.stateValues.getUserName().toLowerCase(Locale.ENGLISH))) continue;
                        String message = DomainManagementMessages.MESSAGES.usernameEasyToGuess(ValidateUserState.this.stateValues.getUserName());
                        String prompt = DomainManagementMessages.MESSAGES.sureToAddUser(ValidateUserState.this.stateValues.getUserName());
                        return new ConfirmationChoice(ValidateUserState.this.theConsole, message, prompt, (State)ValidateUserState.this, ValidateUserState.this.getRetryState());
                    }
                }
                return ValidateUserState.this;
            }
        };
    }

    static {
        char[] validPunctuation = new char[]{'.', '@', '\\', '=', ',', '/'};
        Arrays.sort(validPunctuation);
        VALID_PUNCTUATION = validPunctuation;
    }
}

