/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.structure;

import java.io.Closeable;
import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.ee.structure.AppJBossAllParser;
import org.jboss.as.ee.structure.Attachments;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.ee.structure.JBossDescriptorPropertyReplacement;
import org.jboss.as.ee.structure.SpecDescriptorPropertyReplacement;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.metadata.ear.jboss.JBossAppMetaData;
import org.jboss.metadata.ear.spec.EarMetaData;
import org.jboss.metadata.javaee.spec.RemoteEnvironment;
import org.jboss.metadata.merge.JBossAppMetaDataMerger;
import org.jboss.metadata.parser.jboss.JBossAppMetaDataParser;
import org.jboss.metadata.parser.spec.EarMetaDataParser;
import org.jboss.metadata.parser.util.NoopXMLResolver;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

public class EarMetaDataParsingProcessor
implements DeploymentUnitProcessor {
    private static final String APPLICATION_XML = "META-INF/application.xml";
    private static final String JBOSS_APP_XML = "META-INF/jboss-app.xml";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!DeploymentTypeMarker.isType(DeploymentType.EAR, deploymentUnit)) {
            return;
        }
        ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_ROOT);
        VirtualFile deploymentFile = deploymentRoot.getRoot();
        EarMetaData earMetaData = this.handleSpecMetadata(deploymentFile, SpecDescriptorPropertyReplacement.propertyReplacer(deploymentUnit));
        JBossAppMetaData jbossMetaData = this.handleJbossMetadata(deploymentFile, JBossDescriptorPropertyReplacement.propertyReplacer(deploymentUnit), deploymentUnit);
        if (earMetaData == null && jbossMetaData == null) {
            return;
        }
        if (jbossMetaData != null && jbossMetaData.getDistinctName() != null) {
            deploymentUnit.putAttachment(Attachments.DISTINCT_NAME, (Object)jbossMetaData.getDistinctName());
        }
        JBossAppMetaData merged = earMetaData != null ? new JBossAppMetaData(earMetaData.getEarVersion()) : new JBossAppMetaData();
        JBossAppMetaDataMerger.merge((JBossAppMetaData)merged, (JBossAppMetaData)jbossMetaData, (EarMetaData)earMetaData);
        deploymentUnit.putAttachment(Attachments.EAR_METADATA, (Object)merged);
        if (merged.getEarEnvironmentRefsGroup() != null) {
            DeploymentDescriptorEnvironment bindings = new DeploymentDescriptorEnvironment("java:app/env/", (RemoteEnvironment)merged.getEarEnvironmentRefsGroup());
            deploymentUnit.putAttachment(org.jboss.as.ee.component.Attachments.MODULE_DEPLOYMENT_DESCRIPTOR_ENVIRONMENT, (Object)bindings);
        }
    }

    private EarMetaData handleSpecMetadata(VirtualFile deploymentFile, PropertyReplacer propertyReplacer) throws DeploymentUnitProcessingException {
        VirtualFile applicationXmlFile = deploymentFile.getChild(APPLICATION_XML);
        if (!applicationXmlFile.exists()) {
            return null;
        }
        InputStream inputStream = null;
        try {
            inputStream = applicationXmlFile.openStream();
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setXMLResolver(NoopXMLResolver.create());
            XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(inputStream);
            EarMetaData earMetaData = EarMetaDataParser.INSTANCE.parse(xmlReader, propertyReplacer);
            return earMetaData;
        }
        catch (Exception e) {
            throw EeMessages.MESSAGES.failedToParse(e, applicationXmlFile);
        }
        finally {
            VFSUtils.safeClose((Closeable)inputStream);
        }
    }

    private JBossAppMetaData handleJbossMetadata(VirtualFile deploymentFile, PropertyReplacer propertyReplacer, DeploymentUnit deploymentUnit) throws DeploymentUnitProcessingException {
        VirtualFile applicationXmlFile = deploymentFile.getChild(JBOSS_APP_XML);
        if (!applicationXmlFile.exists()) {
            return (JBossAppMetaData)deploymentUnit.getAttachment(AppJBossAllParser.ATTACHMENT_KEY);
        }
        InputStream inputStream = null;
        try {
            inputStream = applicationXmlFile.openStream();
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setXMLResolver(NoopXMLResolver.create());
            XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(inputStream);
            JBossAppMetaData jBossAppMetaData = JBossAppMetaDataParser.INSTANCE.parse(xmlReader, propertyReplacer);
            return jBossAppMetaData;
        }
        catch (Exception e) {
            throw EeMessages.MESSAGES.failedToParse(e, applicationXmlFile);
        }
        finally {
            VFSUtils.safeClose((Closeable)inputStream);
        }
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        deploymentUnit.removeAttachment(Attachments.EAR_METADATA);
    }
}

