/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3;

import java.lang.reflect.Method;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class EJBMethodIdentifier {
    private final MethodIdentifier methodIdentifier;
    private final String methodDeclaringClass;
    private final int cachedHashCode;

    public EJBMethodIdentifier(MethodIdentifier methodIdentifier, String methodDeclaringClass) {
        this.methodIdentifier = methodIdentifier;
        this.methodDeclaringClass = methodDeclaringClass;
        this.cachedHashCode = this.generateHashCode();
    }

    public static EJBMethodIdentifier fromMethodInfo(MethodInfo methodInfo) {
        String returnType = methodInfo.returnType().name().toString();
        String[] argTypes = new String[methodInfo.args().length];
        int i = 0;
        for (Type argType : methodInfo.args()) {
            argTypes[i++] = argType.name().toString();
        }
        MethodIdentifier methodIdentifier = MethodIdentifier.getIdentifier((String)returnType, (String)methodInfo.name(), (String[])argTypes);
        return new EJBMethodIdentifier(methodIdentifier, methodInfo.declaringClass().name().toString());
    }

    public static EJBMethodIdentifier fromMethod(Method method) {
        MethodIdentifier methodIdentifier = MethodIdentifier.getIdentifierForMethod((Method)method);
        return new EJBMethodIdentifier(methodIdentifier, method.getDeclaringClass().getName());
    }

    private int generateHashCode() {
        int result = this.methodIdentifier.hashCode();
        result = 31 * result + this.methodDeclaringClass.hashCode();
        return result;
    }

    public MethodIdentifier getMethodIdentifier() {
        return this.methodIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EJBMethodIdentifier that = (EJBMethodIdentifier)o;
        if (!this.methodDeclaringClass.equals(that.methodDeclaringClass)) {
            return false;
        }
        return this.methodIdentifier.equals(that.methodIdentifier);
    }

    public int hashCode() {
        return this.cachedHashCode;
    }
}

