/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.inflow;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.TimeUnit;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import org.jboss.as.ejb3.inflow.MessageEndpointInvocationHandler;
import org.jboss.as.ejb3.inflow.MessageEndpointService;

public class JBossMessageEndpointFactory
implements MessageEndpointFactory {
    private final ClassLoader classLoader;
    private final Class<?>[] interfaces;
    private final MessageEndpointService service;

    public JBossMessageEndpointFactory(ClassLoader classLoader, MessageEndpointService service) {
        this.classLoader = classLoader;
        this.service = service;
        this.interfaces = new Class[]{service.getMessageListenerInterface(), MessageEndpoint.class};
    }

    public MessageEndpoint createEndpoint(XAResource xaResource) throws UnavailableException {
        return this.createEndpoint(xaResource, 0L);
    }

    public MessageEndpoint createEndpoint(XAResource xaResource, long timeout) throws UnavailableException {
        Object delegate = this.service.obtain(timeout, TimeUnit.MILLISECONDS);
        MessageEndpointInvocationHandler handler = new MessageEndpointInvocationHandler(this.service, delegate, xaResource);
        return (MessageEndpoint)Proxy.newProxyInstance(this.classLoader, this.interfaces, (InvocationHandler)handler);
    }

    public boolean isDeliveryTransacted(Method method) throws NoSuchMethodException {
        return this.service.isDeliveryTransacted(method);
    }
}

