/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jdr;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.jdr.JdrMessages;
import org.jboss.as.jdr.JdrReport;
import org.jboss.as.jdr.JdrReportService;

public class CommandLineMain {
    private static CommandLineParser parser = new GnuParser();
    private static Options options = new Options();
    private static HelpFormatter formatter = new HelpFormatter();
    private static final String usage = "jdr.{sh,bat} [options]";

    public static void main(String[] args) {
        String port = "9999";
        String host = "localhost";
        try {
            CommandLine line = parser.parse(options, args, false);
            if (line.hasOption("help")) {
                formatter.printHelp(usage, options);
                return;
            }
            if (line.hasOption("host")) {
                host = line.getOptionValue("host");
            }
            if (line.hasOption("port")) {
                port = line.getOptionValue("port");
            }
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            formatter.printHelp(usage, options);
            return;
        }
        System.out.println("Initializing JBoss Diagnostic Reporter...");
        JdrReportService reportService = new JdrReportService();
        JdrReport response = null;
        try {
            response = reportService.standaloneCollect(host, port);
        }
        catch (OperationFailedException e) {
            System.out.println("Failed to complete the JDR report: " + e.getMessage());
        }
        System.out.println("JDR started: " + response.getStartTime().toString());
        System.out.println("JDR ended: " + response.getEndTime().toString());
        System.out.println("JDR location: " + response.getLocation());
        System.exit(0);
    }

    static {
        options.addOption("h", "help", false, JdrMessages.MESSAGES.jdrHelpMessage());
        options.addOption("H", "host", true, JdrMessages.MESSAGES.jdrHostnameMessage());
        options.addOption("p", "port", true, JdrMessages.MESSAGES.jdrPortMessage());
    }
}

