/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jsr77.managedobject;

import java.util.HashSet;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;
import org.jboss.as.jsr77.JSR77Messages;
import org.jboss.as.jsr77.managedobject.Handler;
import org.jboss.as.jsr77.managedobject.ModelReader;

abstract class BaseHandler
extends Handler {
    private static final String ATTR_NAME = "objectName";
    private static final String ATTR_STATE_MANAGEABLE = "stateManageable";
    private static final String ATTR_STATISTICS_PROVIDER = "statisticsProvider";
    private static final String ATTR_EVENT_PROVIDER = "eventProvider";

    protected BaseHandler() {
    }

    @Override
    Object getAttribute(ModelReader reader, ObjectName name, String attribute) throws AttributeNotFoundException {
        if (attribute.equals(ATTR_NAME)) {
            return name.toString();
        }
        if (attribute.equals(ATTR_STATE_MANAGEABLE) || attribute.equals(ATTR_STATISTICS_PROVIDER) || attribute.equals(ATTR_EVENT_PROVIDER)) {
            return false;
        }
        throw JSR77Messages.MESSAGES.noAttributeCalled(attribute);
    }

    @Override
    MBeanInfo getMBeanInfo(ModelReader reader, ObjectName name) throws InstanceNotFoundException {
        Set<ObjectName> names = this.queryObjectNames(reader, name, null);
        if (names.size() != 1) {
            throw JSR77Messages.MESSAGES.noMBeanCalled(name);
        }
        if (!name.apply(names.iterator().next())) {
            throw JSR77Messages.MESSAGES.noMBeanCalled(name);
        }
        Set<MBeanAttributeInfo> attrs = this.getAttributeInfos();
        MBeanAttributeInfo[] attributes = attrs.toArray(new MBeanAttributeInfo[attrs.size()]);
        return new MBeanInfo(this.getClass().getName(), "Management Object", attributes, new MBeanConstructorInfo[0], new MBeanOperationInfo[0], new MBeanNotificationInfo[0]);
    }

    Set<MBeanAttributeInfo> getAttributeInfos() {
        HashSet<MBeanAttributeInfo> attributes = new HashSet<MBeanAttributeInfo>();
        attributes.add(this.createRoMBeanAttributeInfo(ATTR_NAME, String.class.getName(), JSR77Messages.MESSAGES.attrInfoAttrName()));
        attributes.add(this.createRoMBeanAttributeInfo(ATTR_STATE_MANAGEABLE, Boolean.TYPE.getName(), JSR77Messages.MESSAGES.attrInfoStateManageable()));
        attributes.add(this.createRoMBeanAttributeInfo(ATTR_STATISTICS_PROVIDER, Boolean.TYPE.getName(), JSR77Messages.MESSAGES.attrInfoStatisticsProvider()));
        attributes.add(this.createRoMBeanAttributeInfo(ATTR_EVENT_PROVIDER, Boolean.TYPE.getName(), JSR77Messages.MESSAGES.attrInfoEventProvider()));
        return attributes;
    }

    MBeanAttributeInfo createRoMBeanAttributeInfo(String name, String type, String description) {
        return new MBeanAttributeInfo(name, type, description, true, false, false);
    }
}

