/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import org.hornetq.api.core.management.AddressControl;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.messaging.HornetQActivationService;
import org.jboss.as.messaging.ManagementUtil;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class AddressControlHandler
extends AbstractRuntimeOnlyHandler {
    public static AddressControlHandler INSTANCE = new AddressControlHandler();

    private AddressControlHandler() {
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (HornetQActivationService.rollbackOperationIfServerNotActive(context, operation)) {
            return;
        }
        String operationName = operation.require("operation").asString();
        if ("read-attribute".equals(operationName)) {
            this.handleReadAttribute(context, operation);
        } else if ("get-roles-as-json".equals(operationName)) {
            this.handleGetRolesAsJson(context, operation);
        }
    }

    private void handleReadAttribute(OperationContext context, ModelNode operation) {
        block10: {
            if (HornetQActivationService.ignoreOperationIfServerNotActive(context, operation)) {
                return;
            }
            AddressControl addressControl = this.getAddressControl(context, operation);
            if (addressControl == null) {
                ManagementUtil.rollbackOperationWithResourceNotFound(context, operation);
                return;
            }
            String name = operation.require("name").asString();
            try {
                if ("roles".equals(name)) {
                    String json = addressControl.getRolesAsJSON();
                    ManagementUtil.reportRoles(context, json);
                    break block10;
                }
                if ("queue-names".equals(name)) {
                    String[] queues = addressControl.getQueueNames();
                    ManagementUtil.reportListOfString(context, queues);
                    break block10;
                }
                if ("number-of-bytes-per-page".equals(name)) {
                    long l = addressControl.getNumberOfBytesPerPage();
                    context.getResult().set(l);
                    break block10;
                }
                if ("number-of-pages".equals(name)) {
                    int i = addressControl.getNumberOfPages();
                    context.getResult().set(i);
                    break block10;
                }
                if ("binding-names".equals(name)) {
                    String[] bindings = addressControl.getBindingNames();
                    ManagementUtil.reportListOfString(context, bindings);
                    break block10;
                }
                throw MessagingMessages.MESSAGES.unsupportedAttribute(name);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                context.getFailureDescription().set(e.getLocalizedMessage());
            }
        }
        context.stepCompleted();
    }

    private void handleGetRolesAsJson(OperationContext context, ModelNode operation) {
        AddressControl addressControl = this.getAddressControl(context, operation);
        try {
            String json = addressControl.getRolesAsJSON();
            ManagementUtil.reportRolesAsJSON(context, json);
            context.stepCompleted();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            context.getFailureDescription().set(e.getLocalizedMessage());
        }
    }

    private AddressControl getAddressControl(OperationContext context, ModelNode operation) {
        String addressName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ServiceController hqService = context.getServiceRegistry(false).getService(hqServiceName);
        HornetQServer hqServer = (HornetQServer)HornetQServer.class.cast(hqService.getValue());
        return (AddressControl)AddressControl.class.cast(hqServer.getManagementService().getResource("core.address." + addressName));
    }
}

