/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import org.hornetq.api.config.HornetQDefaultConfiguration;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.messaging.AttributeMarshallers;
import org.jboss.as.messaging.BridgeAdd;
import org.jboss.as.messaging.BridgeControlHandler;
import org.jboss.as.messaging.BridgeRemove;
import org.jboss.as.messaging.BridgeWriteAttributeHandler;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.DeprecatedAttributeWriteHandler;
import org.jboss.as.messaging.MessagingExtension;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class BridgeDefinition
extends SimpleResourceDefinition {
    public static final String[] OPERATIONS = new String[]{"start", "stop"};
    public static final PathElement PATH = PathElement.pathElement((String)"bridge");
    private final boolean registerRuntimeOnly;
    public static final PrimitiveListAttributeDefinition CONNECTOR_REFS = ((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)PrimitiveListAttributeDefinition.Builder.of((String)"static-connectors", (ModelType)ModelType.STRING).setAllowNull(true)).setAlternatives(new String[]{"discovery-group-name"})).setValidator((ParameterValidator)new StringLengthValidator(1))).setXmlName("connector-ref")).setAttributeMarshaller((AttributeMarshaller)new AttributeMarshallers.WrappedListAttributeMarshaller("static-connectors"))).setRestartAllServices()).build();
    public static SimpleAttributeDefinition DISCOVERY_GROUP_NAME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"discovery-group-name", (ModelType)ModelType.STRING).setAllowNull(true).setAlternatives(new String[]{"static-connectors"}).setAttributeMarshaller(AttributeMarshallers.DISCOVERY_GROUP_MARSHALLER)).setRestartAllServices().build();
    public static final SimpleAttributeDefinition QUEUE_NAME = SimpleAttributeDefinitionBuilder.create((String)"queue-name", (ModelType)ModelType.STRING).setAllowExpression(true).setRestartAllServices().build();
    public static final SimpleAttributeDefinition PASSWORD = SimpleAttributeDefinitionBuilder.create((String)"password", (ModelType)ModelType.STRING).setAllowNull(true).setAllowExpression(true).setDefaultValue(new ModelNode().set(HornetQDefaultConfiguration.getDefaultClusterPassword())).setRestartAllServices().build();
    public static final SimpleAttributeDefinition USER = SimpleAttributeDefinitionBuilder.create((String)"user", (ModelType)ModelType.STRING).setAllowNull(true).setAllowExpression(true).setDefaultValue(new ModelNode().set(HornetQDefaultConfiguration.getDefaultClusterUser())).setRestartAllServices().build();
    public static final SimpleAttributeDefinition USE_DUPLICATE_DETECTION = SimpleAttributeDefinitionBuilder.create((String)"use-duplicate-detection", (ModelType)ModelType.BOOLEAN).setAllowNull(true).setDefaultValue(new ModelNode().set(HornetQDefaultConfiguration.isDefaultBridgeDuplicateDetection())).setAllowExpression(true).setRestartAllServices().build();
    public static final SimpleAttributeDefinition RECONNECT_ATTEMPTS = SimpleAttributeDefinitionBuilder.create((String)"reconnect-attempts", (ModelType)ModelType.INT).setAllowNull(true).setDefaultValue(new ModelNode().set(HornetQDefaultConfiguration.getDefaultBridgeReconnectAttempts())).setAllowExpression(true).setRestartAllServices().build();
    public static final SimpleAttributeDefinition FORWARDING_ADDRESS = SimpleAttributeDefinitionBuilder.create((String)"forwarding-address", (ModelType)ModelType.STRING).setAllowNull(true).setAllowExpression(true).setRestartAllServices().build();
    public static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{QUEUE_NAME, FORWARDING_ADDRESS, CommonAttributes.HA, CommonAttributes.FILTER, CommonAttributes.TRANSFORMER_CLASS_NAME, CommonAttributes.MIN_LARGE_MESSAGE_SIZE, CommonAttributes.CHECK_PERIOD, CommonAttributes.CONNECTION_TTL, CommonAttributes.RETRY_INTERVAL, CommonAttributes.RETRY_INTERVAL_MULTIPLIER, CommonAttributes.MAX_RETRY_INTERVAL, RECONNECT_ATTEMPTS, USE_DUPLICATE_DETECTION, CommonAttributes.BRIDGE_CONFIRMATION_WINDOW_SIZE, USER, PASSWORD, CONNECTOR_REFS, DISCOVERY_GROUP_NAME};
    public static final AttributeDefinition[] ATTRIBUTES_WITH_EXPRESSION_ALLOWED_IN_1_2_0 = new AttributeDefinition[]{QUEUE_NAME, USE_DUPLICATE_DETECTION, RECONNECT_ATTEMPTS, FORWARDING_ADDRESS, CommonAttributes.FILTER, CommonAttributes.HA, CommonAttributes.MIN_LARGE_MESSAGE_SIZE, CommonAttributes.CHECK_PERIOD, CommonAttributes.CONNECTION_TTL, CommonAttributes.RETRY_INTERVAL, CommonAttributes.RETRY_INTERVAL_MULTIPLIER, CommonAttributes.MAX_RETRY_INTERVAL, CommonAttributes.BRIDGE_CONFIRMATION_WINDOW_SIZE};

    public BridgeDefinition(boolean registerRuntimeOnly) {
        super(PATH, MessagingExtension.getResourceDescriptionResolver("bridge"), (OperationStepHandler)BridgeAdd.INSTANCE, (OperationStepHandler)BridgeRemove.INSTANCE);
        this.registerRuntimeOnly = registerRuntimeOnly;
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        super.registerAttributes(registry);
        for (AttributeDefinition attr : ATTRIBUTES) {
            if (!this.registerRuntimeOnly && attr.getFlags().contains(AttributeAccess.Flag.STORAGE_RUNTIME)) continue;
            registry.registerReadWriteAttribute(attr, null, (OperationStepHandler)BridgeWriteAttributeHandler.INSTANCE);
        }
        if (this.registerRuntimeOnly) {
            BridgeControlHandler.INSTANCE.registerAttributes(registry);
        }
        registry.registerReadWriteAttribute((AttributeDefinition)CommonAttributes.FAILOVER_ON_SERVER_SHUTDOWN, null, (OperationStepHandler)new DeprecatedAttributeWriteHandler(CommonAttributes.FAILOVER_ON_SERVER_SHUTDOWN.getName()));
    }

    public void registerOperations(ManagementResourceRegistration registry) {
        if (this.registerRuntimeOnly) {
            BridgeControlHandler.INSTANCE.registerOperations(registry, this.getResourceDescriptionResolver());
        }
        super.registerOperations(registry);
    }
}

