/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.AlternativeAttributeCheckHandler;
import org.jboss.as.messaging.BroadcastGroupDefinition;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.dmr.ModelNode;

public class BroadcastGroupWriteAttributeHandler
extends ReloadRequiredWriteAttributeHandler {
    public static final BroadcastGroupWriteAttributeHandler INSTANCE = new BroadcastGroupWriteAttributeHandler();

    private BroadcastGroupWriteAttributeHandler() {
        super(BroadcastGroupDefinition.ATTRIBUTES);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep((OperationStepHandler)new AlternativeAttributeCheckHandler(BroadcastGroupDefinition.ATTRIBUTES), OperationContext.Stage.MODEL);
        super.execute(context, operation);
    }

    protected void finishModelStage(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode oldValue, Resource model) throws OperationFailedException {
        if (attributeName.equals(BroadcastGroupDefinition.CONNECTOR_REFS.getName())) {
            this.validateConnectorsUpdate(context, operation, newValue, oldValue, model);
        }
        super.finishModelStage(context, operation, attributeName, newValue, oldValue, model);
    }

    private void validateConnectorsUpdate(OperationContext context, ModelNode operation, ModelNode newValue, ModelNode oldValue, Resource model) throws OperationFailedException {
        Set<String> availableConnectors = this.getAvailableConnectors(context, operation);
        List operationAddress = operation.get("address").asList();
        String broadCastGroup = ((ModelNode)operationAddress.get(operationAddress.size() - 1)).get("broadcast-group").asString();
        for (ModelNode connectorRef : newValue.asList()) {
            String connectorName = connectorRef.asString();
            if (availableConnectors.contains(connectorName)) continue;
            throw MessagingMessages.MESSAGES.wrongConnectorRefInBroadCastGroup(broadCastGroup, connectorName, availableConnectors);
        }
    }

    private Set<String> getAvailableConnectors(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        PathAddress hornetqServer = MessagingServices.getHornetQServerPathAddress(address);
        Resource hornetQServerResource = context.readResourceFromRoot(hornetqServer);
        HashSet<String> availableConnectors = new HashSet<String>();
        availableConnectors.addAll(hornetQServerResource.getChildrenNames("in-vm-connector"));
        availableConnectors.addAll(hornetQServerResource.getChildrenNames("remote-connector"));
        availableConnectors.addAll(hornetQServerResource.getChildrenNames("connector"));
        return availableConnectors;
    }
}

