/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import org.hornetq.core.security.HornetQPrincipal;
import org.hornetq.core.server.ActivateCallback;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.jms.server.JMSServerManager;
import org.hornetq.jms.server.impl.JMSServerManagerImpl;
import org.hornetq.spi.core.naming.BindingRegistry;
import org.jboss.as.messaging.HornetQActivationService;
import org.jboss.as.messaging.HornetQDefaultCredentials;
import org.jboss.as.messaging.MessagingLogger;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.jms.AS7BindingRegistry;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.as.messaging.jms.SecurityActions;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class JMSService
implements Service<JMSServerManager> {
    private final InjectedValue<HornetQServer> hornetQServer = new InjectedValue();
    private final ServiceName hqServiceName;
    private JMSServerManager jmsServer;

    public static ServiceController<JMSServerManager> addService(ServiceTarget target, ServiceName hqServiceName, ServiceListener<Object> ... listeners) {
        JMSService service = new JMSService(hqServiceName);
        return target.addService(JMSServices.getJmsManagerBaseServiceName(hqServiceName), (Service)service).addDependency(hqServiceName, HornetQServer.class, service.getHornetQServer()).addListener(listeners).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    protected JMSService(ServiceName hqServiceName) {
        this.hqServiceName = hqServiceName;
    }

    public synchronized void start(StartContext context) throws StartException {
        ClassLoader oldTccl = SecurityActions.setThreadContextClassLoader(this.getClass());
        try {
            this.jmsServer = new JMSServerManagerImpl((HornetQServer)this.hornetQServer.getValue(), (BindingRegistry)new AS7BindingRegistry(context.getController().getServiceContainer()));
            final ServiceBuilder hornetqActivationService = context.getChildTarget().addService(HornetQActivationService.getHornetQActivationServiceName(this.hqServiceName), (Service)new HornetQActivationService()).setInitialMode(ServiceController.Mode.ACTIVE);
            ((HornetQServer)this.hornetQServer.getValue()).registerActivateCallback(new ActivateCallback(){
                private volatile ServiceController<Void> hornetqActivationController;

                public void preActivate() {
                }

                public void activated() {
                    ((HornetQServer)JMSService.this.hornetQServer.getValue()).getRemotingService().allowInvmSecurityOverride(new HornetQPrincipal(HornetQDefaultCredentials.getUsername(), HornetQDefaultCredentials.getPassword()));
                    if (this.hornetqActivationController == null) {
                        this.hornetqActivationController = hornetqActivationService.install();
                    } else {
                        this.hornetqActivationController.setMode(ServiceController.Mode.ACTIVE);
                    }
                }

                public void deActivate() {
                    if (this.hornetqActivationController != null && this.hornetqActivationController.getState() != ServiceController.State.STOPPING && this.hornetqActivationController.getState() != ServiceController.State.REMOVED) {
                        this.hornetqActivationController.compareAndSetMode(ServiceController.Mode.ACTIVE, ServiceController.Mode.PASSIVE);
                    }
                }
            });
            this.jmsServer.start();
        }
        catch (StartException e) {
            throw e;
        }
        catch (Exception e) {
            throw MessagingMessages.MESSAGES.failedToStartService(e);
        }
        finally {
            SecurityActions.setThreadContextClassLoader(oldTccl);
        }
    }

    public synchronized void stop(StopContext context) {
        try {
            this.jmsServer.stop();
            this.jmsServer = null;
        }
        catch (Exception e) {
            MessagingLogger.MESSAGING_LOGGER.errorStoppingJmsServer(e);
        }
    }

    public synchronized JMSServerManager getValue() throws IllegalStateException {
        if (this.jmsServer == null) {
            throw new IllegalStateException();
        }
        return this.jmsServer;
    }

    InjectedValue<HornetQServer> getHornetQServer() {
        return this.hornetQServer;
    }
}

