/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.security.AccessController;
import java.security.PrivilegedAction;

public final class SecurityActions {
    private SecurityActions() {
    }

    public static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader setThreadContextClassLoader(final Class clazz) {
        if (System.getSecurityManager() == null) {
            Thread thread = Thread.currentThread();
            try {
                ClassLoader classLoader = thread.getContextClassLoader();
                return classLoader;
            }
            finally {
                thread.setContextClassLoader(clazz.getClassLoader());
            }
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ClassLoader run() {
                Thread thread = Thread.currentThread();
                try {
                    ClassLoader classLoader = thread.getContextClassLoader();
                    return classLoader;
                }
                finally {
                    thread.setContextClassLoader(clazz.getClassLoader());
                }
            }
        });
    }

    public static void setThreadContextClassLoader(final ClassLoader cl) {
        if (System.getSecurityManager() == null) {
            Thread.currentThread().setContextClassLoader(cl);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    Thread.currentThread().setContextClassLoader(cl);
                    return cl;
                }
            });
        }
    }
}

