/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.pojo.service;

import org.jboss.as.pojo.BeanState;
import org.jboss.as.pojo.PojoMessages;
import org.jboss.as.pojo.descriptor.BeanMetaDataConfig;
import org.jboss.as.pojo.service.AbstractPojoPhase;
import org.jboss.as.pojo.service.BeanInfo;
import org.jboss.as.pojo.service.DefaultBeanInfo;
import org.jboss.as.pojo.service.InstantiatedPojoPhase;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;

public class DescribedPojoPhase
extends AbstractPojoPhase {
    public DescribedPojoPhase(DeploymentReflectionIndex index, BeanMetaDataConfig beanConfig) {
        this.setIndex(index);
        this.setBeanConfig(beanConfig);
    }

    public void registerAliases(ServiceBuilder serviceBuilder) {
        this.registerAliases(serviceBuilder, this.getLifecycleState());
    }

    @Override
    protected BeanState getLifecycleState() {
        return BeanState.DESCRIBED;
    }

    @Override
    protected AbstractPojoPhase createNextPhase() {
        return new InstantiatedPojoPhase(this);
    }

    @Override
    protected void startInternal(StartContext context) throws StartException {
        try {
            this.setModule((Module)this.getBeanConfig().getModule().getInjectedModule().getValue());
            String beanClass = this.getBeanConfig().getBeanClass();
            if (beanClass != null) {
                Class<?> clazz = Class.forName(beanClass, false, (ClassLoader)this.getModule().getClassLoader());
                this.setBeanInfo(new DefaultBeanInfo(this.getIndex(), clazz));
            }
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
        super.startInternal(context);
    }

    @Override
    public BeanInfo getValue() throws IllegalStateException, IllegalArgumentException {
        BeanInfo beanInfo = this.getBeanInfo();
        if (beanInfo == null) {
            throw new IllegalStateException(PojoMessages.MESSAGES.missingBeanInfo(this.getBeanConfig()));
        }
        return beanInfo;
    }
}

