/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.RejectExpressionValuesTransformer;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformersSubRegistration;
import org.jboss.as.remoting.Attribute;
import org.jboss.as.remoting.ConnectorResource;
import org.jboss.as.remoting.Element;
import org.jboss.as.remoting.GenericOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.LocalOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.Namespace;
import org.jboss.as.remoting.PropertyResource;
import org.jboss.as.remoting.PropertyResourceTransformers;
import org.jboss.as.remoting.RemoteOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.RemotingMessages;
import org.jboss.as.remoting.RemotingSubsystem11Parser;
import org.jboss.as.remoting.RemotingSubsystemRootResource;
import org.jboss.as.remoting.SaslPolicyResource;
import org.jboss.as.remoting.SaslResource;
import org.jboss.as.remoting.SaslResourceTransformers;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.xnio.sasl.SaslQop;
import org.xnio.sasl.SaslStrength;

public class RemotingExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "remoting";
    private static final String RESOURCE_NAME = RemotingExtension.class.getPackage().getName() + ".LocalDescriptions";
    static final String NODE_NAME_PROPERTY = "jboss.node.name";
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 2;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;
    private static final ModelVersion VERSION_1_1 = ModelVersion.create((int)1, (int)1);

    static ResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix) {
        return new StandardResourceDescriptionResolver(keyPrefix, RESOURCE_NAME, RemotingExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration registration = context.registerSubsystem(SUBSYSTEM_NAME, 1, 2, 0);
        registration.registerXMLElementWriter((XMLElementWriter)RemotingSubsystem11Parser.INSTANCE);
        ManagementResourceRegistration subsystem = registration.registerSubsystemModel((ResourceDefinition)new RemotingSubsystemRootResource(context.getProcessType()));
        subsystem.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        ManagementResourceRegistration connector = subsystem.registerSubModel((ResourceDefinition)ConnectorResource.INSTANCE);
        connector.registerSubModel((ResourceDefinition)PropertyResource.INSTANCE_CONNECTOR);
        ManagementResourceRegistration sasl = connector.registerSubModel((ResourceDefinition)SaslResource.INSTANCE);
        sasl.registerSubModel((ResourceDefinition)SaslPolicyResource.INSTANCE);
        sasl.registerSubModel((ResourceDefinition)PropertyResource.INSTANCE_CONNECTOR);
        subsystem.registerSubModel((ResourceDefinition)RemoteOutboundConnectionResourceDefinition.INSTANCE);
        subsystem.registerSubModel((ResourceDefinition)LocalOutboundConnectionResourceDefinition.INSTANCE);
        subsystem.registerSubModel((ResourceDefinition)GenericOutboundConnectionResourceDefinition.INSTANCE);
        if (context.isRegisterTransformers()) {
            this.registerTransformers_1_1(registration);
        }
    }

    private void registerTransformers_1_1(SubsystemRegistration registration) {
        RejectExpressionValuesTransformer rejectExpression = new RejectExpressionValuesTransformer(RemotingSubsystemRootResource.ATTRIBUTES);
        TransformersSubRegistration subsystem = registration.registerModelTransformers((ModelVersionRange)VERSION_1_1, (ResourceTransformer)rejectExpression);
        subsystem.registerOperationTransformer("add", (OperationTransformer)rejectExpression);
        subsystem.registerOperationTransformer("write-attribute", rejectExpression.getWriteAttributeTransformer());
        TransformersSubRegistration connector = subsystem.registerSubResource(ConnectorResource.PATH);
        PropertyResourceTransformers.registerTransformers(connector);
        SaslResourceTransformers.registerTransformers(connector);
        TransformersSubRegistration remoteOutboundConnection = subsystem.registerSubResource(RemoteOutboundConnectionResourceDefinition.ADDRESS);
        RejectExpressionValuesTransformer rejectUserNameExpression = new RejectExpressionValuesTransformer(new AttributeDefinition[]{RemoteOutboundConnectionResourceDefinition.USERNAME});
        remoteOutboundConnection.registerOperationTransformer("add", (OperationTransformer)rejectUserNameExpression);
        remoteOutboundConnection.registerOperationTransformer("write-attribute", rejectUserNameExpression.getWriteAttributeTransformer());
        PropertyResourceTransformers.registerTransformers(remoteOutboundConnection);
        TransformersSubRegistration localOutboundConnection = subsystem.registerSubResource(LocalOutboundConnectionResourceDefinition.ADDRESS);
        PropertyResourceTransformers.registerTransformers(localOutboundConnection);
        TransformersSubRegistration outboundConnection = subsystem.registerSubResource(GenericOutboundConnectionResourceDefinition.ADDRESS);
        PropertyResourceTransformers.registerTransformers(outboundConnection);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.REMOTING_1_0.getUriString(), (XMLElementReader)RemotingSubsystem10Parser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.REMOTING_1_1.getUriString(), (XMLElementReader)RemotingSubsystem11Parser.INSTANCE);
    }

    static final class RemotingSubsystem10Parser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        private static final RemotingSubsystem10Parser INSTANCE = new RemotingSubsystem10Parser();

        RemotingSubsystem10Parser() {
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ModelNode address = new ModelNode();
            address.add("subsystem", RemotingExtension.SUBSYSTEM_NAME);
            address.protect();
            ModelNode subsystem = Util.getEmptyOperation((String)"add", (ModelNode)address);
            list.add(subsystem);
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            block7: while (reader.hasNext() && reader.nextTag() != 2) {
                boolean doneWorkerThreadPool = false;
                switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case REMOTING_1_0: {
                        Element element = Element.forName(reader.getLocalName());
                        switch (element) {
                            case WORKER_THREAD_POOL: {
                                if (doneWorkerThreadPool) {
                                    throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)Element.WORKER_THREAD_POOL.getLocalName());
                                }
                                doneWorkerThreadPool = true;
                                this.parseWorkerThreadPool(reader, subsystem);
                                continue block7;
                            }
                            case CONNECTOR: {
                                this.parseConnector(reader, address, list);
                                continue block7;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }

        void parseWorkerThreadPool(XMLExtendedStreamReader reader, ModelNode subsystemAdd) throws XMLStreamException {
            int count = reader.getAttributeCount();
            block8: for (int i = 0; i < count; ++i) {
                ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case WORKER_READ_THREADS: {
                        if (subsystemAdd.hasDefined("worker-read-threads")) {
                            throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)"worker-read-threads");
                        }
                        RemotingSubsystemRootResource.WORKER_READ_THREADS.parseAndSetParameter(value, subsystemAdd, (XMLStreamReader)reader);
                        continue block8;
                    }
                    case WORKER_TASK_CORE_THREADS: {
                        if (subsystemAdd.hasDefined("worker-task-core-threads")) {
                            throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)"worker-task-core-threads");
                        }
                        RemotingSubsystemRootResource.WORKER_TASK_CORE_THREADS.parseAndSetParameter(value, subsystemAdd, (XMLStreamReader)reader);
                        continue block8;
                    }
                    case WORKER_TASK_KEEPALIVE: {
                        if (subsystemAdd.hasDefined("worker-task-keepalive")) {
                            throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)"worker-task-keepalive");
                        }
                        RemotingSubsystemRootResource.WORKER_TASK_KEEPALIVE.parseAndSetParameter(value, subsystemAdd, (XMLStreamReader)reader);
                        continue block8;
                    }
                    case WORKER_TASK_LIMIT: {
                        if (subsystemAdd.hasDefined("worker-task-limit")) {
                            throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)"worker-task-limit");
                        }
                        RemotingSubsystemRootResource.WORKER_TASK_LIMIT.parseAndSetParameter(value, subsystemAdd, (XMLStreamReader)reader);
                        continue block8;
                    }
                    case WORKER_TASK_MAX_THREADS: {
                        if (subsystemAdd.hasDefined("worker-task-max-threads")) {
                            throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)"worker-task-max-threads");
                        }
                        RemotingSubsystemRootResource.WORKER_TASK_MAX_THREADS.parseAndSetParameter(value, subsystemAdd, (XMLStreamReader)reader);
                        continue block8;
                    }
                    case WORKER_WRITE_THREADS: {
                        if (subsystemAdd.hasDefined("worker-write-threads")) {
                            throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)"worker-write-threads");
                        }
                        RemotingSubsystemRootResource.WORKER_WRITE_THREADS.parseAndSetParameter(value, subsystemAdd, (XMLStreamReader)reader);
                        continue block8;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }

        void parseConnector(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
            String name = null;
            String socketBinding = null;
            EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.SOCKET_BINDING);
            int count = reader.getAttributeCount();
            block12: for (int i = 0; i < count; ++i) {
                ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                required.remove((Object)attribute);
                switch (attribute) {
                    case NAME: {
                        name = value;
                        continue block12;
                    }
                    case SOCKET_BINDING: {
                        socketBinding = value;
                        continue block12;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (!required.isEmpty()) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
            }
            assert (name != null);
            assert (socketBinding != null);
            ModelNode connector = new ModelNode();
            connector.get("operation").set("add");
            connector.get("address").set(address).add("connector", name);
            connector.get("socket-binding").set(socketBinding);
            list.add(connector);
            EnumSet<Element> visited = EnumSet.noneOf(Element.class);
            block13: while (reader.hasNext() && reader.nextTag() != 2) {
                switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case REMOTING_1_0: {
                        Element element = Element.forName(reader.getLocalName());
                        if (visited.contains((Object)element)) {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                        visited.add(element);
                        switch (element) {
                            case SASL: {
                                this.parseSaslElement(reader, connector.get("address"), list);
                                continue block13;
                            }
                            case PROPERTIES: {
                                this.parseProperties(reader, connector.get("address"), list);
                                continue block13;
                            }
                            case AUTHENTICATION_PROVIDER: {
                                connector.get("authentication-provider").set(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name"));
                                continue block13;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }

        void parseSaslElement(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
            ModelNode saslElement = new ModelNode();
            saslElement.get("operation").set("add");
            saslElement.get("address").set(address).add(SaslResource.SASL_CONFIG_PATH.getKey(), SaslResource.SASL_CONFIG_PATH.getValue());
            list.add(saslElement);
            int count = reader.getAttributeCount();
            if (count > 0) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
            }
            EnumSet<Element> visited = EnumSet.noneOf(Element.class);
            block16: while (reader.hasNext() && reader.nextTag() != 2) {
                switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case REMOTING_1_0: {
                        Element element = Element.forName(reader.getLocalName());
                        if (visited.contains((Object)element)) {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                        visited.add(element);
                        switch (element) {
                            case INCLUDE_MECHANISMS: {
                                ModelNode includes = saslElement.get("include-mechanisms");
                                for (String s : (String[])ParseUtils.readArrayAttributeElement((XMLExtendedStreamReader)reader, (String)"value", String.class)) {
                                    includes.add().set(s);
                                }
                                continue block16;
                            }
                            case POLICY: {
                                this.parsePolicyElement(reader, saslElement.get("address"), list);
                                continue block16;
                            }
                            case PROPERTIES: {
                                this.parseProperties(reader, saslElement.get("address"), list);
                                continue block16;
                            }
                            case QOP: {
                                String[] qop;
                                for (String q : qop = (String[])ParseUtils.readArrayAttributeElement((XMLExtendedStreamReader)reader, (String)"value", String.class)) {
                                    try {
                                        saslElement.get("qop").add(SaslQop.fromString((String)q).getString().toLowerCase(Locale.ENGLISH));
                                    }
                                    catch (IllegalArgumentException e) {
                                        throw RemotingMessages.MESSAGES.invalidQOPV(q);
                                    }
                                }
                                continue block16;
                            }
                            case REUSE_SESSION: {
                                saslElement.get("reuse-session").set(ParseUtils.readBooleanAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                                continue block16;
                            }
                            case SERVER_AUTH: {
                                saslElement.get("server-auth").set(ParseUtils.readBooleanAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                                continue block16;
                            }
                            case STRENGTH: {
                                String[] strength;
                                for (String s : strength = (String[])ParseUtils.readArrayAttributeElement((XMLExtendedStreamReader)reader, (String)"value", String.class)) {
                                    try {
                                        saslElement.get("strength").add(SaslStrength.valueOf((String)s.toUpperCase(Locale.ENGLISH)).name().toLowerCase(Locale.ENGLISH));
                                    }
                                    catch (IllegalArgumentException e) {
                                        throw RemotingMessages.MESSAGES.invalidStrength(s);
                                    }
                                }
                                continue block16;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }

        ModelNode parsePolicyElement(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
            ModelNode policy = new ModelNode();
            policy.get("operation").set("add");
            policy.get("address").set(address).add(SaslPolicyResource.SASL_POLICY_CONFIG_PATH.getKey(), SaslPolicyResource.SASL_POLICY_CONFIG_PATH.getValue());
            list.add(policy);
            if (reader.getAttributeCount() > 0) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
            }
            EnumSet<Element> visited = EnumSet.noneOf(Element.class);
            block11: while (reader.hasNext() && reader.nextTag() != 2) {
                switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case REMOTING_1_0: {
                        Element element = Element.forName(reader.getLocalName());
                        if (visited.contains((Object)element)) {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                        visited.add(element);
                        switch (element) {
                            case FORWARD_SECRECY: {
                                policy.get("forward-secrecy").set(ParseUtils.readBooleanAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                                continue block11;
                            }
                            case NO_ACTIVE: {
                                policy.get("no-active").set(ParseUtils.readBooleanAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                                continue block11;
                            }
                            case NO_ANONYMOUS: {
                                policy.get("no-anonymous").set(ParseUtils.readBooleanAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                                continue block11;
                            }
                            case NO_DICTIONARY: {
                                policy.get("no-dictionary").set(ParseUtils.readBooleanAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                                continue block11;
                            }
                            case NO_PLAIN_TEXT: {
                                policy.get("no-plain-text").set(ParseUtils.readBooleanAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                                continue block11;
                            }
                            case PASS_CREDENTIALS: {
                                policy.get("pass-credentials").set(ParseUtils.readBooleanAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                                continue block11;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            return policy;
        }

        private void parseProperties(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
            while (reader.nextTag() != 2) {
                reader.require(1, Namespace.REMOTING_1_0.getUriString(), Element.PROPERTY.getLocalName());
                Property property = ParseUtils.readProperty((XMLExtendedStreamReader)reader);
                ModelNode propertyOp = new ModelNode();
                propertyOp.get("operation").set("add");
                propertyOp.get("address").set(address).add("property", property.getName());
                propertyOp.get("value").set(property.getValue());
                list.add(propertyOp);
            }
        }

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
            ModelNode model = context.getModelNode();
            this.writeWorkerThreadPoolIfAttributesSet(writer, model);
            if (model.hasDefined("connector")) {
                ModelNode connector = model.get("connector");
                for (String name : connector.keys()) {
                    this.writeConnector(writer, connector.require(name), name);
                }
            }
            writer.writeEndElement();
        }

        private void writeWorkerThreadPoolIfAttributesSet(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
            if (model.hasDefined("worker-read-threads") || model.hasDefined("worker-task-core-threads") || model.hasDefined("worker-task-keepalive") || model.hasDefined("worker-task-limit") || model.hasDefined("worker-task-max-threads") || model.hasDefined("worker-write-threads")) {
                writer.writeStartElement(Element.WORKER_THREAD_POOL.getLocalName());
                RemotingSubsystemRootResource.WORKER_READ_THREADS.marshallAsAttribute(model, false, (XMLStreamWriter)writer);
                RemotingSubsystemRootResource.WORKER_TASK_CORE_THREADS.marshallAsAttribute(model, false, (XMLStreamWriter)writer);
                RemotingSubsystemRootResource.WORKER_TASK_KEEPALIVE.marshallAsAttribute(model, false, (XMLStreamWriter)writer);
                RemotingSubsystemRootResource.WORKER_TASK_LIMIT.marshallAsAttribute(model, false, (XMLStreamWriter)writer);
                RemotingSubsystemRootResource.WORKER_TASK_MAX_THREADS.marshallAsAttribute(model, false, (XMLStreamWriter)writer);
                RemotingSubsystemRootResource.WORKER_WRITE_THREADS.marshallAsAttribute(model, false, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
        }

        private void writeConnector(XMLExtendedStreamWriter writer, ModelNode node, String name) throws XMLStreamException {
            writer.writeStartElement(Element.CONNECTOR.getLocalName());
            writer.writeAttribute(Attribute.NAME.getLocalName(), name);
            ConnectorResource.SOCKET_BINDING.marshallAsAttribute(node, (XMLStreamWriter)writer);
            ConnectorResource.AUTHENTICATION_PROVIDER.marshallAsElement(node, (XMLStreamWriter)writer);
            if (node.hasDefined("property")) {
                this.writeProperties(writer, node.get("property"));
            }
            if (node.hasDefined("security") && node.get("security").hasDefined("sasl")) {
                this.writeSasl(writer, node.get(new String[]{"security", "sasl"}));
            }
            writer.writeEndElement();
        }

        private void writeProperties(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
            writer.writeStartElement(Element.PROPERTIES.getLocalName());
            for (Property prop : node.asPropertyList()) {
                writer.writeStartElement(Element.PROPERTY.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), prop.getName());
                PropertyResource.VALUE.marshallAsAttribute(prop.getValue(), (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }

        private void writeSasl(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
            writer.writeStartElement(Element.SASL.getLocalName());
            SaslResource.INCLUDE_MECHANISMS_ATTRIBUTE.marshallAsElement(node, (XMLStreamWriter)writer);
            SaslResource.QOP_ATTRIBUTE.marshallAsElement(node, (XMLStreamWriter)writer);
            SaslResource.STRENGTH_ATTRIBUTE.marshallAsElement(node, (XMLStreamWriter)writer);
            SaslResource.SERVER_AUTH_ATTRIBUTE.marshallAsElement(node, (XMLStreamWriter)writer);
            SaslResource.REUSE_SESSION_ATTRIBUTE.marshallAsElement(node, (XMLStreamWriter)writer);
            if (node.hasDefined("sasl-policy")) {
                this.writePolicy(writer, node.get("sasl-policy"));
            }
            if (node.hasDefined("property")) {
                this.writeProperties(writer, node.get("property"));
            }
            writer.writeEndElement();
        }

        private void writePolicy(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
            writer.writeStartElement(Element.POLICY.getLocalName());
            ModelNode policy = node.get("policy");
            SaslPolicyResource.FORWARD_SECRECY.marshallAsElement(policy, (XMLStreamWriter)writer);
            SaslPolicyResource.NO_ACTIVE.marshallAsElement(policy, (XMLStreamWriter)writer);
            SaslPolicyResource.NO_ANONYMOUS.marshallAsElement(policy, (XMLStreamWriter)writer);
            SaslPolicyResource.NO_DICTIONARY.marshallAsElement(policy, (XMLStreamWriter)writer);
            SaslPolicyResource.NO_PLAIN_TEXT.marshallAsElement(policy, (XMLStreamWriter)writer);
            SaslPolicyResource.PASS_CREDENTIALS.marshallAsElement(policy, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
    }
}

