/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jni;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.catalina.core.AprLifecycleListener;
import org.jboss.logging.Logger;

public final class LibraryLoader {
    private static Logger log = Logger.getLogger(AprLifecycleListener.class);

    public static String getDefaultPlatformName() {
        String name = System.getProperty("os.name");
        String platform = "unknown";
        if (name.startsWith("Windows")) {
            platform = "windows";
        } else if (name.startsWith("Mac OS")) {
            platform = "macosx";
        } else if (name.endsWith("BSD")) {
            platform = "bsd";
        } else if (name.equals("Linux")) {
            platform = "linux2";
        } else if (name.equals("Solaris")) {
            platform = "solaris";
        } else if (name.equals("SunOS")) {
            platform = "solaris";
        } else if (name.equals("HP-UX")) {
            platform = "hpux";
        } else if (name.equals("AIX")) {
            platform = "aix";
        }
        return platform;
    }

    private LibraryLoader() {
    }

    protected static void load(String rootPath) throws SecurityException, IOException, UnsatisfiedLinkError {
        int count = 0;
        String name = LibraryLoader.getDefaultPlatformName();
        Properties props = new Properties();
        try {
            InputStream is = LibraryLoader.class.getResourceAsStream("/org/apache/tomcat/jni/Library.properties");
            props.load(is);
            is.close();
            count = Integer.parseInt(props.getProperty(name + ".count"));
        }
        catch (Throwable t) {
            throw new UnsatisfiedLinkError("Can't use Library.properties for: " + name);
        }
        for (int i = 0; i < count; ++i) {
            boolean optional = false;
            boolean full = false;
            String dlibName = props.getProperty(name + "." + i);
            if (dlibName.startsWith("?")) {
                dlibName = dlibName.substring(1);
                optional = true;
            }
            if (dlibName.startsWith("*")) {
                dlibName = dlibName.substring(1);
                full = true;
            }
            try {
                System.loadLibrary(dlibName);
                log.debug((Object)("Loaded: " + dlibName));
                if (!full) continue;
                break;
            }
            catch (Throwable d) {
                log.debug((Object)("Loading " + dlibName + " throws: " + d));
                if (optional) continue;
                throw new UnsatisfiedLinkError(" Error: " + d.getMessage() + " ");
            }
        }
    }
}

