/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.util;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.naming.NamingException;
import javax.servlet.Servlet;
import org.apache.catalina.Container;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.ContextConfig;
import org.apache.tomcat.InstanceManager;
import org.jboss.as.web.deployment.WebCtxLoader;
import org.jboss.as.webservices.WSMessages;
import org.jboss.msc.service.StartException;

public class WebAppController {
    private Host host;
    private String contextRoot;
    private String urlPattern;
    private String serverTempDir;
    private String servletClass;
    private ClassLoader classloader;
    private volatile StandardContext ctx;
    private int count = 0;

    public WebAppController(Host host, String servletClass, ClassLoader classloader, String contextRoot, String urlPattern, String serverTempDir) {
        this.host = host;
        this.contextRoot = contextRoot;
        this.urlPattern = urlPattern;
        this.serverTempDir = serverTempDir;
        this.classloader = classloader;
        this.servletClass = servletClass;
    }

    public synchronized int incrementUsers() throws StartException {
        if (this.count == 0) {
            try {
                this.ctx = this.startWebApp(this.host);
            }
            catch (Exception e) {
                throw new StartException((Throwable)e);
            }
        }
        return this.count++;
    }

    public synchronized int decrementUsers() {
        if (this.count == 0) {
            throw new IllegalStateException();
        }
        --this.count;
        if (this.count == 0) {
            try {
                this.stopWebApp(this.ctx);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.count;
    }

    private StandardContext startWebApp(Host host) throws Exception {
        StandardContext context = new StandardContext();
        try {
            context.setPath(this.contextRoot);
            context.addLifecycleListener((LifecycleListener)new ContextConfig());
            File docBase = new File(this.serverTempDir, this.contextRoot);
            if (!docBase.exists()) {
                docBase.mkdirs();
            }
            context.setDocBase(docBase.getPath());
            WebCtxLoader loader = new WebCtxLoader(this.classloader);
            loader.setContainer((Container)host);
            context.setLoader((Loader)loader);
            context.setInstanceManager((InstanceManager)new LocalInstanceManager());
            int j = this.servletClass.indexOf(".");
            String servletName = j < 0 ? this.servletClass : this.servletClass.substring(j + 1);
            Class<?> clazz = this.classloader.loadClass(this.servletClass);
            Wrapper wsfsWrapper = context.createWrapper();
            wsfsWrapper.setName(servletName);
            wsfsWrapper.setServlet((Servlet)clazz.newInstance());
            wsfsWrapper.setServletClass(this.servletClass);
            context.addChild((Container)wsfsWrapper);
            context.addServletMapping(this.urlPattern, servletName);
            host.addChild((Container)context);
            context.create();
        }
        catch (Exception e) {
            throw WSMessages.MESSAGES.createContextPhaseFailed(e);
        }
        try {
            context.start();
        }
        catch (LifecycleException e) {
            throw WSMessages.MESSAGES.startContextPhaseFailed(e);
        }
        return context;
    }

    private void stopWebApp(StandardContext context) throws Exception {
        try {
            Container container = context.getParent();
            container.removeChild((Container)context);
            context.stop();
        }
        catch (LifecycleException e) {
            throw WSMessages.MESSAGES.stopContextPhaseFailed(e);
        }
        try {
            context.destroy();
        }
        catch (Exception e) {
            throw WSMessages.MESSAGES.destroyContextPhaseFailed(e);
        }
    }

    private static class LocalInstanceManager
    implements InstanceManager {
        LocalInstanceManager() {
        }

        public Object newInstance(String className) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
            return Class.forName(className).newInstance();
        }

        public Object newInstance(String fqcn, ClassLoader classLoader) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
            return Class.forName(fqcn, false, classLoader).newInstance();
        }

        public Object newInstance(Class<?> c) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException {
            return c.newInstance();
        }

        public void newInstance(Object o) throws IllegalAccessException, InvocationTargetException, NamingException {
            throw new IllegalStateException();
        }

        public void destroyInstance(Object o) throws IllegalAccessException, InvocationTargetException {
        }
    }
}

