/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.as.weld.WeldModuleResourceLoader;
import org.jboss.modules.Module;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.resources.spi.ResourceLoader;

public class BeanDeploymentArchiveImpl
implements BeanDeploymentArchive {
    private final Set<String> beanClasses;
    private final Set<BeanDeploymentArchive> beanDeploymentArchives;
    private final BeansXml beansXml;
    private final String id;
    private final ServiceRegistry serviceRegistry;
    private final Module module;
    private final WeldModuleResourceLoader resourceLoader;
    private final Set<EjbDescriptor<?>> ejbDescriptors;

    public BeanDeploymentArchiveImpl(Set<String> beanClasses, BeansXml beansXml, Module module, String id) {
        this.beanClasses = new ConcurrentSkipListSet<String>(beanClasses);
        this.beanDeploymentArchives = new CopyOnWriteArraySet<BeanDeploymentArchive>();
        this.beansXml = beansXml;
        this.id = id;
        this.serviceRegistry = new SimpleServiceRegistry();
        this.resourceLoader = new WeldModuleResourceLoader(module);
        this.serviceRegistry.add(ResourceLoader.class, (Service)this.resourceLoader);
        this.module = module;
        this.ejbDescriptors = new HashSet();
    }

    public void addBeanDeploymentArchive(BeanDeploymentArchive archive) {
        if (archive == this) {
            return;
        }
        this.beanDeploymentArchives.add(archive);
    }

    public void addBeanDeploymentArchives(Collection<? extends BeanDeploymentArchive> archives) {
        for (BeanDeploymentArchive beanDeploymentArchive : archives) {
            if (beanDeploymentArchive == this) continue;
            this.beanDeploymentArchives.add(beanDeploymentArchive);
        }
    }

    public void addBeanClass(String clazz) {
        this.beanClasses.add(clazz);
    }

    public void addBeanClass(Class<?> clazz) {
        this.resourceLoader.addAdditionalClass(clazz);
    }

    public Collection<String> getBeanClasses() {
        return Collections.unmodifiableSet(new HashSet<String>(this.beanClasses));
    }

    public Collection<BeanDeploymentArchive> getBeanDeploymentArchives() {
        return Collections.unmodifiableCollection(new HashSet<BeanDeploymentArchive>(this.beanDeploymentArchives));
    }

    public BeansXml getBeansXml() {
        return this.beansXml;
    }

    public void addEjbDescriptor(EjbDescriptor<?> descriptor) {
        this.ejbDescriptors.add(descriptor);
    }

    public Collection<EjbDescriptor<?>> getEjbs() {
        return Collections.unmodifiableSet(this.ejbDescriptors);
    }

    public String getId() {
        return this.id;
    }

    public ServiceRegistry getServices() {
        return this.serviceRegistry;
    }

    public Module getModule() {
        return this.module;
    }
}

