/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.injection;

import java.lang.reflect.Method;
import java.util.List;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.as.weld.WeldMessages;
import org.jboss.as.weld.injection.SecurityActions;
import org.jboss.weld.manager.BeanManagerImpl;

final class InjectableMethod {
    private final Method method;
    private final List<Bean<?>> beans;
    private final List<InjectionPoint> injectionPoints;

    public InjectableMethod(Method method, List<Bean<?>> beans, List<InjectionPoint> injectionPoints) {
        this.beans = beans;
        this.method = method;
        this.injectionPoints = injectionPoints;
        SecurityActions.setAccessible(method);
    }

    public void inject(Object instance, BeanManagerImpl beanManager, CreationalContext<?> ctx) {
        try {
            Object[] params = new Object[this.beans.size()];
            int i = 0;
            for (Bean<?> bean : this.beans) {
                Object value = beanManager.getReference(this.injectionPoints.get(i), bean, ctx);
                params[i++] = value;
            }
            this.method.invoke(instance, params);
        }
        catch (Exception e) {
            throw WeldMessages.MESSAGES.couldNotInjectMethod(this.method, instance.getClass(), e);
        }
    }
}

