/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.ejb.client.EJBReceiverInvocationContext;
import org.jboss.ejb.client.remoting.ChannelAssociation;
import org.jboss.ejb.client.remoting.ProtocolMessageHandler;

class NonStatefulBeanSessionOpenFailureHandler
extends ProtocolMessageHandler {
    private final ChannelAssociation channelAssociation;

    NonStatefulBeanSessionOpenFailureHandler(ChannelAssociation channelAssociation) {
        this.channelAssociation = channelAssociation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processMessage(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        try {
            short invocationId = dataInputStream.readShort();
            String failureMessage = dataInputStream.readUTF();
            this.channelAssociation.resultReady(invocationId, new SessionOpenFailureResultProducer(failureMessage));
        }
        finally {
            dataInputStream.close();
        }
    }

    private class SessionOpenFailureResultProducer
    implements EJBReceiverInvocationContext.ResultProducer {
        private final String failureMessage;

        SessionOpenFailureResultProducer(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public Object getResult() throws Exception {
            throw new IllegalArgumentException(this.failureMessage);
        }

        @Override
        public void discardResult() {
        }
    }
}

